#ifndef MgPlotScene_H
#define MgQPlotScene_H

#include <QGraphicsScene>
#include <QMap>

class MgQAnimation;
class MgQBaseNode;
class MgQLayerNode;
class MgQLayoutNode;


/*class MgQLayer
{
	public
*/


class MgQPlotScene : public QGraphicsScene
{

public:
	MgQPlotScene(QObject *parent=0);
	~MgQPlotScene();

	void clearBeforeNewRequest();

	MgQLayoutNode* findZoomableLayout(QPointF);
	MgQLayoutNode* findZoomableLayout();
	MgQLayoutNode* findPreviewLayout();
	MgQLayoutNode* findMagnifierLayout();

	MgQAnimation* animation();
	void addAnimation(MgQLayoutNode*,MgQAnimation*);
	void selectCurrentStepForAnimation();
	
	void updateLayers(const QList<MgQLayerNode*>&);
	const QList<MgQLayerNode*>& uniqueLayers();

	void setRootNode(MgQBaseNode* rootNode) {rootNode_=rootNode;}

	void updateMagnifier(float);
	void clearMagnifier();

protected:
	void scanLayers();

	MgQBaseNode* rootNode_;

	MgQAnimation*  animation_;
	int prevCurrentStep_;

	QMap<QString,QList<MgQLayerNode*> > layers_;
	QList<MgQLayerNode*> uniqueLayers_;
	//QGraphicsScene *layerScene_;

	QRectF magnifierSceneRect_;
	float  magnifierFactor_;
	


};


#endif