/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file XYTransformation.h
    \brief Definition of the Template class XYTransformation.
    
    Magics Team - ECMWF 2005
    
    Started: Mon 19-Sep-2005
    
    Changes:
    
*/

#ifndef XYTransformation_H
#define XYTransformation_H

#include "magics.h"

#include "Transformation.h"
#include "XYTransformationAttributes.h"

namespace magics {
class XmlNode;

class XYTransformation: public Transformation, public XYTransformationAttributes {

public:
	XYTransformation();
	virtual ~XYTransformation();
    virtual void operator()(Layout&) const;
    
    virtual void set(const map<string, string>& map) { XYTransformationAttributes::set(map); }
    virtual void set(const XmlNode& node) { XYTransformationAttributes::set(node); }

    
    virtual Transformation* clone() const {
		XYTransformation* object = new XYTransformation();
		object->x_min_ = x_min_;
		object->x_max_ = x_max_;
		object->y_min_ = y_min_;
		object->y_max_ = y_max_;
		object->dataReferenceX_ = x_ref_;
	    object->dataReferenceY_ = y_ref_;
		return object;
	}
	
	virtual void adjustXAxis(Layout& layout) const;
	virtual void adjustYAxis(Layout& layout) const;
	
	virtual double getMinX() const { return x_min_; }
	virtual double getMaxX() const { return x_max_; }
	virtual double getMinY() const { return y_min_; }
	virtual double getMaxY() const { return y_max_; }

	virtual double getMinPCX() const { return x_min_; }
	virtual double getMaxPCX() const { return x_max_; }
	virtual double getMinPCY() const { return y_min_; }
	virtual double getMaxPCY() const { return y_max_; }
	
	virtual void setMinX(double x)   { x_min_ = x; }
	virtual void setMaxX(double x)   { x_max_ = x; }
	virtual void setMinY(double y)   { y_min_ = y; }
	virtual void setMaxY(double y)   { y_max_ = y; }

	
	virtual bool in(double x, double y) const 
         {  double minx = std::min(x_min_, x_max_);
         	double maxx = std::max(x_min_, x_max_);
         	double miny = std::min(y_min_, y_max_);
         	double maxy = std::max(y_min_, y_max_);
         	return ( minx <= x && x <=  maxx && miny <= y && y <= maxy ); }

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	XYTransformation(const XYTransformation&);
    //! Overloaded << operator to copy - No copy allowed
	XYTransformation& operator=(const XYTransformation&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const XYTransformation& p)
		{ p.print(s); return s; }

};

} // namespace magics
#endif
