/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/
#ifndef MagicsFormat_H
#define MagicsFormat_H
#include "magics.h"


namespace magics {

class MagicsFormat 
{
public:
	MagicsFormat(const string& format) : format_(format) {}
	virtual ~MagicsFormat() {}	
	bool valid(ostream& out) const;

    virtual ostream& format(ostream& out) const;
	
	
		
	friend  ostream& operator <<(ostream& out, const MagicsFormat& manip) 
	{ 		
		return manip.format(out);
	}
	string format_;
};


}

#endif
