/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file CartesianTransformation.cc
    \brief Implementation of the Template class CartesianTransformation.
    
    Magics Team - ECMWF 2005
    
    Started: Mon 19-Sep-2005
    
    Changes:
    
*/


#include "CartesianTransformation.h"
#include "Layout.h"


using namespace magics;


CartesianTransformation::CartesianTransformation() 
{
	dataReferenceX_ =  x_->reference();
	dataReferenceY_ =  y_->reference();
	referenceX_ =  x_->reference();
	referenceY_ =  y_->reference();
}

CartesianTransformation::~CartesianTransformation() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void CartesianTransformation::print(ostream& out)  const
{
	out << "CartesianTransformation[";
	CartesianTransformationAttributes::print(out);
	out << "]";
}


static void niceAdjust(double& min, double& max)
{
	float inc;
	int nb = 5;
	float step;
	float log, ws;

	while (nb < 20) {
		step = (max-min)/nb;
		log = log10(step);
		ws = pow(10., int(log));
		inc = ceil(step/ws)*ws;
		Log::dev() << "Automatic method ---> increment = " << inc << " ---> try base=" << inc/ws << endl;
		if ( inc/ws == 1 || inc/ws == 2 || inc/ws == 5 || inc/ws == 10 ) {
			Log::dev() << "Automatic method ---> increment " << inc << " OK! " << endl;
			break;
		}
		nb++;
		
	}
	
	float first = floor(min/inc) *inc;
	vector<float> values;
    
     
	for (float val = first;  val <= max +inc; val += inc) {
        	values.push_back(val);
	}
	
	if ( values.empty() ) {
		Log::warning() << " No input data --> return to default\n"; 
		min = 0;
		max = 100;
		return;
	}
	min = *std::min_element(values.begin(), values.end());
	max = *std::max_element(values.begin(), values.end());
}

void CartesianTransformation::adjustXAxis(Layout& layout) const
{
	Log::dev() << "CartesianTransformation::adjustXAxis()--->[" << dataMinX_ << ", " << dataMaxX_ << "]\n";
	if (  dataMinX_ == x_->min() && dataMaxX_ == x_->max() ) return;
	if ( dataReferenceX_ == "" ) niceAdjust(dataMinX_, dataMaxX_);
	Log::dev() << "CartesianTransformation::adjustXAxis()--->[" << dataMinX_ << ", " << dataMaxX_ << "]\n";
	
	if (dataMaxX_ - dataMinX_ < 4 ) dataMaxX_ = dataMinX_ + 4;// this needs to be done with more care later!
	// Should become a user option...
	const_cast<CartesianTransformation*>(this)->x_->min(dataMinX_);
	const_cast<CartesianTransformation*>(this)->x_->max(dataMaxX_);
	
	(*this)(layout);
}


void CartesianTransformation::adjustYAxis(Layout& layout) const
{
	Log::dev() << "CartesianTransformation::adjustYAxis()--->[" << dataMinY_ << ", " << dataMaxY_ << "]\n";
	if (  dataMinY_ == y_->min() && dataMaxY_ == y_->max() ) return;
	if ( dataReferenceY_ == "" ) niceAdjust(dataMinY_, dataMaxY_);
	Log::dev() << "CartesianTransformation::adjustYAxis()--->[" << dataMinY_ << ", " << dataMaxY_ << "]\n";
	if (dataMaxY_ - dataMinY_ < 4) dataMaxY_ = dataMinY_ + 4; // this needs to be done with more care later!
	// Should become a user option...
	const_cast<CartesianTransformation*>(this)->y_->min(dataMinY_);
	const_cast<CartesianTransformation*>(this)->y_->max(dataMaxY_);
	const_cast<CartesianTransformation*>(this)->referenceY_ = dataReferenceY_;
	(*this)(layout);
	
}


MAGICS_NO_EXPORT void CartesianTransformation::operator()(Layout& ) const
{
	/*
	if (layout["drawing_area"]) layout["drawing_area"]->setCoordinates(x_->minpc(), x_->maxpc(), y_->minpc(), y_->maxpc());
	if (layout["top_comment_box"]) layout["top_comment_box"]->setCoordinates(x_->minpc(), x_->maxpc(), -10, 10);
	if (layout["bottom_comment_box"]) layout["bottom_comment_box"]->setCoordinates(x_->minpc(), x_->maxpc(), -10, 10);
	if (layout["left_comment_box"]) layout["left_comment_box"]->setCoordinates(-10, 10, y_->minpc(), y_->maxpc());
	if (layout["right_comment_box"]) layout["right_comment_box"]->setCoordinates(-10, 10, y_->minpc(), y_->maxpc());
	if (layout["title"]) layout["title"]->setCoordinates(0, 100, 0, 100);
	if (layout["legend"]) layout["legend"]->setCoordinates(0, 100, 0, 100);
	*/
}
