/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.OutputMethodHandlerImpl;
import com.jclark.xsl.sax.ServletDestination;
import com.jclark.xsl.sax.XSLProcessor;
import com.jclark.xsl.sax.XSLProcessorImpl;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class XSLServlet
extends HttpServlet {
    private XSLProcessor cached;

    public void init() throws ServletException {
        String stylesheet = this.getInitParameter("stylesheet");
        if (stylesheet == null) {
            throw new ServletException("missing stylesheet parameter");
        }
        this.cached = new XSLProcessorImpl();
        this.cached.setParser(XSLServlet.createParser());
        try {
            this.cached.loadStylesheet(new InputSource(this.getServletContext().getResource(stylesheet).toString()));
        }
        catch (SAXException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File inputFile = new File(request.getPathTranslated());
        if (!inputFile.isFile() && !(inputFile = new File(request.getPathTranslated() + ".xml")).isFile()) {
            response.sendError(404, "File not found: " + request.getPathTranslated());
            return;
        }
        XSLProcessor xsl = (XSLProcessor)this.cached.clone();
        xsl.setParser(XSLServlet.createParser());
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            xsl.setParameter(name, request.getParameter(name));
        }
        OutputMethodHandlerImpl outputMethodHandler = new OutputMethodHandlerImpl(xsl);
        xsl.setOutputMethodHandler(outputMethodHandler);
        outputMethodHandler.setDestination(new ServletDestination((ServletResponse)response));
        try {
            xsl.parse(XSLServlet.fileInputSource(inputFile));
        }
        catch (SAXException e2) {
            throw new ServletException((Throwable)e2);
        }
    }

    static Parser createParser() throws ServletException {
        String parserClass = System.getProperty("com.jclark.xsl.sax.parser");
        if (parserClass == null) {
            parserClass = System.getProperty("org.xml.sax.parser");
        }
        if (parserClass == null) {
            parserClass = "com.jclark.xml.sax.CommentDriver";
        }
        try {
            return (Parser)Class.forName(parserClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        catch (ClassCastException e) {
            throw new ServletException(parserClass + " is not a SAX driver");
        }
    }

    public static InputSource fileInputSource(File file) {
        String path = file.getAbsolutePath();
        String fSep = System.getProperty("file.separator");
        if (fSep != null && fSep.length() == 1) {
            path = path.replace(fSep.charAt(0), '/');
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = '/' + path;
        }
        try {
            return new InputSource(new URL("file", "", path).toString());
        }
        catch (MalformedURLException e) {
            throw new Error("unexpected MalformedURLException");
        }
    }
}

