/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.modules.apache.tapestry;

import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

import org.apache.commons.logging.Log;

import xjavadoc.XTag;

import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;

import xdoclet.util.LogUtil;

/**
 * @author               Michael Newcomb (mnewcomb@sourceforge.net)
 * @created              February 4, 2005
 * @version              $Revision: 1.1 $
 * @xdoclet.taghandler   namespace="Tapestry"
 */
public class TapestryTagsHandler extends XDocletTagSupport
{
    private XTag    currentBean;
    private XTag    currentComponent;
    private XTag    currentContextAsset;
    private XTag    currentExternalAsset;
    private XTag    currentPrivateAsset;

    private XTag    currentTag;

    public String currentTagValue(Properties attributes) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "currentTagValue");

        String attrName = attributes.getProperty("attrName");

        return currentTag.getAttributeValue(attrName);
    }

    public void forAllComponents(String template) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllComponents");

        Collection components =
            getCurrentClass().getDoc().getTags("tapestry:component", true);

        for (Iterator i = components.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();
            currentComponent = currentTag;

            generate(template);
        }
        currentComponent = null;
    }

    public void forAllProperties(String template) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllProperties");

        Collection properties =
            getCurrentClass().getDoc().getTags("tapestry:property", true);

        for (Iterator i = properties.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();

            if (currentTag.getAttributeNames().contains("name") &&
                currentTag.getAttributeNames().contains("value") &&
                currentTag.getAttributeNames().size() == 2) {
                generate(template);
            }
        }
    }

    public void forAllComponentItems(String template, Properties attributes) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllComponentItems");

        String tagName = attributes.getProperty("tagName");

        Collection items = getCurrentClass().getDoc().getTags(tagName, true);

        for (Iterator i = items.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();

            if (currentComponent.getAttributeValue("id").equals(
                currentTag.getAttributeValue("component"))) {
                generate(template);
            }
        }
    }

    public void forAllBeans(String template) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllBeans");

        Collection beans =
            getCurrentClass().getDoc().getTags("tapestry:bean", true);

        for (Iterator i = beans.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();
            currentBean = currentTag;

            generate(template);
        }
        currentBean = null;
    }

    public void forAllBeanItems(String template, Properties attributes) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllBeanItems");

        String tagName = attributes.getProperty("tagName");

        Collection items = getCurrentClass().getDoc().getTags(tagName, true);

        for (Iterator i = items.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();

            if (currentBean.getAttributeValue("name").equals(
                currentTag.getAttributeValue("bean"))) {
                generate(template);
            }
        }
    }

    public void forAllExternalAssets(String template) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllExternalAssets");

        Collection externalAssets =
            getCurrentClass().getDoc().getTags("tapestry:external-asset", true);

        for (Iterator i = externalAssets.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();
            currentExternalAsset = currentTag;

            generate(template);
        }
        currentExternalAsset = null;
    }

    public void forAllExternalAssetItems(String template, Properties attributes) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllExternalAssetItems");

        String tagName = attributes.getProperty("tagName");

        Collection items = getCurrentClass().getDoc().getTags(tagName, true);

        for (Iterator i = items.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();

            if (currentExternalAsset.getAttributeValue("name").equals(
                currentTag.getAttributeValue("external-asset"))) {
                generate(template);
            }
        }
    }

    public void forAllContextAssets(String template) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllContextAssets");

        Collection contextAssets =
            getCurrentClass().getDoc().getTags("tapestry:context-asset", true);

        for (Iterator i = contextAssets.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();
            currentContextAsset = currentTag;

            generate(template);
        }
        currentContextAsset = null;
    }

    public void forAllContextAssetItems(String template, Properties attributes) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllContextAssetItems");

        String tagName = attributes.getProperty("tagName");

        Collection items = getCurrentClass().getDoc().getTags(tagName, true);

        for (Iterator i = items.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();

            if (currentContextAsset.getAttributeValue("name").equals(
                currentTag.getAttributeValue("context-asset"))) {
                generate(template);
            }
        }
    }

    public void forAllPrivateAssets(String template) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllPrivateAssets");

        Collection privateAssets =
            getCurrentClass().getDoc().getTags("tapestry:private-asset", true);

        for (Iterator i = privateAssets.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();
            currentPrivateAsset = currentTag;

            generate(template);
        }
        currentPrivateAsset = null;
    }

    public void forAllPrivateAssetItems(String template, Properties attributes) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllPrivateAssetItems");

        String tagName = attributes.getProperty("tagName");

        Collection items = getCurrentClass().getDoc().getTags(tagName, true);

        for (Iterator i = items.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();

            if (currentPrivateAsset.getAttributeValue("name").equals(
                currentTag.getAttributeValue("private-asset"))) {
                generate(template);
            }
        }
    }

    public void forAllPropertySpecifications(String template) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllPropertySpecifications");

        Collection propertySpecifications =
            getCurrentClass().getDoc().getTags(
            "tapestry:property-specification", true);

        for (Iterator i = propertySpecifications.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();

            generate(template);
        }
    }

    public void forAllParameters(String template) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllParameters");

        Collection parameters =
            getCurrentClass().getDoc().getTags("tapestry:parameter", true);

        for (Iterator i = parameters.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();

            generate(template);
        }
    }

    public void forAllReservedParameters(String template) throws XDocletException
    {
        Log log = LogUtil.getLog(TapestryTagsHandler.class,
            "forAllReservedParameters");

        Collection parameters =
            getCurrentClass().getDoc().getTags(
            "tapestry:reserved-parameter", true);

        for (Iterator i = parameters.iterator(); i.hasNext(); ) {
            currentTag = (XTag) i.next();

            generate(template);
        }
    }

    public void ifCurrentTagHasAttribute(String template, Properties attributes) throws XDocletException
    {
        if (currentTagValue(attributes) != null) {
            generate(template);
        }
    }
}
