=begin

= fileutils.rb

  Copyright (c) 2000,2001 Minero Aoki <aamine@loveruby.net>

  This program is free software.
  You can distribute/modify this program under the same terms of ruby.

== module FileUtils

Ūʥե򽸤᤿⥸塼Ǥ

=== ⥸塼ؿ

--- FileUtils#cd( dir, *options )
--- FileUtils#cd( dir, *options ) {|dir| .... }
  Options = noop verbose

  ǥ쥯ȥ dir ˰ưޤ
  ƥ졼ȤƸƤФ줿ϥ֥åλ
  Υǥ쥯ȥޤ

    FileUtils.cd '/', :verbose   # chdir and report it

--- FileUtils#uptodate?( newer, older_list, *options )
  Options = verbose

  newer Ƥ older 꿷Ȥ
  ¸ߤʤե̵¤˸ŤȤߤʤޤ

    FileUtils.newest? 'hello.o', 'hello.c', 'hello.h' or system 'make'

--- FileUtils#mkdir( dirs, *options )
  Options = noop verbose

  ǥ쥯ȥ dirs ޤ

    FileUtils.mkdir 'test'
    FileUtils.mkdir %w( tmp data )
    FileUtils.mkdir notexist', :noop  # does not create really

--- FileUtils#mkdir_p( dirs, ..., *options )
  Options = noop verbose

  ǥ쥯ȥ dir1, dir2 ĤȤοƥǥ쥯ȥƺޤ
  㤨

    FileUtils.mkdir_p '/usr/local/lib/ruby'

  ϰʲǥ쥯ȥ(ʤ)ޤ
      * /usr
      * /usr/local
      * /usr/local/bin
      * /usr/local/bin/ruby

--- FileUtils#rmdir( dirs, *options )
  Options = noop, verbose

  removes directories DIRS.

--- FileUtils#ln( old, new, *options )
  Options = noop verbose

  old ؤΥϡɥ new ޤ
  new ǥ쥯ȥʤ new/old ޤ

    FileUtils.ln :verbose, 'gcc', 'cc'

--- FileUtils#ln( list, dir, *options )
  Options = noop verbose

  file1 ؤΥϡɥ dir/file1file2 ؤΥϡɥ dir/file2 
  ޤ

    FileUtils.ln 'cp', 'mv', 'mkdir', '/usr/bin'
    FileUtils.ln %w( cp mv mkdir ), '/usr/bin'    # same result

--- FileUtils#ln_s( new, old, *options )
  Options = force noop verbose

  old ؤΥܥå new ޤ

    FileUtils.ln_s '/usr/bin/ruby', '/usr/local/bin/ruby'
    FileUtils.ln_s 'verylongsourcefilename.c', 'c', :force

--- FileUtils#ln_s( list, destdir, *options )
  Options = force noop verbose

  file1file2 ĤؤΥܥå dir/file1, dir/file2 Ĥ
  ޤdir ǥ쥯ȥǤʤ㳰 Errno::ENOTDIR 
  ȯޤޤ :force ץ󤬥åȤƤϡ
  ˥ե뤬¸ߤƤ⤽ƥ󥯤ĥޤ

   FileUtils.ln_s Dir.glob('bin/*.rb'), '/home/aamine/bin'

--- FileUtils#ln_sf( src, dest, *options )
  Options = noop verbose

  same to ln_s(src,dest,:force)

--- FileUtils#cp( src, dest, *options )
  Options = preserve noop verbose

  ե src  dest ˥ԡޤdest ǥ쥯ȥʤ
  dest/src ˥ԡޤ

    FileUtils.cp 'eval.c', 'eval.c.org'

--- FileUtils#cp( list, dir, *options )
  Options = preserve noop verbose

  file1  dir/file1 ˥ԡfile2  dir/file2 ˥ԡ
  Ȥ褦ˡǥ쥯ȥ dir ˥ե file1file2 Ĥ
  Ʊ̾ǥԡޤdir ǥ쥯ȥǤʤ㳰
  Errno::ENOTDIR ȯޤ

    FileUtils.cp 'cgi.rb', 'complex.rb', 'date.rb', '/usr/lib/ruby/1.6'
    FileUtils.cp :verbose, %w(cgi.rb complex.rb date.rb), '/usr/lib/ruby/1.6'

--- FileUtils#cp_r( src, dest, *options )
  Options = preserve noop verbose

  src  dest ˥ԡޤsrc ǥ쥯ȥǤäƵŪ
  ԡԤޤκ dest ǥ쥯ȥʤ dest/src 
  ԡޤ

    # installing ruby library "mylib" under the site_ruby
    FileUtils.rm_r site_ruby + '/mylib', :force
    FileUtils.cp_r 'lib/', site_ruby + '/mylib'

--- FileUtils#cp_r( list, dir, *options )
  Options = preserve noop verbose

  file1file2 Ĥǥ쥯ȥ dir ˥ԡޤ
  fileN ǥ쥯ȥʤƵŪ˥ԡޤ

    FileUtils.cp_r 'mail.rb', 'field.rb', 'debug/', site_ruby + '/tmail'
    FileUtils.cp_r :noop, :verbose, Dir.glob('*.rb'), '/home/aamine/lib/ruby'

--- FileUtils#mv( src, dest, *options )
  Options = noop verbose

  from  to ˰ưޤto ǥ쥯ȥʤ to/from 
  ưޤİʾΰͿȤϥǥ쥯ȥ dir 
  ˤ¾Υեưޤ

    FileUtils.mv 'badname.rb', 'goodname.rb'
    FileUtils.mv 'stuff.rb', 'lib/ruby', :force

--- FileUtils#mv( list, dir, *options )
  Options = noop verbose

  file1 file2 Ĥ dir/file1 dir/file2 Ĥ˰ưޤ
  ѡƥޤǰưȤϥԡޤ

    FileUtils.mv 'junk.txt', 'dust.txt', '/home/aamine/.trash/'
    FileUtils.mv Dir.glob('test*.rb'), 'T', :noop, :verbose

--- FileUtils#rm( list, *options )
  Options = force noop verbose

  file1file2 Ĥõޤ:force ץ󤬥åȤ줿
  Ϻ椹٤Ƥ㳰̵뤷ޤ

    FileUtils.rm %w( junk.txt dust.txt )
    FileUtils.rm Dir['*.so']
    FileUtils.rm 'NotExistFile', :force    # never raises exception

--- FileUtils#rm_r( list, *options )
  Options = force noop verbose

  եޤϥǥ쥯ȥ file1, file2 Ĥõޤ
  force ץϤ硢㳰ȯƤ̵뤷ޤ

    FileUtils.rm_r Dir.glob('/tmp/*')
    FileUtils.rm_r '/', :force          #  :-)

--- FileUtils#rm_rf( list, *options )
  Options = noop verbose

  same to rm_r(list,:force)

--- FileUtils#cmp( a, b, *options )
  Options = verbose

  ե a  b ƤƱʤ鿿

    FileUtils.cmp 'somefile', 'somefile'  #=> true
    FileUtils.cmp '/bin/cp', '/bin/mv'    #=> maybe false.

--- FileUtils#install( src, dest, mode = <src's>, *options )
  Options = noop verbose

  from  to Ƥ㤦Ȥ from  to ˥ԡޤ
  Τ⡼ɤ mode ꤷޤ

    FileUtils.install 'ruby', '/usr/local/bin/ruby', 0755, :verbose
    FileUtils.install 'lib.rb', '/usr/local/lib/ruby/site_ruby', :verbose

--- FileUtils#chmod( mode, list, *options )
  Options = noop verbose

  file1 file2 ĤΥ⡼ɤ mode Ѥޤ
  mode ȬʿȤä chmod 0644, fname Τ褦Ϳޤ

    FileUtils.chmod 0644, 'my.rb', 'your.rb'
    FileUtils.chmod 0755, 'somecommand'
    FileUtils.chmod 0755, '/usr/bin/ruby', :verbose

--- FileUtils#touch( list, *options )
  Options = noop verbose

  file1 file2 Ĥκǽѹȥ򸽺ߤλ
  ޤfileN ¸ߤʤƱ˶Υե
  ޤ

    FileUtils.touch 'main.c'; system 'make'

== module FileUtils::Verbose

FileUtils Ʊ᥽åɤƤƱ
ư򤷤ޤ¹ˤ褦ȤƤ뤳Ȥɽޤ

== module FileUtils::NoWrite

FileUtils Ʊ᥽åɤƤޤ
ºݤ˥եѹϼ¹Ԥޤ

=end
