#include <stdio.h>
#include <assert.h>
#include "common.h"
#include "userio.h"
#include "string.h"

int main( int argc, char **argv ) {
  char ch;
  c_string s;
  float f;
  int i,j;
  a_rect r, r2;
  int b;
  a_display_info_rec displayinfo;
  an_input_info_rec  inputinfo;
  a_pen_colour_name cn;
  int x, y;
  an_input_record ir;

  printf( "UserIO Interface Tests...\n\n" );

  printf( "Starting Ada run-time...\n" );
  adainit();
  printf( "Success\n\n" );

  startup_common( "test suite", "test" );
  startup_userio();

  // Startup and Related Global Functions

  draw_cstring( "Startup tests..." );  draw_ln();

  get_display_info( &displayinfo );  // can't test this much
  assert( displayinfo.fields == 8 );
  get_input_info( &inputinfo );  // can't test this much
  assert( inputinfo.fields == 4 );
  b = is_blue_background();
  assert( b == 1 );
  blue_background( 0 );
  b = is_blue_background();
  assert( b == 0 );
  blue_background( 1 ); // back to default
  b = is_blue_background();
  assert( b == 1 );
  draw_cstring( "Success!" );  draw_ln();

  draw_cstring( "Testing colour names..." );  draw_ln();
  set_pen_colour( white );
  draw_cstring( "white..." );  draw_ln();
  set_pen_colour( red );
  draw_cstring( "red..." );  draw_ln();
  set_pen_colour( purple );
  draw_cstring( "purple..." );  draw_ln();
  set_pen_colour( green );
  draw_cstring( "green..." );  draw_ln();
  set_pen_colour( blue );
  draw_cstring( "blue..." );  draw_ln();
  set_pen_colour( yellow );
  draw_cstring( "yellow..." );  draw_ln();
  set_pen_colour( black );
  draw_cstring( "black..." );  draw_ln();
  set_pen_colour( white );
  cn = get_pen_colour();
  assert( cn == white );
  draw_ln();
  draw_cstring( "Success!" );  draw_ln();
  draw_cstring( "press any key..." );  draw_ln();
  get_key( &ch );

  Cls();
  set_pen_colour( white );
  draw_cstring( "Position Tests..." );  draw_ln();
  move_to_global( 5, 5 );
  get_pen_pos( &x, &y );
  assert( x == 5 && y == 5 );
  draw_cstring( ".<-- this is (5, 5)" ); draw_ln();

  draw_cstring( "Success!" );  draw_ln();
  move_to_global( 0, 23 );
  set_pen_colour( white );
  draw_cstring( "press any key..." );  draw_ln();
  get_key( &ch );

  Cls();
  move_to_global( 0, 0 );
  set_pen_colour( white );
  draw_cstring( "Drawing Lines..." );  draw_ln();
  draw_horizontal_line( 5, 20, 5 );
  draw_vertical_line( 5, 20, 5 );
  draw_line( 5, 5, 20, 20 );

  move_to_global( 0, 23 );
  set_pen_colour( white );
  draw_cstring( "press any key..." );  draw_ln();
  get_key( &ch );

  Cls();
  move_to_global( 0, 0 );
  set_pen_colour( white );
  draw_cstring( "Drawing Rectangles..." );  draw_ln();

  move_to_global( 1, 4 );
  draw_cstring( "frame_rect" );  draw_ln();
  set_rect( &r, 1, 5, 10, 10 );
  frame_rect( &r );
  move_to_global( 11, 4 );
  draw_cstring( "frame_rect_3d" );  draw_ln();
  set_rect( &r, 11, 5, 25, 10 );
  frame_rect_3d( &r );
  move_to_global( 26, 4 );
  draw_cstring( "framed_rect" );  draw_ln();
  set_rect( &r, 26, 5, 40, 10 );
  framed_rect( &r, green, purple );
  move_to_global( 41, 4 );
  draw_cstring( "fill_rect" );  draw_ln();
  set_rect( &r, 41, 5, 55, 10 );
  fill_rect( &r, red );
  move_to_global( 56, 4 );
  draw_cstring( "paint_rect" );  draw_ln();
  set_rect( &r, 56, 5, 70, 10 );
  paint_rect( &r );
  move_to_global( 1, 14 );
  draw_cstring( "erase_rect" );  draw_ln();
  set_rect( &r, 1, 15, 15, 10 );
  erase_rect( &r );
  
  move_to_global( 0, 23 );
  set_pen_colour( white );
  draw_cstring( "press any key..." );  draw_ln();
  get_key( &ch );

  Cls();
  move_to_global( 0, 0 );
  set_pen_colour( white );
  draw_cstring( "Input Tests..." );  draw_ln();
  draw_cstring( "input record integrity..." );  draw_ln();
  assert( sizeof( ir ) == 24 );
  assert( sizeof( ir.input_type ) == 1 );
  assert( sizeof( ir.time_stamp ) == 8 );
  assert( sizeof( ir.key_data.key ) == 1 );
  assert( sizeof( ir.held_key_data.held_key ) == 1 );
  assert( sizeof( ir.direction_data.direction ) == 4 );
  assert( sizeof( ir.direction_data.velocity ) == 4 );
  assert( sizeof( ir.location_data.x ) == 4 );
  assert( sizeof( ir.location_data.y ) == 4 );
  assert( sizeof( ir.button_down_data.down_button ) == 4 );
  assert( sizeof( ir.button_down_data.down_location_x ) == 4 );
  assert( sizeof( ir.button_down_data.down_location_y ) == 4 );
  assert( sizeof( ir.button_up_data.up_button ) == 4 );
  assert( sizeof( ir.button_up_data.up_location_x ) == 4 );
  assert( sizeof( ir.button_up_data.up_location_y ) == 4 );
  assert( sizeof( ir.move_data.move_location_x ) == 4 );
  assert( sizeof( ir.move_data.move_location_y ) == 4 );
  assert( sizeof( ir.user_data.id ) == 4 );

  draw_cstring( "event queue testing..." );  draw_ln();

  draw_cstring( "  empty queue size..." );  draw_ln();
  assert( get_input_length() == 0 );

  //draw_cstring( "  reading an empty queue..." );  draw_ln();
  //get_input( &ir, instant );
  //assert( ir.input_type == null_input );

  draw_cstring( "  adding an event..." );  draw_ln();
  set_input( &ir, 0 );
  assert( get_input_length() == 1 );

  draw_cstring( "  flushing the queue..." );  draw_ln();
  //ir.input_type = null_input;
  //get_input( &ir, instant );
  flush_input();
  assert( get_input_length() == 0 );
  // assert( ir.input_type == heart_beat_input );
  draw_cstring( "  press a key (keypress(1))..." );  draw_ln();
  i = 0;
  for (;;) {
      i++;
      ch = keypress( 1 );
      if (ch != '\0' ) break;
  }
  draw_cstring( "  press a key (keypress(0))..." );  draw_ln();
  i = 0;
  for (;;) {
      i++;
      ch = keypress( 0 );
      if (ch != '\0' ) break;
  }

  // set_input_string not tested

  draw_cstring( "  brief wait for an event..." );  draw_ln();
  wait_for( 6 ); // no checks, just make sure it's callable

  move_to_global( 0, 23 );
  set_pen_colour( white );
  draw_cstring( "press any key..." );  draw_ln();
  get_key( &ch );

  Cls();
  set_pen_colour( white );
  draw_cstring( "             DrawErr Tests..." );  draw_ln();
  draw_cerr( "Emergency test" );
  draw_errln();
  draw_cerr( "Emergency test" );
  draw_errln();
  draw_cerr( "Last Emergency test" );
  draw_errln();

  move_to_global( 0, 23 );
  set_pen_colour( white );
  draw_cstring( "press any key..." );  draw_ln();
  get_key( &ch );

  Cls();
  set_pen_colour( white );
  draw_cstring( "Draw Spooling Tests..." );  draw_ln();
  draw_cstring( "There should be a pause before rectangle appears..." );  draw_ln();
  wait_to_reveal();
  move_to_global( 1, 4 );
  draw_cstring( "frame_rect" );  draw_ln();
  set_rect( &r, 1, 5, 10, 10 );
  frame_rect( &r );
  wait_for( 200 ); // no checks, just make sure it's callable
  reveal();

  move_to_global( 0, 23 );
  set_pen_colour( white );
  draw_cstring( "done. press any key." );  draw_ln();
  get_key( &ch );
  shutdown_userio();
  shutdown_common();
  adafinal();

  return 0;

}

