/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.remote.soap;

import java.io.IOException;
import java.util.Map;

import javax.security.auth.Subject;
import javax.management.MBeanServer;

import mx4j.tools.remote.AbstractConnectionManager;
import mx4j.tools.remote.Connection;
import mx4j.tools.remote.AbstractJMXConnectorServer;

/**
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.4 $
 */
class SOAPConnectionManager extends AbstractConnectionManager
{
   private final MBeanServer mbeanServer;

   SOAPConnectionManager(AbstractJMXConnectorServer server, Map environment)
   {
      super(server, environment);
      this.mbeanServer = server.getMBeanServer();
   }

   public String getProtocol()
   {
      return "soap";
   }

   protected Connection doConnect(String connectionId, Subject subject) throws IOException
   {
      SOAPConnection serverInvoker = new ServerInvoker(mbeanServer, getEnvironment());
//      SOAPConnection serverCatcher = ServerExceptionCatcher.newInstance(serverInvoker);
      // TODO: chain the subject invoker
//      SOAPConnection subjectInvoker = serverCatcher;
      SOAPConnection subjectInvoker = serverInvoker;
      return new ServerSOAPConnection(connectionId, this, subjectInvoker);
   }

   protected void doClose() throws IOException
   {
   }

   protected void doCloseConnection(Connection connection) throws IOException
   {
   }
}
