/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.remote.local;

import java.io.IOException;
import java.util.Set;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.security.auth.Subject;

import mx4j.tools.remote.AbstractConnection;

/**
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.3 $
 */
class LocalConnectionImpl extends AbstractConnection implements LocalConnection
{
   private final LocalConnection target;
   private volatile boolean closed;

   LocalConnectionImpl(String connectionId, LocalConnectionManager manager, LocalConnection target)
   {
      super(connectionId, manager);
      this.target = target;
   }

   public void close() throws IOException
   {
      if (closed) return;
      closed = true;
      target.close();
      super.close();
   }

   public void addNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback, Subject delegate)
           throws InstanceNotFoundException, IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      target.addNotificationListener(observed, listener, filter, handback, delegate);
   }

   public void removeNotificationListener(ObjectName observed, NotificationListener listener, Subject delegate)
           throws InstanceNotFoundException, ListenerNotFoundException, IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      target.removeNotificationListener(observed, listener, delegate);
   }

   public void removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback, Subject delegate)
           throws InstanceNotFoundException, ListenerNotFoundException, IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      target.removeNotificationListener(observed, listener, filter, handback, delegate);
   }

   public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature, Subject delegate)
           throws ReflectionException,
           InstanceAlreadyExistsException,
           MBeanRegistrationException,
           MBeanException,
           NotCompliantMBeanException,
           IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.createMBean(className, name, params, signature, delegate);
   }

   public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature, Subject delegate)
           throws ReflectionException,
           InstanceAlreadyExistsException,
           MBeanRegistrationException,
           MBeanException,
           NotCompliantMBeanException,
           InstanceNotFoundException,
           IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.createMBean(className, name, loaderName, params, signature, delegate);
   }

   public void unregisterMBean(ObjectName name, Subject delegate) throws InstanceNotFoundException, MBeanRegistrationException, IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      target.unregisterMBean(name, delegate);
   }

   public ObjectInstance getObjectInstance(ObjectName name, Subject delegate) throws InstanceNotFoundException, IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.getObjectInstance(name, delegate);
   }

   public Set queryMBeans(ObjectName name, QueryExp query, Subject delegate) throws IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.queryMBeans(name, query, delegate);
   }

   public Set queryNames(ObjectName name, QueryExp query, Subject delegate) throws IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.queryNames(name, query, delegate);
   }

   public boolean isRegistered(ObjectName name, Subject delegate) throws IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.isRegistered(name, delegate);
   }

   public Integer getMBeanCount(Subject delegate) throws IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.getMBeanCount(delegate);
   }

   public Object getAttribute(ObjectName name, String attribute, Subject delegate)
           throws MBeanException,
           AttributeNotFoundException,
           InstanceNotFoundException,
           ReflectionException,
           IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.getAttribute(name, attribute, delegate);
   }

   public AttributeList getAttributes(ObjectName name, String[] attributes, Subject delegate)
           throws InstanceNotFoundException, ReflectionException, IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.getAttributes(name, attributes, delegate);
   }

   public void setAttribute(ObjectName name, Attribute attribute, Subject delegate)
           throws InstanceNotFoundException,
           AttributeNotFoundException,
           InvalidAttributeValueException,
           MBeanException,
           ReflectionException,
           IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      target.setAttribute(name, attribute, delegate);
   }

   public AttributeList setAttributes(ObjectName name, AttributeList attributes, Subject delegate)
           throws InstanceNotFoundException,
           ReflectionException,
           IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.setAttributes(name, attributes, delegate);
   }

   public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature, Subject delegate)
           throws InstanceNotFoundException,
           MBeanException,
           ReflectionException,
           IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.invoke(name, operationName, params, signature, delegate);
   }

   public String getDefaultDomain(Subject delegate) throws IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.getDefaultDomain(delegate);
   }

   public String[] getDomains(Subject delegate) throws IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.getDomains(delegate);
   }

   public MBeanInfo getMBeanInfo(ObjectName name, Subject delegate) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.getMBeanInfo(name, delegate);
   }

   public boolean isInstanceOf(ObjectName name, String className, Subject delegate) throws InstanceNotFoundException, IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      return target.isInstanceOf(name, className, delegate);
   }

   public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback, Subject delegate)
           throws InstanceNotFoundException, IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      target.addNotificationListener(name, listener, filter, handback, delegate);
   }

   public void removeNotificationListener(ObjectName name, ObjectName listener, Subject delegate)
           throws InstanceNotFoundException, ListenerNotFoundException, IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      target.removeNotificationListener(name, listener, delegate);
   }

   public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback, Subject delegate)
           throws InstanceNotFoundException, ListenerNotFoundException, IOException
   {
      if (closed) throw new IOException("Connection has been closed");
      target.removeNotificationListener(name, listener, filter, handback, delegate);
   }
}
