# -*- ruby -*-
# This file is a part of test scripts of LDAP extension module.

require "test/conf"
require "ldap"

conn = LDAP::Conn.new($HOST, $PORT)
conn.perror("bind")
conn.bind{
  # search2 returns an array of hash
  print("search2 without a block:\n")
  conn.search2("dc=localhost, dc=localdomain", LDAP::LDAP_SCOPE_SUBTREE,
	       "(objectclass=*)", nil, false, 0, 0).each{|ent|
    ent.each{|attr,vals|
      print("#{attr}: #{vals.join(', ')}\n")
    }
    print("\n")
  }

  # search2 can has a block
  print("search2 with a block:\n")
  conn.search2("dc=localhost, dc=localdomain", LDAP::LDAP_SCOPE_SUBTREE,
	       "(objectclass=*)", nil, false, 0, 0){|ent|
    ent.each{|attr,vals|
      print("#{attr}: #{vals.join(', ')}\n")
    }
    print("\n")
  }
  print("\n")
}
