#ifndef ISO2MB_JA_H

#define ISO2MB_JA_H

#include <mb.h>

#define MB_SJIS_FC (mb_SJIS_FCs & ((1 << 7) - 1))
#define MB_SJIS0213_FC ((mb_SJIS_FCs >> 7) & ((1 << 7) - 1))

enum {
  mb_cs_detect_ja_EUC,
  mb_cs_detect_ja_SJIS,
  mb_cs_detect_ja_UTF8,
  mb_cs_detect_ja_N,
};

extern void mb_conv_euc_jp(mb_char_t *ch, mb_info_t *info);
extern void mb_conv_sjis(mb_char_t *ch, mb_info_t *info);
extern void mb_cs_judge_euc_jp(mb_cs_detector_stat_t *p, const char *bag, size_t e);
extern void mb_cs_judge_shift_jis(mb_cs_detector_stat_t *p, const char *bag, size_t e);
extern size_t mb_cs_judge_ja(mb_cs_detector_t *p);
extern char *mb_cs_setup_ja(mb_cs_detector_t *p, size_t i, size_t same);

#ifdef USE_UCS

#include <ucs.h>

extern void mb_conv_ucs_to_ja(mb_char_t *ch, mb_info_t *info);

#endif

#endif
