/**
 * GUI Commands
 * Copyright 2005 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: ActionCommandInterceptor.java,v 1.4 2005/08/28 05:57:28 pietschy Exp $
 */
package org.pietschy.command;

/**
 * This interface allows the interception of command execution.  The
 * interceptor is notified just before and just after the command has been invoked.  The interceptor can cancel
 * the command invocation if required by returning <tt>false</tt> from {@link #beforeExecute(ActionCommand)}.
 * @author andrewp
 * @version $Revision: 1.4 $
 */
public interface
ActionCommandInterceptor
{
   /**
    * Called just prior to a commands execution.
    *
    * @param command the command that is about to be invoked.
    * @return <tt>true</tt> to continue the command invocation, <tt>false</tt> to cancel it.
    */

   public boolean
   beforeExecute(ActionCommand command);

   /**
    * Called just after a commands execution.
    *
    * @param command the command that was invoked.
    */
   public void
   afterExecute(ActionCommand command);
}
