=begin
= Statistics

== Methods

--- GSL::Stats.mean(v)
--- GSL::Vector#mean
    Arithmetic mean.

    * Ex:
         irb(main):001:0> require("gsl")
         => true
         irb(main):002:0> v = Vector[1..7]
         => GSL::Vector: 
         [ 1.000e+00 2.000e+00 3.000e+00 4.000e+00 5.000e+00 6.000e+00 7.000e+00 ]
         irb(main):003:0> v.mean
         => 4.0
         irb(main):004:0> Stats.mean(v)
         => 4.0

--- GSL::Stats.variance_m(v[, mean])
--- GSL::Vector#variance_m([mean])
    Variance of ((|v|)) relative to the given value of ((|mean|)).

--- GSL::Stats.sd(v[, mean])
--- GSL::Vector#sd([mean])
    Standard deviation.

--- GSL::Stats.variance_with_fixed_mean(v, mean)
--- GSL::Vector#variance_with_fixed_mean(mean)
    Unbiased estimate of the variance of ((|v|)) when the population mean 
    ((|mean|)) of the underlying distribution is known ((|a priori|)).

--- GSL::Stats.variance_with_fixed_mean(v, mean)
--- GSL::Vector#variance_with_fixed_mean(mean)
--- GSL::Stats.sd_with_fixed_mean(v, mean)
--- GSL::Vector#sd_with_fixed_mean(mean)
    Unbiased estimate of the variance of ((|v|)) when the population mean 
    ((|mean|)) of the underlying distribution is known ((|a priori|)).

--- GSL::Stats.absdev(v[, mean])
--- GSL::Vector#absdev([mean])
    Compute the absolute deviation (from the mean ((|mean|)) if given).

--- GSL::Stats.skew(v[, mean, sd])
--- GSL::Vector#skew([mean, sd])
    Skewness

--- GSL::Stats.kurtosis(v[, mean, sd])
--- GSL::Vector#kurtosis([mean, sd])
    Kurtosis

--- GSL::Stats.lag1_autocorrelation(v[, mean])
--- GSL::Vector#lag1_autocorrelation([mean])
    The lag-1 autocorrelation

--- GSL::Stats.median_from_sorted_data(v)
--- GSL::Vector#median_from_sorted_data
    Return the median value. The elements of the data must be 
    in ascending numerical order. There are no checks to see whether 
    the data are sorted, so the method (({GSL::Vector#sort})) 
    should always be used first.

--- GSL::Stats.quantile_from_sorted_data(v)
--- GSL::Vector#quantile_from_sorted_data
    Return the quantile value. The elements of the data must be 
    in ascending numerical order. There are no checks to see whether 
    the data are sorted, so the method (({GSL::Vector#sort})) 
    should always be used first.

--- GSL::Stats.covariance(v1, v2)
--- GSL::Stats.covariance_m(v1, v2, mean1, mean2)
    Covariance of vectors ((|v1, v2|)).

== Weighted samples
--- GSL::Vector#wmean(w)
--- GSL::Vector#wvariance(w)
--- GSL::Vector#wsd(w)
--- GSL::Vector#wabsdev(w)
--- GSL::Vector#wskew(w)
--- GSL::Vector#wkurtosis(w)

== Example

     #!/usr/bin/env ruby
     require 'gsl'

     ary =  [17.2, 18.1, 16.5, 18.3, 12.6]
     data = Vector.alloc(ary)
     mean     = data.mean()
     variance = data.stats_variance()
     largest  = data.stats_max()
     smallest = data.stats_min()

     printf("The dataset is %g, %g, %g, %g, %g\n",
            data[0], data[1], data[2], data[3], data[4]);

     printf("The sample mean is %g\n", mean);
     printf("The estimated variance is %g\n", variance);
     printf("The largest value is %g\n", largest);
     printf("The smallest value is %g\n", smallest);

((<prev|URL:randist.html>))
((<next|URL:hist.html>))

((<Reference index|URL:ref.html>))
((<top|URL:index.html>))
=end
