/**
 * @file seq.c Seq container functions
 *
 * $Id: seq.c,v 1.3 2001/08/19 19:31:38 chipx86 Exp $
 *
 * @Copyright (C) 1999-2001 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <gnurdf.h>
#include <libgnurdf/internal.h>

RdfSeq *
rdfCreateSeq(RdfElement *parent, const char *property, RdfNamespace *ns)
{
	RdfElement   *cur;
	RdfNamespace *rdf;
	
	if (parent == NULL || property == NULL || ns == NULL)
		return NULL;
	
	rdf = rdfGetRdfNamespace(rdfGetElementSchema(parent));
	cur = xmlNewChild(parent, ns,  property, NULL);
	cur = xmlNewChild(cur,  rdf, "Seq",    NULL);

	return cur;
}

RdfElement *
rdfSeqAddValue(RdfSeq *seq, const char *property, RdfNamespace *ns,
               const char *value, RdfElement *element)
{
	RdfElement *cur;

	if (seq == NULL || property == NULL || ns == NULL)
		return NULL;
	
	if (value != NULL)
	{
		cur = xmlNewChild(seq, ns, property, (xmlChar *)value);
	}
	else
	{
		cur = xmlNewDocNode(rdfGetElementSchema(seq), ns, property, NULL);
		
		if (element != NULL)
			xmlAddChild(cur, element);

		xmlAddChild(seq, cur);
	}

	return cur;
}

