/**
 * @file libgnurdf/search.h Search functions
 *
 * $Id: search.h,v 1.3 2001/08/23 08:51:22 chipx86 Exp $
 *
 * @Copyright (C) 1999-2001 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _LIBGNURDF_SEARCH_H_
#define _LIBGNURDF_SEARCH_H_

#include <libgnurdf/types.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Returns the element with the specified value.
 *
 * @param container The container to search.
 * @param value     The value to search for.
 *
 * @return The element, or NULL if not found.
 */
RdfElement *rdfFindElementWithValue(RdfContainer *container,
									const char *value);

/**
 * Returns the element with the specified resource.
 *
 * @param container The container to search.
 * @param resource  The resource to search for.
 *
 * @return The element, or NULL if not found.
 */
RdfElement *rdfFindElementWithResource(RdfContainer *container,
									   const char *resource);

/*************************************************************************/
/** @name Backwards-compatibility functions                              */
/*************************************************************************/
/*@{*/

/**
 * Returns the element with the specified value.
 *
 * @deprecated This function has been replaced by rdfFindElementWithValue()
 * 
 * @see rdfFindElementWithValue()
 */
RdfElement *rdfGetElementFromValue(RdfContainer *container,
								   const char *value);

/**
 * Returns the element with the specified resource.
 *
 * @deprecated This function has been replaced by
 *             rdfFindElementWithResource()
 * 
 * @see rdfFindElementWithResource()
 */
RdfElement *rdfGetElementFromResource(RdfContainer *container,
									  const char *resource);

/*@}*/

#ifdef __cplusplus
}
#endif

#endif /* _LIBGNURDF_SEARCH_H_ */

