/* gisicomm.c generated by valac 0.14.2, the Vala compiler
 * generated from gisicomm.vala, do not modify */

/*
 *  Communication helper library for GISI
 *
 *  (C) 2009-2010 Nokia Corporation and/or its subsidiary(-ies).
 *  (C) 2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *  (C) 2011 Klaus 'MrMoku' Kurzmann <mok@fluxnetz.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <network.h>
#include <libgisi.h>
#include <clients.h>
#include <gio/gio.h>
#include <call.h>
#include <gpds.h>
#include <gss.h>
#include <info.h>
#include <mtc.h>
#include <sim.h>
#include <simauth.h>
#include <sms.h>
#include <ss.h>
#include <time.h>
#include <sys/uio.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <gobject/gvaluecollector.h>


#define GISI_COMM_TYPE_ERROR_CODE (gisi_comm_error_code_get_type ())

#define GISI_COMM_NETWORK_TYPE_ISI_REGSTATUS (gisi_comm_network_isi_regstatus_get_type ())
typedef struct _GIsiCommNetworkISI_RegStatus GIsiCommNetworkISI_RegStatus;

#define GISI_COMM_NETWORK_TYPE_ISI_PROVIDER (gisi_comm_network_isi_provider_get_type ())
typedef struct _GIsiCommNetworkISI_Provider GIsiCommNetworkISI_Provider;

#define GISI_COMM_TYPE_ONLINE_STATUS (gisi_comm_online_status_get_type ())

#define GISI_COMM_TYPE_MODEM_ACCESS (gisi_comm_modem_access_get_type ())
#define GISI_COMM_MODEM_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_MODEM_ACCESS, GIsiCommModemAccess))
#define GISI_COMM_MODEM_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_MODEM_ACCESS, GIsiCommModemAccessClass))
#define GISI_COMM_IS_MODEM_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_MODEM_ACCESS))
#define GISI_COMM_IS_MODEM_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_MODEM_ACCESS))
#define GISI_COMM_MODEM_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_MODEM_ACCESS, GIsiCommModemAccessClass))

typedef struct _GIsiCommModemAccess GIsiCommModemAccess;
typedef struct _GIsiCommModemAccessClass GIsiCommModemAccessClass;
typedef struct _GIsiCommModemAccessPrivate GIsiCommModemAccessPrivate;

#define GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT (gisi_comm_abstract_base_client_get_type ())
#define GISI_COMM_ABSTRACT_BASE_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT, GIsiCommAbstractBaseClient))
#define GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT, GIsiCommAbstractBaseClientClass))
#define GISI_COMM_IS_ABSTRACT_BASE_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT))
#define GISI_COMM_IS_ABSTRACT_BASE_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT))
#define GISI_COMM_ABSTRACT_BASE_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT, GIsiCommAbstractBaseClientClass))

typedef struct _GIsiCommAbstractBaseClient GIsiCommAbstractBaseClient;
typedef struct _GIsiCommAbstractBaseClientClass GIsiCommAbstractBaseClientClass;

#define GISI_COMM_TYPE_MTC (gisi_comm_mtc_get_type ())
#define GISI_COMM_MTC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_MTC, GIsiCommMTC))
#define GISI_COMM_MTC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_MTC, GIsiCommMTCClass))
#define GISI_COMM_IS_MTC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_MTC))
#define GISI_COMM_IS_MTC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_MTC))
#define GISI_COMM_MTC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_MTC, GIsiCommMTCClass))

typedef struct _GIsiCommMTC GIsiCommMTC;
typedef struct _GIsiCommMTCClass GIsiCommMTCClass;

#define GISI_COMM_TYPE_PHONE_INFO (gisi_comm_phone_info_get_type ())
#define GISI_COMM_PHONE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_PHONE_INFO, GIsiCommPhoneInfo))
#define GISI_COMM_PHONE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_PHONE_INFO, GIsiCommPhoneInfoClass))
#define GISI_COMM_IS_PHONE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_PHONE_INFO))
#define GISI_COMM_IS_PHONE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_PHONE_INFO))
#define GISI_COMM_PHONE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_PHONE_INFO, GIsiCommPhoneInfoClass))

typedef struct _GIsiCommPhoneInfo GIsiCommPhoneInfo;
typedef struct _GIsiCommPhoneInfoClass GIsiCommPhoneInfoClass;

#define GISI_COMM_TYPE_SIM (gisi_comm_sim_get_type ())
#define GISI_COMM_SIM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_SIM, GIsiCommSIM))
#define GISI_COMM_SIM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_SIM, GIsiCommSIMClass))
#define GISI_COMM_IS_SIM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_SIM))
#define GISI_COMM_IS_SIM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_SIM))
#define GISI_COMM_SIM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_SIM, GIsiCommSIMClass))

typedef struct _GIsiCommSIM GIsiCommSIM;
typedef struct _GIsiCommSIMClass GIsiCommSIMClass;

#define GISI_COMM_TYPE_CALL (gisi_comm_call_get_type ())
#define GISI_COMM_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_CALL, GIsiCommCall))
#define GISI_COMM_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_CALL, GIsiCommCallClass))
#define GISI_COMM_IS_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_CALL))
#define GISI_COMM_IS_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_CALL))
#define GISI_COMM_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_CALL, GIsiCommCallClass))

typedef struct _GIsiCommCall GIsiCommCall;
typedef struct _GIsiCommCallClass GIsiCommCallClass;

#define GISI_COMM_TYPE_SMS (gisi_comm_sms_get_type ())
#define GISI_COMM_SMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_SMS, GIsiCommSMS))
#define GISI_COMM_SMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_SMS, GIsiCommSMSClass))
#define GISI_COMM_IS_SMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_SMS))
#define GISI_COMM_IS_SMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_SMS))
#define GISI_COMM_SMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_SMS, GIsiCommSMSClass))

typedef struct _GIsiCommSMS GIsiCommSMS;
typedef struct _GIsiCommSMSClass GIsiCommSMSClass;

#define GISI_COMM_TYPE_SIM_AUTH (gisi_comm_sim_auth_get_type ())
#define GISI_COMM_SIM_AUTH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_SIM_AUTH, GIsiCommSIMAuth))
#define GISI_COMM_SIM_AUTH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_SIM_AUTH, GIsiCommSIMAuthClass))
#define GISI_COMM_IS_SIM_AUTH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_SIM_AUTH))
#define GISI_COMM_IS_SIM_AUTH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_SIM_AUTH))
#define GISI_COMM_SIM_AUTH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_SIM_AUTH, GIsiCommSIMAuthClass))

typedef struct _GIsiCommSIMAuth GIsiCommSIMAuth;
typedef struct _GIsiCommSIMAuthClass GIsiCommSIMAuthClass;

#define GISI_COMM_TYPE_NETWORK (gisi_comm_network_get_type ())
#define GISI_COMM_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_NETWORK, GIsiCommNetwork))
#define GISI_COMM_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_NETWORK, GIsiCommNetworkClass))
#define GISI_COMM_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_NETWORK))
#define GISI_COMM_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_NETWORK))
#define GISI_COMM_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_NETWORK, GIsiCommNetworkClass))

typedef struct _GIsiCommNetwork GIsiCommNetwork;
typedef struct _GIsiCommNetworkClass GIsiCommNetworkClass;

#define GISI_COMM_TYPE_SS (gisi_comm_ss_get_type ())
#define GISI_COMM_SS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_SS, GIsiCommSS))
#define GISI_COMM_SS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_SS, GIsiCommSSClass))
#define GISI_COMM_IS_SS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_SS))
#define GISI_COMM_IS_SS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_SS))
#define GISI_COMM_SS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_SS, GIsiCommSSClass))

typedef struct _GIsiCommSS GIsiCommSS;
typedef struct _GIsiCommSSClass GIsiCommSSClass;

#define GISI_COMM_TYPE_GSS (gisi_comm_gss_get_type ())
#define GISI_COMM_GSS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_GSS, GIsiCommGSS))
#define GISI_COMM_GSS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_GSS, GIsiCommGSSClass))
#define GISI_COMM_IS_GSS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_GSS))
#define GISI_COMM_IS_GSS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_GSS))
#define GISI_COMM_GSS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_GSS, GIsiCommGSSClass))

typedef struct _GIsiCommGSS GIsiCommGSS;
typedef struct _GIsiCommGSSClass GIsiCommGSSClass;

#define GISI_COMM_TYPE_GPDS (gisi_comm_gpds_get_type ())
#define GISI_COMM_GPDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_GPDS, GIsiCommGPDS))
#define GISI_COMM_GPDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_GPDS, GIsiCommGPDSClass))
#define GISI_COMM_IS_GPDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_GPDS))
#define GISI_COMM_IS_GPDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_GPDS))
#define GISI_COMM_GPDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_GPDS, GIsiCommGPDSClass))

typedef struct _GIsiCommGPDS GIsiCommGPDS;
typedef struct _GIsiCommGPDSClass GIsiCommGPDSClass;

#define GISI_COMM_TYPE_EPOC_INFO (gisi_comm_epoc_info_get_type ())
#define GISI_COMM_EPOC_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_EPOC_INFO, GIsiCommEpocInfo))
#define GISI_COMM_EPOC_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_EPOC_INFO, GIsiCommEpocInfoClass))
#define GISI_COMM_IS_EPOC_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_EPOC_INFO))
#define GISI_COMM_IS_EPOC_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_EPOC_INFO))
#define GISI_COMM_EPOC_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_EPOC_INFO, GIsiCommEpocInfoClass))

typedef struct _GIsiCommEpocInfo GIsiCommEpocInfo;
typedef struct _GIsiCommEpocInfoClass GIsiCommEpocInfoClass;
#define _g_isi_modem_destroy0(var) ((var == NULL) ? NULL : (var = (g_isi_modem_destroy (var), NULL)))
#define _gisi_comm_abstract_base_client_unref0(var) ((var == NULL) ? NULL : (var = (gisi_comm_abstract_base_client_unref (var), NULL)))
#define _gisi_comm_epoc_info_unref0(var) ((var == NULL) ? NULL : (var = (gisi_comm_epoc_info_unref (var), NULL)))
#define _gisi_comm_modem_access_unref0(var) ((var == NULL) ? NULL : (var = (gisi_comm_modem_access_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _gisi_comm_modem_access_queryModemStateData gisi_comm_modem_access_queryModemStateData;
typedef struct _Block2Data Block2Data;
typedef struct _GisiCommModemAccessConnectData GisiCommModemAccessConnectData;
typedef struct _GisiCommModemAccessDisconnectData GisiCommModemAccessDisconnectData;
typedef struct _GIsiCommAbstractBaseClientPrivate GIsiCommAbstractBaseClientPrivate;
typedef struct _GisiCommModemAccessLaunchData GisiCommModemAccessLaunchData;
typedef struct _Block3Data Block3Data;
typedef struct _GisiCommModemAccessStartupData GisiCommModemAccessStartupData;
typedef struct _GisiCommModemAccessPoweronData GisiCommModemAccessPoweronData;
typedef struct _GIsiCommParamSpecModemAccess GIsiCommParamSpecModemAccess;
typedef struct _gisi_comm_abstract_base_client_waitUntilSubsystemIsOnlineData gisi_comm_abstract_base_client_waitUntilSubsystemIsOnlineData;
typedef struct _Block4Data Block4Data;
typedef struct _GIsiCommParamSpecAbstractBaseClient GIsiCommParamSpecAbstractBaseClient;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GIsiCommMTCPrivate GIsiCommMTCPrivate;
#define _g_isi_client_destroy0(var) ((var == NULL) ? NULL : (var = (g_isi_client_destroy (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _GIsiCommPhoneInfoPrivate GIsiCommPhoneInfoPrivate;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _GIsiCommSIMAuthPrivate GIsiCommSIMAuthPrivate;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
typedef struct _gisi_comm_sim_auth_changePinData gisi_comm_sim_auth_changePinData;
typedef struct _GIsiCommSIMPrivate GIsiCommSIMPrivate;
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;

#define GISI_COMM_SIM_TYPE_ISI_SPN (gisi_comm_sim_isi_spn_get_type ())
typedef struct _GIsiCommSIMISI_SPN GIsiCommSIMISI_SPN;
typedef struct _Block18Data Block18Data;

#define GISI_COMM_SIM_TYPE_ISI_IMSI (gisi_comm_sim_isi_imsi_get_type ())
typedef struct _GIsiCommSIMISI_IMSI GIsiCommSIMISI_IMSI;
typedef struct _GIsiCommNetworkPrivate GIsiCommNetworkPrivate;

#define GISI_COMM_NETWORK_TYPE_ISI_TIME (gisi_comm_network_isi_time_get_type ())
typedef struct _GIsiCommNetworkISI_Time GIsiCommNetworkISI_Time;
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;
typedef struct _Block23Data Block23Data;
typedef struct _Block24Data Block24Data;
typedef struct _GIsiCommCallPrivate GIsiCommCallPrivate;

#define GISI_COMM_CALL_TYPE_ISI_CALLSTATUS (gisi_comm_call_isi_callstatus_get_type ())
typedef struct _GIsiCommCallISI_CallStatus GIsiCommCallISI_CallStatus;
typedef struct _Block25Data Block25Data;
typedef struct _Block26Data Block26Data;
typedef struct _Block27Data Block27Data;
typedef struct _Block28Data Block28Data;
typedef struct _Block29Data Block29Data;
typedef struct _GIsiCommSMSPrivate GIsiCommSMSPrivate;
typedef struct _GIsiCommGSSPrivate GIsiCommGSSPrivate;
typedef struct _GIsiCommSSPrivate GIsiCommSSPrivate;

#define GISI_COMM_TYPE_GPDS_HELPER (gisi_comm_gpds_helper_get_type ())
#define GISI_COMM_GPDS_HELPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GISI_COMM_TYPE_GPDS_HELPER, GIsiCommGPDSHelper))
#define GISI_COMM_GPDS_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GISI_COMM_TYPE_GPDS_HELPER, GIsiCommGPDSHelperClass))
#define GISI_COMM_IS_GPDS_HELPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GISI_COMM_TYPE_GPDS_HELPER))
#define GISI_COMM_IS_GPDS_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GISI_COMM_TYPE_GPDS_HELPER))
#define GISI_COMM_GPDS_HELPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GISI_COMM_TYPE_GPDS_HELPER, GIsiCommGPDSHelperClass))

typedef struct _GIsiCommGPDSHelper GIsiCommGPDSHelper;
typedef struct _GIsiCommGPDSHelperClass GIsiCommGPDSHelperClass;
typedef struct _GIsiCommGPDSHelperPrivate GIsiCommGPDSHelperPrivate;
typedef struct _GIsiCommParamSpecGPDSHelper GIsiCommParamSpecGPDSHelper;
typedef struct _GIsiCommGPDSPrivate GIsiCommGPDSPrivate;
#define _g_isi_pep_destroy0(var) ((var == NULL) ? NULL : (var = (g_isi_pep_destroy (var), NULL)))
#define _g_isi_pipe_destroy0(var) ((var == NULL) ? NULL : (var = (g_isi_pipe_destroy (var), NULL)))
#define _gisi_comm_gpds_helper_unref0(var) ((var == NULL) ? NULL : (var = (gisi_comm_gpds_helper_unref (var), NULL)))
typedef struct _Block30Data Block30Data;
typedef struct _GisiCommGpdsActivateData GisiCommGpdsActivateData;
typedef struct _Block31Data Block31Data;
typedef struct _GisiCommGpdsDeactivateData GisiCommGpdsDeactivateData;
typedef struct _GIsiCommEpocInfoPrivate GIsiCommEpocInfoPrivate;
#define _g_isi_server_destroy0(var) ((var == NULL) ? NULL : (var = (g_isi_server_destroy (var), NULL)))
#define _g_isi_version_free0(var) ((var == NULL) ? NULL : (var = (g_isi_version_free (var), NULL)))
#define _0(var) ((var == NULL) ? NULL : (var = ( (var), NULL)))
typedef struct _GIsiCommParamSpecEpocInfo GIsiCommParamSpecEpocInfo;

typedef enum  {
	GISI_COMM_ERROR_CODE_OK = 0xE0,
	GISI_COMM_ERROR_CODE_INVALID_FORMAT = 0xE1
} GIsiCommErrorCode;

typedef void (*GIsiCommVoidResultFunc) (GIsiCommErrorCode _error_, void* user_data);
typedef void (*GIsiCommBoolResultFunc) (GIsiCommErrorCode _error_, gboolean yesOrNo, void* user_data);
typedef void (*GIsiCommStringResultFunc) (GIsiCommErrorCode _error_, const gchar* _result_, void* user_data);
typedef void (*GIsiCommIntResultFunc) (GIsiCommErrorCode _error_, gint _result_, void* user_data);
struct _GIsiCommNetworkISI_RegStatus {
	guint8 status;
	guint8 mode;
	gchar* network;
	gchar* name;
	gchar* lac;
	gchar* cid;
	gchar* mcc;
	gchar* mnc;
	guint band;
	gboolean egprs;
	gboolean hsdpa;
	gboolean hsupa;
};

typedef void (*GIsiCommIsiRegStatusResultFunc) (GIsiCommErrorCode _error_, GIsiCommNetworkISI_RegStatus* status, void* user_data);
struct _GIsiCommNetworkISI_Provider {
	guint8 status;
	gchar* name;
	gchar* mcc;
	gchar* mnc;
	gint technology;
};

typedef void (*GIsiCommIsiProviderArrayResultFunc) (GIsiCommErrorCode _error_, GIsiCommNetworkISI_Provider* providers, int providers_length1, void* user_data);
typedef void (*GIsiCommMtcStatesResultFunc) (GIsiCommErrorCode _error_, guint8 current, guint8 target, void* user_data);
typedef void (*GIsiCommByteArrayResultFunc) (GIsiCommErrorCode code, guint8* array, int array_length1, void* user_data);
typedef enum  {
	GISI_COMM_ONLINE_STATUS_UNKNOWN,
	GISI_COMM_ONLINE_STATUS_NO,
	GISI_COMM_ONLINE_STATUS_YES
} GIsiCommOnlineStatus;

struct _GIsiCommModemAccess {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GIsiCommModemAccessPrivate * priv;
	GIsiModem* m;
	GIsiCommOnlineStatus online;
	GIsiPhonetNetlink* netlink;
	GIsiCommMTC* mtc;
	GIsiCommPhoneInfo* info;
	GIsiCommSIM* sim;
	GIsiCommCall* call;
	GIsiCommSMS* sms;
	GIsiCommSIMAuth* simauth;
	GIsiCommNetwork* net;
	GIsiCommSS* ss;
	GIsiCommGSS* gss;
	GIsiCommGPDS* gpds;
	GIsiCommEpocInfo* epoc;
	guint8 state;
};

struct _GIsiCommModemAccessClass {
	GTypeClass parent_class;
	void (*finalize) (GIsiCommModemAccess *self);
};

struct _Block1Data {
	int _ref_count_;
	GIsiCommModemAccess * self;
	guint8 current;
	guint8 target;
	gpointer _async_data_;
};

struct _gisi_comm_modem_access_queryModemStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GIsiCommModemAccess* self;
	guint8 result;
	Block1Data* _data1_;
	gboolean ok;
	gboolean _tmp0_;
	gboolean _tmp1_;
	guint8 _tmp2_;
	guint8 _tmp3_;
	GIsiCommMTC* _tmp4_;
	guint8 _tmp5_;
	const gchar* _tmp6_;
	guint8 _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	guint8 _tmp11_;
};

struct _Block2Data {
	int _ref_count_;
	GIsiCommModemAccess * self;
	gpointer _async_data_;
};

struct _GisiCommModemAccessConnectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GIsiCommModemAccess* self;
	gboolean result;
	Block2Data* _data2_;
	GIsiModem* _tmp0_;
	GIsiModem* _tmp1_;
	GIsiPhonetNetlink* _tmp2_;
	GIsiPhonetNetlink* _tmp3_;
	GIsiCommOnlineStatus _tmp4_;
	GIsiCommOnlineStatus _tmp5_;
};

struct _GisiCommModemAccessDisconnectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GIsiCommModemAccess* self;
	GIsiModem* _tmp0_;
	GIsiPhonetNetlink* _tmp1_;
	GIsiPhonetNetlink* _tmp2_;
};

struct _GIsiCommAbstractBaseClient {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GIsiCommAbstractBaseClientPrivate * priv;
	gboolean reachable;
	guint16 isiobj;
	GIsiClient* client;
	GSourceFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _GIsiCommAbstractBaseClientClass {
	GTypeClass parent_class;
	void (*finalize) (GIsiCommAbstractBaseClient *self);
	void (*onSubsystemIsReachable) (GIsiCommAbstractBaseClient* self);
};

struct _GisiCommModemAccessLaunchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GIsiCommModemAccess* self;
	gboolean result;
	GIsiModem* _tmp0_;
	GIsiCommMTC* _tmp1_;
	GIsiCommMTC* _tmp2_;
	GIsiModem* _tmp3_;
	GIsiCommPhoneInfo* _tmp4_;
	GIsiCommPhoneInfo* _tmp5_;
	GIsiModem* _tmp6_;
	GIsiCommSIM* _tmp7_;
	GIsiCommSIM* _tmp8_;
	GIsiModem* _tmp9_;
	GIsiCommSIMAuth* _tmp10_;
	GIsiCommSIMAuth* _tmp11_;
	GIsiModem* _tmp12_;
	GIsiCommCall* _tmp13_;
	GIsiCommCall* _tmp14_;
	GIsiModem* _tmp15_;
	GIsiCommSMS* _tmp16_;
	GIsiCommSMS* _tmp17_;
	GIsiModem* _tmp18_;
	GIsiCommSS* _tmp19_;
	GIsiCommSS* _tmp20_;
	GIsiModem* _tmp21_;
	GIsiCommGSS* _tmp22_;
	GIsiCommGSS* _tmp23_;
	GIsiModem* _tmp24_;
	GIsiCommNetwork* _tmp25_;
	GIsiCommNetwork* _tmp26_;
	GIsiModem* _tmp27_;
	GIsiCommGPDS* _tmp28_;
	GIsiCommGPDS* _tmp29_;
	GIsiModem* _tmp30_;
	GIsiCommEpocInfo* _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	GIsiCommMTC* _tmp40_;
	gboolean _tmp41_;
	GIsiCommPhoneInfo* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	GIsiCommSIM* _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	GIsiCommCall* _tmp48_;
	gboolean _tmp49_;
	gboolean _tmp50_;
	GIsiCommSMS* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	GIsiCommSS* _tmp54_;
	gboolean _tmp55_;
	gboolean _tmp56_;
	GIsiCommGSS* _tmp57_;
	gboolean _tmp58_;
	gboolean _tmp59_;
	GIsiCommNetwork* _tmp60_;
	gboolean _tmp61_;
	gboolean _tmp62_;
	GIsiCommGPDS* _tmp63_;
	gboolean _tmp64_;
	gboolean _tmp65_;
};

struct _Block3Data {
	int _ref_count_;
	GIsiCommModemAccess * self;
	gboolean ok;
	gpointer _async_data_;
};

struct _GisiCommModemAccessStartupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GIsiCommModemAccess* self;
	gboolean result;
	Block3Data* _data3_;
	GIsiCommMTC* _tmp0_;
};

struct _GisiCommModemAccessPoweronData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GIsiCommModemAccess* self;
	gboolean result;
};

struct _GIsiCommParamSpecModemAccess {
	GParamSpec parent_instance;
};

struct _gisi_comm_abstract_base_client_waitUntilSubsystemIsOnlineData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GIsiCommAbstractBaseClient* self;
	GIsiClient* _tmp0_;
	GIsiClient* _tmp1_;
};

struct _Block4Data {
	int _ref_count_;
	GIsiCommAbstractBaseClient * self;
	GIsiCommByteArrayResultFunc cb;
	gpointer cb_target;
};

struct _GIsiCommParamSpecAbstractBaseClient {
	GParamSpec parent_instance;
};

struct _GIsiCommMTC {
	GIsiCommAbstractBaseClient parent_instance;
	GIsiCommMTCPrivate * priv;
	GIsiClient* ll;
	guint8 state;
};

struct _GIsiCommMTCClass {
	GIsiCommAbstractBaseClientClass parent_class;
};

struct _Block5Data {
	int _ref_count_;
	GIsiCommMTC * self;
	GIsiCommMtcStatesResultFunc cb;
	gpointer cb_target;
};

struct _Block6Data {
	int _ref_count_;
	GIsiCommMTC * self;
	GIsiCommIntResultFunc cb;
	gpointer cb_target;
};

struct _Block7Data {
	int _ref_count_;
	GIsiCommMTC * self;
	GIsiCommVoidResultFunc cb;
	gpointer cb_target;
};

typedef void (*GIsiCommMTCIsiCauseResultFunc) (GIsiCommErrorCode _error_, guint8 cause, void* user_data);
struct _Block8Data {
	int _ref_count_;
	GIsiCommMTC * self;
	GIsiCommMTCIsiCauseResultFunc cb;
	gpointer cb_target;
};

struct _GIsiCommPhoneInfo {
	GIsiCommAbstractBaseClient parent_instance;
	GIsiCommPhoneInfoPrivate * priv;
	GIsiClient* ll;
};

struct _GIsiCommPhoneInfoClass {
	GIsiCommAbstractBaseClientClass parent_class;
};

struct _Block9Data {
	int _ref_count_;
	GIsiCommPhoneInfo * self;
	GIsiCommStringResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _Block10Data {
	int _ref_count_;
	GIsiCommPhoneInfo * self;
	GIsiCommStringResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _Block11Data {
	int _ref_count_;
	GIsiCommPhoneInfo * self;
	GIsiCommStringResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _Block12Data {
	int _ref_count_;
	GIsiCommPhoneInfo * self;
	GIsiCommStringResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _GIsiCommSIMAuth {
	GIsiCommAbstractBaseClient parent_instance;
	GIsiCommSIMAuthPrivate * priv;
	GIsiClient* ll;
};

struct _GIsiCommSIMAuthClass {
	GIsiCommAbstractBaseClientClass parent_class;
};

struct _Block13Data {
	int _ref_count_;
	GIsiCommSIMAuth * self;
	GIsiCommIntResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _Block14Data {
	int _ref_count_;
	GIsiCommSIMAuth * self;
	GIsiCommIntResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _Block15Data {
	int _ref_count_;
	GIsiCommSIMAuth * self;
	GIsiCommVoidResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
	gpointer _async_data_;
};

struct _gisi_comm_sim_auth_changePinData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GIsiCommSIMAuth* self;
	gchar* oldpin;
	gchar* newpin;
	GIsiCommVoidResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
	Block15Data* _data15_;
	GIsiCommVoidResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	guchar* p;
	const gchar* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	const gchar* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GIsiClient* _tmp14_;
};

struct _GIsiCommSIM {
	GIsiCommAbstractBaseClient parent_instance;
	GIsiCommSIMPrivate * priv;
};

struct _GIsiCommSIMClass {
	GIsiCommAbstractBaseClientClass parent_class;
};

struct _GIsiCommSIMPrivate {
	GIsiClient* ll;
};

struct _Block16Data {
	int _ref_count_;
	GIsiCommSIM * self;
	GIsiCommStringResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _Block17Data {
	int _ref_count_;
	GIsiCommSIM * self;
	GIsiCommStringResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _GIsiCommSIMISI_SPN {
	guint16 name[17];
	guint8 disp_home;
	guint8 disp_roam;
};

struct _Block18Data {
	int _ref_count_;
	GIsiCommSIM * self;
	GIsiCommStringResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _GIsiCommSIMISI_IMSI {
	guint8 length;
	guint8 imsi[8];
};

struct _GIsiCommNetwork {
	GIsiCommAbstractBaseClient parent_instance;
	GIsiCommNetworkPrivate * priv;
};

struct _GIsiCommNetworkClass {
	GIsiCommAbstractBaseClientClass parent_class;
};

struct _GIsiCommNetworkPrivate {
	GIsiClient* ll;
};

struct _GIsiCommNetworkISI_Time {
	guint8 year;
	guint8 mon;
	guint8 mday;
	guint8 hour;
	guint8 min;
	guint8 sec;
	guint8 utc;
	guint8 dst;
};

struct _Block19Data {
	int _ref_count_;
	GIsiCommNetwork * self;
	GIsiCommIsiRegStatusResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _Block20Data {
	int _ref_count_;
	GIsiCommNetwork * self;
	GIsiCommIntResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _Block21Data {
	int _ref_count_;
	GIsiCommNetwork * self;
	GIsiCommIsiProviderArrayResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _Block22Data {
	int _ref_count_;
	GIsiCommNetwork * self;
	GIsiCommVoidResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _Block23Data {
	int _ref_count_;
	GIsiCommNetwork * self;
	GIsiCommVoidResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _Block24Data {
	int _ref_count_;
	GIsiCommNetwork * self;
	GIsiCommIntResultFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _GIsiCommCall {
	GIsiCommAbstractBaseClient parent_instance;
	GIsiCommCallPrivate * priv;
};

struct _GIsiCommCallClass {
	GIsiCommAbstractBaseClientClass parent_class;
};

struct _GIsiCommCallPrivate {
	GIsiClient* ll;
};

struct _GIsiCommCallISI_CallStatus {
	guint8 id;
	guint8 status;
	guint8 ntype;
	gchar* number;
};

struct _Block25Data {
	int _ref_count_;
	GIsiCommCall * self;
	GIsiCommIntResultFunc cb;
	gpointer cb_target;
};

struct _Block26Data {
	int _ref_count_;
	GIsiCommCall * self;
	GIsiCommVoidResultFunc cb;
	gpointer cb_target;
};

struct _Block27Data {
	int _ref_count_;
	GIsiCommCall * self;
	GIsiCommVoidResultFunc cb;
	gpointer cb_target;
};

struct _Block28Data {
	int _ref_count_;
	GIsiCommCall * self;
	GIsiCommVoidResultFunc cb;
	gpointer cb_target;
};

struct _Block29Data {
	int _ref_count_;
	GIsiCommCall * self;
	GIsiCommVoidResultFunc cb;
	gpointer cb_target;
};

struct _GIsiCommSMS {
	GIsiCommAbstractBaseClient parent_instance;
	GIsiCommSMSPrivate * priv;
};

struct _GIsiCommSMSClass {
	GIsiCommAbstractBaseClientClass parent_class;
};

struct _GIsiCommSMSPrivate {
	GIsiClient* ll;
};

struct _GIsiCommGSS {
	GIsiCommAbstractBaseClient parent_instance;
	GIsiCommGSSPrivate * priv;
};

struct _GIsiCommGSSClass {
	GIsiCommAbstractBaseClientClass parent_class;
};

struct _GIsiCommGSSPrivate {
	GIsiClient* ll;
};

struct _GIsiCommSS {
	GIsiCommAbstractBaseClient parent_instance;
	GIsiCommSSPrivate * priv;
};

struct _GIsiCommSSClass {
	GIsiCommAbstractBaseClientClass parent_class;
};

struct _GIsiCommSSPrivate {
	GIsiClient* ll;
};

struct _GIsiCommGPDSHelper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GIsiCommGPDSHelperPrivate * priv;
	GIsiCommGPDS* instance;
	GSourceFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _GIsiCommGPDSHelperClass {
	GTypeClass parent_class;
	void (*finalize) (GIsiCommGPDSHelper *self);
};

struct _GIsiCommParamSpecGPDSHelper {
	GParamSpec parent_instance;
};

struct _GIsiCommGPDS {
	GIsiCommAbstractBaseClient parent_instance;
	GIsiCommGPDSPrivate * priv;
};

struct _GIsiCommGPDSClass {
	GIsiCommAbstractBaseClientClass parent_class;
};

struct _GIsiCommGPDSPrivate {
	GIsiClient* ll;
	GIsiPEP* pep;
	GIsiPipe* pipe;
	guint8 ctxid;
	GIsiCommGPDSHelper* helper;
};

struct _Block30Data {
	int _ref_count_;
	GIsiCommGPDS * self;
	gboolean ok;
	GIsiCommVoidResultFunc cb;
	gpointer cb_target;
	gpointer _async_data_;
};

struct _GisiCommGpdsActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GIsiCommGPDS* self;
	gchar* apn;
	gchar* user;
	gchar* pw;
	GIsiCommVoidResultFunc cb;
	gpointer cb_target;
	Block30Data* _data30_;
	GIsiCommVoidResultFunc _tmp0_;
	void* _tmp0__target;
	GIsiClient* _tmp1_;
	GIsiModem* _tmp2_;
	GIsiModem* _tmp3_;
	GIsiPEP* _tmp4_;
	GIsiPEP* _tmp5_;
	GIsiCommVoidResultFunc _tmp6_;
	void* _tmp6__target;
	GIsiClient* _tmp7_;
	GIsiModem* _tmp8_;
	GIsiModem* _tmp9_;
	GIsiPEP* _tmp10_;
	guint16 _tmp11_;
	guint16 _tmp12_;
	GIsiPipe* _tmp13_;
	GIsiPipe* _tmp14_;
	GIsiCommVoidResultFunc _tmp15_;
	void* _tmp15__target;
	GIsiPipe* _tmp16_;
	GIsiCommGPDSHelper* _tmp17_;
	GIsiCommGPDSHelper* _tmp18_;
	guint8* _tmp19_;
	guint8* req1;
	gint req1_length1;
	gint _req1_size_;
	GIsiClient* _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	gboolean _tmp22_;
	guint8 _tmp23_;
	GIsiPipe* _tmp24_;
	guchar _tmp25_;
	guint8* _tmp26_;
	guint8* req2;
	gint req2_length1;
	gint _req2_size_;
	GIsiClient* _tmp27_;
	guint8* _tmp28_;
	gint _tmp28__length1;
	gboolean _tmp29_;
	guint8 _tmp30_;
	guint8 _tmp31_;
	const gchar* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	guint8* _tmp35_;
	guint8* req3;
	gint req3_length1;
	gint _req3_size_;
	gint i;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	const gchar* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	guint8* _tmp43_;
	gint _tmp43__length1;
	gint _tmp44_;
	const gchar* _tmp45_;
	gint _tmp46_;
	gchar _tmp47_;
	guint8 _tmp48_;
	GIsiClient* _tmp49_;
	guint8* _tmp50_;
	gint _tmp50__length1;
	gboolean _tmp51_;
	gboolean _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	gboolean _tmp55_;
	const gchar* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	guint8 _tmp59_;
	guint8 sb_userinfo_len;
	guint8 _tmp60_;
	const gchar* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	guint8 userinfo_pad_len;
	const gchar* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	guint8 _tmp67_;
	guint8 sb_password_info_len;
	guint8 _tmp68_;
	const gchar* _tmp69_;
	gint _tmp70_;
	gint _tmp71_;
	guint8 password_pad_len;
	guint8* _tmp72_;
	guint8* pad;
	gint pad_length1;
	gint _pad_size_;
	guint8 _tmp73_;
	guint8 _tmp74_;
	const gchar* _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	guint8* _tmp78_;
	guint8* top;
	gint top_length1;
	gint _top_size_;
	guint8 _tmp79_;
	const gchar* _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	guint8* _tmp83_;
	guint8* bottom;
	gint bottom_length1;
	gint _bottom_size_;
	struct iovec* _tmp84_;
	struct iovec* iov2;
	gint iov2_length1;
	gint _iov2_size_;
	struct iovec* _tmp85_;
	gint _tmp85__length1;
	guint8* _tmp86_;
	gint _tmp86__length1;
	guint8* _tmp87_;
	gint _tmp87__length1;
	struct iovec _tmp88_;
	struct iovec _tmp89_;
	struct iovec* _tmp90_;
	gint _tmp90__length1;
	const gchar* _tmp91_;
	const gchar* _tmp92_;
	gint _tmp93_;
	gint _tmp94_;
	struct iovec _tmp95_;
	struct iovec _tmp96_;
	struct iovec* _tmp97_;
	gint _tmp97__length1;
	guint8* _tmp98_;
	gint _tmp98__length1;
	guint8 _tmp99_;
	struct iovec _tmp100_;
	struct iovec _tmp101_;
	struct iovec* _tmp102_;
	gint _tmp102__length1;
	guint8* _tmp103_;
	gint _tmp103__length1;
	guint8* _tmp104_;
	gint _tmp104__length1;
	struct iovec _tmp105_;
	struct iovec _tmp106_;
	struct iovec* _tmp107_;
	gint _tmp107__length1;
	const gchar* _tmp108_;
	const gchar* _tmp109_;
	gint _tmp110_;
	gint _tmp111_;
	struct iovec _tmp112_;
	struct iovec _tmp113_;
	struct iovec* _tmp114_;
	gint _tmp114__length1;
	guint8* _tmp115_;
	gint _tmp115__length1;
	guint8 _tmp116_;
	struct iovec _tmp117_;
	struct iovec _tmp118_;
	GIsiClient* _tmp119_;
	struct iovec* _tmp120_;
	gint _tmp120__length1;
	gboolean _tmp121_;
	guint8 _tmp122_;
	guint8* _tmp123_;
	guint8* req4;
	gint req4_length1;
	gint _req4_size_;
	GIsiClient* _tmp124_;
	guint8* _tmp125_;
	gint _tmp125__length1;
	gboolean _tmp126_;
	GIsiPipe* _tmp127_;
	GIsiCommVoidResultFunc _tmp128_;
	void* _tmp128__target;
};

struct _Block31Data {
	int _ref_count_;
	GIsiCommGPDS * self;
	gpointer _async_data_;
};

struct _GisiCommGpdsDeactivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GIsiCommGPDS* self;
	Block31Data* _data31_;
	guint8 _tmp0_;
	guint8* _tmp1_;
	guint8* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
};

struct _GIsiCommEpocInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GIsiCommEpocInfoPrivate * priv;
};

struct _GIsiCommEpocInfoClass {
	GTypeClass parent_class;
	void (*finalize) (GIsiCommEpocInfo *self);
};

struct _GIsiCommEpocInfoPrivate {
	guint sv;
	GIsiServer* ll;
};

struct _GIsiCommParamSpecEpocInfo {
	GParamSpec parent_instance;
};


static gpointer gisi_comm_modem_access_parent_class = NULL;
static gpointer gisi_comm_abstract_base_client_parent_class = NULL;
static gpointer gisi_comm_mtc_parent_class = NULL;
static gpointer gisi_comm_phone_info_parent_class = NULL;
static gpointer gisi_comm_sim_auth_parent_class = NULL;
static gpointer gisi_comm_sim_parent_class = NULL;
static gpointer gisi_comm_network_parent_class = NULL;
static gpointer gisi_comm_call_parent_class = NULL;
static gpointer gisi_comm_sms_parent_class = NULL;
static gpointer gisi_comm_gss_parent_class = NULL;
static gpointer gisi_comm_ss_parent_class = NULL;
static gpointer gisi_comm_gpds_helper_parent_class = NULL;
static gpointer gisi_comm_gpds_parent_class = NULL;
static gpointer gisi_comm_epoc_info_parent_class = NULL;

GType gisi_comm_error_code_get_type (void) G_GNUC_CONST;
GType gisi_comm_network_isi_regstatus_get_type (void) G_GNUC_CONST;
GIsiCommNetworkISI_RegStatus* gisi_comm_network_isi_regstatus_dup (const GIsiCommNetworkISI_RegStatus* self);
void gisi_comm_network_isi_regstatus_free (GIsiCommNetworkISI_RegStatus* self);
void gisi_comm_network_isi_regstatus_copy (const GIsiCommNetworkISI_RegStatus* self, GIsiCommNetworkISI_RegStatus* dest);
void gisi_comm_network_isi_regstatus_destroy (GIsiCommNetworkISI_RegStatus* self);
GType gisi_comm_network_isi_provider_get_type (void) G_GNUC_CONST;
GIsiCommNetworkISI_Provider* gisi_comm_network_isi_provider_dup (const GIsiCommNetworkISI_Provider* self);
void gisi_comm_network_isi_provider_free (GIsiCommNetworkISI_Provider* self);
void gisi_comm_network_isi_provider_copy (const GIsiCommNetworkISI_Provider* self, GIsiCommNetworkISI_Provider* dest);
void gisi_comm_network_isi_provider_destroy (GIsiCommNetworkISI_Provider* self);
GType gisi_comm_online_status_get_type (void) G_GNUC_CONST;
gpointer gisi_comm_modem_access_ref (gpointer instance);
void gisi_comm_modem_access_unref (gpointer instance);
GParamSpec* gisi_comm_param_spec_modem_access (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gisi_comm_value_set_modem_access (GValue* value, gpointer v_object);
void gisi_comm_value_take_modem_access (GValue* value, gpointer v_object);
gpointer gisi_comm_value_get_modem_access (const GValue* value);
GType gisi_comm_modem_access_get_type (void) G_GNUC_CONST;
gpointer gisi_comm_abstract_base_client_ref (gpointer instance);
void gisi_comm_abstract_base_client_unref (gpointer instance);
GParamSpec* gisi_comm_param_spec_abstract_base_client (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gisi_comm_value_set_abstract_base_client (GValue* value, gpointer v_object);
void gisi_comm_value_take_abstract_base_client (GValue* value, gpointer v_object);
gpointer gisi_comm_value_get_abstract_base_client (const GValue* value);
GType gisi_comm_abstract_base_client_get_type (void) G_GNUC_CONST;
GType gisi_comm_mtc_get_type (void) G_GNUC_CONST;
GType gisi_comm_phone_info_get_type (void) G_GNUC_CONST;
GType gisi_comm_sim_get_type (void) G_GNUC_CONST;
GType gisi_comm_call_get_type (void) G_GNUC_CONST;
GType gisi_comm_sms_get_type (void) G_GNUC_CONST;
GType gisi_comm_sim_auth_get_type (void) G_GNUC_CONST;
GType gisi_comm_network_get_type (void) G_GNUC_CONST;
GType gisi_comm_ss_get_type (void) G_GNUC_CONST;
GType gisi_comm_gss_get_type (void) G_GNUC_CONST;
GType gisi_comm_gpds_get_type (void) G_GNUC_CONST;
gpointer gisi_comm_epoc_info_ref (gpointer instance);
void gisi_comm_epoc_info_unref (gpointer instance);
GParamSpec* gisi_comm_param_spec_epoc_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gisi_comm_value_set_epoc_info (GValue* value, gpointer v_object);
void gisi_comm_value_take_epoc_info (GValue* value, gpointer v_object);
gpointer gisi_comm_value_get_epoc_info (const GValue* value);
GType gisi_comm_epoc_info_get_type (void) G_GNUC_CONST;
enum  {
	GISI_COMM_MODEM_ACCESS_DUMMY_PROPERTY
};
static void gisi_comm_modem_access_queryModemState_data_free (gpointer _data);
static void gisi_comm_modem_access_queryModemState (GIsiCommModemAccess* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static guint8 gisi_comm_modem_access_queryModemState_finish (GIsiCommModemAccess* self, GAsyncResult* _res_);
static gboolean gisi_comm_modem_access_queryModemState_co (gisi_comm_modem_access_queryModemStateData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean ____lambda37_ (Block1Data* _data1_);
static gboolean _____lambda37__gsource_func (gpointer self);
void gisi_comm_mtc_readState (GIsiCommMTC* self, GIsiCommMtcStatesResultFunc cb, void* cb_target);
static void ____lambda38_ (Block1Data* _data1_, GIsiCommErrorCode _error_, guint8 c, guint8 t);
static void _____lambda38__gisi_comm_mtc_states_result_func (GIsiCommErrorCode _error_, guint8 current, guint8 target, gpointer self);
const gchar* MTC_modem_state_to_string (guint8 self);
static const char* _MTC_modem_state_to_string (guint8 value);
static void gisi_comm_modem_access_onNetlinkStateChanged (GIsiCommModemAccess* self, GIsiModem* modem, guchar state, const gchar* iface);
const gchar* g_isi_phonet_link_state_to_string (guchar self);
static const char* _g_isi_phonet_link_state_to_string (guchar value);
GIsiCommModemAccess* gisi_comm_modem_access_new (const gchar* iface);
GIsiCommModemAccess* gisi_comm_modem_access_construct (GType object_type, const gchar* iface);
static void gisi_comm_modem_access_connect_data_free (gpointer _data);
void gisi_comm_modem_access_connect (GIsiCommModemAccess* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean gisi_comm_modem_access_connect_finish (GIsiCommModemAccess* self, GAsyncResult* _res_);
static gboolean gisi_comm_modem_access_connect_co (GisiCommModemAccessConnectData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _gisi_comm_modem_access_onNetlinkStateChanged_gisi_phonet_netlink_func (GIsiModem* modem, guchar st, const gchar* iface, gpointer self);
static gboolean ___lambda39_ (Block2Data* _data2_);
static gboolean ____lambda39__gsource_func (gpointer self);
static void gisi_comm_modem_access_disconnect_data_free (gpointer _data);
void gisi_comm_modem_access_disconnect (GIsiCommModemAccess* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gisi_comm_modem_access_disconnect_finish (GIsiCommModemAccess* self, GAsyncResult* _res_);
static gboolean gisi_comm_modem_access_disconnect_co (GisiCommModemAccessDisconnectData* _data_);
static void gisi_comm_modem_access_launch_data_free (gpointer _data);
void gisi_comm_modem_access_launch (GIsiCommModemAccess* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean gisi_comm_modem_access_launch_finish (GIsiCommModemAccess* self, GAsyncResult* _res_);
static gboolean gisi_comm_modem_access_launch_co (GisiCommModemAccessLaunchData* _data_);
GIsiCommMTC* gisi_comm_mtc_new (GIsiModem* modem);
GIsiCommMTC* gisi_comm_mtc_construct (GType object_type, GIsiModem* modem);
void gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline (GIsiCommAbstractBaseClient* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_finish (GIsiCommAbstractBaseClient* self, GAsyncResult* _res_);
static void gisi_comm_modem_access_launch_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GIsiCommPhoneInfo* gisi_comm_phone_info_new (GIsiModem* modem);
GIsiCommPhoneInfo* gisi_comm_phone_info_construct (GType object_type, GIsiModem* modem);
GIsiCommSIM* gisi_comm_sim_new (GIsiModem* modem);
GIsiCommSIM* gisi_comm_sim_construct (GType object_type, GIsiModem* modem);
GIsiCommSIMAuth* gisi_comm_sim_auth_new (GIsiModem* modem);
GIsiCommSIMAuth* gisi_comm_sim_auth_construct (GType object_type, GIsiModem* modem);
GIsiCommCall* gisi_comm_call_new (GIsiModem* modem);
GIsiCommCall* gisi_comm_call_construct (GType object_type, GIsiModem* modem);
GIsiCommSMS* gisi_comm_sms_new (GIsiModem* modem);
GIsiCommSMS* gisi_comm_sms_construct (GType object_type, GIsiModem* modem);
GIsiCommSS* gisi_comm_ss_new (GIsiModem* modem);
GIsiCommSS* gisi_comm_ss_construct (GType object_type, GIsiModem* modem);
GIsiCommGSS* gisi_comm_gss_new (GIsiModem* modem);
GIsiCommGSS* gisi_comm_gss_construct (GType object_type, GIsiModem* modem);
GIsiCommNetwork* gisi_comm_network_new (GIsiModem* modem);
GIsiCommNetwork* gisi_comm_network_construct (GType object_type, GIsiModem* modem);
GIsiCommGPDS* gisi_comm_gpds_new (GIsiModem* modem);
GIsiCommGPDS* gisi_comm_gpds_construct (GType object_type, GIsiModem* modem);
GIsiCommEpocInfo* gisi_comm_epoc_info_new (GIsiModem* modem);
GIsiCommEpocInfo* gisi_comm_epoc_info_construct (GType object_type, GIsiModem* modem);
static void gisi_comm_modem_access_startup_data_free (gpointer _data);
void gisi_comm_modem_access_startup (GIsiCommModemAccess* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean gisi_comm_modem_access_startup_finish (GIsiCommModemAccess* self, GAsyncResult* _res_);
static gboolean gisi_comm_modem_access_startup_co (GisiCommModemAccessStartupData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
void gisi_comm_mtc_startupSynq (GIsiCommMTC* self, GIsiCommVoidResultFunc cb, void* cb_target);
static void __lambda40_ (Block3Data* _data3_, GIsiCommErrorCode _error_);
static void ___lambda40__gisi_comm_void_result_func (GIsiCommErrorCode _error_, gpointer self);
static gboolean _gisi_comm_modem_access_startup_co_gsource_func (gpointer self);
static void gisi_comm_modem_access_poweron_data_free (gpointer _data);
void gisi_comm_modem_access_poweron (GIsiCommModemAccess* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean gisi_comm_modem_access_poweron_finish (GIsiCommModemAccess* self, GAsyncResult* _res_);
static gboolean gisi_comm_modem_access_poweron_co (GisiCommModemAccessPoweronData* _data_);
static void gisi_comm_modem_access_finalize (GIsiCommModemAccess* obj);
enum  {
	GISI_COMM_ABSTRACT_BASE_CLIENT_DUMMY_PROPERTY
};
GIsiCommAbstractBaseClient* gisi_comm_abstract_base_client_construct (GType object_type);
static void gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_data_free (gpointer _data);
static gboolean gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_co (gisi_comm_abstract_base_client_waitUntilSubsystemIsOnlineData* _data_);
static void gisi_comm_abstract_base_client_onReachabilityResultReceived (GIsiCommAbstractBaseClient* self, GIsiMessage* msg);
static void _gisi_comm_abstract_base_client_onReachabilityResultReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
static gboolean _gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_co_gsource_func (gpointer self);
const gchar* g_isi_phonet_subsystem_to_string (guchar self);
static const char* _g_isi_phonet_subsystem_to_string (guchar value);
void gisi_comm_abstract_base_client_onSubsystemIsReachable (GIsiCommAbstractBaseClient* self);
static void gisi_comm_abstract_base_client_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* self);
void gisi_comm_abstract_base_client_sendGenericRequest (GIsiCommAbstractBaseClient* self, guint8* req, int req_length1, GIsiCommByteArrayResultFunc cb, void* cb_target);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void __lambda0_ (Block4Data* _data4_, GIsiMessage* msg);
static void ___lambda0__gisi_notify_func (GIsiMessage* msg, gpointer self);
guint8 gisi_comm_abstract_base_client_align4 (GIsiCommAbstractBaseClient* self, guint8 size);
static void gisi_comm_abstract_base_client_finalize (GIsiCommAbstractBaseClient* obj);
void gisi_comm_checked (gboolean predicate, GError** error);
void gisi_comm_parseSimpleString (GIsiMessage* msg, GIsiCommStringResultFunc cb, void* cb_target);
enum  {
	GISI_COMM_MTC_DUMMY_PROPERTY
};
static void gisi_comm_mtc_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base);
static void gisi_comm_mtc_onStateInfoIndicationReceived (GIsiCommMTC* self, GIsiMessage* msg);
static void _gisi_comm_mtc_onStateInfoIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
static void ___lambda2_ (GIsiCommMTC* self, GIsiCommErrorCode _error_, guint8 current, guint8 target);
static void ____lambda2__gisi_comm_mtc_states_result_func (GIsiCommErrorCode _error_, guint8 current, guint8 target, gpointer self);
const gchar* MTC_isi_action_to_string (guint8 self);
static const char* _MTC_isi_action_to_string (guint8 value);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void __lambda1_ (Block5Data* _data5_, GIsiMessage* msg);
static void ___lambda1__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_mtc_setState (GIsiCommMTC* self, gboolean on, gboolean online, GIsiCommIntResultFunc cb, void* cb_target);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void __lambda3_ (Block6Data* _data6_, GIsiMessage* msg);
static void ___lambda3__gisi_notify_func (GIsiMessage* msg, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static void __lambda4_ (Block7Data* _data7_, GIsiMessage* msg);
static void ___lambda4__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_mtc_setPower (GIsiCommMTC* self, gboolean on, GIsiCommMTCIsiCauseResultFunc cb, void* cb_target);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static void __lambda5_ (Block8Data* _data8_, GIsiMessage* msg);
const gchar* MTC_isi_cause_to_string (guint8 self);
static const char* _MTC_isi_cause_to_string (guint8 value);
static void ___lambda5__gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_mtc_finalize (GIsiCommAbstractBaseClient* obj);
enum  {
	GISI_COMM_PHONE_INFO_DUMMY_PROPERTY
};
static void gisi_comm_phone_info_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base);
void gisi_comm_phone_info_readManufacturer (GIsiCommPhoneInfo* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
static void __lambda6_ (Block9Data* _data9_, GIsiMessage* msg);
static void ___lambda6__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_phone_info_readModel (GIsiCommPhoneInfo* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static void __lambda7_ (Block10Data* _data10_, GIsiMessage* msg);
static void ___lambda7__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_phone_info_readSerial (GIsiCommPhoneInfo* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static void __lambda8_ (Block11Data* _data11_, GIsiMessage* msg);
static void ___lambda8__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_phone_info_readVersion (GIsiCommPhoneInfo* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
static void __lambda9_ (Block12Data* _data12_, GIsiMessage* msg);
const gchar* INFO_subblock_type_to_string (guint8 self);
static const char* _INFO_subblock_type_to_string (guint8 value);
static void ___lambda9__gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_phone_info_finalize (GIsiCommAbstractBaseClient* obj);
enum  {
	GISI_COMM_SIM_AUTH_DUMMY_PROPERTY
};
static void gisi_comm_sim_auth_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base);
void gisi_comm_sim_auth_queryStatus (GIsiCommSIMAuth* self, GIsiCommIntResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static void __lambda19_ (GIsiCommSIMAuth* self, GIsiCommErrorCode _error_, gint _result_);
static void ___lambda19__gisi_comm_int_result_func (GIsiCommErrorCode _error_, gint _result_, gpointer self);
static void gisi_comm_sim_auth_onIndicationReceived (GIsiCommSIMAuth* self, GIsiMessage* msg);
static void _gisi_comm_sim_auth_onIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
static void __lambda18_ (Block13Data* _data13_, GIsiMessage* msg);
static void ___lambda18__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_sim_auth_sendPin (GIsiCommSIMAuth* self, const gchar* pin, GIsiCommIntResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (Block14Data* _data14_);
static void __lambda20_ (Block14Data* _data14_, GIsiMessage* msg);
static void ___lambda20__gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_sim_auth_changePin_data_free (gpointer _data);
void gisi_comm_sim_auth_changePin (GIsiCommSIMAuth* self, const gchar* oldpin, const gchar* newpin, GIsiCommVoidResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gisi_comm_sim_auth_changePin_finish (GIsiCommSIMAuth* self, GAsyncResult* _res_);
static gboolean gisi_comm_sim_auth_changePin_co (gisi_comm_sim_auth_changePinData* _data_);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (Block15Data* _data15_);
static void __lambda21_ (Block15Data* _data15_, GIsiMessage* msg);
static void ___lambda21__gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_sim_auth_finalize (GIsiCommAbstractBaseClient* obj);
#define GISI_COMM_SIM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GISI_COMM_TYPE_SIM, GIsiCommSIMPrivate))
enum  {
	GISI_COMM_SIM_DUMMY_PROPERTY
};
static void gisi_comm_sim_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base);
static void gisi_comm_sim_onIndicationReceived (GIsiCommSIM* self, GIsiMessage* msg);
static void _gisi_comm_sim_onIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_sim_readHPLMN (GIsiCommSIM* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (Block16Data* _data16_);
static void __lambda10_ (Block16Data* _data16_, GIsiMessage* msg);
static void ___lambda10__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_sim_readSPN (GIsiCommSIM* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (Block17Data* _data17_);
static void __lambda11_ (Block17Data* _data17_, GIsiMessage* msg);
GType gisi_comm_sim_isi_spn_get_type (void) G_GNUC_CONST;
GIsiCommSIMISI_SPN* gisi_comm_sim_isi_spn_dup (const GIsiCommSIMISI_SPN* self);
void gisi_comm_sim_isi_spn_free (GIsiCommSIMISI_SPN* self);
static void ___lambda11__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_sim_readIMSI (GIsiCommSIM* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (Block18Data* _data18_);
static void __lambda12_ (Block18Data* _data18_, GIsiMessage* msg);
GType gisi_comm_sim_isi_imsi_get_type (void) G_GNUC_CONST;
GIsiCommSIMISI_IMSI* gisi_comm_sim_isi_imsi_dup (const GIsiCommSIMISI_IMSI* self);
void gisi_comm_sim_isi_imsi_free (GIsiCommSIMISI_IMSI* self);
static void ___lambda12__gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_sim_finalize (GIsiCommAbstractBaseClient* obj);
#define GISI_COMM_NETWORK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GISI_COMM_TYPE_NETWORK, GIsiCommNetworkPrivate))
enum  {
	GISI_COMM_NETWORK_DUMMY_PROPERTY
};
static void gisi_comm_network_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base);
static void gisi_comm_network_onSignalStrengthIndicationReceived (GIsiCommNetwork* self, GIsiMessage* msg);
static void _gisi_comm_network_onSignalStrengthIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_network_onRegistrationStatusIndicationReceived (GIsiCommNetwork* self, GIsiMessage* msg);
static void _gisi_comm_network_onRegistrationStatusIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_network_onRadioAccessTechnologyIndicationReceived (GIsiCommNetwork* self, GIsiMessage* msg);
static void _gisi_comm_network_onRadioAccessTechnologyIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_network_onTimeIndicationReceived (GIsiCommNetwork* self, GIsiMessage* msg);
static void _gisi_comm_network_onTimeIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_network_queryRat (GIsiCommNetwork* self, GIsiCommIntResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static void __lambda23_ (GIsiCommNetwork* self, GIsiCommErrorCode _error_, gint _result_);
void gisi_comm_network_queryStatus (GIsiCommNetwork* self, GIsiCommIsiRegStatusResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static void __lambda25_ (GIsiCommNetwork* self, GIsiCommErrorCode _error_, GIsiCommNetworkISI_RegStatus* _result_);
static void ___lambda25__gisi_comm_isi_reg_status_result_func (GIsiCommErrorCode _error_, GIsiCommNetworkISI_RegStatus* status, gpointer self);
static void ___lambda23__gisi_comm_int_result_func (GIsiCommErrorCode _error_, gint _result_, gpointer self);
static void gisi_comm_network_parseRegistrationStatusMessage (GIsiCommNetwork* self, GIsiMessage* msg, GIsiCommNetworkISI_RegStatus* result);
const gchar* NET_registration_status_to_string (guint8 self);
static const char* _NET_registration_status_to_string (guint8 value);
const gchar* NET_operator_select_mode_to_string (guint8 self);
static const char* _NET_operator_select_mode_to_string (guint8 value);
GType gisi_comm_network_isi_time_get_type (void) G_GNUC_CONST;
GIsiCommNetworkISI_Time* gisi_comm_network_isi_time_dup (const GIsiCommNetworkISI_Time* self);
void gisi_comm_network_isi_time_free (GIsiCommNetworkISI_Time* self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (Block19Data* _data19_);
static void __lambda24_ (Block19Data* _data19_, GIsiMessage* msg);
static void ___lambda24__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_network_queryStrength (GIsiCommNetwork* self, GIsiCommIntResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (Block20Data* _data20_);
static void __lambda26_ (Block20Data* _data20_, GIsiMessage* msg);
static void ___lambda26__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_network_listProviders (GIsiCommNetwork* self, GIsiCommIsiProviderArrayResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (Block21Data* _data21_);
static void __lambda27_ (Block21Data* _data21_, GIsiMessage* msg);
static void _vala_GIsiCommNetworkISI_Provider_array_free (GIsiCommNetworkISI_Provider* array, gint array_length);
static void _vala_array_add1 (GIsiCommNetworkISI_Provider** array, int* length, int* size, const GIsiCommNetworkISI_Provider* value);
const gchar* NET_operator_status_to_string (guint8 self);
static const char* _NET_operator_status_to_string (guint8 value);
static void ___lambda27__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_network_registerAutomatic (GIsiCommNetwork* self, gboolean force, GIsiCommVoidResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (Block22Data* _data22_);
static void __lambda28_ (Block22Data* _data22_, GIsiMessage* msg);
static void ___lambda28__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_network_registerManual (GIsiCommNetwork* self, const gchar* mcc, const gchar* mnc, GIsiCommVoidResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (Block23Data* _data23_);
static void __lambda29_ (Block23Data* _data23_, GIsiMessage* msg);
static void ___lambda29__gisi_notify_func (GIsiMessage* msg, gpointer self);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (Block24Data* _data24_);
static void __lambda22_ (Block24Data* _data24_, GIsiMessage* msg);
static void ___lambda22__gisi_notify_func (GIsiMessage* msg, gpointer self);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void gisi_comm_network_finalize (GIsiCommAbstractBaseClient* obj);
#define GISI_COMM_CALL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GISI_COMM_TYPE_CALL, GIsiCommCallPrivate))
enum  {
	GISI_COMM_CALL_DUMMY_PROPERTY
};
static void gisi_comm_call_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base);
static void gisi_comm_call_onStatusIndicationReceived (GIsiCommCall* self, GIsiMessage* msg);
static void _gisi_comm_call_onStatusIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
GType gisi_comm_call_isi_callstatus_get_type (void) G_GNUC_CONST;
GIsiCommCallISI_CallStatus* gisi_comm_call_isi_callstatus_dup (const GIsiCommCallISI_CallStatus* self);
void gisi_comm_call_isi_callstatus_free (GIsiCommCallISI_CallStatus* self);
void gisi_comm_call_isi_callstatus_copy (const GIsiCommCallISI_CallStatus* self, GIsiCommCallISI_CallStatus* dest);
void gisi_comm_call_isi_callstatus_destroy (GIsiCommCallISI_CallStatus* self);
static void gisi_comm_call_parseCallStatus (GIsiCommCall* self, GIsiMessage* msg, GIsiCommCallISI_CallStatus* result);
const gchar* CALL_mode_to_string (guint8 self);
static const char* _CALL_mode_to_string (guint8 value);
const gchar* CALL_mode_info_to_string (guint8 self);
static const char* _CALL_mode_info_to_string (guint8 value);
const gchar* CALL_status_to_string (guint8 self);
static const char* _CALL_status_to_string (guint8 value);
void gisi_comm_call_initiateVoiceCall (GIsiCommCall* self, const gchar* number, guint8 ntype, guint8 presentation, GIsiCommIntResultFunc cb, void* cb_target);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (Block25Data* _data25_);
static void __lambda13_ (Block25Data* _data25_, GIsiMessage* msg);
static void ___lambda13__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_call_releaseVoiceCall (GIsiCommCall* self, guint8 callid, guint8 causeType, guint8 causeValue, GIsiCommVoidResultFunc cb, void* cb_target);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (Block26Data* _data26_);
static void __lambda14_ (Block26Data* _data26_, GIsiMessage* msg);
static void ___lambda14__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_call_answerVoiceCall (GIsiCommCall* self, guint8 callid, GIsiCommVoidResultFunc cb, void* cb_target);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (Block27Data* _data27_);
static void __lambda15_ (Block27Data* _data27_, GIsiMessage* msg);
static void ___lambda15__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_call_controlVoiceCall (GIsiCommCall* self, guint8 callid, guint8 operation, guint8 param, GIsiCommVoidResultFunc cb, void* cb_target);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (Block28Data* _data28_);
static void __lambda16_ (Block28Data* _data28_, GIsiMessage* msg);
static void ___lambda16__gisi_notify_func (GIsiMessage* msg, gpointer self);
void gisi_comm_call_sendTonesOnVoiceCall (GIsiCommCall* self, guint8 callid, const gchar* tones, GIsiCommVoidResultFunc cb, void* cb_target);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (Block29Data* _data29_);
static void __lambda17_ (Block29Data* _data29_, GIsiMessage* msg);
static void ___lambda17__gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_call_finalize (GIsiCommAbstractBaseClient* obj);
#define GISI_COMM_SMS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GISI_COMM_TYPE_SMS, GIsiCommSMSPrivate))
enum  {
	GISI_COMM_SMS_DUMMY_PROPERTY
};
static void gisi_comm_sms_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base);
static void gisi_comm_sms_onSendStatusIndicationReceived (GIsiCommSMS* self, GIsiMessage* msg);
static void _gisi_comm_sms_onSendStatusIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_sms_finalize (GIsiCommAbstractBaseClient* obj);
#define GISI_COMM_GSS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GISI_COMM_TYPE_GSS, GIsiCommGSSPrivate))
enum  {
	GISI_COMM_GSS_DUMMY_PROPERTY
};
static void gisi_comm_gss_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base);
static void gisi_comm_gss_finalize (GIsiCommAbstractBaseClient* obj);
#define GISI_COMM_SS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GISI_COMM_TYPE_SS, GIsiCommSSPrivate))
enum  {
	GISI_COMM_SS_DUMMY_PROPERTY
};
static void gisi_comm_ss_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base);
static void gisi_comm_ss_onStatusIndicationReceived (GIsiCommSS* self, GIsiMessage* msg);
static void _gisi_comm_ss_onStatusIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_ss_onUssdReceiveIndicationReceived (GIsiCommSS* self, GIsiMessage* msg);
static void _gisi_comm_ss_onUssdReceiveIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_ss_finalize (GIsiCommAbstractBaseClient* obj);
gpointer gisi_comm_gpds_helper_ref (gpointer instance);
void gisi_comm_gpds_helper_unref (gpointer instance);
GParamSpec* gisi_comm_param_spec_gpds_helper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gisi_comm_value_set_gpds_helper (GValue* value, gpointer v_object);
void gisi_comm_value_take_gpds_helper (GValue* value, gpointer v_object);
gpointer gisi_comm_value_get_gpds_helper (const GValue* value);
GType gisi_comm_gpds_helper_get_type (void) G_GNUC_CONST;
enum  {
	GISI_COMM_GPDS_HELPER_DUMMY_PROPERTY
};
GIsiCommGPDSHelper* gisi_comm_gpds_helper_new (GIsiCommGPDS* instance, GSourceFunc cb, void* cb_target);
GIsiCommGPDSHelper* gisi_comm_gpds_helper_construct (GType object_type, GIsiCommGPDS* instance, GSourceFunc cb, void* cb_target);
static void gisi_comm_gpds_helper_finalize (GIsiCommGPDSHelper* obj);
#define GISI_COMM_GPDS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GISI_COMM_TYPE_GPDS, GIsiCommGPDSPrivate))
enum  {
	GISI_COMM_GPDS_DUMMY_PROPERTY
};
static void gisi_comm_gpds_onPipeCreated (GIsiPipe* p);
static void gisi_comm_gpds_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base);
static void gisi_comm_gpds_onDetachIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void _gisi_comm_gpds_onDetachIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_gpds_onTransferStatusIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void _gisi_comm_gpds_onTransferStatusIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_gpds_onContextActivateIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void _gisi_comm_gpds_onContextActivateIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_gpds_onContextDeactivateIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void _gisi_comm_gpds_onContextDeactivateIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_gpds_activate_data_free (gpointer _data);
void gisi_comm_gpds_activate (GIsiCommGPDS* self, const gchar* apn, const gchar* user, const gchar* pw, GIsiCommVoidResultFunc cb, void* cb_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gisi_comm_gpds_activate_finish (GIsiCommGPDS* self, GAsyncResult* _res_);
static gboolean gisi_comm_gpds_activate_co (GisiCommGpdsActivateData* _data_);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (Block30Data* _data30_);
static void __lambda30_ (GIsiCommGPDS* self, GIsiPEP* p);
static void ___lambda30__gisi_pep_callback (GIsiPEP* pep, gpointer self);
static void _gisi_comm_gpds_onPipeCreated_gisi_pipe_handler (GIsiPipe* pipe);
static gboolean _gisi_comm_gpds_activate_co_gsource_func (gpointer self);
static void __lambda31_ (Block30Data* _data30_, GIsiMessage* msg);
static void ___lambda31__gisi_notify_func (GIsiMessage* msg, gpointer self);
static void __lambda32_ (Block30Data* _data30_, GIsiMessage* msg);
static void ___lambda32__gisi_notify_func (GIsiMessage* msg, gpointer self);
static void __lambda33_ (Block30Data* _data30_, GIsiMessage* msg);
static void ___lambda33__gisi_notify_func (GIsiMessage* msg, gpointer self);
static void ___lambda34_ (Block30Data* _data30_, GIsiMessage* msg);
static void ____lambda34__gisi_notify_func (GIsiMessage* msg, gpointer self);
static void __lambda35_ (Block30Data* _data30_, GIsiMessage* msg);
static void ___lambda35__gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_gpds_deactivate_data_free (gpointer _data);
void gisi_comm_gpds_deactivate (GIsiCommGPDS* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gisi_comm_gpds_deactivate_finish (GIsiCommGPDS* self, GAsyncResult* _res_);
static gboolean gisi_comm_gpds_deactivate_co (GisiCommGpdsDeactivateData* _data_);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (Block31Data* _data31_);
static void __lambda36_ (Block31Data* _data31_, GIsiMessage* msg);
static void ___lambda36__gisi_notify_func (GIsiMessage* msg, gpointer self);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void gisi_comm_gpds_onContextIdCreateIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onContextIdDeleteIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onContextMwiActRequestIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onAttachIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onSmsPduReceiveIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onContextActivateFailIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onContextStatusIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onContextActivatingIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onContextModifyIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onAttachFailIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onContextDeactivatingIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onConfigurationInfoIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onRadioActivityIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onMbmsStatusIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onMbmsContextDeleteIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onMbmsServiceSelectionIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void gisi_comm_gpds_onMbmsServiceAvailableIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void gisi_comm_gpds_finalize (GIsiCommAbstractBaseClient* obj);
#define GISI_COMM_EPOC_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GISI_COMM_TYPE_EPOC_INFO, GIsiCommEpocInfoPrivate))
enum  {
	GISI_COMM_EPOC_INFO_DUMMY_PROPERTY
};
static void gisi_comm_epoc_info_onSerialNumberReadReq (GIsiCommEpocInfo* self, GIsiMessage* msg);
static void _gisi_comm_epoc_info_onSerialNumberReadReq_gisi_notify_func (GIsiMessage* msg, gpointer self);
static void gisi_comm_epoc_info_finalize (GIsiCommEpocInfo* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType gisi_comm_error_code_get_type (void) {
	static volatile gsize gisi_comm_error_code_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_error_code_type_id__volatile)) {
		static const GEnumValue values[] = {{GISI_COMM_ERROR_CODE_OK, "GISI_COMM_ERROR_CODE_OK", "ok"}, {GISI_COMM_ERROR_CODE_INVALID_FORMAT, "GISI_COMM_ERROR_CODE_INVALID_FORMAT", "invalid-format"}, {0, NULL, NULL}};
		GType gisi_comm_error_code_type_id;
		gisi_comm_error_code_type_id = g_enum_register_static ("GIsiCommErrorCode", values);
		g_once_init_leave (&gisi_comm_error_code_type_id__volatile, gisi_comm_error_code_type_id);
	}
	return gisi_comm_error_code_type_id__volatile;
}


GType gisi_comm_online_status_get_type (void) {
	static volatile gsize gisi_comm_online_status_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_online_status_type_id__volatile)) {
		static const GEnumValue values[] = {{GISI_COMM_ONLINE_STATUS_UNKNOWN, "GISI_COMM_ONLINE_STATUS_UNKNOWN", "unknown"}, {GISI_COMM_ONLINE_STATUS_NO, "GISI_COMM_ONLINE_STATUS_NO", "no"}, {GISI_COMM_ONLINE_STATUS_YES, "GISI_COMM_ONLINE_STATUS_YES", "yes"}, {0, NULL, NULL}};
		GType gisi_comm_online_status_type_id;
		gisi_comm_online_status_type_id = g_enum_register_static ("GIsiCommOnlineStatus", values);
		g_once_init_leave (&gisi_comm_online_status_type_id__volatile, gisi_comm_online_status_type_id);
	}
	return gisi_comm_online_status_type_id__volatile;
}


static void gisi_comm_modem_access_queryModemState_data_free (gpointer _data) {
	gisi_comm_modem_access_queryModemStateData* _data_;
	_data_ = _data;
	_gisi_comm_modem_access_unref0 (_data_->self);
	g_slice_free (gisi_comm_modem_access_queryModemStateData, _data_);
}


static gpointer _gisi_comm_modem_access_ref0 (gpointer self) {
	return self ? gisi_comm_modem_access_ref (self) : NULL;
}


static void gisi_comm_modem_access_queryModemState (GIsiCommModemAccess* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	gisi_comm_modem_access_queryModemStateData* _data_;
	GIsiCommModemAccess* _tmp0_;
	_data_ = g_slice_new0 (gisi_comm_modem_access_queryModemStateData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, gisi_comm_modem_access_queryModemState);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gisi_comm_modem_access_queryModemState_data_free);
	_tmp0_ = _gisi_comm_modem_access_ref0 (self);
	_data_->self = _tmp0_;
	gisi_comm_modem_access_queryModemState_co (_data_);
}


static guint8 gisi_comm_modem_access_queryModemState_finish (GIsiCommModemAccess* self, GAsyncResult* _res_) {
	guint8 result;
	gisi_comm_modem_access_queryModemStateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_gisi_comm_modem_access_unref0 (_data1_->self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean ____lambda37_ (Block1Data* _data1_) {
	GIsiCommModemAccess * self;
	gboolean result = FALSE;
	self = _data1_->self;
	gisi_comm_modem_access_queryModemState_co (_data1_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean _____lambda37__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda37_ (self);
	return result;
}


static void ____lambda38_ (Block1Data* _data1_, GIsiCommErrorCode _error_, guint8 c, guint8 t) {
	GIsiCommModemAccess * self;
	GIsiCommErrorCode _tmp0_;
	self = _data1_->self;
	_tmp0_ = _error_;
	if (_tmp0_ != GISI_COMM_ERROR_CODE_OK) {
		g_debug ("gisicomm.vala:91: ERROR GETTING STATE");
	} else {
		guint8 _tmp1_;
		guint8 _tmp2_;
		_tmp1_ = c;
		_data1_->current = _tmp1_;
		_tmp2_ = t;
		_data1_->target = _tmp2_;
		gisi_comm_modem_access_queryModemState_co (_data1_->_async_data_);
	}
}


static void _____lambda38__gisi_comm_mtc_states_result_func (GIsiCommErrorCode _error_, guint8 current, guint8 target, gpointer self) {
	____lambda38_ (self, _error_, current, target);
}


static const char* _MTC_modem_state_to_string (guint8 value) {
	switch (value) {
		case MTC_STATE_NONE:
		return "MTC_STATE_NONE";
		case MTC_POWER_OFF:
		return "MTC_POWER_OFF";
		case MTC_NORMAL:
		return "MTC_NORMAL";
		case MTC_CHARGING:
		return "MTC_CHARGING";
		case MTC_ALARM:
		return "MTC_ALARM";
		case MTC_TEST:
		return "MTC_TEST";
		case MTC_LOCAL:
		return "MTC_LOCAL";
		case MTC_WARRANTY:
		return "MTC_WARRANTY";
		case MTC_RELIABILITY:
		return "MTC_RELIABILITY";
		case MTC_SELFTEST_FAIL:
		return "MTC_SELFTEST_FAIL";
		case MTC_SWDL:
		return "MTC_SWDL";
		case MTC_RF_INACTIVE:
		return "MTC_RF_INACTIVE";
		case MTC_ID_WRITE:
		return "MTC_ID_WRITE";
		case MTC_DISCHARGING:
		return "MTC_DISCHARGING";
		case MTC_DISK_WIPE:
		return "MTC_DISK_WIPE";
		case MTC_SW_RESET:
		return "MTC_SW_RESET";
		case MTC_CMT_ONLY_MODE:
		return "MTC_CMT_ONLY_MODE";
	}
	return NULL;
}


static gboolean gisi_comm_modem_access_queryModemState_co (gisi_comm_modem_access_queryModemStateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = gisi_comm_modem_access_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->ok = FALSE;
	_data_->_data1_->current = 0xE3;
	_data_->_data1_->target = 0xE4;
	{
		_data_->_tmp0_ = TRUE;
		while (TRUE) {
			_data_->_tmp1_ = _data_->_tmp0_;
			if (!_data_->_tmp1_) {
				_data_->_tmp2_ = _data_->_data1_->current;
				_data_->_tmp3_ = _data_->_data1_->target;
				if (!(_data_->_tmp2_ != _data_->_tmp3_)) {
					break;
				}
			}
			_data_->_tmp0_ = FALSE;
			g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _____lambda37__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
			_data_->_state_ = 1;
			return FALSE;
			_state_1:
			;
			_data_->_tmp4_ = _data_->self->mtc;
			gisi_comm_mtc_readState (_data_->_tmp4_, _____lambda38__gisi_comm_mtc_states_result_func, _data_->_data1_);
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
			_data_->_tmp5_ = _data_->_data1_->current;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = _MTC_modem_state_to_string (_data_->_tmp5_);
			_data_->_tmp7_ = _data_->_data1_->target;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _MTC_modem_state_to_string (_data_->_tmp7_);
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = g_strconcat ("MODEM STATE NOW ", _data_->_tmp6_, ", TARGET = ", _data_->_tmp8_, NULL);
			_data_->_tmp10_ = _data_->_tmp9_;
			g_debug ("gisicomm.vala:103: %s", _data_->_tmp10_);
			_g_free0 (_data_->_tmp10_);
		}
	}
	_data_->_tmp11_ = _data_->_data1_->current;
	_data_->result = _data_->_tmp11_;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static const char* _g_isi_phonet_link_state_to_string (guchar value) {
	switch (value) {
		case PN_LINK_REMOVED:
		return "PN_LINK_REMOVED";
		case PN_LINK_DOWN:
		return "PN_LINK_DOWN";
		case PN_LINK_UP:
		return "PN_LINK_UP";
	}
	return NULL;
}


static void gisi_comm_modem_access_onNetlinkStateChanged (GIsiCommModemAccess* self, GIsiModem* modem, guchar state, const gchar* iface) {
	guchar _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GIsiCommOnlineStatus _tmp5_;
	gboolean _tmp7_;
	GIsiCommOnlineStatus _tmp8_ = 0;
	guchar _tmp9_;
	GIsiCommOnlineStatus _tmp10_;
	GIsiCommOnlineStatus _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (modem != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = state;
	_tmp1_ = _g_isi_phonet_link_state_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("NETLINK STATE = ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	g_debug ("gisicomm.vala:112: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp5_ = self->online;
	if (_tmp5_ == GISI_COMM_ONLINE_STATUS_UNKNOWN) {
		guchar _tmp6_;
		_tmp6_ = state;
		_tmp4_ = _tmp6_ == PN_LINK_DOWN;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		return;
	}
	_tmp9_ = state;
	if (_tmp9_ == PN_LINK_UP) {
		_tmp8_ = GISI_COMM_ONLINE_STATUS_YES;
	} else {
		_tmp8_ = GISI_COMM_ONLINE_STATUS_NO;
	}
	_tmp10_ = _tmp8_;
	self->online = _tmp10_;
	_tmp11_ = self->online;
	g_signal_emit_by_name (self, "netlink-changed", _tmp11_ == GISI_COMM_ONLINE_STATUS_YES);
}


GIsiCommModemAccess* gisi_comm_modem_access_construct (GType object_type, const gchar* iface) {
	GIsiCommModemAccess* self = NULL;
	const gchar* _tmp0_;
	GIsiModem* _tmp1_;
	g_return_val_if_fail (iface != NULL, NULL);
	self = (GIsiCommModemAccess*) g_type_create_instance (object_type);
	_tmp0_ = iface;
	_tmp1_ = g_isi_modem_create_by_name (_tmp0_);
	_g_isi_modem_destroy0 (self->m);
	self->m = _tmp1_;
	return self;
}


GIsiCommModemAccess* gisi_comm_modem_access_new (const gchar* iface) {
	return gisi_comm_modem_access_construct (GISI_COMM_TYPE_MODEM_ACCESS, iface);
}


static void gisi_comm_modem_access_connect_data_free (gpointer _data) {
	GisiCommModemAccessConnectData* _data_;
	_data_ = _data;
	_gisi_comm_modem_access_unref0 (_data_->self);
	g_slice_free (GisiCommModemAccessConnectData, _data_);
}


void gisi_comm_modem_access_connect (GIsiCommModemAccess* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GisiCommModemAccessConnectData* _data_;
	GIsiCommModemAccess* _tmp0_;
	_data_ = g_slice_new0 (GisiCommModemAccessConnectData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, gisi_comm_modem_access_connect);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gisi_comm_modem_access_connect_data_free);
	_tmp0_ = _gisi_comm_modem_access_ref0 (self);
	_data_->self = _tmp0_;
	gisi_comm_modem_access_connect_co (_data_);
}


gboolean gisi_comm_modem_access_connect_finish (GIsiCommModemAccess* self, GAsyncResult* _res_) {
	gboolean result;
	GisiCommModemAccessConnectData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_gisi_comm_modem_access_unref0 (_data2_->self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _gisi_comm_modem_access_onNetlinkStateChanged_gisi_phonet_netlink_func (GIsiModem* modem, guchar st, const gchar* iface, gpointer self) {
	gisi_comm_modem_access_onNetlinkStateChanged (self, modem, st, iface);
}


static gboolean ___lambda39_ (Block2Data* _data2_) {
	GIsiCommModemAccess * self;
	gboolean result = FALSE;
	self = _data2_->self;
	gisi_comm_modem_access_connect_co (_data2_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean ____lambda39__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda39_ (self);
	return result;
}


static gboolean gisi_comm_modem_access_connect_co (GisiCommModemAccessConnectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = gisi_comm_modem_access_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->m;
	if (_data_->_tmp0_ == NULL) {
		_data_->result = FALSE;
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->m;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_isi_pn_netlink_start (_data_->_tmp1_, _gisi_comm_modem_access_onNetlinkStateChanged_gisi_phonet_netlink_func, _data_->self);
	_data_->self->netlink = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->netlink;
	if (_data_->_tmp3_ == NULL) {
		_data_->result = FALSE;
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	while (TRUE) {
		_data_->_tmp4_ = _data_->self->online;
		if (!(_data_->_tmp4_ == GISI_COMM_ONLINE_STATUS_UNKNOWN)) {
			break;
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda39__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
		g_debug ("gisicomm.vala:142: waiting for netlink state to change...");
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	_data_->_tmp5_ = _data_->self->online;
	_data_->result = _data_->_tmp5_ == GISI_COMM_ONLINE_STATUS_YES;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void gisi_comm_modem_access_disconnect_data_free (gpointer _data) {
	GisiCommModemAccessDisconnectData* _data_;
	_data_ = _data;
	_gisi_comm_modem_access_unref0 (_data_->self);
	g_slice_free (GisiCommModemAccessDisconnectData, _data_);
}


void gisi_comm_modem_access_disconnect (GIsiCommModemAccess* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GisiCommModemAccessDisconnectData* _data_;
	GIsiCommModemAccess* _tmp0_;
	_data_ = g_slice_new0 (GisiCommModemAccessDisconnectData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, gisi_comm_modem_access_disconnect);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gisi_comm_modem_access_disconnect_data_free);
	_tmp0_ = _gisi_comm_modem_access_ref0 (self);
	_data_->self = _tmp0_;
	gisi_comm_modem_access_disconnect_co (_data_);
}


void gisi_comm_modem_access_disconnect_finish (GIsiCommModemAccess* self, GAsyncResult* _res_) {
	GisiCommModemAccessDisconnectData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean gisi_comm_modem_access_disconnect_co (GisiCommModemAccessDisconnectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->m;
	if (_data_->_tmp0_ == NULL) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->netlink;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->netlink;
		g_isi_pn_netlink_stop (_data_->_tmp2_);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void gisi_comm_modem_access_launch_data_free (gpointer _data) {
	GisiCommModemAccessLaunchData* _data_;
	_data_ = _data;
	_gisi_comm_modem_access_unref0 (_data_->self);
	g_slice_free (GisiCommModemAccessLaunchData, _data_);
}


void gisi_comm_modem_access_launch (GIsiCommModemAccess* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GisiCommModemAccessLaunchData* _data_;
	GIsiCommModemAccess* _tmp0_;
	_data_ = g_slice_new0 (GisiCommModemAccessLaunchData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, gisi_comm_modem_access_launch);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gisi_comm_modem_access_launch_data_free);
	_tmp0_ = _gisi_comm_modem_access_ref0 (self);
	_data_->self = _tmp0_;
	gisi_comm_modem_access_launch_co (_data_);
}


gboolean gisi_comm_modem_access_launch_finish (GIsiCommModemAccess* self, GAsyncResult* _res_) {
	gboolean result;
	GisiCommModemAccessLaunchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void gisi_comm_modem_access_launch_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GisiCommModemAccessLaunchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gisi_comm_modem_access_launch_co (_data_);
}


static gboolean gisi_comm_modem_access_launch_co (GisiCommModemAccessLaunchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
		case 9:
		goto _state_9;
		case 10:
		goto _state_10;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->m;
	_data_->_tmp1_ = gisi_comm_mtc_new (_data_->_tmp0_);
	_gisi_comm_abstract_base_client_unref0 (_data_->self->mtc);
	_data_->self->mtc = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->mtc;
	_data_->_state_ = 1;
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline ((GIsiCommAbstractBaseClient*) _data_->_tmp2_, gisi_comm_modem_access_launch_ready, _data_);
	return FALSE;
	_state_1:
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_finish ((GIsiCommAbstractBaseClient*) _data_->_tmp2_, _data_->_res_);
	_data_->_tmp3_ = _data_->self->m;
	_data_->_tmp4_ = gisi_comm_phone_info_new (_data_->_tmp3_);
	_gisi_comm_abstract_base_client_unref0 (_data_->self->info);
	_data_->self->info = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->info;
	_data_->_state_ = 2;
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline ((GIsiCommAbstractBaseClient*) _data_->_tmp5_, gisi_comm_modem_access_launch_ready, _data_);
	return FALSE;
	_state_2:
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_finish ((GIsiCommAbstractBaseClient*) _data_->_tmp5_, _data_->_res_);
	_data_->_tmp6_ = _data_->self->m;
	_data_->_tmp7_ = gisi_comm_sim_new (_data_->_tmp6_);
	_gisi_comm_abstract_base_client_unref0 (_data_->self->sim);
	_data_->self->sim = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->self->sim;
	_data_->_state_ = 3;
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline ((GIsiCommAbstractBaseClient*) _data_->_tmp8_, gisi_comm_modem_access_launch_ready, _data_);
	return FALSE;
	_state_3:
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_finish ((GIsiCommAbstractBaseClient*) _data_->_tmp8_, _data_->_res_);
	_data_->_tmp9_ = _data_->self->m;
	_data_->_tmp10_ = gisi_comm_sim_auth_new (_data_->_tmp9_);
	_gisi_comm_abstract_base_client_unref0 (_data_->self->simauth);
	_data_->self->simauth = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->self->simauth;
	_data_->_state_ = 4;
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline ((GIsiCommAbstractBaseClient*) _data_->_tmp11_, gisi_comm_modem_access_launch_ready, _data_);
	return FALSE;
	_state_4:
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_finish ((GIsiCommAbstractBaseClient*) _data_->_tmp11_, _data_->_res_);
	_data_->_tmp12_ = _data_->self->m;
	_data_->_tmp13_ = gisi_comm_call_new (_data_->_tmp12_);
	_gisi_comm_abstract_base_client_unref0 (_data_->self->call);
	_data_->self->call = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->self->call;
	_data_->_state_ = 5;
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline ((GIsiCommAbstractBaseClient*) _data_->_tmp14_, gisi_comm_modem_access_launch_ready, _data_);
	return FALSE;
	_state_5:
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_finish ((GIsiCommAbstractBaseClient*) _data_->_tmp14_, _data_->_res_);
	_data_->_tmp15_ = _data_->self->m;
	_data_->_tmp16_ = gisi_comm_sms_new (_data_->_tmp15_);
	_gisi_comm_abstract_base_client_unref0 (_data_->self->sms);
	_data_->self->sms = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->self->sms;
	_data_->_state_ = 6;
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline ((GIsiCommAbstractBaseClient*) _data_->_tmp17_, gisi_comm_modem_access_launch_ready, _data_);
	return FALSE;
	_state_6:
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_finish ((GIsiCommAbstractBaseClient*) _data_->_tmp17_, _data_->_res_);
	_data_->_tmp18_ = _data_->self->m;
	_data_->_tmp19_ = gisi_comm_ss_new (_data_->_tmp18_);
	_gisi_comm_abstract_base_client_unref0 (_data_->self->ss);
	_data_->self->ss = _data_->_tmp19_;
	_data_->_tmp20_ = _data_->self->ss;
	_data_->_state_ = 7;
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline ((GIsiCommAbstractBaseClient*) _data_->_tmp20_, gisi_comm_modem_access_launch_ready, _data_);
	return FALSE;
	_state_7:
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_finish ((GIsiCommAbstractBaseClient*) _data_->_tmp20_, _data_->_res_);
	_data_->_tmp21_ = _data_->self->m;
	_data_->_tmp22_ = gisi_comm_gss_new (_data_->_tmp21_);
	_gisi_comm_abstract_base_client_unref0 (_data_->self->gss);
	_data_->self->gss = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->self->gss;
	_data_->_state_ = 8;
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline ((GIsiCommAbstractBaseClient*) _data_->_tmp23_, gisi_comm_modem_access_launch_ready, _data_);
	return FALSE;
	_state_8:
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_finish ((GIsiCommAbstractBaseClient*) _data_->_tmp23_, _data_->_res_);
	_data_->_tmp24_ = _data_->self->m;
	_data_->_tmp25_ = gisi_comm_network_new (_data_->_tmp24_);
	_gisi_comm_abstract_base_client_unref0 (_data_->self->net);
	_data_->self->net = _data_->_tmp25_;
	_data_->_tmp26_ = _data_->self->net;
	_data_->_state_ = 9;
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline ((GIsiCommAbstractBaseClient*) _data_->_tmp26_, gisi_comm_modem_access_launch_ready, _data_);
	return FALSE;
	_state_9:
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_finish ((GIsiCommAbstractBaseClient*) _data_->_tmp26_, _data_->_res_);
	_data_->_tmp27_ = _data_->self->m;
	_data_->_tmp28_ = gisi_comm_gpds_new (_data_->_tmp27_);
	_gisi_comm_abstract_base_client_unref0 (_data_->self->gpds);
	_data_->self->gpds = _data_->_tmp28_;
	_data_->_tmp29_ = _data_->self->gpds;
	_data_->_state_ = 10;
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline ((GIsiCommAbstractBaseClient*) _data_->_tmp29_, gisi_comm_modem_access_launch_ready, _data_);
	return FALSE;
	_state_10:
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_finish ((GIsiCommAbstractBaseClient*) _data_->_tmp29_, _data_->_res_);
	_data_->_tmp30_ = _data_->self->m;
	_data_->_tmp31_ = gisi_comm_epoc_info_new (_data_->_tmp30_);
	_gisi_comm_epoc_info_unref0 (_data_->self->epoc);
	_data_->self->epoc = _data_->_tmp31_;
	_data_->_tmp40_ = _data_->self->mtc;
	_data_->_tmp41_ = ((GIsiCommAbstractBaseClient*) _data_->_tmp40_)->reachable;
	if (_data_->_tmp41_) {
		_data_->_tmp42_ = _data_->self->info;
		_data_->_tmp43_ = ((GIsiCommAbstractBaseClient*) _data_->_tmp42_)->reachable;
		_data_->_tmp39_ = _data_->_tmp43_;
	} else {
		_data_->_tmp39_ = FALSE;
	}
	_data_->_tmp44_ = _data_->_tmp39_;
	if (_data_->_tmp44_) {
		_data_->_tmp45_ = _data_->self->sim;
		_data_->_tmp46_ = ((GIsiCommAbstractBaseClient*) _data_->_tmp45_)->reachable;
		_data_->_tmp38_ = _data_->_tmp46_;
	} else {
		_data_->_tmp38_ = FALSE;
	}
	_data_->_tmp47_ = _data_->_tmp38_;
	if (_data_->_tmp47_) {
		_data_->_tmp48_ = _data_->self->call;
		_data_->_tmp49_ = ((GIsiCommAbstractBaseClient*) _data_->_tmp48_)->reachable;
		_data_->_tmp37_ = _data_->_tmp49_;
	} else {
		_data_->_tmp37_ = FALSE;
	}
	_data_->_tmp50_ = _data_->_tmp37_;
	if (_data_->_tmp50_) {
		_data_->_tmp51_ = _data_->self->sms;
		_data_->_tmp52_ = ((GIsiCommAbstractBaseClient*) _data_->_tmp51_)->reachable;
		_data_->_tmp36_ = _data_->_tmp52_;
	} else {
		_data_->_tmp36_ = FALSE;
	}
	_data_->_tmp53_ = _data_->_tmp36_;
	if (_data_->_tmp53_) {
		_data_->_tmp54_ = _data_->self->ss;
		_data_->_tmp55_ = ((GIsiCommAbstractBaseClient*) _data_->_tmp54_)->reachable;
		_data_->_tmp35_ = _data_->_tmp55_;
	} else {
		_data_->_tmp35_ = FALSE;
	}
	_data_->_tmp56_ = _data_->_tmp35_;
	if (_data_->_tmp56_) {
		_data_->_tmp57_ = _data_->self->gss;
		_data_->_tmp58_ = ((GIsiCommAbstractBaseClient*) _data_->_tmp57_)->reachable;
		_data_->_tmp34_ = _data_->_tmp58_;
	} else {
		_data_->_tmp34_ = FALSE;
	}
	_data_->_tmp59_ = _data_->_tmp34_;
	if (_data_->_tmp59_) {
		_data_->_tmp60_ = _data_->self->net;
		_data_->_tmp61_ = ((GIsiCommAbstractBaseClient*) _data_->_tmp60_)->reachable;
		_data_->_tmp33_ = _data_->_tmp61_;
	} else {
		_data_->_tmp33_ = FALSE;
	}
	_data_->_tmp62_ = _data_->_tmp33_;
	if (_data_->_tmp62_) {
		_data_->_tmp63_ = _data_->self->gpds;
		_data_->_tmp64_ = ((GIsiCommAbstractBaseClient*) _data_->_tmp63_)->reachable;
		_data_->_tmp32_ = _data_->_tmp64_;
	} else {
		_data_->_tmp32_ = FALSE;
	}
	_data_->_tmp65_ = _data_->_tmp32_;
	_data_->result = _data_->_tmp65_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void gisi_comm_modem_access_startup_data_free (gpointer _data) {
	GisiCommModemAccessStartupData* _data_;
	_data_ = _data;
	_gisi_comm_modem_access_unref0 (_data_->self);
	g_slice_free (GisiCommModemAccessStartupData, _data_);
}


void gisi_comm_modem_access_startup (GIsiCommModemAccess* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GisiCommModemAccessStartupData* _data_;
	GIsiCommModemAccess* _tmp0_;
	_data_ = g_slice_new0 (GisiCommModemAccessStartupData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, gisi_comm_modem_access_startup);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gisi_comm_modem_access_startup_data_free);
	_tmp0_ = _gisi_comm_modem_access_ref0 (self);
	_data_->self = _tmp0_;
	gisi_comm_modem_access_startup_co (_data_);
}


gboolean gisi_comm_modem_access_startup_finish (GIsiCommModemAccess* self, GAsyncResult* _res_) {
	gboolean result;
	GisiCommModemAccessStartupData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_gisi_comm_modem_access_unref0 (_data3_->self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda40_ (Block3Data* _data3_, GIsiCommErrorCode _error_) {
	GIsiCommModemAccess * self;
	GIsiCommErrorCode _tmp0_;
	self = _data3_->self;
	_tmp0_ = _error_;
	_data3_->ok = _tmp0_ == GISI_COMM_ERROR_CODE_OK;
	gisi_comm_modem_access_startup_co (_data3_->_async_data_);
}


static void ___lambda40__gisi_comm_void_result_func (GIsiCommErrorCode _error_, gpointer self) {
	__lambda40_ (self, _error_);
}


static gboolean _gisi_comm_modem_access_startup_co_gsource_func (gpointer self) {
	gboolean result;
	result = gisi_comm_modem_access_startup_co (self);
	return result;
}


static gboolean gisi_comm_modem_access_startup_co (GisiCommModemAccessStartupData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = gisi_comm_modem_access_ref (_data_->self);
	_data_->_data3_->_async_data_ = _data_;
	_data_->_data3_->ok = FALSE;
	_data_->_tmp0_ = _data_->self->mtc;
	gisi_comm_mtc_startupSynq (_data_->_tmp0_, ___lambda40__gisi_comm_void_result_func, _data_->_data3_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _gisi_comm_modem_access_startup_co_gsource_func, _data_, NULL);
	_data_->_state_ = 2;
	return FALSE;
	_state_2:
	;
	_data_->result = TRUE;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void gisi_comm_modem_access_poweron_data_free (gpointer _data) {
	GisiCommModemAccessPoweronData* _data_;
	_data_ = _data;
	_gisi_comm_modem_access_unref0 (_data_->self);
	g_slice_free (GisiCommModemAccessPoweronData, _data_);
}


void gisi_comm_modem_access_poweron (GIsiCommModemAccess* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GisiCommModemAccessPoweronData* _data_;
	GIsiCommModemAccess* _tmp0_;
	_data_ = g_slice_new0 (GisiCommModemAccessPoweronData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, gisi_comm_modem_access_poweron);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gisi_comm_modem_access_poweron_data_free);
	_tmp0_ = _gisi_comm_modem_access_ref0 (self);
	_data_->self = _tmp0_;
	gisi_comm_modem_access_poweron_co (_data_);
}


gboolean gisi_comm_modem_access_poweron_finish (GIsiCommModemAccess* self, GAsyncResult* _res_) {
	gboolean result;
	GisiCommModemAccessPoweronData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean gisi_comm_modem_access_poweron_co (GisiCommModemAccessPoweronData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void gisi_comm_value_modem_access_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gisi_comm_value_modem_access_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gisi_comm_modem_access_unref (value->data[0].v_pointer);
	}
}


static void gisi_comm_value_modem_access_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gisi_comm_modem_access_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gisi_comm_value_modem_access_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gisi_comm_value_modem_access_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GIsiCommModemAccess* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gisi_comm_modem_access_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gisi_comm_value_modem_access_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GIsiCommModemAccess** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gisi_comm_modem_access_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gisi_comm_param_spec_modem_access (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GIsiCommParamSpecModemAccess* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GISI_COMM_TYPE_MODEM_ACCESS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gisi_comm_value_get_modem_access (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GISI_COMM_TYPE_MODEM_ACCESS), NULL);
	return value->data[0].v_pointer;
}


void gisi_comm_value_set_modem_access (GValue* value, gpointer v_object) {
	GIsiCommModemAccess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GISI_COMM_TYPE_MODEM_ACCESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GISI_COMM_TYPE_MODEM_ACCESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gisi_comm_modem_access_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gisi_comm_modem_access_unref (old);
	}
}


void gisi_comm_value_take_modem_access (GValue* value, gpointer v_object) {
	GIsiCommModemAccess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GISI_COMM_TYPE_MODEM_ACCESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GISI_COMM_TYPE_MODEM_ACCESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gisi_comm_modem_access_unref (old);
	}
}


static void gisi_comm_modem_access_class_init (GIsiCommModemAccessClass * klass) {
	gisi_comm_modem_access_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_MODEM_ACCESS_CLASS (klass)->finalize = gisi_comm_modem_access_finalize;
	g_signal_new ("netlink_changed", GISI_COMM_TYPE_MODEM_ACCESS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void gisi_comm_modem_access_instance_init (GIsiCommModemAccess * self) {
	self->ref_count = 1;
}


static void gisi_comm_modem_access_finalize (GIsiCommModemAccess* obj) {
	GIsiCommModemAccess * self;
	self = GISI_COMM_MODEM_ACCESS (obj);
	_g_isi_modem_destroy0 (self->m);
	_gisi_comm_abstract_base_client_unref0 (self->mtc);
	_gisi_comm_abstract_base_client_unref0 (self->info);
	_gisi_comm_abstract_base_client_unref0 (self->sim);
	_gisi_comm_abstract_base_client_unref0 (self->call);
	_gisi_comm_abstract_base_client_unref0 (self->sms);
	_gisi_comm_abstract_base_client_unref0 (self->simauth);
	_gisi_comm_abstract_base_client_unref0 (self->net);
	_gisi_comm_abstract_base_client_unref0 (self->ss);
	_gisi_comm_abstract_base_client_unref0 (self->gss);
	_gisi_comm_abstract_base_client_unref0 (self->gpds);
	_gisi_comm_epoc_info_unref0 (self->epoc);
}


/**
     * @class ModemAccess
     *
     * Covers modem and subsystems lifecycle
     **/
GType gisi_comm_modem_access_get_type (void) {
	static volatile gsize gisi_comm_modem_access_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_modem_access_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gisi_comm_value_modem_access_init, gisi_comm_value_modem_access_free_value, gisi_comm_value_modem_access_copy_value, gisi_comm_value_modem_access_peek_pointer, "p", gisi_comm_value_modem_access_collect_value, "p", gisi_comm_value_modem_access_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommModemAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_modem_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommModemAccess), 0, (GInstanceInitFunc) gisi_comm_modem_access_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gisi_comm_modem_access_type_id;
		gisi_comm_modem_access_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GIsiCommModemAccess", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gisi_comm_modem_access_type_id__volatile, gisi_comm_modem_access_type_id);
	}
	return gisi_comm_modem_access_type_id__volatile;
}


gpointer gisi_comm_modem_access_ref (gpointer instance) {
	GIsiCommModemAccess* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gisi_comm_modem_access_unref (gpointer instance) {
	GIsiCommModemAccess* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GISI_COMM_MODEM_ACCESS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GIsiCommAbstractBaseClient* gisi_comm_abstract_base_client_construct (GType object_type) {
	GIsiCommAbstractBaseClient* self = NULL;
	self = (GIsiCommAbstractBaseClient*) g_type_create_instance (object_type);
	return self;
}


static void gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_data_free (gpointer _data) {
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnlineData* _data_;
	_data_ = _data;
	_gisi_comm_abstract_base_client_unref0 (_data_->self);
	g_slice_free (gisi_comm_abstract_base_client_waitUntilSubsystemIsOnlineData, _data_);
}


static gpointer _gisi_comm_abstract_base_client_ref0 (gpointer self) {
	return self ? gisi_comm_abstract_base_client_ref (self) : NULL;
}


void gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline (GIsiCommAbstractBaseClient* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnlineData* _data_;
	GIsiCommAbstractBaseClient* _tmp0_;
	_data_ = g_slice_new0 (gisi_comm_abstract_base_client_waitUntilSubsystemIsOnlineData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_data_free);
	_tmp0_ = _gisi_comm_abstract_base_client_ref0 (self);
	_data_->self = _tmp0_;
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_co (_data_);
}


void gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_finish (GIsiCommAbstractBaseClient* self, GAsyncResult* _res_) {
	gisi_comm_abstract_base_client_waitUntilSubsystemIsOnlineData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _gisi_comm_abstract_base_client_onReachabilityResultReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_abstract_base_client_onReachabilityResultReceived (self, msg);
}


static gboolean _gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_co_gsource_func (gpointer self) {
	gboolean result;
	result = gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_co (self);
	return result;
}


static gboolean gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_co (gisi_comm_abstract_base_client_waitUntilSubsystemIsOnlineData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->client;
	g_assert (_data_->_tmp0_ != NULL);
	_data_->_tmp1_ = _data_->self->client;
	g_isi_client_verify (_data_->_tmp1_, _gisi_comm_abstract_base_client_onReachabilityResultReceived_gisi_notify_func, gisi_comm_abstract_base_client_ref (_data_->self), gisi_comm_abstract_base_client_unref);
	(_data_->self->cb_target_destroy_notify == NULL) ? NULL : (_data_->self->cb_target_destroy_notify (_data_->self->cb_target), NULL);
	_data_->self->cb = NULL;
	_data_->self->cb_target = NULL;
	_data_->self->cb_target_destroy_notify = NULL;
	_data_->self->cb = _gisi_comm_abstract_base_client_waitUntilSubsystemIsOnline_co_gsource_func;
	_data_->self->cb_target = _data_;
	_data_->self->cb_target_destroy_notify = NULL;
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean g_isi_msg_ok (GIsiMessage* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_isi_msg_error (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ >= 0;
	return result;
}


static const char* _g_isi_phonet_subsystem_to_string (guchar value) {
	switch (value) {
		case PN_CALL:
		return "PN_CALL";
		case PN_EPOC_INFO:
		return "PN_EPOC_INFO";
		case PN_GPDS:
		return "PN_GPDS";
		case PN_GSS:
		return "PN_GSS";
		case PN_MTC:
		return "PN_MTC";
		case PN_NETWORK:
		return "PN_NETWORK";
		case PN_PHONE_INFO:
		return "PN_PHONE_INFO";
		case PN_SIM:
		return "PN_SIM";
		case PN_SIM_AUTH:
		return "PN_SIM_AUTH";
		case PN_SMS:
		return "PN_SMS";
		case PN_SS:
		return "PN_SS";
		case PN_WRAN:
		return "PN_WRAN";
	}
	return NULL;
}


static gchar* g_isi_msg_to_string (GIsiMessage* self) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_isi_msg_ok (self);
	if (_tmp0_) {
		guchar _tmp1_;
		guchar _tmp2_;
		const gchar* _tmp3_ = NULL;
		guchar _tmp4_;
		guchar _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		guchar _tmp10_;
		guchar _tmp11_;
		gchar* _tmp12_ = NULL;
		_tmp1_ = g_isi_msg_resource (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _g_isi_phonet_subsystem_to_string (_tmp2_);
		_tmp4_ = g_isi_msg_resource (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_isi_msg_version_major (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_isi_msg_version_minor (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_isi_msg_id (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf ("<[%s (%d) v%03d.%03d]: OK, id = 0x%0X>", _tmp3_, (gint) _tmp5_, _tmp7_, _tmp9_, (guint) _tmp11_);
		result = _tmp12_;
		return result;
	} else {
		guchar _tmp13_;
		guchar _tmp14_;
		const gchar* _tmp15_ = NULL;
		guchar _tmp16_;
		guchar _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gchar* _tmp26_ = NULL;
		_tmp13_ = g_isi_msg_resource (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = _g_isi_phonet_subsystem_to_string (_tmp14_);
		_tmp16_ = g_isi_msg_resource (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_isi_msg_version_major (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_isi_msg_version_minor (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_isi_msg_strerror (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_isi_msg_error (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strdup_printf ("<[%s (%d) v%03d.%03d]: ERROR, %s (0x%0X)>", _tmp15_, (gint) _tmp17_, _tmp19_, _tmp21_, _tmp23_, (guint) _tmp25_);
		result = _tmp26_;
		return result;
	}
}


static void gisi_comm_abstract_base_client_onReachabilityResultReceived (GIsiCommAbstractBaseClient* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GIsiMessage* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GSourceFunc _tmp10_;
	void* _tmp10__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("Reachability result: ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:241: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = msg;
	_tmp6_ = g_isi_msg_ok (_tmp5_);
	if (!_tmp6_) {
		g_warning ("gisicomm.vala:244: Subsystem not reachable");
		self->reachable = FALSE;
	} else {
		GIsiMessage* _tmp7_;
		guint16 _tmp8_;
		guint16 _tmp9_;
		self->reachable = TRUE;
		_tmp7_ = msg;
		_tmp8_ = g_isi_msg_object (_tmp7_);
		_tmp9_ = _tmp8_;
		self->isiobj = _tmp9_;
		gisi_comm_abstract_base_client_onSubsystemIsReachable (self);
	}
	_tmp10_ = self->cb;
	_tmp10__target = self->cb_target;
	_tmp10_ (_tmp10__target);
	(self->cb_target_destroy_notify == NULL) ? NULL : (self->cb_target_destroy_notify (self->cb_target), NULL);
	self->cb = NULL;
	self->cb_target = NULL;
	self->cb_target_destroy_notify = NULL;
	self->cb = NULL;
	self->cb_target = NULL;
	self->cb_target_destroy_notify = NULL;
}


static void gisi_comm_abstract_base_client_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* self) {
	g_critical ("Type `%s' does not implement abstract method `gisi_comm_abstract_base_client_onSubsystemIsReachable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void gisi_comm_abstract_base_client_onSubsystemIsReachable (GIsiCommAbstractBaseClient* self) {
	g_return_if_fail (self != NULL);
	GISI_COMM_ABSTRACT_BASE_CLIENT_GET_CLASS (self)->onSubsystemIsReachable (self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data4_->self);
		g_slice_free (Block4Data, _data4_);
	}
}


static guint8* g_isi_msg_get_data (GIsiMessage* self, int* result_length1) {
	guint8* result;
	void* _tmp0_;
	void* _tmp1_;
	guint8* array;
	gint array_length1;
	gint _array_size_;
	gsize _tmp2_;
	gsize _tmp3_;
	gint _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_isi_msg_data (self);
	_tmp1_ = _tmp0_;
	array = (guint8*) _tmp1_;
	array_length1 = -1;
	_array_size_ = array_length1;
	_tmp2_ = g_isi_msg_data_len (self);
	_tmp3_ = _tmp2_;
	array_length1 = (gint) _tmp3_;
	_tmp4_ = array_length1;
	_tmp5_ = array;
	_tmp5__length1 = array_length1;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}


static void __lambda0_ (Block4Data* _data4_, GIsiMessage* msg) {
	GIsiCommAbstractBaseClient * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiCommByteArrayResultFunc _tmp3_;
	void* _tmp3__target;
	GIsiMessage* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	self = _data4_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommByteArrayResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data4_->cb;
		_tmp2__target = _data4_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, NULL, 0, _tmp2__target);
		return;
	}
	_tmp3_ = _data4_->cb;
	_tmp3__target = _data4_->cb_target;
	_tmp4_ = msg;
	_tmp5_ = g_isi_msg_get_data (_tmp4_, &_tmp5__length1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp3_ (GISI_COMM_ERROR_CODE_OK, _tmp6_, _tmp6__length1, _tmp3__target);
}


static void ___lambda0__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda0_ (self, msg);
}


void gisi_comm_abstract_base_client_sendGenericRequest (GIsiCommAbstractBaseClient* self, guint8* req, int req_length1, GIsiCommByteArrayResultFunc cb, void* cb_target) {
	Block4Data* _data4_;
	GIsiCommByteArrayResultFunc _tmp0_;
	void* _tmp0__target;
	GIsiClient* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_data4_->cb = _tmp0_;
	_data4_->cb_target = _tmp0__target;
	_tmp1_ = self->client;
	_tmp2_ = req;
	_tmp2__length1 = req_length1;
	g_isi_client_send (_tmp1_, _tmp2_, _tmp2__length1, ___lambda0__gisi_notify_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


guint8 gisi_comm_abstract_base_client_align4 (GIsiCommAbstractBaseClient* self, guint8 size) {
	guint8 result = 0U;
	guint8 _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = size;
	result = (guint8) ((_tmp0_ + 3) & (~3));
	return result;
}


static void gisi_comm_value_abstract_base_client_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gisi_comm_value_abstract_base_client_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gisi_comm_abstract_base_client_unref (value->data[0].v_pointer);
	}
}


static void gisi_comm_value_abstract_base_client_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gisi_comm_abstract_base_client_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gisi_comm_value_abstract_base_client_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gisi_comm_value_abstract_base_client_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GIsiCommAbstractBaseClient* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gisi_comm_abstract_base_client_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gisi_comm_value_abstract_base_client_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GIsiCommAbstractBaseClient** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gisi_comm_abstract_base_client_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gisi_comm_param_spec_abstract_base_client (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GIsiCommParamSpecAbstractBaseClient* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gisi_comm_value_get_abstract_base_client (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT), NULL);
	return value->data[0].v_pointer;
}


void gisi_comm_value_set_abstract_base_client (GValue* value, gpointer v_object) {
	GIsiCommAbstractBaseClient* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gisi_comm_abstract_base_client_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gisi_comm_abstract_base_client_unref (old);
	}
}


void gisi_comm_value_take_abstract_base_client (GValue* value, gpointer v_object) {
	GIsiCommAbstractBaseClient* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gisi_comm_abstract_base_client_unref (old);
	}
}


static void gisi_comm_abstract_base_client_class_init (GIsiCommAbstractBaseClientClass * klass) {
	gisi_comm_abstract_base_client_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->finalize = gisi_comm_abstract_base_client_finalize;
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->onSubsystemIsReachable = gisi_comm_abstract_base_client_real_onSubsystemIsReachable;
}


static void gisi_comm_abstract_base_client_instance_init (GIsiCommAbstractBaseClient * self) {
	self->ref_count = 1;
}


static void gisi_comm_abstract_base_client_finalize (GIsiCommAbstractBaseClient* obj) {
	GIsiCommAbstractBaseClient * self;
	self = GISI_COMM_ABSTRACT_BASE_CLIENT (obj);
	(self->cb_target_destroy_notify == NULL) ? NULL : (self->cb_target_destroy_notify (self->cb_target), NULL);
	self->cb = NULL;
	self->cb_target = NULL;
	self->cb_target_destroy_notify = NULL;
}


/**
     * @class AbstractBaseClient
     *
     * Handles initial setup and indicator/notification subscriptions
     **/
GType gisi_comm_abstract_base_client_get_type (void) {
	static volatile gsize gisi_comm_abstract_base_client_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_abstract_base_client_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gisi_comm_value_abstract_base_client_init, gisi_comm_value_abstract_base_client_free_value, gisi_comm_value_abstract_base_client_copy_value, gisi_comm_value_abstract_base_client_peek_pointer, "p", gisi_comm_value_abstract_base_client_collect_value, "p", gisi_comm_value_abstract_base_client_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommAbstractBaseClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_abstract_base_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommAbstractBaseClient), 0, (GInstanceInitFunc) gisi_comm_abstract_base_client_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gisi_comm_abstract_base_client_type_id;
		gisi_comm_abstract_base_client_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GIsiCommAbstractBaseClient", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&gisi_comm_abstract_base_client_type_id__volatile, gisi_comm_abstract_base_client_type_id);
	}
	return gisi_comm_abstract_base_client_type_id__volatile;
}


gpointer gisi_comm_abstract_base_client_ref (gpointer instance) {
	GIsiCommAbstractBaseClient* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gisi_comm_abstract_base_client_unref (gpointer instance) {
	GIsiCommAbstractBaseClient* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GISI_COMM_ABSTRACT_BASE_CLIENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


void gisi_comm_checked (gboolean predicate, GError** error) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	_tmp0_ = predicate;
	if (!_tmp0_) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_INVALID_DATA, "FSO");
		_inner_error_ = _tmp1_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void g_isi_msg_subblock_iter_create (GIsiMessage* self, gsize used, GIsiSubBlockIter* result) {
	GIsiSubBlockIter iter = {0};
	gsize _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = used;
	g_isi_sb_iter_init (&iter, self, _tmp0_);
	*result = iter;
	return;
}


static gchar* g_isi_sub_block_iter_to_string (GIsiSubBlockIter *self) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	gchar* _tmp4_ = NULL;
	_tmp0_ = g_isi_sb_iter_get_id (&(*self));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_isi_sb_iter_get_len (&(*self));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("<SubblockIter @ %p: ID=%u, length=%u>", &(*self), (guint) _tmp1_, (guint) _tmp3_);
	result = _tmp4_;
	return result;
}


static void g_isi_sub_block_iter_checked (GIsiSubBlockIter *self, gboolean predicate, GError** error) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	_tmp0_ = predicate;
	if (!_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
		_tmp1_ = g_isi_sub_block_iter_to_string (&(*self));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat ("Invalid data in SubblockIter ", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_INVALID_DATA, _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static guchar g_isi_sub_block_iter_byte_at_position (GIsiSubBlockIter *self, guint pos, GError** error) {
	guchar result = '\0';
	guchar _result_ = '\0';
	guint _tmp0_;
	guchar _tmp1_ = '\0';
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = pos;
	_tmp2_ = g_isi_sb_iter_get_byte (&(*self), &_tmp1_, _tmp0_);
	_result_ = _tmp1_;
	g_isi_sub_block_iter_checked (&(*self), _tmp2_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return '\0';
	}
	result = _result_;
	return result;
}


static gchar* g_isi_sub_block_iter_latin_tag_at_position (GIsiSubBlockIter *self, gsize length, guint pos, GError** error) {
	gchar* result = NULL;
	gchar* tag = NULL;
	gsize _tmp0_;
	guint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = length;
	_tmp1_ = pos;
	_tmp3_ = g_isi_sb_iter_get_latin_tag (&(*self), &_tmp2_, _tmp0_, _tmp1_);
	_g_free0 (tag);
	_tmp4_ = g_strdup (_tmp2_);
	tag = _tmp4_;
	g_isi_sub_block_iter_checked (&(*self), _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (tag);
		return NULL;
	}
	_tmp5_ = tag;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	_g_free0 (tag);
	return result;
}


void gisi_comm_parseSimpleString (GIsiMessage* msg, GIsiCommStringResultFunc cb, void* cb_target) {
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiMessage* _tmp3_;
	GIsiSubBlockIter _tmp4_ = {0};
	GIsiSubBlockIter sbi;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommStringResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = cb;
		_tmp2__target = cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, NULL, _tmp2__target);
		return;
	}
	_tmp3_ = msg;
	g_isi_msg_subblock_iter_create (_tmp3_, (gsize) 2, &_tmp4_);
	sbi = _tmp4_;
	_tmp5_ = g_isi_sb_iter_is_valid (&sbi);
	if (!_tmp5_) {
		GIsiCommStringResultFunc _tmp6_;
		void* _tmp6__target;
		_tmp6_ = cb;
		_tmp6__target = cb_target;
		_tmp6_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, NULL, _tmp6__target);
		return;
	}
	{
		guchar _tmp7_ = '\0';
		guchar _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		GIsiCommStringResultFunc _tmp11_;
		void* _tmp11__target;
		gchar* _tmp12_;
		_tmp7_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 3, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp9_ = g_isi_sub_block_iter_latin_tag_at_position (&sbi, (gsize) _tmp8_, (guint) 4, &_inner_error_);
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp11_ = cb;
		_tmp11__target = cb_target;
		_tmp12_ = _tmp10_;
		_tmp11_ (GISI_COMM_ERROR_CODE_OK, _tmp12_, _tmp11__target);
		_g_free0 (_tmp12_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GIsiCommStringResultFunc _tmp13_;
		void* _tmp13__target;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = cb;
		_tmp13__target = cb_target;
		_tmp13_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, NULL, _tmp13__target);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static GIsiClient* g_isi_modem_mtc_client_create (GIsiModem* self) {
	GIsiClient* result = NULL;
	GIsiClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_isi_client_create (self, PN_MTC);
	result = (GIsiClient*) _tmp0_;
	return result;
}


GIsiCommMTC* gisi_comm_mtc_construct (GType object_type, GIsiModem* modem) {
	GIsiCommMTC* self = NULL;
	GIsiModem* _tmp0_;
	GIsiClient* _tmp1_ = NULL;
	GIsiClient* _tmp2_;
	g_return_val_if_fail (modem != NULL, NULL);
	self = (GIsiCommMTC*) gisi_comm_abstract_base_client_construct (object_type);
	_tmp0_ = modem;
	_tmp1_ = g_isi_modem_mtc_client_create (_tmp0_);
	_g_isi_client_destroy0 (self->ll);
	self->ll = _tmp1_;
	_tmp2_ = self->ll;
	((GIsiCommAbstractBaseClient*) self)->client = _tmp2_;
	self->state = 0xE0;
	return self;
}


GIsiCommMTC* gisi_comm_mtc_new (GIsiModem* modem) {
	return gisi_comm_mtc_construct (GISI_COMM_TYPE_MTC, modem);
}


static void _gisi_comm_mtc_onStateInfoIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_mtc_onStateInfoIndicationReceived (self, msg);
}


static void ___lambda2_ (GIsiCommMTC* self, GIsiCommErrorCode _error_, guint8 current, guint8 target) {
	GIsiCommErrorCode _tmp0_;
	_tmp0_ = _error_;
	if (_tmp0_ == GISI_COMM_ERROR_CODE_OK) {
		guint8 _tmp1_;
		guint8 _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp1_ = current;
		self->state = _tmp1_;
		_tmp2_ = self->state;
		_tmp3_ = _MTC_modem_state_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("initial state = ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		g_debug ("gisicomm.vala:346: %s", _tmp5_);
		_g_free0 (_tmp5_);
	} else {
		GIsiCommErrorCode _tmp6_;
		_tmp6_ = _error_;
		g_debug ("gisicomm.vala:350: can't query initial state: error = %d", (gint) _tmp6_);
	}
}


static void ____lambda2__gisi_comm_mtc_states_result_func (GIsiCommErrorCode _error_, guint8 current, guint8 target, gpointer self) {
	___lambda2_ (self, _error_, current, target);
}


static void gisi_comm_mtc_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base) {
	GIsiCommMTC * self;
	GIsiClient* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean ok;
	gboolean _tmp2_;
	self = (GIsiCommMTC*) base;
	_tmp0_ = self->ll;
	_tmp1_ = g_isi_client_ind_subscribe (_tmp0_, (guchar) MTC_STATE_INFO_IND, _gisi_comm_mtc_onStateInfoIndicationReceived_gisi_notify_func, self);
	ok = _tmp1_;
	_tmp2_ = ok;
	if (!_tmp2_) {
		g_warning ("gisicomm.vala:338: Could not subscribe to MTC STATE_INFO_IND");
	} else {
		gisi_comm_mtc_readState (self, ____lambda2__gisi_comm_mtc_states_result_func, self);
	}
}


static const char* _MTC_isi_action_to_string (guint8 value) {
	switch (value) {
		case MTC_START:
		return "MTC_START";
		case MTC_READY:
		return "MTC_READY";
		case MTC_NOS_READY:
		return "MTC_NOS_READY";
		case MTC_SOS_START:
		return "MTC_SOS_START";
		case MTC_SOS_READY:
		return "MTC_SOS_READY";
	}
	return NULL;
}


static void gisi_comm_mtc_onStateInfoIndicationReceived (GIsiCommMTC* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8 _tmp3_;
	guint8 state;
	GIsiMessage* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8 _tmp7_;
	guint8 action;
	GIsiMessage* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	guint8 _tmp11_;
	const gchar* _tmp12_ = NULL;
	guint8 _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	guint8 _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_get_data (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp3_ = _tmp2_[0];
	state = (guint8) _tmp3_;
	_tmp4_ = msg;
	_tmp5_ = g_isi_msg_get_data (_tmp4_, &_tmp5__length1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_[1];
	action = (guint8) _tmp7_;
	_tmp8_ = msg;
	_tmp9_ = g_isi_msg_to_string (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = state;
	_tmp12_ = _MTC_modem_state_to_string (_tmp11_);
	_tmp13_ = action;
	_tmp14_ = _MTC_isi_action_to_string (_tmp13_);
	_tmp15_ = g_strconcat ("Received state info indication with message ", _tmp10_, ", state = ", _tmp12_, ", action = ", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	g_message ("gisicomm.vala:360: %s", _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp10_);
	_tmp17_ = action;
	if (_tmp17_ == MTC_READY) {
		guint8 _tmp18_;
		_tmp18_ = state;
		self->state = _tmp18_;
	}
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data5_->self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda1_ (Block5Data* _data5_, GIsiMessage* msg) {
	GIsiCommMTC * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiMessage* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8 _tmp6_;
	guint8 current;
	GIsiMessage* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8 _tmp10_;
	guint8 target;
	guint8 _tmp11_;
	const gchar* _tmp12_ = NULL;
	guint8 _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	GIsiCommMtcStatesResultFunc _tmp17_;
	void* _tmp17__target;
	guint8 _tmp18_;
	guint8 _tmp19_;
	self = _data5_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommMtcStatesResultFunc _tmp2_;
		void* _tmp2__target;
		g_debug ("gisicomm.vala:377: error reading state");
		_tmp2_ = _data5_->cb;
		_tmp2__target = _data5_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, (guint8) 0xE0, (guint8) 0xE1, _tmp2__target);
		return;
	}
	_tmp3_ = msg;
	_tmp4_ = g_isi_msg_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = _tmp5_[0];
	current = (guint8) _tmp6_;
	_tmp7_ = msg;
	_tmp8_ = g_isi_msg_get_data (_tmp7_, &_tmp8__length1);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	_tmp10_ = _tmp9_[1];
	target = (guint8) _tmp10_;
	_tmp11_ = current;
	_tmp12_ = _MTC_modem_state_to_string (_tmp11_);
	_tmp13_ = target;
	_tmp14_ = _MTC_modem_state_to_string (_tmp13_);
	_tmp15_ = g_strconcat ("reading state ok: current = ", _tmp12_, ", target = ", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	g_debug ("gisicomm.vala:383: %s", _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = _data5_->cb;
	_tmp17__target = _data5_->cb_target;
	_tmp18_ = current;
	_tmp19_ = target;
	_tmp17_ (GISI_COMM_ERROR_CODE_OK, _tmp18_, _tmp19_, _tmp17__target);
}


static void ___lambda1__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda1_ (self, msg);
}


void gisi_comm_mtc_readState (GIsiCommMTC* self, GIsiCommMtcStatesResultFunc cb, void* cb_target) {
	Block5Data* _data5_;
	GIsiCommMtcStatesResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_data5_->cb = _tmp0_;
	_data5_->cb_target = _tmp0__target;
	_tmp1_ = g_new0 (guchar, 3);
	_tmp1_[0] = (guchar) MTC_STATE_QUERY_REQ;
	_tmp1_[1] = (guchar) 0x00;
	_tmp1_[2] = (guchar) 0x00;
	req = _tmp1_;
	req_length1 = 3;
	_req_size_ = req_length1;
	_tmp2_ = self->ll;
	g_isi_client_send (_tmp2_, req, req_length1, ___lambda1__gisi_notify_func, block5_data_ref (_data5_), block5_data_unref);
	req = (g_free (req), NULL);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data6_->self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void __lambda3_ (Block6Data* _data6_, GIsiMessage* msg) {
	GIsiCommMTC * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiMessage* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8 _tmp6_;
	guint8 cause;
	GIsiCommIntResultFunc _tmp7_;
	void* _tmp7__target;
	guint8 _tmp8_;
	self = _data6_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommIntResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data6_->cb;
		_tmp2__target = _data6_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, 0xFF, _tmp2__target);
		return;
	}
	_tmp3_ = msg;
	_tmp4_ = g_isi_msg_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = _tmp5_[0];
	cause = (guint8) _tmp6_;
	_tmp7_ = _data6_->cb;
	_tmp7__target = _data6_->cb_target;
	_tmp8_ = cause;
	_tmp7_ (GISI_COMM_ERROR_CODE_OK, (gint) _tmp8_, _tmp7__target);
}


static void ___lambda3__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda3_ (self, msg);
}


void gisi_comm_mtc_setState (GIsiCommMTC* self, gboolean on, gboolean online, GIsiCommIntResultFunc cb, void* cb_target) {
	Block6Data* _data6_;
	GIsiCommIntResultFunc _tmp0_;
	void* _tmp0__target;
	guint8 state;
	gboolean _tmp1_;
	gboolean _tmp2_;
	guint8 _tmp3_;
	guchar* _tmp4_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp5_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_data6_->cb = _tmp0_;
	_data6_->cb_target = _tmp0__target;
	state = MTC_NORMAL;
	_tmp1_ = on;
	if (!_tmp1_) {
		state = MTC_POWER_OFF;
	}
	_tmp2_ = online;
	if (!_tmp2_) {
		state = MTC_RF_INACTIVE;
	}
	_tmp3_ = state;
	_tmp4_ = g_new0 (guchar, 3);
	_tmp4_[0] = (guchar) MTC_STATE_REQ;
	_tmp4_[1] = (guchar) _tmp3_;
	_tmp4_[2] = (guchar) 0x00;
	req = _tmp4_;
	req_length1 = 3;
	_req_size_ = req_length1;
	_tmp5_ = self->ll;
	g_isi_client_send_with_timeout (_tmp5_, req, req_length1, MTC_STATE_REQ_TIMEOUT, ___lambda3__gisi_notify_func, block6_data_ref (_data6_), block6_data_unref);
	req = (g_free (req), NULL);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data7_->self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void __lambda4_ (Block7Data* _data7_, GIsiMessage* msg) {
	GIsiCommMTC * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiCommVoidResultFunc _tmp3_;
	void* _tmp3__target;
	self = _data7_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommVoidResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data7_->cb;
		_tmp2__target = _data7_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _tmp2__target);
		return;
	}
	_tmp3_ = _data7_->cb;
	_tmp3__target = _data7_->cb_target;
	_tmp3_ (GISI_COMM_ERROR_CODE_OK, _tmp3__target);
}


static void ___lambda4__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda4_ (self, msg);
}


void gisi_comm_mtc_startupSynq (GIsiCommMTC* self, GIsiCommVoidResultFunc cb, void* cb_target) {
	Block7Data* _data7_;
	GIsiCommVoidResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_data7_->cb = _tmp0_;
	_data7_->cb_target = _tmp0__target;
	_tmp1_ = g_new0 (guchar, 3);
	_tmp1_[0] = (guchar) MTC_STARTUP_SYNQ_REQ;
	_tmp1_[1] = (guchar) 0;
	_tmp1_[2] = (guchar) 0;
	req = _tmp1_;
	req_length1 = 3;
	_req_size_ = req_length1;
	_tmp2_ = self->ll;
	g_isi_client_send (_tmp2_, req, req_length1, ___lambda4__gisi_notify_func, block7_data_ref (_data7_), block7_data_unref);
	req = (g_free (req), NULL);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data8_->self);
		g_slice_free (Block8Data, _data8_);
	}
}


static const char* _MTC_isi_cause_to_string (guint8 value) {
	switch (value) {
		case MTC_OK:
		return "MTC_OK";
		case MTC_FAIL:
		return "MTC_FAIL";
		case MTC_NOT_ALLOWED:
		return "MTC_NOT_ALLOWED";
		case MTC_STATE_TRANSITION_GOING_ON:
		return "MTC_STATE_TRANSITION_GOING_ON";
		case MTC_ALREADY_ACTIVE:
		return "MTC_ALREADY_ACTIVE";
		case MTC_SERVICE_DISABLED:
		return "MTC_SERVICE_DISABLED";
		case MTC_NOT_READY_YET:
		return "MTC_NOT_READY_YET";
		case MTC_NOT_SUPPORTED:
		return "MTC_NOT_SUPPORTED";
		case MTC_TRANSITION_ONGOING:
		return "MTC_TRANSITION_ONGOING";
		case MTC_RESET_REQUIRED:
		return "MTC_RESET_REQUIRED";
	}
	return NULL;
}


static void __lambda5_ (Block8Data* _data8_, GIsiMessage* msg) {
	GIsiCommMTC * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiMessage* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8 _tmp6_;
	guint8 cause;
	guint8 _tmp7_;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	GIsiCommMTCIsiCauseResultFunc _tmp11_;
	void* _tmp11__target;
	guint8 _tmp12_;
	self = _data8_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommMTCIsiCauseResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data8_->cb;
		_tmp2__target = _data8_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, 0, _tmp2__target);
		return;
	}
	_tmp3_ = msg;
	_tmp4_ = g_isi_msg_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = _tmp5_[0];
	cause = (guint8) _tmp6_;
	_tmp7_ = cause;
	_tmp8_ = _MTC_isi_cause_to_string (_tmp7_);
	_tmp9_ = g_strconcat ("set power answer ", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	g_debug ("gisicomm.vala:437: %s", _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = _data8_->cb;
	_tmp11__target = _data8_->cb_target;
	_tmp12_ = cause;
	_tmp11_ (GISI_COMM_ERROR_CODE_OK, _tmp12_, _tmp11__target);
}


static void ___lambda5__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda5_ (self, msg);
}


void gisi_comm_mtc_setPower (GIsiCommMTC* self, gboolean on, GIsiCommMTCIsiCauseResultFunc cb, void* cb_target) {
	Block8Data* _data8_;
	GIsiCommMTCIsiCauseResultFunc _tmp0_;
	void* _tmp0__target;
	guint8 _tmp1_ = 0;
	gboolean _tmp2_;
	guint8 _tmp3_;
	guchar* _tmp4_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp5_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_data8_->cb = _tmp0_;
	_data8_->cb_target = _tmp0__target;
	_tmp2_ = on;
	if (_tmp2_) {
		_tmp1_ = MTC_POWER_ON_REQ;
	} else {
		_tmp1_ = MTC_POWER_OFF_REQ;
	}
	_tmp3_ = _tmp1_;
	_tmp4_ = g_new0 (guchar, 3);
	_tmp4_[0] = (guchar) _tmp3_;
	_tmp4_[1] = (guchar) 0x00;
	_tmp4_[2] = (guchar) 0x00;
	req = _tmp4_;
	req_length1 = 3;
	_req_size_ = req_length1;
	_tmp5_ = self->ll;
	g_isi_client_send (_tmp5_, req, req_length1, ___lambda5__gisi_notify_func, block8_data_ref (_data8_), block8_data_unref);
	req = (g_free (req), NULL);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}


static void gisi_comm_mtc_class_init (GIsiCommMTCClass * klass) {
	gisi_comm_mtc_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->finalize = gisi_comm_mtc_finalize;
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->onSubsystemIsReachable = gisi_comm_mtc_real_onSubsystemIsReachable;
}


static void gisi_comm_mtc_instance_init (GIsiCommMTC * self) {
}


static void gisi_comm_mtc_finalize (GIsiCommAbstractBaseClient* obj) {
	GIsiCommMTC * self;
	self = GISI_COMM_MTC (obj);
	_g_isi_client_destroy0 (self->ll);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (gisi_comm_mtc_parent_class)->finalize (obj);
}


/**
     * @class MTC
     *
     * Power and Functionality control
     **/
GType gisi_comm_mtc_get_type (void) {
	static volatile gsize gisi_comm_mtc_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_mtc_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommMTCClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_mtc_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommMTC), 0, (GInstanceInitFunc) gisi_comm_mtc_instance_init, NULL };
		GType gisi_comm_mtc_type_id;
		gisi_comm_mtc_type_id = g_type_register_static (GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT, "GIsiCommMTC", &g_define_type_info, 0);
		g_once_init_leave (&gisi_comm_mtc_type_id__volatile, gisi_comm_mtc_type_id);
	}
	return gisi_comm_mtc_type_id__volatile;
}


static GIsiClient* g_isi_modem_phone_info_client_create (GIsiModem* self) {
	GIsiClient* result = NULL;
	GIsiClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_isi_client_create (self, PN_PHONE_INFO);
	result = (GIsiClient*) _tmp0_;
	return result;
}


GIsiCommPhoneInfo* gisi_comm_phone_info_construct (GType object_type, GIsiModem* modem) {
	GIsiCommPhoneInfo* self = NULL;
	GIsiModem* _tmp0_;
	GIsiClient* _tmp1_ = NULL;
	GIsiClient* _tmp2_;
	g_return_val_if_fail (modem != NULL, NULL);
	self = (GIsiCommPhoneInfo*) gisi_comm_abstract_base_client_construct (object_type);
	_tmp0_ = modem;
	_tmp1_ = g_isi_modem_phone_info_client_create (_tmp0_);
	_g_isi_client_destroy0 (self->ll);
	self->ll = _tmp1_;
	_tmp2_ = self->ll;
	((GIsiCommAbstractBaseClient*) self)->client = _tmp2_;
	return self;
}


GIsiCommPhoneInfo* gisi_comm_phone_info_new (GIsiModem* modem) {
	return gisi_comm_phone_info_construct (GISI_COMM_TYPE_PHONE_INFO, modem);
}


static void gisi_comm_phone_info_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base) {
	GIsiCommPhoneInfo * self;
	self = (GIsiCommPhoneInfo*) base;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data9_->self);
		(_data9_->cb_target_destroy_notify == NULL) ? NULL : (_data9_->cb_target_destroy_notify (_data9_->cb_target), NULL);
		_data9_->cb = NULL;
		_data9_->cb_target = NULL;
		_data9_->cb_target_destroy_notify = NULL;
		g_slice_free (Block9Data, _data9_);
	}
}


static void __lambda6_ (Block9Data* _data9_, GIsiMessage* msg) {
	GIsiCommPhoneInfo * self;
	GIsiMessage* _tmp0_;
	GIsiCommStringResultFunc _tmp1_;
	void* _tmp1__target;
	self = _data9_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = _data9_->cb;
	_tmp1__target = _data9_->cb_target;
	gisi_comm_parseSimpleString (_tmp0_, _tmp1_, _tmp1__target);
}


static void ___lambda6__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda6_ (self, msg);
}


void gisi_comm_phone_info_readManufacturer (GIsiCommPhoneInfo* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block9Data* _data9_;
	GIsiCommStringResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data9_->cb_target_destroy_notify == NULL) ? NULL : (_data9_->cb_target_destroy_notify (_data9_->cb_target), NULL);
	_data9_->cb = NULL;
	_data9_->cb_target = NULL;
	_data9_->cb_target_destroy_notify = NULL;
	_data9_->cb = _tmp0_;
	_data9_->cb_target = _tmp0__target;
	_data9_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = g_new0 (guchar, 2);
	_tmp1_[0] = (guchar) INFO_PRODUCT_INFO_READ_REQ;
	_tmp1_[1] = (guchar) INFO_SB_PRODUCT_INFO_MANUFACTURER;
	req = _tmp1_;
	req_length1 = 2;
	_req_size_ = req_length1;
	_tmp2_ = self->ll;
	g_isi_client_send (_tmp2_, req, req_length1, ___lambda6__gisi_notify_func, block9_data_ref (_data9_), block9_data_unref);
	req = (g_free (req), NULL);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data10_->self);
		(_data10_->cb_target_destroy_notify == NULL) ? NULL : (_data10_->cb_target_destroy_notify (_data10_->cb_target), NULL);
		_data10_->cb = NULL;
		_data10_->cb_target = NULL;
		_data10_->cb_target_destroy_notify = NULL;
		g_slice_free (Block10Data, _data10_);
	}
}


static void __lambda7_ (Block10Data* _data10_, GIsiMessage* msg) {
	GIsiCommPhoneInfo * self;
	GIsiMessage* _tmp0_;
	GIsiCommStringResultFunc _tmp1_;
	void* _tmp1__target;
	self = _data10_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = _data10_->cb;
	_tmp1__target = _data10_->cb_target;
	gisi_comm_parseSimpleString (_tmp0_, _tmp1_, _tmp1__target);
}


static void ___lambda7__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda7_ (self, msg);
}


void gisi_comm_phone_info_readModel (GIsiCommPhoneInfo* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block10Data* _data10_;
	GIsiCommStringResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data10_->cb_target_destroy_notify == NULL) ? NULL : (_data10_->cb_target_destroy_notify (_data10_->cb_target), NULL);
	_data10_->cb = NULL;
	_data10_->cb_target = NULL;
	_data10_->cb_target_destroy_notify = NULL;
	_data10_->cb = _tmp0_;
	_data10_->cb_target = _tmp0__target;
	_data10_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = g_new0 (guchar, 2);
	_tmp1_[0] = (guchar) INFO_PRODUCT_INFO_READ_REQ;
	_tmp1_[1] = (guchar) INFO_SB_PRODUCT_INFO_NAME;
	req = _tmp1_;
	req_length1 = 2;
	_req_size_ = req_length1;
	_tmp2_ = self->ll;
	g_isi_client_send (_tmp2_, req, req_length1, ___lambda7__gisi_notify_func, block10_data_ref (_data10_), block10_data_unref);
	req = (g_free (req), NULL);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data11_->self);
		(_data11_->cb_target_destroy_notify == NULL) ? NULL : (_data11_->cb_target_destroy_notify (_data11_->cb_target), NULL);
		_data11_->cb = NULL;
		_data11_->cb_target = NULL;
		_data11_->cb_target_destroy_notify = NULL;
		g_slice_free (Block11Data, _data11_);
	}
}


static void __lambda8_ (Block11Data* _data11_, GIsiMessage* msg) {
	GIsiCommPhoneInfo * self;
	GIsiMessage* _tmp0_;
	GIsiCommStringResultFunc _tmp1_;
	void* _tmp1__target;
	self = _data11_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = _data11_->cb;
	_tmp1__target = _data11_->cb_target;
	gisi_comm_parseSimpleString (_tmp0_, _tmp1_, _tmp1__target);
}


static void ___lambda8__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda8_ (self, msg);
}


void gisi_comm_phone_info_readSerial (GIsiCommPhoneInfo* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block11Data* _data11_;
	GIsiCommStringResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data11_->cb_target_destroy_notify == NULL) ? NULL : (_data11_->cb_target_destroy_notify (_data11_->cb_target), NULL);
	_data11_->cb = NULL;
	_data11_->cb_target = NULL;
	_data11_->cb_target_destroy_notify = NULL;
	_data11_->cb = _tmp0_;
	_data11_->cb_target = _tmp0__target;
	_data11_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = g_new0 (guchar, 2);
	_tmp1_[0] = (guchar) INFO_SERIAL_NUMBER_READ_REQ;
	_tmp1_[1] = (guchar) INFO_SB_SN_IMEI_PLAIN;
	req = _tmp1_;
	req_length1 = 2;
	_req_size_ = req_length1;
	_tmp2_ = self->ll;
	g_isi_client_send (_tmp2_, req, req_length1, ___lambda8__gisi_notify_func, block11_data_ref (_data11_), block11_data_unref);
	req = (g_free (req), NULL);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data12_->self);
		(_data12_->cb_target_destroy_notify == NULL) ? NULL : (_data12_->cb_target_destroy_notify (_data12_->cb_target), NULL);
		_data12_->cb = NULL;
		_data12_->cb_target = NULL;
		_data12_->cb_target_destroy_notify = NULL;
		g_slice_free (Block12Data, _data12_);
	}
}


static const char* _INFO_subblock_type_to_string (guint8 value) {
	switch (value) {
		case INFO_SB_PRODUCT_INFO_NAME:
		return "INFO_SB_PRODUCT_INFO_NAME";
		case INFO_SB_PRODUCT_INFO_MANUFACTURER:
		return "INFO_SB_PRODUCT_INFO_MANUFACTURER";
		case INFO_SB_SN_IMEI_PLAIN:
		return "INFO_SB_SN_IMEI_PLAIN";
		case INFO_SB_SN_IMEI_SV_TO_NET:
		return "INFO_SB_SN_IMEI_SV_TO_NET";
		case INFO_SB_PP:
		return "INFO_SB_PP";
		case INFO_SB_MCUSW_VERSION:
		return "INFO_SB_MCUSW_VERSION";
	}
	return NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void __lambda9_ (Block12Data* _data12_, GIsiMessage* msg) {
	GIsiCommPhoneInfo * self;
	GIsiMessage* _tmp0_;
	GIsiCommStringResultFunc _tmp1_;
	void* _tmp1__target;
	self = _data12_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = _data12_->cb;
	_tmp1__target = _data12_->cb_target;
	gisi_comm_parseSimpleString (_tmp0_, _tmp1_, _tmp1__target);
	{
		GIsiMessage* _tmp2_;
		GIsiSubBlockIter _tmp3_ = {0};
		GIsiSubBlockIter sbi;
		_tmp2_ = msg;
		g_isi_msg_subblock_iter_create (_tmp2_, (gsize) 2, &_tmp3_);
		sbi = _tmp3_;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gboolean _tmp6_ = FALSE;
				GIsiSubBlockIter _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* sbtype;
				const gchar* _tmp17_;
				const gchar* _tmp18_ = NULL;
				GIsiSubBlockIter _tmp19_;
				gsize _tmp20_;
				gsize _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				GIsiSubBlockIter _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					g_isi_sb_iter_next (&sbi);
				}
				_tmp4_ = FALSE;
				_tmp6_ = g_isi_sb_iter_is_valid (&sbi);
				if (!_tmp6_) {
					break;
				}
				_tmp7_ = sbi;
				_tmp8_ = g_isi_sb_iter_get_id (&_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _INFO_subblock_type_to_string ((guint8) _tmp9_);
				_tmp11_ = g_strdup (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = _tmp12_;
				if (_tmp13_ == NULL) {
					gchar* _tmp14_;
					_tmp14_ = g_strdup ("unknown");
					_g_free0 (_tmp12_);
					_tmp12_ = _tmp14_;
				}
				_tmp15_ = _tmp12_;
				_tmp16_ = g_strdup (_tmp15_);
				sbtype = _tmp16_;
				_tmp17_ = sbtype;
				_tmp18_ = string_to_string (_tmp17_);
				_tmp19_ = sbi;
				_tmp20_ = g_isi_sb_iter_get_len (&_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup_printf ("%" G_GSIZE_FORMAT, _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strconcat ("Got subblock ", _tmp18_, " (0x%02X) w/ length ", _tmp23_, NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = sbi;
				_tmp27_ = g_isi_sb_iter_get_id (&_tmp26_);
				_tmp28_ = _tmp27_;
				g_message (_tmp25_, _tmp28_);
				_g_free0 (_tmp25_);
				_g_free0 (_tmp23_);
				_g_free0 (sbtype);
				_g_free0 (_tmp12_);
			}
		}
	}
}


static void ___lambda9__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda9_ (self, msg);
}


void gisi_comm_phone_info_readVersion (GIsiCommPhoneInfo* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block12Data* _data12_;
	GIsiCommStringResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data12_->cb_target_destroy_notify == NULL) ? NULL : (_data12_->cb_target_destroy_notify (_data12_->cb_target), NULL);
	_data12_->cb = NULL;
	_data12_->cb_target = NULL;
	_data12_->cb_target_destroy_notify = NULL;
	_data12_->cb = _tmp0_;
	_data12_->cb_target = _tmp0__target;
	_data12_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = g_new0 (guchar, 2);
	_tmp1_[0] = (guchar) INFO_VERSION_READ_REQ;
	_tmp1_[1] = (guchar) INFO_SB_MCUSW_VERSION;
	req = _tmp1_;
	req_length1 = 2;
	_req_size_ = req_length1;
	_tmp2_ = self->ll;
	g_isi_client_send (_tmp2_, req, req_length1, ___lambda9__gisi_notify_func, block12_data_ref (_data12_), block12_data_unref);
	req = (g_free (req), NULL);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}


static void gisi_comm_phone_info_class_init (GIsiCommPhoneInfoClass * klass) {
	gisi_comm_phone_info_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->finalize = gisi_comm_phone_info_finalize;
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->onSubsystemIsReachable = gisi_comm_phone_info_real_onSubsystemIsReachable;
}


static void gisi_comm_phone_info_instance_init (GIsiCommPhoneInfo * self) {
}


static void gisi_comm_phone_info_finalize (GIsiCommAbstractBaseClient* obj) {
	GIsiCommPhoneInfo * self;
	self = GISI_COMM_PHONE_INFO (obj);
	_g_isi_client_destroy0 (self->ll);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (gisi_comm_phone_info_parent_class)->finalize (obj);
}


/**
     * @class PhoneInfo
     *
     * Device Information Interface
     **/
GType gisi_comm_phone_info_get_type (void) {
	static volatile gsize gisi_comm_phone_info_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_phone_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommPhoneInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_phone_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommPhoneInfo), 0, (GInstanceInitFunc) gisi_comm_phone_info_instance_init, NULL };
		GType gisi_comm_phone_info_type_id;
		gisi_comm_phone_info_type_id = g_type_register_static (GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT, "GIsiCommPhoneInfo", &g_define_type_info, 0);
		g_once_init_leave (&gisi_comm_phone_info_type_id__volatile, gisi_comm_phone_info_type_id);
	}
	return gisi_comm_phone_info_type_id__volatile;
}


static GIsiClient* g_isi_modem_sim_auth_client_create (GIsiModem* self) {
	GIsiClient* result = NULL;
	GIsiClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_isi_client_create (self, PN_SIM_AUTH);
	result = (GIsiClient*) _tmp0_;
	return result;
}


GIsiCommSIMAuth* gisi_comm_sim_auth_construct (GType object_type, GIsiModem* modem) {
	GIsiCommSIMAuth* self = NULL;
	GIsiModem* _tmp0_;
	GIsiClient* _tmp1_ = NULL;
	GIsiClient* _tmp2_;
	g_return_val_if_fail (modem != NULL, NULL);
	self = (GIsiCommSIMAuth*) gisi_comm_abstract_base_client_construct (object_type);
	_tmp0_ = modem;
	_tmp1_ = g_isi_modem_sim_auth_client_create (_tmp0_);
	_g_isi_client_destroy0 (self->ll);
	self->ll = _tmp1_;
	_tmp2_ = self->ll;
	((GIsiCommAbstractBaseClient*) self)->client = _tmp2_;
	return self;
}


GIsiCommSIMAuth* gisi_comm_sim_auth_new (GIsiModem* modem) {
	return gisi_comm_sim_auth_construct (GISI_COMM_TYPE_SIM_AUTH, modem);
}


static void __lambda19_ (GIsiCommSIMAuth* self, GIsiCommErrorCode _error_, gint _result_) {
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	_tmp0_ = _result_;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("received SIM status result ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	g_debug ("gisicomm.vala:532: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void ___lambda19__gisi_comm_int_result_func (GIsiCommErrorCode _error_, gint _result_, gpointer self) {
	__lambda19_ (self, _error_, _result_);
}


static void _gisi_comm_sim_auth_onIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_sim_auth_onIndicationReceived (self, msg);
}


static void gisi_comm_sim_auth_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base) {
	GIsiCommSIMAuth * self;
	GIsiClient* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean ok;
	gboolean _tmp2_;
	self = (GIsiCommSIMAuth*) base;
	gisi_comm_sim_auth_queryStatus (self, ___lambda19__gisi_comm_int_result_func, gisi_comm_abstract_base_client_ref (self), gisi_comm_abstract_base_client_unref);
	_tmp0_ = self->ll;
	_tmp1_ = g_isi_client_ind_subscribe (_tmp0_, (guchar) SIM_AUTH_STATUS_IND, _gisi_comm_sim_auth_onIndicationReceived_gisi_notify_func, self);
	ok = _tmp1_;
	_tmp2_ = ok;
	if (!_tmp2_) {
		g_warning ("gisicomm.vala:539: Could not subscribe to SIM indications");
	}
}


static void gisi_comm_sim_auth_onIndicationReceived (GIsiCommSIMAuth* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("Received Indication with message ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:545: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data13_->self);
		(_data13_->cb_target_destroy_notify == NULL) ? NULL : (_data13_->cb_target_destroy_notify (_data13_->cb_target), NULL);
		_data13_->cb = NULL;
		_data13_->cb_target = NULL;
		_data13_->cb_target_destroy_notify = NULL;
		g_slice_free (Block13Data, _data13_);
	}
}


static void __lambda18_ (Block13Data* _data13_, GIsiMessage* msg) {
	GIsiCommSIMAuth * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiMessage* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8 _tmp6_;
	self = _data13_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommIntResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data13_->cb;
		_tmp2__target = _data13_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, 0, _tmp2__target);
		return;
	}
	_tmp3_ = msg;
	_tmp4_ = g_isi_msg_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = _tmp5_[0];
	switch (_tmp6_) {
		case SIM_AUTH_STATUS_RESP_NEED_PIN:
		case SIM_AUTH_STATUS_RESP_NEED_PUK:
		case SIM_AUTH_STATUS_RESP_INIT:
		{
			GIsiCommIntResultFunc _tmp7_;
			void* _tmp7__target;
			GIsiMessage* _tmp8_;
			guint8* _tmp9_;
			gint _tmp9__length1;
			guint8* _tmp10_;
			gint _tmp10__length1;
			guint8 _tmp11_;
			_tmp7_ = _data13_->cb;
			_tmp7__target = _data13_->cb_target;
			_tmp8_ = msg;
			_tmp9_ = g_isi_msg_get_data (_tmp8_, &_tmp9__length1);
			_tmp10_ = _tmp9_;
			_tmp10__length1 = _tmp9__length1;
			_tmp11_ = _tmp10_[0];
			_tmp7_ (GISI_COMM_ERROR_CODE_OK, (gint) _tmp11_, _tmp7__target);
			break;
		}
		case SIM_AUTH_STATUS_RESP_RUNNING:
		{
			GIsiMessage* _tmp12_;
			guint8* _tmp13_;
			gint _tmp13__length1;
			guint8* _tmp14_;
			gint _tmp14__length1;
			guint8 _tmp15_;
			_tmp12_ = msg;
			_tmp13_ = g_isi_msg_get_data (_tmp12_, &_tmp13__length1);
			_tmp14_ = _tmp13_;
			_tmp14__length1 = _tmp13__length1;
			_tmp15_ = _tmp14_[1];
			switch (_tmp15_) {
				case SIM_AUTH_STATUS_RESP_RUNNING_AUTHORIZED:
				case SIM_AUTH_STATUS_RESP_RUNNING_UNPROTECTED:
				case SIM_AUTH_STATUS_RESP_RUNNING_NO_SIM:
				{
					GIsiCommIntResultFunc _tmp16_;
					void* _tmp16__target;
					GIsiMessage* _tmp17_;
					guint8* _tmp18_;
					gint _tmp18__length1;
					guint8* _tmp19_;
					gint _tmp19__length1;
					guint8 _tmp20_;
					_tmp16_ = _data13_->cb;
					_tmp16__target = _data13_->cb_target;
					_tmp17_ = msg;
					_tmp18_ = g_isi_msg_get_data (_tmp17_, &_tmp18__length1);
					_tmp19_ = _tmp18_;
					_tmp19__length1 = _tmp18__length1;
					_tmp20_ = _tmp19_[1];
					_tmp16_ (GISI_COMM_ERROR_CODE_OK, (gint) _tmp20_, _tmp16__target);
					break;
				}
				default:
				{
					GIsiMessage* _tmp21_;
					guint8* _tmp22_;
					gint _tmp22__length1;
					guint8* _tmp23_;
					gint _tmp23__length1;
					guint8 _tmp24_;
					GIsiCommIntResultFunc _tmp25_;
					void* _tmp25__target;
					_tmp21_ = msg;
					_tmp22_ = g_isi_msg_get_data (_tmp21_, &_tmp22__length1);
					_tmp23_ = _tmp22_;
					_tmp23__length1 = _tmp22__length1;
					_tmp24_ = _tmp23_[1];
					g_error ("gisicomm.vala:579: Unknown SIMAuth.StatusResponseRunningType 0x%0X", (guint) _tmp24_);
					_tmp25_ = _data13_->cb;
					_tmp25__target = _data13_->cb_target;
					_tmp25_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, 0, _tmp25__target);
				}
			}
			break;
		}
		default:
		{
			GIsiMessage* _tmp26_;
			guint8* _tmp27_;
			gint _tmp27__length1;
			guint8* _tmp28_;
			gint _tmp28__length1;
			guint8 _tmp29_;
			GIsiCommIntResultFunc _tmp30_;
			void* _tmp30__target;
			_tmp26_ = msg;
			_tmp27_ = g_isi_msg_get_data (_tmp26_, &_tmp27__length1);
			_tmp28_ = _tmp27_;
			_tmp28__length1 = _tmp27__length1;
			_tmp29_ = _tmp28_[0];
			g_error ("gisicomm.vala:585: Unknown SIMAuth.StatusResponse 0x%0Xd", (guint) _tmp29_);
			_tmp30_ = _data13_->cb;
			_tmp30__target = _data13_->cb_target;
			_tmp30_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, 0, _tmp30__target);
			break;
		}
	}
}


static void ___lambda18__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda18_ (self, msg);
}


void gisi_comm_sim_auth_queryStatus (GIsiCommSIMAuth* self, GIsiCommIntResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block13Data* _data13_;
	GIsiCommIntResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data13_->cb_target_destroy_notify == NULL) ? NULL : (_data13_->cb_target_destroy_notify (_data13_->cb_target), NULL);
	_data13_->cb = NULL;
	_data13_->cb_target = NULL;
	_data13_->cb_target_destroy_notify = NULL;
	_data13_->cb = _tmp0_;
	_data13_->cb_target = _tmp0__target;
	_data13_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = g_new0 (guchar, 3);
	_tmp1_[0] = (guchar) SIM_AUTH_STATUS_REQ;
	_tmp1_[1] = (guchar) 0x0;
	_tmp1_[2] = (guchar) 0x0;
	req = _tmp1_;
	req_length1 = 3;
	_req_size_ = req_length1;
	_tmp2_ = self->ll;
	g_isi_client_send_with_timeout (_tmp2_, req, req_length1, SIM_AUTH_TIMEOUT, ___lambda18__gisi_notify_func, block13_data_ref (_data13_), block13_data_unref);
	req = (g_free (req), NULL);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (Block14Data* _data14_) {
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data14_->self);
		(_data14_->cb_target_destroy_notify == NULL) ? NULL : (_data14_->cb_target_destroy_notify (_data14_->cb_target), NULL);
		_data14_->cb = NULL;
		_data14_->cb_target = NULL;
		_data14_->cb_target_destroy_notify = NULL;
		g_slice_free (Block14Data, _data14_);
	}
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void __lambda20_ (Block14Data* _data14_, GIsiMessage* msg) {
	GIsiCommSIMAuth * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiMessage* _tmp3_;
	guchar _tmp4_;
	guchar _tmp5_;
	self = _data14_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommIntResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data14_->cb;
		_tmp2__target = _data14_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, 0, _tmp2__target);
		return;
	}
	_tmp3_ = msg;
	_tmp4_ = g_isi_msg_id (_tmp3_);
	_tmp5_ = _tmp4_;
	switch (_tmp5_) {
		case SIM_AUTH_FAIL_RESP:
		{
			GIsiMessage* _tmp6_;
			guint8* _tmp7_;
			gint _tmp7__length1;
			guint8* _tmp8_;
			gint _tmp8__length1;
			guint8 _tmp9_;
			_tmp6_ = msg;
			_tmp7_ = g_isi_msg_get_data (_tmp6_, &_tmp7__length1);
			_tmp8_ = _tmp7_;
			_tmp8__length1 = _tmp7__length1;
			_tmp9_ = _tmp8_[0];
			switch (_tmp9_) {
				case SIM_AUTH_ERROR_INVALID_PW:
				case SIM_AUTH_ERROR_NEED_PUK:
				{
					GIsiCommIntResultFunc _tmp10_;
					void* _tmp10__target;
					GIsiMessage* _tmp11_;
					guint8* _tmp12_;
					gint _tmp12__length1;
					guint8* _tmp13_;
					gint _tmp13__length1;
					guint8 _tmp14_;
					_tmp10_ = _data14_->cb;
					_tmp10__target = _data14_->cb_target;
					_tmp11_ = msg;
					_tmp12_ = g_isi_msg_get_data (_tmp11_, &_tmp12__length1);
					_tmp13_ = _tmp12_;
					_tmp13__length1 = _tmp12__length1;
					_tmp14_ = _tmp13_[0];
					_tmp10_ (GISI_COMM_ERROR_CODE_OK, (gint) _tmp14_, _tmp10__target);
					break;
				}
				default:
				{
					GIsiMessage* _tmp15_;
					guint8* _tmp16_;
					gint _tmp16__length1;
					guint8* _tmp17_;
					gint _tmp17__length1;
					guint8 _tmp18_;
					GIsiCommIntResultFunc _tmp19_;
					void* _tmp19__target;
					_tmp15_ = msg;
					_tmp16_ = g_isi_msg_get_data (_tmp15_, &_tmp16__length1);
					_tmp17_ = _tmp16_;
					_tmp17__length1 = _tmp16__length1;
					_tmp18_ = _tmp17_[0];
					g_error ("gisicomm.vala:621: Unknown SIMAuth.IsiCause 0x%0X", (guint) _tmp18_);
					_tmp19_ = _data14_->cb;
					_tmp19__target = _data14_->cb_target;
					_tmp19_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, 0, _tmp19__target);
				}
			}
			break;
		}
		case SIM_AUTH_SUCCESS_RESP:
		{
			GIsiMessage* _tmp20_;
			guint8* _tmp21_;
			gint _tmp21__length1;
			guint8* _tmp22_;
			gint _tmp22__length1;
			guint8 _tmp23_;
			_tmp20_ = msg;
			_tmp21_ = g_isi_msg_get_data (_tmp20_, &_tmp21__length1);
			_tmp22_ = _tmp21_;
			_tmp22__length1 = _tmp21__length1;
			_tmp23_ = _tmp22_[0];
			switch (_tmp23_) {
				case SIM_AUTH_IND_OK:
				{
					GIsiCommIntResultFunc _tmp24_;
					void* _tmp24__target;
					GIsiMessage* _tmp25_;
					guint8* _tmp26_;
					gint _tmp26__length1;
					guint8* _tmp27_;
					gint _tmp27__length1;
					guint8 _tmp28_;
					_tmp24_ = _data14_->cb;
					_tmp24__target = _data14_->cb_target;
					_tmp25_ = msg;
					_tmp26_ = g_isi_msg_get_data (_tmp25_, &_tmp26__length1);
					_tmp27_ = _tmp26_;
					_tmp27__length1 = _tmp26__length1;
					_tmp28_ = _tmp27_[0];
					_tmp24_ (GISI_COMM_ERROR_CODE_OK, (gint) _tmp28_, _tmp24__target);
					break;
				}
				default:
				{
					GIsiMessage* _tmp29_;
					guint8* _tmp30_;
					gint _tmp30__length1;
					guint8* _tmp31_;
					gint _tmp31__length1;
					guint8 _tmp32_;
					GIsiCommIntResultFunc _tmp33_;
					void* _tmp33__target;
					_tmp29_ = msg;
					_tmp30_ = g_isi_msg_get_data (_tmp29_, &_tmp30__length1);
					_tmp31_ = _tmp30_;
					_tmp31__length1 = _tmp30__length1;
					_tmp32_ = _tmp31_[0];
					g_error ("gisicomm.vala:634: Unknown SIMAuth.IndicationType 0x%0X", (guint) _tmp32_);
					_tmp33_ = _data14_->cb;
					_tmp33__target = _data14_->cb_target;
					_tmp33_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, 0, _tmp33__target);
				}
			}
			break;
		}
		default:
		{
			GIsiMessage* _tmp34_;
			guchar _tmp35_;
			guchar _tmp36_;
			GIsiCommIntResultFunc _tmp37_;
			void* _tmp37__target;
			_tmp34_ = msg;
			_tmp35_ = g_isi_msg_id (_tmp34_);
			_tmp36_ = _tmp35_;
			g_error ("gisicomm.vala:640: Unknown Send PIN response message ID 0x%0X", (guint) _tmp36_);
			_tmp37_ = _data14_->cb;
			_tmp37__target = _data14_->cb_target;
			_tmp37_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, 0, _tmp37__target);
		}
	}
}


static void ___lambda20__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda20_ (self, msg);
}


void gisi_comm_sim_auth_sendPin (GIsiCommSIMAuth* self, const gchar* pin, GIsiCommIntResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block14Data* _data14_;
	GIsiCommIntResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	guchar* p;
	const gchar* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GIsiClient* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pin != NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data14_->cb_target_destroy_notify == NULL) ? NULL : (_data14_->cb_target_destroy_notify (_data14_->cb_target), NULL);
	_data14_->cb = NULL;
	_data14_->cb_target = NULL;
	_data14_->cb_target_destroy_notify = NULL;
	_data14_->cb = _tmp0_;
	_data14_->cb_target = _tmp0__target;
	_data14_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = g_new0 (guchar, 24);
	_tmp1_[0] = (guchar) SIM_AUTH_REQ;
	_tmp1_[1] = (guchar) SIM_AUTH_REQ_PIN;
	_tmp1_[2] = (guchar) 0x00;
	_tmp1_[3] = (guchar) 0x00;
	_tmp1_[4] = (guchar) 0x00;
	_tmp1_[5] = (guchar) 0x00;
	_tmp1_[6] = (guchar) 0x00;
	_tmp1_[7] = (guchar) 0x00;
	_tmp1_[8] = (guchar) 0x00;
	_tmp1_[9] = (guchar) 0x00;
	_tmp1_[10] = (guchar) 0x00;
	_tmp1_[11] = (guchar) 0x00;
	_tmp1_[12] = (guchar) 0x00;
	_tmp1_[13] = (guchar) 0x00;
	_tmp1_[14] = (guchar) 0x00;
	_tmp1_[15] = (guchar) 0x00;
	_tmp1_[16] = (guchar) 0x00;
	_tmp1_[17] = (guchar) 0x00;
	_tmp1_[18] = (guchar) 0x00;
	_tmp1_[19] = (guchar) 0x00;
	_tmp1_[20] = (guchar) 0x00;
	_tmp1_[21] = (guchar) 0x00;
	_tmp1_[22] = (guchar) 0x00;
	_tmp1_[23] = (guchar) 0x00;
	req = _tmp1_;
	req_length1 = 24;
	_req_size_ = req_length1;
	p = req;
	_tmp2_ = pin;
	_tmp3_ = string_get_data (_tmp2_, &_tmp3__length1);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = pin;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	memcpy (p + 2, _tmp4_, (gsize) _tmp7_);
	_tmp8_ = self->ll;
	g_isi_client_send_with_timeout (_tmp8_, req, req_length1, SIM_AUTH_TIMEOUT, ___lambda20__gisi_notify_func, block14_data_ref (_data14_), block14_data_unref);
	req = (g_free (req), NULL);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}


static void gisi_comm_sim_auth_changePin_data_free (gpointer _data) {
	gisi_comm_sim_auth_changePinData* _data_;
	_data_ = _data;
	_g_free0 (_data_->oldpin);
	_g_free0 (_data_->newpin);
	(_data_->cb_target_destroy_notify == NULL) ? NULL : (_data_->cb_target_destroy_notify (_data_->cb_target), NULL);
	_data_->cb = NULL;
	_data_->cb_target = NULL;
	_data_->cb_target_destroy_notify = NULL;
	_gisi_comm_abstract_base_client_unref0 (_data_->self);
	g_slice_free (gisi_comm_sim_auth_changePinData, _data_);
}


void gisi_comm_sim_auth_changePin (GIsiCommSIMAuth* self, const gchar* oldpin, const gchar* newpin, GIsiCommVoidResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	gisi_comm_sim_auth_changePinData* _data_;
	GIsiCommSIMAuth* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GIsiCommVoidResultFunc _tmp5_;
	void* _tmp5__target;
	_data_ = g_slice_new0 (gisi_comm_sim_auth_changePinData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, gisi_comm_sim_auth_changePin);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gisi_comm_sim_auth_changePin_data_free);
	_tmp0_ = _gisi_comm_abstract_base_client_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = oldpin;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->oldpin = _tmp2_;
	_tmp3_ = newpin;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->newpin = _tmp4_;
	_tmp5_ = cb;
	_tmp5__target = cb_target;
	(_data_->cb_target_destroy_notify == NULL) ? NULL : (_data_->cb_target_destroy_notify (_data_->cb_target), NULL);
	_data_->cb = NULL;
	_data_->cb_target = NULL;
	_data_->cb_target_destroy_notify = NULL;
	_data_->cb = _tmp5_;
	_data_->cb_target = _tmp5__target;
	_data_->cb_target_destroy_notify = NULL;
	gisi_comm_sim_auth_changePin_co (_data_);
}


void gisi_comm_sim_auth_changePin_finish (GIsiCommSIMAuth* self, GAsyncResult* _res_) {
	gisi_comm_sim_auth_changePinData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (Block15Data* _data15_) {
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data15_->self);
		(_data15_->cb_target_destroy_notify == NULL) ? NULL : (_data15_->cb_target_destroy_notify (_data15_->cb_target), NULL);
		_data15_->cb = NULL;
		_data15_->cb_target = NULL;
		_data15_->cb_target_destroy_notify = NULL;
		g_slice_free (Block15Data, _data15_);
	}
}


static void __lambda21_ (Block15Data* _data15_, GIsiMessage* msg) {
	GIsiCommSIMAuth * self;
	gboolean _tmp0_ = FALSE;
	GIsiMessage* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp6_;
	GIsiCommVoidResultFunc _tmp8_;
	void* _tmp8__target;
	self = _data15_->self;
	g_return_if_fail (msg != NULL);
	_tmp1_ = msg;
	_tmp2_ = g_isi_msg_ok (_tmp1_);
	if (!_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		GIsiMessage* _tmp3_;
		guchar _tmp4_;
		guchar _tmp5_;
		_tmp3_ = msg;
		_tmp4_ = g_isi_msg_id (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ != SIM_AUTH_UPDATE_SUCCESS_RESP;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		GIsiCommVoidResultFunc _tmp7_;
		void* _tmp7__target;
		_tmp7_ = _data15_->cb;
		_tmp7__target = _data15_->cb_target;
		_tmp7_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _tmp7__target);
	}
	_tmp8_ = _data15_->cb;
	_tmp8__target = _data15_->cb_target;
	_tmp8_ (GISI_COMM_ERROR_CODE_OK, _tmp8__target);
	gisi_comm_sim_auth_changePin_co (_data15_->_async_data_);
}


static void ___lambda21__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda21_ (self, msg);
}


static gboolean gisi_comm_sim_auth_changePin_co (gisi_comm_sim_auth_changePinData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data15_ = g_slice_new0 (Block15Data);
	_data_->_data15_->_ref_count_ = 1;
	_data_->_data15_->self = gisi_comm_abstract_base_client_ref (_data_->self);
	_data_->_tmp0_ = _data_->cb;
	_data_->_tmp0__target = _data_->cb_target;
	(_data_->_data15_->cb_target_destroy_notify == NULL) ? NULL : (_data_->_data15_->cb_target_destroy_notify (_data_->_data15_->cb_target), NULL);
	_data_->_data15_->cb = NULL;
	_data_->_data15_->cb_target = NULL;
	_data_->_data15_->cb_target_destroy_notify = NULL;
	_data_->_data15_->cb = _data_->_tmp0_;
	_data_->_data15_->cb_target = _data_->_tmp0__target;
	_data_->_data15_->cb_target_destroy_notify = _data_->cb_target_destroy_notify;
	_data_->_data15_->_async_data_ = _data_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_new0 (guchar, 24);
	_data_->_tmp1_[0] = (guchar) SIM_AUTH_UPDATE_REQ;
	_data_->_tmp1_[1] = (guchar) SIM_AUTH_IND_PIN;
	_data_->_tmp1_[2] = (guchar) 0x00;
	_data_->_tmp1_[3] = (guchar) 0x00;
	_data_->_tmp1_[4] = (guchar) 0x00;
	_data_->_tmp1_[5] = (guchar) 0x00;
	_data_->_tmp1_[6] = (guchar) 0x00;
	_data_->_tmp1_[7] = (guchar) 0x00;
	_data_->_tmp1_[8] = (guchar) 0x00;
	_data_->_tmp1_[9] = (guchar) 0x00;
	_data_->_tmp1_[10] = (guchar) 0x00;
	_data_->_tmp1_[11] = (guchar) 0x00;
	_data_->_tmp1_[12] = (guchar) 0x00;
	_data_->_tmp1_[13] = (guchar) 0x00;
	_data_->_tmp1_[14] = (guchar) 0x00;
	_data_->_tmp1_[15] = (guchar) 0x00;
	_data_->_tmp1_[16] = (guchar) 0x00;
	_data_->_tmp1_[17] = (guchar) 0x00;
	_data_->_tmp1_[18] = (guchar) 0x00;
	_data_->_tmp1_[19] = (guchar) 0x00;
	_data_->_tmp1_[20] = (guchar) 0x00;
	_data_->_tmp1_[21] = (guchar) 0x00;
	_data_->_tmp1_[22] = (guchar) 0x00;
	_data_->_tmp1_[23] = (guchar) 0x00;
	_data_->req = _data_->_tmp1_;
	_data_->req_length1 = 24;
	_data_->_req_size_ = _data_->req_length1;
	_data_->p = _data_->req;
	_data_->_tmp2_ = _data_->oldpin;
	_data_->_tmp3_ = string_get_data (_data_->_tmp2_, &_data_->_tmp3__length1);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp4__length1 = _data_->_tmp3__length1;
	_data_->_tmp5_ = _data_->oldpin;
	_data_->_tmp6_ = strlen (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	memcpy (_data_->p + 2, _data_->_tmp4_, (gsize) _data_->_tmp7_);
	_data_->_tmp8_ = _data_->newpin;
	_data_->_tmp9_ = string_get_data (_data_->_tmp8_, &_data_->_tmp9__length1);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp10__length1 = _data_->_tmp9__length1;
	_data_->_tmp11_ = _data_->newpin;
	_data_->_tmp12_ = strlen (_data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	memcpy (_data_->p + 13, _data_->_tmp10_, (gsize) _data_->_tmp13_);
	_data_->_tmp14_ = _data_->self->ll;
	g_isi_client_send_with_timeout (_data_->_tmp14_, _data_->req, _data_->req_length1, SIM_AUTH_TIMEOUT, ___lambda21__gisi_notify_func, block15_data_ref (_data_->_data15_), block15_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->req = (g_free (_data_->req), NULL);
	block15_data_unref (_data_->_data15_);
	_data_->_data15_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void gisi_comm_sim_auth_class_init (GIsiCommSIMAuthClass * klass) {
	gisi_comm_sim_auth_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->finalize = gisi_comm_sim_auth_finalize;
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->onSubsystemIsReachable = gisi_comm_sim_auth_real_onSubsystemIsReachable;
}


static void gisi_comm_sim_auth_instance_init (GIsiCommSIMAuth * self) {
}


static void gisi_comm_sim_auth_finalize (GIsiCommAbstractBaseClient* obj) {
	GIsiCommSIMAuth * self;
	self = GISI_COMM_SIM_AUTH (obj);
	_g_isi_client_destroy0 (self->ll);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (gisi_comm_sim_auth_parent_class)->finalize (obj);
}


/**
     * @class SIMAuth
     *
     * SIM Authorization Interface
     **/
GType gisi_comm_sim_auth_get_type (void) {
	static volatile gsize gisi_comm_sim_auth_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_sim_auth_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommSIMAuthClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_sim_auth_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommSIMAuth), 0, (GInstanceInitFunc) gisi_comm_sim_auth_instance_init, NULL };
		GType gisi_comm_sim_auth_type_id;
		gisi_comm_sim_auth_type_id = g_type_register_static (GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT, "GIsiCommSIMAuth", &g_define_type_info, 0);
		g_once_init_leave (&gisi_comm_sim_auth_type_id__volatile, gisi_comm_sim_auth_type_id);
	}
	return gisi_comm_sim_auth_type_id__volatile;
}


static GIsiClient* g_isi_modem_sim_client_create (GIsiModem* self) {
	GIsiClient* result = NULL;
	GIsiClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_isi_client_create (self, PN_SIM);
	result = (GIsiClient*) _tmp0_;
	return result;
}


GIsiCommSIM* gisi_comm_sim_construct (GType object_type, GIsiModem* modem) {
	GIsiCommSIM* self = NULL;
	GIsiModem* _tmp0_;
	GIsiClient* _tmp1_ = NULL;
	GIsiClient* _tmp2_;
	g_return_val_if_fail (modem != NULL, NULL);
	self = (GIsiCommSIM*) gisi_comm_abstract_base_client_construct (object_type);
	_tmp0_ = modem;
	_tmp1_ = g_isi_modem_sim_client_create (_tmp0_);
	_g_isi_client_destroy0 (self->priv->ll);
	self->priv->ll = _tmp1_;
	_tmp2_ = self->priv->ll;
	((GIsiCommAbstractBaseClient*) self)->client = _tmp2_;
	return self;
}


GIsiCommSIM* gisi_comm_sim_new (GIsiModem* modem) {
	return gisi_comm_sim_construct (GISI_COMM_TYPE_SIM, modem);
}


static void _gisi_comm_sim_onIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_sim_onIndicationReceived (self, msg);
}


static void gisi_comm_sim_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base) {
	GIsiCommSIM * self;
	GIsiClient* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean ok;
	gboolean _tmp2_;
	self = (GIsiCommSIM*) base;
	_tmp0_ = self->priv->ll;
	_tmp1_ = g_isi_client_ind_subscribe (_tmp0_, (guchar) SIM_IND, _gisi_comm_sim_onIndicationReceived_gisi_notify_func, self);
	ok = _tmp1_;
	_tmp2_ = ok;
	if (!_tmp2_) {
		g_warning ("gisicomm.vala:703: Could not subscribe to SIM indications");
	}
}


static void gisi_comm_sim_onIndicationReceived (GIsiCommSIM* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("Received Indication with message ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:709: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (Block16Data* _data16_) {
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data16_->self);
		(_data16_->cb_target_destroy_notify == NULL) ? NULL : (_data16_->cb_target_destroy_notify (_data16_->cb_target), NULL);
		_data16_->cb = NULL;
		_data16_->cb_target = NULL;
		_data16_->cb_target_destroy_notify = NULL;
		g_slice_free (Block16Data, _data16_);
	}
}


static void __lambda10_ (Block16Data* _data16_, GIsiMessage* msg) {
	GIsiCommSIM * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiMessage* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8 _tmp6_;
	GIsiMessage* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	guint8 _tmp11_;
	GIsiMessage* _tmp13_;
	guint8* _tmp14_;
	gint _tmp14__length1;
	guint8* _tmp15_;
	gint _tmp15__length1;
	guint8 _tmp16_;
	guint8 digits12;
	GIsiMessage* _tmp17_;
	guint8* _tmp18_;
	gint _tmp18__length1;
	guint8* _tmp19_;
	gint _tmp19__length1;
	guint8 _tmp20_;
	guint8 digits3;
	GIsiMessage* _tmp21_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	guint8* _tmp23_;
	gint _tmp23__length1;
	guint8 _tmp24_;
	guint8 digits45;
	guchar _result_[6] = {0};
	guint8 _tmp25_;
	guchar _tmp26_;
	guint8 _tmp27_;
	guchar _tmp28_;
	guint8 _tmp29_;
	guchar _tmp30_;
	guint8 _tmp31_;
	guchar _tmp32_;
	guint8 _tmp33_;
	guchar _tmp34_;
	guchar _tmp35_;
	GIsiCommStringResultFunc _tmp36_;
	void* _tmp36__target;
	self = _data16_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommStringResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data16_->cb;
		_tmp2__target = _data16_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, NULL, _tmp2__target);
		return;
	}
	_tmp3_ = msg;
	_tmp4_ = g_isi_msg_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = _tmp5_[1];
	if (_tmp6_ == SIM_SERV_DATA_NOT_AVAIL) {
		GIsiCommStringResultFunc _tmp7_;
		void* _tmp7__target;
		_tmp7_ = _data16_->cb;
		_tmp7__target = _data16_->cb_target;
		_tmp7_ (GISI_COMM_ERROR_CODE_OK, "<unknown>", _tmp7__target);
		return;
	}
	_tmp8_ = msg;
	_tmp9_ = g_isi_msg_get_data (_tmp8_, &_tmp9__length1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	_tmp11_ = _tmp10_[1];
	if (_tmp11_ != SIM_SERV_OK) {
		GIsiCommStringResultFunc _tmp12_;
		void* _tmp12__target;
		_tmp12_ = _data16_->cb;
		_tmp12__target = _data16_->cb_target;
		_tmp12_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, NULL, _tmp12__target);
		return;
	}
	_tmp13_ = msg;
	_tmp14_ = g_isi_msg_get_data (_tmp13_, &_tmp14__length1);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp14__length1;
	_tmp16_ = _tmp15_[2];
	digits12 = _tmp16_;
	_tmp17_ = msg;
	_tmp18_ = g_isi_msg_get_data (_tmp17_, &_tmp18__length1);
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _tmp18__length1;
	_tmp20_ = _tmp19_[3];
	digits3 = _tmp20_ & 0x0F;
	_tmp21_ = msg;
	_tmp22_ = g_isi_msg_get_data (_tmp21_, &_tmp22__length1);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp22__length1;
	_tmp24_ = _tmp23_[4];
	digits45 = _tmp24_;
	_tmp25_ = digits12;
	_result_[0] = (guchar) ('0' + (_tmp25_ & 0xF));
	_tmp26_ = _result_[0];
	_tmp27_ = digits12;
	_result_[1] = (guchar) ('0' + (_tmp27_ >> 4));
	_tmp28_ = _result_[1];
	_tmp29_ = digits3;
	_result_[2] = (guchar) ('0' + _tmp29_);
	_tmp30_ = _result_[2];
	_tmp31_ = digits45;
	_result_[3] = (guchar) ('0' + (_tmp31_ & 0xF));
	_tmp32_ = _result_[3];
	_tmp33_ = digits45;
	_result_[4] = (guchar) ('0' + (_tmp33_ >> 4));
	_tmp34_ = _result_[4];
	_result_[5] = (guchar) '\0';
	_tmp35_ = _result_[5];
	_tmp36_ = _data16_->cb;
	_tmp36__target = _data16_->cb_target;
	_tmp36_ (GISI_COMM_ERROR_CODE_OK, (const gchar*) _result_, _tmp36__target);
}


static void ___lambda10__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda10_ (self, msg);
}


void gisi_comm_sim_readHPLMN (GIsiCommSIM* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block16Data* _data16_;
	GIsiCommStringResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data16_->cb_target_destroy_notify == NULL) ? NULL : (_data16_->cb_target_destroy_notify (_data16_->cb_target), NULL);
	_data16_->cb = NULL;
	_data16_->cb_target = NULL;
	_data16_->cb_target_destroy_notify = NULL;
	_data16_->cb = _tmp0_;
	_data16_->cb_target = _tmp0__target;
	_data16_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = g_new0 (guchar, 3);
	_tmp1_[0] = (guchar) SIM_NETWORK_INFO_REQ;
	_tmp1_[1] = (guchar) READ_HPLMN;
	_tmp1_[2] = (guchar) 0x0;
	req = _tmp1_;
	req_length1 = 3;
	_req_size_ = req_length1;
	_tmp2_ = self->priv->ll;
	g_isi_client_send (_tmp2_, req, req_length1, ___lambda10__gisi_notify_func, block16_data_ref (_data16_), block16_data_unref);
	req = (g_free (req), NULL);
	block16_data_unref (_data16_);
	_data16_ = NULL;
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (Block17Data* _data17_) {
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data17_->self);
		(_data17_->cb_target_destroy_notify == NULL) ? NULL : (_data17_->cb_target_destroy_notify (_data17_->cb_target), NULL);
		_data17_->cb = NULL;
		_data17_->cb_target = NULL;
		_data17_->cb_target_destroy_notify = NULL;
		g_slice_free (Block17Data, _data17_);
	}
}


static void __lambda11_ (Block17Data* _data17_, GIsiMessage* msg) {
	GIsiCommSIM * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiMessage* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8 _tmp6_;
	GIsiMessage* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	guint8 _tmp11_;
	GIsiCommSIMISI_SPN* isispn = NULL;
	GIsiMessage* _tmp13_;
	void* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	guint8 spn[17] = {0};
	GIsiCommStringResultFunc _tmp36_;
	void* _tmp36__target;
	self = _data17_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommStringResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data17_->cb;
		_tmp2__target = _data17_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, NULL, _tmp2__target);
		return;
	}
	_tmp3_ = msg;
	_tmp4_ = g_isi_msg_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = _tmp5_[1];
	if (_tmp6_ == SIM_SERV_DATA_NOT_AVAIL) {
		GIsiCommStringResultFunc _tmp7_;
		void* _tmp7__target;
		_tmp7_ = _data17_->cb;
		_tmp7__target = _data17_->cb_target;
		_tmp7_ (GISI_COMM_ERROR_CODE_OK, "<unknown>", _tmp7__target);
		return;
	}
	_tmp8_ = msg;
	_tmp9_ = g_isi_msg_get_data (_tmp8_, &_tmp9__length1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	_tmp11_ = _tmp10_[1];
	if (_tmp11_ != SIM_SERV_OK) {
		GIsiCommStringResultFunc _tmp12_;
		void* _tmp12__target;
		_tmp12_ = _data17_->cb;
		_tmp12__target = _data17_->cb_target;
		_tmp12_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, NULL, _tmp12__target);
		return;
	}
	_tmp13_ = msg;
	_tmp15_ = g_isi_msg_data_get_struct (_tmp13_, (guint) 2, &_tmp14_, (gsize) sizeof (GIsiCommSIMISI_SPN));
	isispn = _tmp14_;
	if (!_tmp15_) {
		GIsiCommStringResultFunc _tmp16_;
		void* _tmp16__target;
		_tmp16_ = _data17_->cb;
		_tmp16__target = _data17_->cb_target;
		_tmp16_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, NULL, _tmp16__target);
		return;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gint _tmp20_;
				GIsiCommSIMISI_SPN* _tmp21_;
				gint _tmp22_;
				guint16 _tmp23_;
				GIsiCommSIMISI_SPN* _tmp24_;
				gint _tmp25_;
				guint16 _tmp26_;
				guint16 c;
				guint8 _tmp27_ = 0U;
				gboolean _tmp28_ = FALSE;
				guint16 _tmp29_;
				gboolean _tmp31_;
				gint _tmp33_;
				guint8 _tmp34_;
				guint8 _tmp35_;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = i;
				if (!(_tmp20_ < 16)) {
					break;
				}
				_tmp21_ = isispn;
				_tmp22_ = i;
				_tmp23_ = (*_tmp21_).name[_tmp22_];
				_tmp24_ = isispn;
				_tmp25_ = i;
				_tmp26_ = (*_tmp24_).name[_tmp25_];
				c = (guint16) ((_tmp23_ >> 8) | (_tmp26_ << 8));
				_tmp29_ = c;
				if (((gint) _tmp29_) > 31) {
					guint16 _tmp30_;
					_tmp30_ = c;
					_tmp28_ = ((gint) _tmp30_) < 128;
				} else {
					_tmp28_ = FALSE;
				}
				_tmp31_ = _tmp28_;
				if (_tmp31_) {
					guint16 _tmp32_;
					_tmp32_ = c;
					_tmp27_ = (guint8) _tmp32_;
				} else {
					_tmp27_ = (guint8) '?';
				}
				_tmp33_ = i;
				_tmp34_ = _tmp27_;
				spn[_tmp33_] = _tmp34_;
				_tmp35_ = spn[_tmp33_];
			}
		}
	}
	_tmp36_ = _data17_->cb;
	_tmp36__target = _data17_->cb_target;
	_tmp36_ (GISI_COMM_ERROR_CODE_OK, (const gchar*) spn, _tmp36__target);
}


static void ___lambda11__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda11_ (self, msg);
}


void gisi_comm_sim_readSPN (GIsiCommSIM* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block17Data* _data17_;
	GIsiCommStringResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data17_->cb_target_destroy_notify == NULL) ? NULL : (_data17_->cb_target_destroy_notify (_data17_->cb_target), NULL);
	_data17_->cb = NULL;
	_data17_->cb_target = NULL;
	_data17_->cb_target_destroy_notify = NULL;
	_data17_->cb = _tmp0_;
	_data17_->cb_target = _tmp0__target;
	_data17_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = g_new0 (guchar, 3);
	_tmp1_[0] = (guchar) SIM_SERV_PROV_NAME_REQ;
	_tmp1_[1] = (guchar) SIM_ST_READ_SERV_PROV_NAME;
	_tmp1_[2] = (guchar) 0x0;
	req = _tmp1_;
	req_length1 = 3;
	_req_size_ = req_length1;
	_tmp2_ = self->priv->ll;
	g_isi_client_send (_tmp2_, req, req_length1, ___lambda11__gisi_notify_func, block17_data_ref (_data17_), block17_data_unref);
	req = (g_free (req), NULL);
	block17_data_unref (_data17_);
	_data17_ = NULL;
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}


static void block18_data_unref (Block18Data* _data18_) {
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data18_->self);
		(_data18_->cb_target_destroy_notify == NULL) ? NULL : (_data18_->cb_target_destroy_notify (_data18_->cb_target), NULL);
		_data18_->cb = NULL;
		_data18_->cb_target = NULL;
		_data18_->cb_target_destroy_notify = NULL;
		g_slice_free (Block18Data, _data18_);
	}
}


static void __lambda12_ (Block18Data* _data18_, GIsiMessage* msg) {
	GIsiCommSIM * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiCommSIMISI_IMSI* isiimsi = NULL;
	GIsiMessage* _tmp3_;
	void* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	guint8* _tmp7_ = NULL;
	guint8* imsi;
	gint imsi_length1;
	gint _imsi_size_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	GIsiCommSIMISI_IMSI* _tmp9_;
	guint8 _tmp10_;
	guint8 _tmp11_;
	gsize j;
	guint8* _tmp35_;
	gint _tmp35__length1;
	gsize _tmp36_;
	guint8 _tmp37_;
	GIsiCommStringResultFunc _tmp38_;
	void* _tmp38__target;
	guint8* _tmp39_;
	gint _tmp39__length1;
	self = _data18_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommStringResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data18_->cb;
		_tmp2__target = _data18_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, NULL, _tmp2__target);
		return;
	}
	_tmp3_ = msg;
	_tmp5_ = g_isi_msg_data_get_struct (_tmp3_, (guint) 2, &_tmp4_, (gsize) sizeof (GIsiCommSIMISI_IMSI));
	isiimsi = _tmp4_;
	if (!_tmp5_) {
		GIsiCommStringResultFunc _tmp6_;
		void* _tmp6__target;
		_tmp6_ = _data18_->cb;
		_tmp6__target = _data18_->cb_target;
		_tmp6_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, NULL, _tmp6__target);
		return;
	}
	_tmp7_ = g_new0 (guint8, SIM_MAX_IMSI_LENGTH + 1);
	imsi = _tmp7_;
	imsi_length1 = SIM_MAX_IMSI_LENGTH + 1;
	_imsi_size_ = imsi_length1;
	_tmp8_ = imsi;
	_tmp8__length1 = imsi_length1;
	_tmp9_ = isiimsi;
	_tmp10_ = (*_tmp9_).imsi[0];
	_tmp8_[0] = (guint8) (((_tmp10_ & 0xF0) >> 4) + '0');
	_tmp11_ = _tmp8_[0];
	j = (gsize) 1;
	{
		gsize i;
		i = (gsize) 1;
		{
			gboolean _tmp12_;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_;
				gboolean _tmp15_ = FALSE;
				gsize _tmp16_;
				GIsiCommSIMISI_IMSI* _tmp17_;
				guint8 _tmp18_;
				gboolean _tmp20_;
				gchar nibble = '\0';
				guint8* _tmp21_;
				gint _tmp21__length1;
				gsize _tmp22_;
				GIsiCommSIMISI_IMSI* _tmp23_;
				gsize _tmp24_;
				guint8 _tmp25_;
				guint8 _tmp26_;
				GIsiCommSIMISI_IMSI* _tmp27_;
				gsize _tmp28_;
				guint8 _tmp29_;
				gchar _tmp30_;
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					gsize _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp16_ = i;
				_tmp17_ = isiimsi;
				_tmp18_ = (*_tmp17_).length;
				if (_tmp16_ < ((gsize) _tmp18_)) {
					gsize _tmp19_;
					_tmp19_ = j;
					_tmp15_ = _tmp19_ < ((gsize) SIM_MAX_IMSI_LENGTH);
				} else {
					_tmp15_ = FALSE;
				}
				_tmp20_ = _tmp15_;
				if (!_tmp20_) {
					break;
				}
				_tmp21_ = imsi;
				_tmp21__length1 = imsi_length1;
				_tmp22_ = j;
				j = _tmp22_ + 1;
				_tmp23_ = isiimsi;
				_tmp24_ = i;
				_tmp25_ = (*_tmp23_).imsi[_tmp24_];
				_tmp21_[_tmp22_] = (_tmp25_ & 0x0F) + '0';
				_tmp26_ = _tmp21_[_tmp22_];
				_tmp27_ = isiimsi;
				_tmp28_ = i;
				_tmp29_ = (*_tmp27_).imsi[_tmp28_];
				nibble = (gchar) ((_tmp29_ & 0xF0) >> 4);
				_tmp30_ = nibble;
				if (((gint) _tmp30_) != 0x0F) {
					guint8* _tmp31_;
					gint _tmp31__length1;
					gsize _tmp32_;
					gchar _tmp33_;
					guint8 _tmp34_;
					_tmp31_ = imsi;
					_tmp31__length1 = imsi_length1;
					_tmp32_ = j;
					j = _tmp32_ + 1;
					_tmp33_ = nibble;
					_tmp31_[_tmp32_] = (guint8) (_tmp33_ + '0');
					_tmp34_ = _tmp31_[_tmp32_];
				}
			}
		}
	}
	_tmp35_ = imsi;
	_tmp35__length1 = imsi_length1;
	_tmp36_ = j;
	_tmp35_[_tmp36_] = (guint8) '\0';
	_tmp37_ = _tmp35_[_tmp36_];
	_tmp38_ = _data18_->cb;
	_tmp38__target = _data18_->cb_target;
	_tmp39_ = imsi;
	_tmp39__length1 = imsi_length1;
	_tmp38_ (GISI_COMM_ERROR_CODE_OK, (const gchar*) _tmp39_, _tmp38__target);
	imsi = (g_free (imsi), NULL);
}


static void ___lambda12__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda12_ (self, msg);
}


void gisi_comm_sim_readIMSI (GIsiCommSIM* self, GIsiCommStringResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block18Data* _data18_;
	GIsiCommStringResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data18_->cb_target_destroy_notify == NULL) ? NULL : (_data18_->cb_target_destroy_notify (_data18_->cb_target), NULL);
	_data18_->cb = NULL;
	_data18_->cb_target = NULL;
	_data18_->cb_target_destroy_notify = NULL;
	_data18_->cb = _tmp0_;
	_data18_->cb_target = _tmp0__target;
	_data18_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = g_new0 (guchar, 2);
	_tmp1_[0] = (guchar) SIM_IMSI_REQ_READ_IMSI;
	_tmp1_[1] = (guchar) READ_IMSI;
	req = _tmp1_;
	req_length1 = 2;
	_req_size_ = req_length1;
	_tmp2_ = self->priv->ll;
	g_isi_client_send (_tmp2_, req, req_length1, ___lambda12__gisi_notify_func, block18_data_ref (_data18_), block18_data_unref);
	req = (g_free (req), NULL);
	block18_data_unref (_data18_);
	_data18_ = NULL;
}


GIsiCommSIMISI_IMSI* gisi_comm_sim_isi_imsi_dup (const GIsiCommSIMISI_IMSI* self) {
	GIsiCommSIMISI_IMSI* dup;
	dup = g_new0 (GIsiCommSIMISI_IMSI, 1);
	memcpy (dup, self, sizeof (GIsiCommSIMISI_IMSI));
	return dup;
}


void gisi_comm_sim_isi_imsi_free (GIsiCommSIMISI_IMSI* self) {
	g_free (self);
}


GType gisi_comm_sim_isi_imsi_get_type (void) {
	static volatile gsize gisi_comm_sim_isi_imsi_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_sim_isi_imsi_type_id__volatile)) {
		GType gisi_comm_sim_isi_imsi_type_id;
		gisi_comm_sim_isi_imsi_type_id = g_boxed_type_register_static ("GIsiCommSIMISI_IMSI", (GBoxedCopyFunc) gisi_comm_sim_isi_imsi_dup, (GBoxedFreeFunc) gisi_comm_sim_isi_imsi_free);
		g_once_init_leave (&gisi_comm_sim_isi_imsi_type_id__volatile, gisi_comm_sim_isi_imsi_type_id);
	}
	return gisi_comm_sim_isi_imsi_type_id__volatile;
}


GIsiCommSIMISI_SPN* gisi_comm_sim_isi_spn_dup (const GIsiCommSIMISI_SPN* self) {
	GIsiCommSIMISI_SPN* dup;
	dup = g_new0 (GIsiCommSIMISI_SPN, 1);
	memcpy (dup, self, sizeof (GIsiCommSIMISI_SPN));
	return dup;
}


void gisi_comm_sim_isi_spn_free (GIsiCommSIMISI_SPN* self) {
	g_free (self);
}


GType gisi_comm_sim_isi_spn_get_type (void) {
	static volatile gsize gisi_comm_sim_isi_spn_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_sim_isi_spn_type_id__volatile)) {
		GType gisi_comm_sim_isi_spn_type_id;
		gisi_comm_sim_isi_spn_type_id = g_boxed_type_register_static ("GIsiCommSIMISI_SPN", (GBoxedCopyFunc) gisi_comm_sim_isi_spn_dup, (GBoxedFreeFunc) gisi_comm_sim_isi_spn_free);
		g_once_init_leave (&gisi_comm_sim_isi_spn_type_id__volatile, gisi_comm_sim_isi_spn_type_id);
	}
	return gisi_comm_sim_isi_spn_type_id__volatile;
}


static void gisi_comm_sim_class_init (GIsiCommSIMClass * klass) {
	gisi_comm_sim_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->finalize = gisi_comm_sim_finalize;
	g_type_class_add_private (klass, sizeof (GIsiCommSIMPrivate));
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->onSubsystemIsReachable = gisi_comm_sim_real_onSubsystemIsReachable;
}


static void gisi_comm_sim_instance_init (GIsiCommSIM * self) {
	self->priv = GISI_COMM_SIM_GET_PRIVATE (self);
}


static void gisi_comm_sim_finalize (GIsiCommAbstractBaseClient* obj) {
	GIsiCommSIM * self;
	self = GISI_COMM_SIM (obj);
	_g_isi_client_destroy0 (self->priv->ll);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (gisi_comm_sim_parent_class)->finalize (obj);
}


/**
     * @class SIM
     *
     * SIM Data Interface
     **/
GType gisi_comm_sim_get_type (void) {
	static volatile gsize gisi_comm_sim_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_sim_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommSIMClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_sim_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommSIM), 0, (GInstanceInitFunc) gisi_comm_sim_instance_init, NULL };
		GType gisi_comm_sim_type_id;
		gisi_comm_sim_type_id = g_type_register_static (GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT, "GIsiCommSIM", &g_define_type_info, 0);
		g_once_init_leave (&gisi_comm_sim_type_id__volatile, gisi_comm_sim_type_id);
	}
	return gisi_comm_sim_type_id__volatile;
}


static GIsiClient* g_isi_modem_network_client_create (GIsiModem* self) {
	GIsiClient* result = NULL;
	GIsiClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_isi_client_create (self, PN_NETWORK);
	result = (GIsiClient*) _tmp0_;
	return result;
}


GIsiCommNetwork* gisi_comm_network_construct (GType object_type, GIsiModem* modem) {
	GIsiCommNetwork* self = NULL;
	GIsiModem* _tmp0_;
	GIsiClient* _tmp1_ = NULL;
	GIsiClient* _tmp2_;
	g_return_val_if_fail (modem != NULL, NULL);
	self = (GIsiCommNetwork*) gisi_comm_abstract_base_client_construct (object_type);
	_tmp0_ = modem;
	_tmp1_ = g_isi_modem_network_client_create (_tmp0_);
	_g_isi_client_destroy0 (self->priv->ll);
	self->priv->ll = _tmp1_;
	_tmp2_ = self->priv->ll;
	((GIsiCommAbstractBaseClient*) self)->client = _tmp2_;
	return self;
}


GIsiCommNetwork* gisi_comm_network_new (GIsiModem* modem) {
	return gisi_comm_network_construct (GISI_COMM_TYPE_NETWORK, modem);
}


static void _gisi_comm_network_onSignalStrengthIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_network_onSignalStrengthIndicationReceived (self, msg);
}


static void _gisi_comm_network_onRegistrationStatusIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_network_onRegistrationStatusIndicationReceived (self, msg);
}


static void _gisi_comm_network_onRadioAccessTechnologyIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_network_onRadioAccessTechnologyIndicationReceived (self, msg);
}


static void _gisi_comm_network_onTimeIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_network_onTimeIndicationReceived (self, msg);
}


static void __lambda25_ (GIsiCommNetwork* self, GIsiCommErrorCode _error_, GIsiCommNetworkISI_RegStatus* _result_) {
	GIsiCommErrorCode _tmp0_;
	_tmp0_ = _error_;
	g_debug ("gisicomm.vala:899: query status done, error = %d", (gint) _tmp0_);
}


static void ___lambda25__gisi_comm_isi_reg_status_result_func (GIsiCommErrorCode _error_, GIsiCommNetworkISI_RegStatus* status, gpointer self) {
	__lambda25_ (self, _error_, status);
}


static void __lambda23_ (GIsiCommNetwork* self, GIsiCommErrorCode _error_, gint _result_) {
	GIsiCommErrorCode _tmp0_;
	_tmp0_ = _error_;
	g_debug ("gisicomm.vala:897: query rat done, error = %d", (gint) _tmp0_);
	gisi_comm_network_queryStatus (self, ___lambda25__gisi_comm_isi_reg_status_result_func, gisi_comm_abstract_base_client_ref (self), gisi_comm_abstract_base_client_unref);
}


static void ___lambda23__gisi_comm_int_result_func (GIsiCommErrorCode _error_, gint _result_, gpointer self) {
	__lambda23_ (self, _error_, _result_);
}


static void gisi_comm_network_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base) {
	GIsiCommNetwork * self;
	GIsiClient* _tmp0_;
	GIsiClient* _tmp1_;
	GIsiClient* _tmp2_;
	GIsiClient* _tmp3_;
	self = (GIsiCommNetwork*) base;
	_tmp0_ = self->priv->ll;
	g_isi_client_ind_subscribe (_tmp0_, (guchar) NET_RSSI_IND, _gisi_comm_network_onSignalStrengthIndicationReceived_gisi_notify_func, self);
	_tmp1_ = self->priv->ll;
	g_isi_client_ind_subscribe (_tmp1_, (guchar) NET_REG_STATUS_IND, _gisi_comm_network_onRegistrationStatusIndicationReceived_gisi_notify_func, self);
	_tmp2_ = self->priv->ll;
	g_isi_client_ind_subscribe (_tmp2_, (guchar) NET_RAT_IND, _gisi_comm_network_onRadioAccessTechnologyIndicationReceived_gisi_notify_func, self);
	_tmp3_ = self->priv->ll;
	g_isi_client_ind_subscribe (_tmp3_, (guchar) NET_TIME_IND, _gisi_comm_network_onTimeIndicationReceived_gisi_notify_func, self);
	gisi_comm_network_queryRat (self, ___lambda23__gisi_comm_int_result_func, gisi_comm_abstract_base_client_ref (self), gisi_comm_abstract_base_client_unref);
}


static const char* _NET_registration_status_to_string (guint8 value) {
	switch (value) {
		case NET_REG_STATUS_HOME:
		return "NET_REG_STATUS_HOME";
		case NET_REG_STATUS_ROAM:
		return "NET_REG_STATUS_ROAM";
		case NET_REG_STATUS_ROAM_BLINK:
		return "NET_REG_STATUS_ROAM_BLINK";
		case NET_REG_STATUS_NOSERV:
		return "NET_REG_STATUS_NOSERV";
		case NET_REG_STATUS_NOSERV_SEARCHING:
		return "NET_REG_STATUS_NOSERV_SEARCHING";
		case NET_REG_STATUS_NOSERV_NOTSEARCHING:
		return "NET_REG_STATUS_NOSERV_NOTSEARCHING";
		case NET_REG_STATUS_NOSERV_NOSIM:
		return "NET_REG_STATUS_NOSERV_NOSIM";
		case NET_REG_STATUS_POWER_OFF:
		return "NET_REG_STATUS_POWER_OFF";
		case NET_REG_STATUS_NSPS:
		return "NET_REG_STATUS_NSPS";
		case NET_REG_STATUS_NSPS_NO_COVERAGE:
		return "NET_REG_STATUS_NSPS_NO_COVERAGE";
		case NET_REG_STATUS_NOSERV_SIM_REJECTED_BY_NW:
		return "NET_REG_STATUS_NOSERV_SIM_REJECTED_BY_NW";
	}
	return NULL;
}


static const char* _NET_operator_select_mode_to_string (guint8 value) {
	switch (value) {
		case NET_SELECT_MODE_UNKNOWN:
		return "NET_SELECT_MODE_UNKNOWN";
		case NET_SELECT_MODE_MANUAL:
		return "NET_SELECT_MODE_MANUAL";
		case NET_SELECT_MODE_AUTOMATIC:
		return "NET_SELECT_MODE_AUTOMATIC";
		case NET_SELECT_MODE_USER_RESELECTION:
		return "NET_SELECT_MODE_USER_RESELECTION";
		case NET_SELECT_MODE_NO_SELECTION:
		return "NET_SELECT_MODE_NO_SELECTION";
	}
	return NULL;
}


static gchar* g_isi_sub_block_iter_alpha_tag_at_position (GIsiSubBlockIter *self, gsize length, guint pos, GError** error) {
	gchar* result = NULL;
	gchar* tag = NULL;
	gsize _tmp0_;
	guint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = length;
	_tmp1_ = pos;
	_tmp3_ = g_isi_sb_iter_get_alpha_tag (&(*self), &_tmp2_, _tmp0_, _tmp1_);
	_g_free0 (tag);
	_tmp4_ = g_strdup (_tmp2_);
	tag = _tmp4_;
	g_isi_sub_block_iter_checked (&(*self), _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (tag);
		return NULL;
	}
	_tmp5_ = tag;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	_g_free0 (tag);
	return result;
}


static guint16 g_isi_sub_block_iter_word_at_position (GIsiSubBlockIter *self, guint pos, GError** error) {
	guint16 result = 0U;
	guint16 _result_ = 0U;
	guint _tmp0_;
	guint16 _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = pos;
	_tmp2_ = g_isi_sb_iter_get_word (&(*self), &_tmp1_, _tmp0_);
	_result_ = _tmp1_;
	g_isi_sub_block_iter_checked (&(*self), _tmp2_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0U;
	}
	result = _result_;
	return result;
}


static guint32 g_isi_sub_block_iter_dword_at_position (GIsiSubBlockIter *self, guint pos, GError** error) {
	guint32 result = 0U;
	guint32 _result_ = 0U;
	guint _tmp0_;
	guint32 _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = pos;
	_tmp2_ = g_isi_sb_iter_get_dword (&(*self), &_tmp1_, _tmp0_);
	_result_ = _tmp1_;
	g_isi_sub_block_iter_checked (&(*self), _tmp2_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0U;
	}
	result = _result_;
	return result;
}


static void g_isi_sub_block_iter_oper_code_at_position (GIsiSubBlockIter *self, gchar** mcc, gchar** mnc, guint pos, GError** error) {
	gchar* _vala_mcc = NULL;
	gchar* _vala_mnc = NULL;
	guint8* _tmp0_ = NULL;
	guint8* a;
	gint a_length1;
	gint _a_size_;
	guint8* _tmp1_ = NULL;
	guint8* b;
	gint b_length1;
	gint _b_size_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint _tmp4_;
	gboolean _tmp5_ = FALSE;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_new0 (guint8, 4);
	a = _tmp0_;
	a_length1 = 4;
	_a_size_ = a_length1;
	_tmp1_ = g_new0 (guint8, 4);
	b = _tmp1_;
	b_length1 = 4;
	_b_size_ = b_length1;
	_tmp2_ = a;
	_tmp2__length1 = a_length1;
	_tmp3_ = b;
	_tmp3__length1 = b_length1;
	_tmp4_ = pos;
	_tmp5_ = g_isi_sb_iter_get_oper_code (&(*self), _tmp2_, _tmp3_, _tmp4_);
	g_isi_sub_block_iter_checked (&(*self), _tmp5_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		b = (g_free (b), NULL);
		a = (g_free (a), NULL);
		return;
	}
	_tmp6_ = a;
	_tmp6__length1 = a_length1;
	_tmp7_ = g_strdup ((const gchar*) _tmp6_);
	_g_free0 (_vala_mcc);
	_vala_mcc = _tmp7_;
	_tmp8_ = b;
	_tmp8__length1 = b_length1;
	_tmp9_ = g_strdup ((const gchar*) _tmp8_);
	_g_free0 (_vala_mnc);
	_vala_mnc = _tmp9_;
	b = (g_free (b), NULL);
	a = (g_free (a), NULL);
	if (mcc) {
		*mcc = _vala_mcc;
	} else {
		_g_free0 (_vala_mcc);
	}
	if (mnc) {
		*mnc = _vala_mnc;
	} else {
		_g_free0 (_vala_mnc);
	}
}


static gboolean g_isi_sub_block_iter_bool_at_position (GIsiSubBlockIter *self, guint pos, GError** error) {
	gboolean result = FALSE;
	guint _tmp0_;
	guchar _tmp1_ = '\0';
	guchar _tmp2_;
	GError * _inner_error_ = NULL;
	_tmp0_ = pos;
	_tmp1_ = g_isi_sub_block_iter_byte_at_position (&(*self), _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = (gboolean) _tmp2_;
	return result;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static void gisi_comm_network_parseRegistrationStatusMessage (GIsiCommNetwork* self, GIsiMessage* msg, GIsiCommNetworkISI_RegStatus* result) {
	GIsiCommNetworkISI_RegStatus _tmp0_ = {0};
	GIsiCommNetworkISI_RegStatus _result_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_result_ = _tmp0_;
	{
		GIsiMessage* _tmp1_;
		GIsiSubBlockIter _tmp2_ = {0};
		GIsiSubBlockIter sbi;
		_tmp1_ = msg;
		g_isi_msg_subblock_iter_create (_tmp1_, (gsize) 2, &_tmp2_);
		sbi = _tmp2_;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gboolean _tmp5_ = FALSE;
				GIsiSubBlockIter _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				GIsiSubBlockIter _tmp11_;
				gsize _tmp12_;
				gsize _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				GIsiSubBlockIter _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					g_isi_sb_iter_next (&sbi);
				}
				_tmp3_ = FALSE;
				_tmp5_ = g_isi_sb_iter_is_valid (&sbi);
				if (!_tmp5_) {
					break;
				}
				_tmp6_ = sbi;
				_tmp7_ = g_isi_sb_iter_get_id (&_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strdup_printf ("%i", _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = sbi;
				_tmp12_ = g_isi_sb_iter_get_len (&_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strdup_printf ("%" G_GSIZE_FORMAT, _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat ("Have subblock with ID ", _tmp10_, ", length ", _tmp15_, NULL);
				_tmp17_ = _tmp16_;
				g_message ("gisicomm.vala:910: %s", _tmp17_);
				_g_free0 (_tmp17_);
				_g_free0 (_tmp15_);
				_g_free0 (_tmp10_);
				_tmp18_ = sbi;
				_tmp19_ = g_isi_sb_iter_get_id (&_tmp18_);
				_tmp20_ = _tmp19_;
				switch (_tmp20_) {
					case NET_GSM_REG_NETWORK_INFO:
					{
						guint8 length = 0U;
						guchar _tmp21_ = '\0';
						gboolean _tmp22_ = FALSE;
						guint8 _tmp23_;
						gchar* _tmp24_ = NULL;
						gchar* _tmp25_;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_;
						guint8 _tmp28_;
						gchar* str = NULL;
						guint8 _tmp29_;
						const gchar* _tmp30_ = NULL;
						gboolean _tmp31_ = FALSE;
						gchar* _tmp32_;
						const gchar* _tmp33_;
						const gchar* _tmp34_ = NULL;
						gchar* _tmp35_ = NULL;
						gchar* _tmp36_;
						const gchar* _tmp37_;
						gchar* _tmp38_;
						_tmp22_ = g_isi_sb_iter_get_byte (&sbi, &_tmp21_, (guint) 5);
						length = (guint8) _tmp21_;
						if (!_tmp22_) {
							continue;
						}
						_tmp23_ = length;
						_tmp24_ = g_strdup_printf ("%hhu", _tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = g_strconcat ("length = ", _tmp25_, NULL);
						_tmp27_ = _tmp26_;
						g_debug ("gisicomm.vala:921: %s", _tmp27_);
						_g_free0 (_tmp27_);
						_g_free0 (_tmp25_);
						_tmp28_ = length;
						length = (guint8) (_tmp28_ * 2);
						_tmp29_ = length;
						_tmp31_ = g_isi_sb_iter_get_alpha_tag (&sbi, &_tmp30_, (gsize) _tmp29_, (guint) 6);
						_g_free0 (str);
						_tmp32_ = g_strdup (_tmp30_);
						str = _tmp32_;
						if (!_tmp31_) {
							_g_free0 (str);
							continue;
						}
						_tmp33_ = str;
						_tmp34_ = string_to_string (_tmp33_);
						_tmp35_ = g_strconcat ("OPER = ", _tmp34_, NULL);
						_tmp36_ = _tmp35_;
						g_message ("gisicomm.vala:928: %s", _tmp36_);
						_g_free0 (_tmp36_);
						_tmp37_ = str;
						_tmp38_ = g_strdup (_tmp37_);
						_g_free0 (_result_.name);
						_result_.name = _tmp38_;
						_g_free0 (str);
						break;
					}
					case NET_REG_INFO_COMMON:
					{
						guchar _tmp39_ = '\0';
						guchar _tmp40_;
						guchar _tmp41_ = '\0';
						guchar _tmp42_;
						GIsiCommNetworkISI_RegStatus _tmp43_;
						guint8 _tmp44_;
						const gchar* _tmp45_ = NULL;
						gchar* _tmp46_ = NULL;
						gchar* _tmp47_;
						GIsiCommNetworkISI_RegStatus _tmp48_;
						guint8 _tmp49_;
						const gchar* _tmp50_ = NULL;
						gchar* _tmp51_ = NULL;
						gchar* _tmp52_;
						guchar _tmp53_ = '\0';
						guint8 nNames;
						guint8 _tmp54_;
						gchar* _tmp55_ = NULL;
						gchar* _tmp56_;
						gchar* _tmp57_ = NULL;
						gchar* _tmp58_;
						gboolean _tmp59_ = FALSE;
						gboolean _tmp60_ = FALSE;
						GIsiCommNetworkISI_RegStatus _tmp61_;
						guint8 _tmp62_;
						gboolean _tmp65_;
						gboolean _tmp68_;
						_tmp39_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 2, &_inner_error_);
						_tmp40_ = _tmp39_;
						if (_inner_error_ != NULL) {
							gisi_comm_network_isi_regstatus_destroy (&_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_result_.status = (guint8) _tmp40_;
						_tmp41_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 3, &_inner_error_);
						_tmp42_ = _tmp41_;
						if (_inner_error_ != NULL) {
							gisi_comm_network_isi_regstatus_destroy (&_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_result_.mode = (guint8) _tmp42_;
						_tmp43_ = _result_;
						_tmp44_ = _tmp43_.status;
						_tmp45_ = _NET_registration_status_to_string (_tmp44_);
						_tmp46_ = g_strconcat ("regstatus = ", _tmp45_, NULL);
						_tmp47_ = _tmp46_;
						g_debug ("gisicomm.vala:937: %s", _tmp47_);
						_g_free0 (_tmp47_);
						_tmp48_ = _result_;
						_tmp49_ = _tmp48_.mode;
						_tmp50_ = _NET_operator_select_mode_to_string (_tmp49_);
						_tmp51_ = g_strconcat ("regmode = ", _tmp50_, NULL);
						_tmp52_ = _tmp51_;
						g_debug ("gisicomm.vala:938: %s", _tmp52_);
						_g_free0 (_tmp52_);
						_tmp53_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 4, &_inner_error_);
						nNames = (guint8) _tmp53_;
						if (_inner_error_ != NULL) {
							gisi_comm_network_isi_regstatus_destroy (&_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp54_ = nNames;
						_tmp55_ = g_strdup_printf ("%hhu", _tmp54_);
						_tmp56_ = _tmp55_;
						_tmp57_ = g_strconcat ("# of alternative names: ", _tmp56_, NULL);
						_tmp58_ = _tmp57_;
						g_debug ("gisicomm.vala:941: %s", _tmp58_);
						_g_free0 (_tmp58_);
						_g_free0 (_tmp56_);
						_tmp61_ = _result_;
						_tmp62_ = _tmp61_.status;
						if (_tmp62_ == NET_REG_STATUS_HOME) {
							_tmp60_ = TRUE;
						} else {
							GIsiCommNetworkISI_RegStatus _tmp63_;
							guint8 _tmp64_;
							_tmp63_ = _result_;
							_tmp64_ = _tmp63_.status;
							_tmp60_ = _tmp64_ == NET_REG_STATUS_ROAM;
						}
						_tmp65_ = _tmp60_;
						if (_tmp65_) {
							_tmp59_ = TRUE;
						} else {
							GIsiCommNetworkISI_RegStatus _tmp66_;
							guint8 _tmp67_;
							_tmp66_ = _result_;
							_tmp67_ = _tmp66_.status;
							_tmp59_ = _tmp67_ == NET_REG_STATUS_ROAM_BLINK;
						}
						_tmp68_ = _tmp59_;
						if (_tmp68_) {
							guchar _tmp69_ = '\0';
							guchar _tmp70_;
							gchar* _tmp71_ = NULL;
							gchar* _tmp72_;
							GIsiCommNetworkISI_RegStatus _tmp73_;
							const gchar* _tmp74_;
							const gchar* _tmp75_ = NULL;
							gchar* _tmp76_ = NULL;
							gchar* _tmp77_;
							_tmp69_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 7, &_inner_error_);
							_tmp70_ = _tmp69_;
							if (_inner_error_ != NULL) {
								gisi_comm_network_isi_regstatus_destroy (&_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp71_ = g_isi_sub_block_iter_alpha_tag_at_position (&sbi, (gsize) (_tmp70_ * 2), (guint) 8, &_inner_error_);
							_tmp72_ = _tmp71_;
							if (_inner_error_ != NULL) {
								gisi_comm_network_isi_regstatus_destroy (&_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_g_free0 (_result_.network);
							_result_.network = _tmp72_;
							_tmp73_ = _result_;
							_tmp74_ = _tmp73_.network;
							_tmp75_ = string_to_string (_tmp74_);
							_tmp76_ = g_strconcat ("regname = ", _tmp75_, NULL);
							_tmp77_ = _tmp76_;
							g_debug ("gisicomm.vala:948: %s", _tmp77_);
							_g_free0 (_tmp77_);
						} else {
							g_debug ("gisicomm.vala:952: not looking for regname, since we're not camped");
						}
						break;
					}
					case NET_GSM_REG_INFO:
					{
						guint16 _tmp78_ = 0U;
						guint16 _tmp79_;
						gchar* _tmp80_ = NULL;
						guint32 _tmp81_ = 0U;
						guint32 _tmp82_;
						gchar* _tmp83_ = NULL;
						gchar* _tmp84_ = NULL;
						gchar* _tmp85_ = NULL;
						GIsiCommNetworkISI_RegStatus _tmp86_;
						const gchar* _tmp87_;
						const gchar* _tmp88_ = NULL;
						GIsiCommNetworkISI_RegStatus _tmp89_;
						const gchar* _tmp90_;
						const gchar* _tmp91_ = NULL;
						gchar* _tmp92_ = NULL;
						gchar* _tmp93_;
						guchar _tmp94_ = '\0';
						guchar _tmp95_;
						GIsiCommNetworkISI_RegStatus _tmp96_;
						guint _tmp97_;
						gchar* _tmp98_ = NULL;
						gchar* _tmp99_;
						gchar* _tmp100_ = NULL;
						gchar* _tmp101_;
						gboolean _tmp102_ = FALSE;
						gboolean _tmp103_;
						gboolean _tmp104_ = FALSE;
						gboolean _tmp105_;
						gboolean _tmp106_ = FALSE;
						gboolean _tmp107_;
						GIsiCommNetworkISI_RegStatus _tmp108_;
						const gchar* _tmp109_;
						GIsiCommNetworkISI_RegStatus _tmp110_;
						const gchar* _tmp111_;
						GIsiCommNetworkISI_RegStatus _tmp112_;
						gboolean _tmp113_;
						gchar* _tmp114_ = NULL;
						gchar* _tmp115_;
						GIsiCommNetworkISI_RegStatus _tmp116_;
						gboolean _tmp117_;
						gchar* _tmp118_ = NULL;
						gchar* _tmp119_;
						GIsiCommNetworkISI_RegStatus _tmp120_;
						gboolean _tmp121_;
						gchar* _tmp122_ = NULL;
						gchar* _tmp123_;
						gchar* _tmp124_ = NULL;
						gchar* _tmp125_;
						_tmp78_ = g_isi_sub_block_iter_word_at_position (&sbi, (guint) 2, &_inner_error_);
						_tmp79_ = _tmp78_;
						if (_inner_error_ != NULL) {
							gisi_comm_network_isi_regstatus_destroy (&_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp80_ = g_strdup_printf ("%04X", (guint) _tmp79_);
						_g_free0 (_result_.lac);
						_result_.lac = _tmp80_;
						_tmp81_ = g_isi_sub_block_iter_dword_at_position (&sbi, (guint) 4, &_inner_error_);
						_tmp82_ = _tmp81_;
						if (_inner_error_ != NULL) {
							gisi_comm_network_isi_regstatus_destroy (&_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp83_ = g_strdup_printf ("%04X", (guint) (_tmp82_ >> 16));
						_g_free0 (_result_.cid);
						_result_.cid = _tmp83_;
						g_isi_sub_block_iter_oper_code_at_position (&sbi, &_tmp84_, &_tmp85_, (guint) 8, &_inner_error_);
						_g_free0 (_result_.mcc);
						_result_.mcc = _tmp84_;
						_g_free0 (_result_.mnc);
						_result_.mnc = _tmp85_;
						if (_inner_error_ != NULL) {
							gisi_comm_network_isi_regstatus_destroy (&_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp86_ = _result_;
						_tmp87_ = _tmp86_.mcc;
						_tmp88_ = string_to_string (_tmp87_);
						_tmp89_ = _result_;
						_tmp90_ = _tmp89_.mnc;
						_tmp91_ = string_to_string (_tmp90_);
						_tmp92_ = g_strconcat ("mccmnc = ", _tmp88_, _tmp91_, NULL);
						_tmp93_ = _tmp92_;
						g_debug ("gisicomm.vala:963: %s", _tmp93_);
						_g_free0 (_tmp93_);
						_tmp94_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 11, &_inner_error_);
						_tmp95_ = _tmp94_;
						if (_inner_error_ != NULL) {
							gisi_comm_network_isi_regstatus_destroy (&_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						switch (_tmp95_) {
							case 1:
							{
								_result_.band = (guint) 900;
								break;
							}
							case 2:
							{
								_result_.band = (guint) 1800;
								break;
							}
							case 4:
							{
								_result_.band = (guint) 1900;
								break;
							}
							case 8:
							{
								_result_.band = (guint) 850;
								break;
							}
							default:
							{
								_result_.band = (guint) 0;
								break;
							}
						}
						_tmp96_ = _result_;
						_tmp97_ = _tmp96_.band;
						_tmp98_ = g_strdup_printf ("%u", _tmp97_);
						_tmp99_ = _tmp98_;
						_tmp100_ = g_strconcat ("band = ", _tmp99_, NULL);
						_tmp101_ = _tmp100_;
						g_debug ("gisicomm.vala:983: %s", _tmp101_);
						_g_free0 (_tmp101_);
						_g_free0 (_tmp99_);
						_tmp102_ = g_isi_sub_block_iter_bool_at_position (&sbi, (guint) 17, &_inner_error_);
						_tmp103_ = _tmp102_;
						if (_inner_error_ != NULL) {
							gisi_comm_network_isi_regstatus_destroy (&_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_result_.egprs = _tmp103_;
						_tmp104_ = g_isi_sub_block_iter_bool_at_position (&sbi, (guint) 20, &_inner_error_);
						_tmp105_ = _tmp104_;
						if (_inner_error_ != NULL) {
							gisi_comm_network_isi_regstatus_destroy (&_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_result_.hsdpa = _tmp105_;
						_tmp106_ = g_isi_sub_block_iter_bool_at_position (&sbi, (guint) 21, &_inner_error_);
						_tmp107_ = _tmp106_;
						if (_inner_error_ != NULL) {
							gisi_comm_network_isi_regstatus_destroy (&_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_result_.hsupa = _tmp107_;
						_tmp108_ = _result_;
						_tmp109_ = _tmp108_.lac;
						_tmp110_ = _result_;
						_tmp111_ = _tmp110_.cid;
						g_debug ("gisicomm.vala:989: lac = 0x%s, cid = 0x%s", _tmp109_, _tmp111_);
						_tmp112_ = _result_;
						_tmp113_ = _tmp112_.egprs;
						_tmp114_ = bool_to_string (_tmp113_);
						_tmp115_ = _tmp114_;
						_tmp116_ = _result_;
						_tmp117_ = _tmp116_.hsdpa;
						_tmp118_ = bool_to_string (_tmp117_);
						_tmp119_ = _tmp118_;
						_tmp120_ = _result_;
						_tmp121_ = _tmp120_.hsupa;
						_tmp122_ = bool_to_string (_tmp121_);
						_tmp123_ = _tmp122_;
						_tmp124_ = g_strconcat ("edge = ", _tmp115_, ", hsdpa = ", _tmp119_, ", hsupa = ", _tmp123_, NULL);
						_tmp125_ = _tmp124_;
						g_debug ("gisicomm.vala:990: %s", _tmp125_);
						_g_free0 (_tmp125_);
						_g_free0 (_tmp123_);
						_g_free0 (_tmp119_);
						_g_free0 (_tmp115_);
						break;
					}
					default:
					{
						GIsiSubBlockIter _tmp126_;
						gint _tmp127_;
						gint _tmp128_;
						gchar* _tmp129_ = NULL;
						gchar* _tmp130_;
						gchar* _tmp131_ = NULL;
						gchar* _tmp132_;
						_tmp126_ = sbi;
						_tmp127_ = g_isi_sb_iter_get_id (&_tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = g_strdup_printf ("%i", _tmp128_);
						_tmp130_ = _tmp129_;
						_tmp131_ = g_strconcat ("FIXME: handle unknown subblock with ID ", _tmp130_, NULL);
						_tmp132_ = _tmp131_;
						g_message ("gisicomm.vala:994: %s", _tmp132_);
						_g_free0 (_tmp132_);
						_g_free0 (_tmp130_);
						break;
					}
				}
			}
		}
	}
	*result = _result_;
	return;
}


static void gisi_comm_network_onRadioAccessTechnologyIndicationReceived (GIsiCommNetwork* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("NET RAT IND ", _tmp2_, " received, iterating through subblocks", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:1004: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	{
		GIsiMessage* _tmp5_;
		GIsiSubBlockIter _tmp6_ = {0};
		GIsiSubBlockIter sbi;
		_tmp5_ = msg;
		g_isi_msg_subblock_iter_create (_tmp5_, (gsize) 2, &_tmp6_);
		sbi = _tmp6_;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gboolean _tmp9_ = FALSE;
				GIsiSubBlockIter _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				GIsiSubBlockIter _tmp15_;
				gsize _tmp16_;
				gsize _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				GIsiSubBlockIter _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					g_isi_sb_iter_next (&sbi);
				}
				_tmp7_ = FALSE;
				_tmp9_ = g_isi_sb_iter_is_valid (&sbi);
				if (!_tmp9_) {
					break;
				}
				_tmp10_ = sbi;
				_tmp11_ = g_isi_sb_iter_get_id (&_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strdup_printf ("%i", _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = sbi;
				_tmp16_ = g_isi_sb_iter_get_len (&_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strdup_printf ("%" G_GSIZE_FORMAT, _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strconcat ("Have subblock with ID ", _tmp14_, ", length ", _tmp19_, NULL);
				_tmp21_ = _tmp20_;
				g_message ("gisicomm.vala:1008: %s", _tmp21_);
				_g_free0 (_tmp21_);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp14_);
				_tmp22_ = sbi;
				_tmp23_ = g_isi_sb_iter_get_id (&_tmp22_);
				_tmp24_ = _tmp23_;
				switch (_tmp24_) {
					case NET_RAT_INFO:
					{
						guchar _tmp25_ = '\0';
						guchar _tmp26_;
						_tmp25_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 2, &_inner_error_);
						_tmp26_ = _tmp25_;
						if (_inner_error_ != NULL) {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						g_message ("gisicomm.vala:1013: FIXME: RAT 0x%0X detected", _tmp26_);
						break;
					}
					default:
					{
						GIsiSubBlockIter _tmp27_;
						gint _tmp28_;
						gint _tmp29_;
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_;
						gchar* _tmp32_ = NULL;
						gchar* _tmp33_;
						_tmp27_ = sbi;
						_tmp28_ = g_isi_sb_iter_get_id (&_tmp27_);
						_tmp29_ = _tmp28_;
						_tmp30_ = g_strdup_printf ("%i", _tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = g_strconcat ("FIXME: handle unknown subblock with ID ", _tmp31_, NULL);
						_tmp33_ = _tmp32_;
						g_message ("gisicomm.vala:1017: %s", _tmp33_);
						_g_free0 (_tmp33_);
						_g_free0 (_tmp31_);
						break;
					}
				}
			}
		}
	}
}


static void gisi_comm_network_onTimeIndicationReceived (GIsiCommNetwork* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("NET TIME IND ", _tmp2_, " received, iterating through subblocks", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:1026: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	{
		GIsiMessage* _tmp5_;
		GIsiSubBlockIter _tmp6_ = {0};
		GIsiSubBlockIter sbi;
		_tmp5_ = msg;
		g_isi_msg_subblock_iter_create (_tmp5_, (gsize) 2, &_tmp6_);
		sbi = _tmp6_;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gboolean _tmp9_ = FALSE;
				GIsiSubBlockIter _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				GIsiSubBlockIter _tmp15_;
				gsize _tmp16_;
				gsize _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				GIsiSubBlockIter _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					g_isi_sb_iter_next (&sbi);
				}
				_tmp7_ = FALSE;
				_tmp9_ = g_isi_sb_iter_is_valid (&sbi);
				if (!_tmp9_) {
					break;
				}
				_tmp10_ = sbi;
				_tmp11_ = g_isi_sb_iter_get_id (&_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strdup_printf ("%i", _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = sbi;
				_tmp16_ = g_isi_sb_iter_get_len (&_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strdup_printf ("%" G_GSIZE_FORMAT, _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strconcat ("Have subblock with ID ", _tmp14_, ", length ", _tmp19_, NULL);
				_tmp21_ = _tmp20_;
				g_message ("gisicomm.vala:1030: %s", _tmp21_);
				_g_free0 (_tmp21_);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp14_);
				_tmp22_ = sbi;
				_tmp23_ = g_isi_sb_iter_get_id (&_tmp22_);
				_tmp24_ = _tmp23_;
				switch (_tmp24_) {
					case NET_TIME_INFO:
					{
						GIsiCommNetworkISI_Time isitime = {0};
						gboolean _tmp25_ = FALSE;
						struct tm t = {0};
						guint8 _tmp26_ = 0U;
						GIsiCommNetworkISI_Time _tmp27_;
						guint8 _tmp28_;
						guint8 _tmp31_;
						gint _tmp32_;
						guint8 _tmp33_ = 0U;
						GIsiCommNetworkISI_Time _tmp34_;
						guint8 _tmp35_;
						guint8 _tmp38_;
						guint8 _tmp39_ = 0U;
						GIsiCommNetworkISI_Time _tmp40_;
						guint8 _tmp41_;
						guint8 _tmp44_;
						guint8 _tmp45_ = 0U;
						GIsiCommNetworkISI_Time _tmp46_;
						guint8 _tmp47_;
						guint8 _tmp50_;
						guint8 _tmp51_ = 0U;
						GIsiCommNetworkISI_Time _tmp52_;
						guint8 _tmp53_;
						guint8 _tmp56_;
						guint8 _tmp57_ = 0U;
						GIsiCommNetworkISI_Time _tmp58_;
						guint8 _tmp59_;
						guint8 _tmp62_;
						guint8 _tmp63_ = 0U;
						GIsiCommNetworkISI_Time _tmp64_;
						guint8 _tmp65_;
						guint8 _tmp68_;
						struct tm _tmp69_;
						memset (&isitime, 0, sizeof (GIsiCommNetworkISI_Time));
						_tmp25_ = g_isi_sb_iter_get_struct (&sbi, &isitime, (gsize) sizeof (GIsiCommNetworkISI_Time), (guint) 2);
						if (!_tmp25_) {
							continue;
						}
						memset (&t, 0, sizeof (struct tm));
						_tmp27_ = isitime;
						_tmp28_ = _tmp27_.year;
						if (((guint) _tmp28_) != NET_INVALID_TIME) {
							GIsiCommNetworkISI_Time _tmp29_;
							guint8 _tmp30_;
							_tmp29_ = isitime;
							_tmp30_ = _tmp29_.year;
							_tmp26_ = _tmp30_;
						} else {
							_tmp26_ = (guint8) (-1);
						}
						_tmp31_ = _tmp26_;
						t.tm_year = (gint) _tmp31_;
						_tmp32_ = t.tm_year;
						t.tm_year = _tmp32_ + 2000;
						_tmp34_ = isitime;
						_tmp35_ = _tmp34_.mon;
						if (((guint) _tmp35_) != NET_INVALID_TIME) {
							GIsiCommNetworkISI_Time _tmp36_;
							guint8 _tmp37_;
							_tmp36_ = isitime;
							_tmp37_ = _tmp36_.mon;
							_tmp33_ = _tmp37_;
						} else {
							_tmp33_ = (guint8) (-1);
						}
						_tmp38_ = _tmp33_;
						t.tm_mon = (gint) _tmp38_;
						_tmp40_ = isitime;
						_tmp41_ = _tmp40_.mday;
						if (((guint) _tmp41_) != NET_INVALID_TIME) {
							GIsiCommNetworkISI_Time _tmp42_;
							guint8 _tmp43_;
							_tmp42_ = isitime;
							_tmp43_ = _tmp42_.mday;
							_tmp39_ = _tmp43_;
						} else {
							_tmp39_ = (guint8) (-1);
						}
						_tmp44_ = _tmp39_;
						t.tm_mday = (gint) _tmp44_;
						_tmp46_ = isitime;
						_tmp47_ = _tmp46_.hour;
						if (((guint) _tmp47_) != NET_INVALID_TIME) {
							GIsiCommNetworkISI_Time _tmp48_;
							guint8 _tmp49_;
							_tmp48_ = isitime;
							_tmp49_ = _tmp48_.hour;
							_tmp45_ = _tmp49_;
						} else {
							_tmp45_ = (guint8) (-1);
						}
						_tmp50_ = _tmp45_;
						t.tm_hour = (gint) _tmp50_;
						_tmp52_ = isitime;
						_tmp53_ = _tmp52_.min;
						if (((guint) _tmp53_) != NET_INVALID_TIME) {
							GIsiCommNetworkISI_Time _tmp54_;
							guint8 _tmp55_;
							_tmp54_ = isitime;
							_tmp55_ = _tmp54_.min;
							_tmp51_ = _tmp55_;
						} else {
							_tmp51_ = (guint8) (-1);
						}
						_tmp56_ = _tmp51_;
						t.tm_min = (gint) _tmp56_;
						_tmp58_ = isitime;
						_tmp59_ = _tmp58_.sec;
						if (((guint) _tmp59_) != NET_INVALID_TIME) {
							GIsiCommNetworkISI_Time _tmp60_;
							guint8 _tmp61_;
							_tmp60_ = isitime;
							_tmp61_ = _tmp60_.sec;
							_tmp57_ = _tmp61_;
						} else {
							_tmp57_ = (guint8) (-1);
						}
						_tmp62_ = _tmp57_;
						t.tm_sec = (gint) _tmp62_;
						_tmp64_ = isitime;
						_tmp65_ = _tmp64_.dst;
						if (((guint) _tmp65_) != NET_INVALID_TIME) {
							GIsiCommNetworkISI_Time _tmp66_;
							guint8 _tmp67_;
							_tmp66_ = isitime;
							_tmp67_ = _tmp66_.dst;
							_tmp63_ = _tmp67_;
						} else {
							_tmp63_ = (guint8) (-1);
						}
						_tmp68_ = _tmp63_;
						t.tm_isdst = (gint) _tmp68_;
						_tmp69_ = t;
						g_signal_emit_by_name (self, "time-info", &_tmp69_);
						break;
					}
					default:
					{
						GIsiSubBlockIter _tmp70_;
						gint _tmp71_;
						gint _tmp72_;
						gchar* _tmp73_ = NULL;
						gchar* _tmp74_;
						gchar* _tmp75_ = NULL;
						gchar* _tmp76_;
						_tmp70_ = sbi;
						_tmp71_ = g_isi_sb_iter_get_id (&_tmp70_);
						_tmp72_ = _tmp71_;
						_tmp73_ = g_strdup_printf ("%i", _tmp72_);
						_tmp74_ = _tmp73_;
						_tmp75_ = g_strconcat ("FIXME: handle unknown subblock with ID ", _tmp74_, NULL);
						_tmp76_ = _tmp75_;
						g_message ("gisicomm.vala:1069: %s", _tmp76_);
						_g_free0 (_tmp76_);
						_g_free0 (_tmp74_);
						break;
					}
				}
			}
		}
	}
}


static void gisi_comm_network_onRegistrationStatusIndicationReceived (GIsiCommNetwork* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GIsiMessage* _tmp5_;
	GIsiCommNetworkISI_RegStatus _tmp6_ = {0};
	GIsiCommNetworkISI_RegStatus status;
	GIsiCommNetworkISI_RegStatus _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("NET Status IND ", _tmp2_, " received, iterating through subblocks", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:1077: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = msg;
	gisi_comm_network_parseRegistrationStatusMessage (self, _tmp5_, &_tmp6_);
	status = _tmp6_;
	_tmp7_ = status;
	g_signal_emit_by_name (self, "registration-status", &_tmp7_);
	gisi_comm_network_isi_regstatus_destroy (&status);
}


static void gisi_comm_network_onSignalStrengthIndicationReceived (GIsiCommNetwork* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8 _tmp3_;
	GIsiMessage* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8 _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_get_data (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp3_ = _tmp2_[0];
	g_message ("gisicomm.vala:1084: RSSI = %d", (gint) _tmp3_);
	_tmp4_ = msg;
	_tmp5_ = g_isi_msg_get_data (_tmp4_, &_tmp5__length1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_[0];
	g_signal_emit_by_name (self, "signal-strength", _tmp7_);
}


static Block19Data* block19_data_ref (Block19Data* _data19_) {
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}


static void block19_data_unref (Block19Data* _data19_) {
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data19_->self);
		(_data19_->cb_target_destroy_notify == NULL) ? NULL : (_data19_->cb_target_destroy_notify (_data19_->cb_target), NULL);
		_data19_->cb = NULL;
		_data19_->cb_target = NULL;
		_data19_->cb_target_destroy_notify = NULL;
		g_slice_free (Block19Data, _data19_);
	}
}


static void __lambda24_ (Block19Data* _data19_, GIsiMessage* msg) {
	GIsiCommNetwork * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiMessage* _tmp3_;
	GIsiCommNetworkISI_RegStatus _tmp4_ = {0};
	GIsiCommNetworkISI_RegStatus status;
	GIsiCommIsiRegStatusResultFunc _tmp5_;
	void* _tmp5__target;
	GIsiCommNetworkISI_RegStatus _tmp6_;
	self = _data19_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommIsiRegStatusResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data19_->cb;
		_tmp2__target = _data19_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, NULL, _tmp2__target);
		return;
	}
	_tmp3_ = msg;
	gisi_comm_network_parseRegistrationStatusMessage (self, _tmp3_, &_tmp4_);
	status = _tmp4_;
	_tmp5_ = _data19_->cb;
	_tmp5__target = _data19_->cb_target;
	_tmp6_ = status;
	_tmp5_ (GISI_COMM_ERROR_CODE_OK, &_tmp6_, _tmp5__target);
	gisi_comm_network_isi_regstatus_destroy (&status);
}


static void ___lambda24__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda24_ (self, msg);
}


void gisi_comm_network_queryStatus (GIsiCommNetwork* self, GIsiCommIsiRegStatusResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block19Data* _data19_;
	GIsiCommIsiRegStatusResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data19_->cb_target_destroy_notify == NULL) ? NULL : (_data19_->cb_target_destroy_notify (_data19_->cb_target), NULL);
	_data19_->cb = NULL;
	_data19_->cb_target = NULL;
	_data19_->cb_target_destroy_notify = NULL;
	_data19_->cb = _tmp0_;
	_data19_->cb_target = _tmp0__target;
	_data19_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = g_new0 (guchar, 1);
	_tmp1_[0] = (guchar) NET_REG_STATUS_GET_REQ;
	req = _tmp1_;
	req_length1 = 1;
	_req_size_ = req_length1;
	_tmp2_ = self->priv->ll;
	g_isi_client_send (_tmp2_, req, req_length1, ___lambda24__gisi_notify_func, block19_data_ref (_data19_), block19_data_unref);
	req = (g_free (req), NULL);
	block19_data_unref (_data19_);
	_data19_ = NULL;
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (Block20Data* _data20_) {
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data20_->self);
		(_data20_->cb_target_destroy_notify == NULL) ? NULL : (_data20_->cb_target_destroy_notify (_data20_->cb_target), NULL);
		_data20_->cb = NULL;
		_data20_->cb_target = NULL;
		_data20_->cb_target_destroy_notify = NULL;
		g_slice_free (Block20Data, _data20_);
	}
}


static void __lambda26_ (Block20Data* _data20_, GIsiMessage* msg) {
	GIsiCommNetwork * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = _data20_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommIntResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data20_->cb;
		_tmp2__target = _data20_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, -1, _tmp2__target);
		return;
	}
	{
		GIsiMessage* _tmp3_;
		GIsiSubBlockIter _tmp4_ = {0};
		GIsiSubBlockIter sbi;
		_tmp3_ = msg;
		g_isi_msg_subblock_iter_create (_tmp3_, (gsize) 2, &_tmp4_);
		sbi = _tmp4_;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gboolean _tmp7_ = FALSE;
				GIsiSubBlockIter _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				GIsiSubBlockIter _tmp13_;
				gsize _tmp14_;
				gsize _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				GIsiSubBlockIter _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					g_isi_sb_iter_next (&sbi);
				}
				_tmp5_ = FALSE;
				_tmp7_ = g_isi_sb_iter_is_valid (&sbi);
				if (!_tmp7_) {
					break;
				}
				_tmp8_ = sbi;
				_tmp9_ = g_isi_sb_iter_get_id (&_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strdup_printf ("%i", _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = sbi;
				_tmp14_ = g_isi_sb_iter_get_len (&_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strdup_printf ("%" G_GSIZE_FORMAT, _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat ("Have subblock with ID ", _tmp12_, ", length ", _tmp17_, NULL);
				_tmp19_ = _tmp18_;
				g_message ("gisicomm.vala:1121: %s", _tmp19_);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp17_);
				_g_free0 (_tmp12_);
				_tmp20_ = sbi;
				_tmp21_ = g_isi_sb_iter_get_id (&_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_ == ((gint) NET_RSSI_CURRENT)) {
					guchar _tmp23_ = '\0';
					guchar _tmp24_;
					GIsiCommIntResultFunc _tmp25_;
					void* _tmp25__target;
					_tmp23_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 2, &_inner_error_);
					_tmp24_ = _tmp23_;
					if (_inner_error_ != NULL) {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp25_ = _data20_->cb;
					_tmp25__target = _data20_->cb_target;
					_tmp25_ (GISI_COMM_ERROR_CODE_OK, (gint) _tmp24_, _tmp25__target);
					break;
				}
			}
		}
	}
}


static void ___lambda26__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda26_ (self, msg);
}


void gisi_comm_network_queryStrength (GIsiCommNetwork* self, GIsiCommIntResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block20Data* _data20_;
	GIsiCommIntResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data20_->cb_target_destroy_notify == NULL) ? NULL : (_data20_->cb_target_destroy_notify (_data20_->cb_target), NULL);
	_data20_->cb = NULL;
	_data20_->cb_target = NULL;
	_data20_->cb_target_destroy_notify = NULL;
	_data20_->cb = _tmp0_;
	_data20_->cb_target = _tmp0__target;
	_data20_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = g_new0 (guchar, 3);
	_tmp1_[0] = (guchar) NET_RSSI_GET_REQ;
	_tmp1_[1] = (guchar) NET_CS_GSM;
	_tmp1_[2] = (guchar) NET_CURRENT_CELL_RSSI;
	req = _tmp1_;
	req_length1 = 3;
	_req_size_ = req_length1;
	_tmp2_ = self->priv->ll;
	g_isi_client_send (_tmp2_, req, req_length1, ___lambda26__gisi_notify_func, block20_data_ref (_data20_), block20_data_unref);
	req = (g_free (req), NULL);
	block20_data_unref (_data20_);
	_data20_ = NULL;
}


static Block21Data* block21_data_ref (Block21Data* _data21_) {
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}


static void block21_data_unref (Block21Data* _data21_) {
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data21_->self);
		(_data21_->cb_target_destroy_notify == NULL) ? NULL : (_data21_->cb_target_destroy_notify (_data21_->cb_target), NULL);
		_data21_->cb = NULL;
		_data21_->cb_target = NULL;
		_data21_->cb_target_destroy_notify = NULL;
		g_slice_free (Block21Data, _data21_);
	}
}


static void _vala_GIsiCommNetworkISI_Provider_array_free (GIsiCommNetworkISI_Provider* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gisi_comm_network_isi_provider_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _vala_array_add1 (GIsiCommNetworkISI_Provider** array, int* length, int* size, const GIsiCommNetworkISI_Provider* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GIsiCommNetworkISI_Provider, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static const char* _NET_operator_status_to_string (guint8 value) {
	switch (value) {
		case NET_OPER_STATUS_UNKNOWN:
		return "NET_OPER_STATUS_UNKNOWN";
		case NET_OPER_STATUS_AVAILABLE:
		return "NET_OPER_STATUS_AVAILABLE";
		case NET_OPER_STATUS_CURRENT:
		return "NET_OPER_STATUS_CURRENT";
		case NET_OPER_STATUS_FORBIDDEN:
		return "NET_OPER_STATUS_FORBIDDEN";
	}
	return NULL;
}


static void __lambda27_ (Block21Data* _data21_, GIsiMessage* msg) {
	GIsiCommNetwork * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiCommNetworkISI_Provider* _tmp3_ = NULL;
	GIsiCommNetworkISI_Provider* providers;
	gint providers_length1;
	gint _providers_size_;
	guint index;
	GIsiCommNetworkISI_Provider* _tmp52_;
	gint _tmp52__length1;
	GIsiCommIsiProviderArrayResultFunc _tmp68_;
	void* _tmp68__target;
	GIsiCommNetworkISI_Provider* _tmp69_;
	gint _tmp69__length1;
	GError * _inner_error_ = NULL;
	self = _data21_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommIsiProviderArrayResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data21_->cb;
		_tmp2__target = _data21_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, NULL, 0, _tmp2__target);
		return;
	}
	_tmp3_ = g_new0 (GIsiCommNetworkISI_Provider, 0);
	providers = _tmp3_;
	providers_length1 = 0;
	_providers_size_ = providers_length1;
	index = (guint) 0;
	{
		GIsiMessage* _tmp4_;
		GIsiSubBlockIter _tmp5_ = {0};
		GIsiSubBlockIter sbi;
		_tmp4_ = msg;
		g_isi_msg_subblock_iter_create (_tmp4_, (gsize) 2, &_tmp5_);
		sbi = _tmp5_;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_;
				gboolean _tmp8_ = FALSE;
				GIsiSubBlockIter _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				GIsiSubBlockIter _tmp14_;
				gsize _tmp15_;
				gsize _tmp16_;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				GIsiSubBlockIter _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					g_isi_sb_iter_next (&sbi);
				}
				_tmp6_ = FALSE;
				_tmp8_ = g_isi_sb_iter_is_valid (&sbi);
				if (!_tmp8_) {
					break;
				}
				_tmp9_ = sbi;
				_tmp10_ = g_isi_sb_iter_get_id (&_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strdup_printf ("%i", _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = sbi;
				_tmp15_ = g_isi_sb_iter_get_len (&_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strdup_printf ("%" G_GSIZE_FORMAT, _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strconcat ("Have subblock with ID ", _tmp13_, ", length ", _tmp18_, NULL);
				_tmp20_ = _tmp19_;
				g_message ("gisicomm.vala:1156: %s", _tmp20_);
				_g_free0 (_tmp20_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp13_);
				_tmp21_ = sbi;
				_tmp22_ = g_isi_sb_iter_get_id (&_tmp21_);
				_tmp23_ = _tmp22_;
				switch (_tmp23_) {
					case NET_AVAIL_NETWORK_INFO_COMMON:
					{
						GIsiCommNetworkISI_Provider newp = {0};
						guchar _tmp24_ = '\0';
						guchar _tmp25_;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_;
						guchar _tmp28_ = '\0';
						guchar _tmp29_;
						GIsiCommNetworkISI_Provider* _tmp30_;
						gint _tmp30__length1;
						GIsiCommNetworkISI_Provider _tmp31_;
						GIsiCommNetworkISI_Provider _tmp32_ = {0};
						memset (&newp, 0, sizeof (GIsiCommNetworkISI_Provider));
						_tmp24_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 5, &_inner_error_);
						_tmp25_ = _tmp24_;
						if (_inner_error_ != NULL) {
							gisi_comm_network_isi_provider_destroy (&newp);
							providers = (_vala_GIsiCommNetworkISI_Provider_array_free (providers, providers_length1), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp26_ = g_isi_sub_block_iter_alpha_tag_at_position (&sbi, (gsize) (_tmp25_ * 2), (guint) 6, &_inner_error_);
						_tmp27_ = _tmp26_;
						if (_inner_error_ != NULL) {
							gisi_comm_network_isi_provider_destroy (&newp);
							providers = (_vala_GIsiCommNetworkISI_Provider_array_free (providers, providers_length1), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_g_free0 (newp.name);
						newp.name = _tmp27_;
						_tmp28_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 2, &_inner_error_);
						_tmp29_ = _tmp28_;
						if (_inner_error_ != NULL) {
							gisi_comm_network_isi_provider_destroy (&newp);
							providers = (_vala_GIsiCommNetworkISI_Provider_array_free (providers, providers_length1), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						newp.status = (guint8) _tmp29_;
						_tmp30_ = providers;
						_tmp30__length1 = providers_length1;
						_tmp31_ = newp;
						gisi_comm_network_isi_provider_copy (&_tmp31_, &_tmp32_);
						_vala_array_add1 (&providers, &providers_length1, &_providers_size_, &_tmp32_);
						gisi_comm_network_isi_provider_destroy (&newp);
						break;
					}
					case NET_DETAILED_NETWORK_INFO:
					{
						GIsiCommNetworkISI_Provider* _tmp33_;
						gint _tmp33__length1;
						guint _tmp34_;
						GIsiCommNetworkISI_Provider* p;
						GIsiCommNetworkISI_Provider* _tmp35_;
						GIsiCommNetworkISI_Provider* _tmp36_;
						gchar* _tmp37_ = NULL;
						gchar* _tmp38_ = NULL;
						gint _tmp39_ = 0;
						guchar _tmp40_ = '\0';
						guchar _tmp41_;
						GIsiCommNetworkISI_Provider* _tmp42_;
						gint _tmp43_;
						guint _tmp44_;
						_tmp33_ = providers;
						_tmp33__length1 = providers_length1;
						_tmp34_ = index;
						p = &_tmp33_[_tmp34_];
						_tmp35_ = p;
						_tmp36_ = p;
						g_isi_sub_block_iter_oper_code_at_position (&sbi, &_tmp37_, &_tmp38_, (guint) 2, &_inner_error_);
						_g_free0 ((*_tmp35_).mcc);
						(*_tmp35_).mcc = _tmp37_;
						_g_free0 ((*_tmp36_).mnc);
						(*_tmp36_).mnc = _tmp38_;
						if (_inner_error_ != NULL) {
							providers = (_vala_GIsiCommNetworkISI_Provider_array_free (providers, providers_length1), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp40_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 7, &_inner_error_);
						_tmp41_ = _tmp40_;
						if (_inner_error_ != NULL) {
							providers = (_vala_GIsiCommNetworkISI_Provider_array_free (providers, providers_length1), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						if (((gint) _tmp41_) != 0) {
							_tmp39_ = 2;
						} else {
							_tmp39_ = 3;
						}
						_tmp42_ = p;
						_tmp43_ = _tmp39_;
						(*_tmp42_).technology = _tmp43_;
						_tmp44_ = index;
						index = _tmp44_ + 1;
						break;
					}
					default:
					{
						GIsiSubBlockIter _tmp45_;
						gint _tmp46_;
						gint _tmp47_;
						gchar* _tmp48_ = NULL;
						gchar* _tmp49_;
						gchar* _tmp50_ = NULL;
						gchar* _tmp51_;
						_tmp45_ = sbi;
						_tmp46_ = g_isi_sb_iter_get_id (&_tmp45_);
						_tmp47_ = _tmp46_;
						_tmp48_ = g_strdup_printf ("%i", _tmp47_);
						_tmp49_ = _tmp48_;
						_tmp50_ = g_strconcat ("FIXME: handle unknown subblock with ID ", _tmp49_, NULL);
						_tmp51_ = _tmp50_;
						g_message ("gisicomm.vala:1178: %s", _tmp51_);
						_g_free0 (_tmp51_);
						_g_free0 (_tmp49_);
						break;
					}
				}
			}
		}
	}
	_tmp52_ = providers;
	_tmp52__length1 = providers_length1;
	{
		GIsiCommNetworkISI_Provider* prov_collection = NULL;
		gint prov_collection_length1 = 0;
		gint _prov_collection_size_ = 0;
		gint prov_it = 0;
		prov_collection = _tmp52_;
		prov_collection_length1 = _tmp52__length1;
		for (prov_it = 0; prov_it < _tmp52__length1; prov_it = prov_it + 1) {
			GIsiCommNetworkISI_Provider _tmp53_ = {0};
			GIsiCommNetworkISI_Provider prov = {0};
			gisi_comm_network_isi_provider_copy (&prov_collection[prov_it], &_tmp53_);
			prov = _tmp53_;
			{
				GIsiCommNetworkISI_Provider _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_ = NULL;
				GIsiCommNetworkISI_Provider _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_ = NULL;
				GIsiCommNetworkISI_Provider _tmp60_;
				const gchar* _tmp61_;
				const gchar* _tmp62_ = NULL;
				GIsiCommNetworkISI_Provider _tmp63_;
				guint8 _tmp64_;
				const gchar* _tmp65_ = NULL;
				gchar* _tmp66_ = NULL;
				gchar* _tmp67_;
				_tmp54_ = prov;
				_tmp55_ = _tmp54_.name;
				_tmp56_ = string_to_string (_tmp55_);
				_tmp57_ = prov;
				_tmp58_ = _tmp57_.mcc;
				_tmp59_ = string_to_string (_tmp58_);
				_tmp60_ = prov;
				_tmp61_ = _tmp60_.mnc;
				_tmp62_ = string_to_string (_tmp61_);
				_tmp63_ = prov;
				_tmp64_ = _tmp63_.status;
				_tmp65_ = _NET_operator_status_to_string (_tmp64_);
				_tmp66_ = g_strconcat ("found provider ", _tmp56_, " [", _tmp59_, _tmp62_, "] with status ", _tmp65_, NULL);
				_tmp67_ = _tmp66_;
				g_debug ("gisicomm.vala:1185: %s", _tmp67_);
				_g_free0 (_tmp67_);
				gisi_comm_network_isi_provider_destroy (&prov);
			}
		}
	}
	_tmp68_ = _data21_->cb;
	_tmp68__target = _data21_->cb_target;
	_tmp69_ = providers;
	_tmp69__length1 = providers_length1;
	_tmp68_ (GISI_COMM_ERROR_CODE_OK, _tmp69_, _tmp69__length1, _tmp68__target);
	providers = (_vala_GIsiCommNetworkISI_Provider_array_free (providers, providers_length1), NULL);
}


static void ___lambda27__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda27_ (self, msg);
}


void gisi_comm_network_listProviders (GIsiCommNetwork* self, GIsiCommIsiProviderArrayResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block21Data* _data21_;
	GIsiCommIsiProviderArrayResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data21_->cb_target_destroy_notify == NULL) ? NULL : (_data21_->cb_target_destroy_notify (_data21_->cb_target), NULL);
	_data21_->cb = NULL;
	_data21_->cb_target = NULL;
	_data21_->cb_target_destroy_notify = NULL;
	_data21_->cb = _tmp0_;
	_data21_->cb_target = _tmp0__target;
	_data21_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = g_new0 (guchar, 7);
	_tmp1_[0] = (guchar) NET_AVAILABLE_GET_REQ;
	_tmp1_[1] = (guchar) NET_MANUAL_SEARCH;
	_tmp1_[2] = (guchar) 0x01;
	_tmp1_[3] = (guchar) NET_GSM_BAND_INFO;
	_tmp1_[4] = (guchar) 0x04;
	_tmp1_[5] = (guchar) NET_GSM_BAND_ALL_SUPPORTED_BANDS;
	_tmp1_[6] = (guchar) 0x00;
	req = _tmp1_;
	req_length1 = 7;
	_req_size_ = req_length1;
	_tmp2_ = self->priv->ll;
	g_isi_client_send_with_timeout (_tmp2_, req, req_length1, NETWORK_SCAN_TIMEOUT, ___lambda27__gisi_notify_func, block21_data_ref (_data21_), block21_data_unref);
	req = (g_free (req), NULL);
	block21_data_unref (_data21_);
	_data21_ = NULL;
}


static Block22Data* block22_data_ref (Block22Data* _data22_) {
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}


static void block22_data_unref (Block22Data* _data22_) {
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data22_->self);
		(_data22_->cb_target_destroy_notify == NULL) ? NULL : (_data22_->cb_target_destroy_notify (_data22_->cb_target), NULL);
		_data22_->cb = NULL;
		_data22_->cb_target = NULL;
		_data22_->cb_target_destroy_notify = NULL;
		g_slice_free (Block22Data, _data22_);
	}
}


static void __lambda28_ (Block22Data* _data22_, GIsiMessage* msg) {
	GIsiCommNetwork * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiCommVoidResultFunc _tmp3_;
	void* _tmp3__target;
	self = _data22_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommVoidResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data22_->cb;
		_tmp2__target = _data22_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _tmp2__target);
		return;
	}
	_tmp3_ = _data22_->cb;
	_tmp3__target = _data22_->cb_target;
	_tmp3_ (GISI_COMM_ERROR_CODE_OK, _tmp3__target);
}


static void ___lambda28__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda28_ (self, msg);
}


void gisi_comm_network_registerAutomatic (GIsiCommNetwork* self, gboolean force, GIsiCommVoidResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block22Data* _data22_;
	GIsiCommVoidResultFunc _tmp0_;
	void* _tmp0__target;
	guint8 _tmp1_ = 0;
	gboolean _tmp2_;
	guint8 _tmp3_;
	guchar* _tmp4_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp5_;
	g_return_if_fail (self != NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data22_->cb_target_destroy_notify == NULL) ? NULL : (_data22_->cb_target_destroy_notify (_data22_->cb_target), NULL);
	_data22_->cb = NULL;
	_data22_->cb_target = NULL;
	_data22_->cb_target_destroy_notify = NULL;
	_data22_->cb = _tmp0_;
	_data22_->cb_target = _tmp0__target;
	_data22_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp2_ = force;
	if (_tmp2_) {
		_tmp1_ = NET_SELECT_MODE_USER_RESELECTION;
	} else {
		_tmp1_ = NET_SELECT_MODE_AUTOMATIC;
	}
	_tmp3_ = _tmp1_;
	_tmp4_ = g_new0 (guchar, 7);
	_tmp4_[0] = (guchar) NET_SET_REQ;
	_tmp4_[1] = (guchar) 0x00;
	_tmp4_[2] = (guchar) 0x01;
	_tmp4_[3] = (guchar) NET_OPERATOR_INFO_COMMON;
	_tmp4_[4] = (guchar) 0x04;
	_tmp4_[5] = (guchar) _tmp3_;
	_tmp4_[6] = (guchar) 0x00;
	req = _tmp4_;
	req_length1 = 7;
	_req_size_ = req_length1;
	_tmp5_ = self->priv->ll;
	g_isi_client_send_with_timeout (_tmp5_, req, req_length1, NETWORK_SET_TIMEOUT, ___lambda28__gisi_notify_func, block22_data_ref (_data22_), block22_data_unref);
	req = (g_free (req), NULL);
	block22_data_unref (_data22_);
	_data22_ = NULL;
}


static Block23Data* block23_data_ref (Block23Data* _data23_) {
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}


static void block23_data_unref (Block23Data* _data23_) {
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data23_->self);
		(_data23_->cb_target_destroy_notify == NULL) ? NULL : (_data23_->cb_target_destroy_notify (_data23_->cb_target), NULL);
		_data23_->cb = NULL;
		_data23_->cb_target = NULL;
		_data23_->cb_target_destroy_notify = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void __lambda29_ (Block23Data* _data23_, GIsiMessage* msg) {
	GIsiCommNetwork * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiCommVoidResultFunc _tmp3_;
	void* _tmp3__target;
	self = _data23_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommVoidResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data23_->cb;
		_tmp2__target = _data23_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _tmp2__target);
		return;
	}
	_tmp3_ = _data23_->cb;
	_tmp3__target = _data23_->cb_target;
	_tmp3_ (GISI_COMM_ERROR_CODE_OK, _tmp3__target);
}


static void ___lambda29__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda29_ (self, msg);
}


void gisi_comm_network_registerManual (GIsiCommNetwork* self, const gchar* mcc, const gchar* mnc, GIsiCommVoidResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block23Data* _data23_;
	GIsiCommVoidResultFunc _tmp0_;
	void* _tmp0__target;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	guint8 _tmp7_[3] = {0};
	guint8 bcd[3];
	const gchar* _tmp8_;
	gchar _tmp9_ = '\0';
	const gchar* _tmp10_;
	gchar _tmp11_ = '\0';
	guint8 _tmp12_;
	const gchar* _tmp13_;
	gchar _tmp14_ = '\0';
	guint8 _tmp15_;
	gint _tmp16_ = 0;
	const gchar* _tmp17_;
	gchar _tmp18_ = '\0';
	gint _tmp21_;
	guint8 _tmp22_;
	const gchar* _tmp23_;
	gchar _tmp24_ = '\0';
	const gchar* _tmp25_;
	gchar _tmp26_ = '\0';
	guint8 _tmp27_;
	guint8 _tmp28_;
	guint8 _tmp29_;
	guint8 _tmp30_;
	guchar* _tmp31_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mcc != NULL);
	g_return_if_fail (mnc != NULL);
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_data23_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data23_->cb_target_destroy_notify == NULL) ? NULL : (_data23_->cb_target_destroy_notify (_data23_->cb_target), NULL);
	_data23_->cb = NULL;
	_data23_->cb_target = NULL;
	_data23_->cb_target_destroy_notify = NULL;
	_data23_->cb = _tmp0_;
	_data23_->cb_target = _tmp0__target;
	_data23_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = mcc;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = mnc;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_strconcat ("mcc = ", _tmp2_, ", mnc = ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	g_debug ("gisicomm.vala:1216: %s", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_[0] = (guint8) 0;
	_tmp7_[1] = (guint8) 0;
	_tmp7_[2] = (guint8) 0;
	memcpy (bcd, _tmp7_, 3 * sizeof (guint8));
	_tmp8_ = mcc;
	_tmp9_ = string_get (_tmp8_, (glong) 0);
	_tmp10_ = mcc;
	_tmp11_ = string_get (_tmp10_, (glong) 1);
	bcd[0] = (guint8) ((_tmp9_ - '0') | ((_tmp11_ - '0') << 4));
	_tmp12_ = bcd[0];
	_tmp13_ = mcc;
	_tmp14_ = string_get (_tmp13_, (glong) 2);
	bcd[1] = (guint8) (_tmp14_ - '0');
	_tmp15_ = bcd[1];
	_tmp17_ = mnc;
	_tmp18_ = string_get (_tmp17_, (glong) 2);
	if (_tmp18_ == '\0') {
		_tmp16_ = 0x0f;
	} else {
		const gchar* _tmp19_;
		gchar _tmp20_ = '\0';
		_tmp19_ = mnc;
		_tmp20_ = string_get (_tmp19_, (glong) 2);
		_tmp16_ = (gint) (_tmp20_ - '0');
	}
	_tmp21_ = _tmp16_;
	bcd[1] |= (guint8) (_tmp21_ << 4);
	_tmp22_ = bcd[1];
	_tmp23_ = mnc;
	_tmp24_ = string_get (_tmp23_, (glong) 0);
	_tmp25_ = mnc;
	_tmp26_ = string_get (_tmp25_, (glong) 1);
	bcd[2] = (guint8) ((_tmp24_ - '0') | ((_tmp26_ - '0') << 4));
	_tmp27_ = bcd[2];
	_tmp28_ = bcd[0];
	_tmp29_ = bcd[1];
	_tmp30_ = bcd[2];
	_tmp31_ = g_new0 (guchar, 15);
	_tmp31_[0] = (guchar) NET_SET_REQ;
	_tmp31_[1] = (guchar) 0x00;
	_tmp31_[2] = (guchar) 0x02;
	_tmp31_[3] = (guchar) NET_OPERATOR_INFO_COMMON;
	_tmp31_[4] = (guchar) 0x04;
	_tmp31_[5] = (guchar) NET_SELECT_MODE_MANUAL;
	_tmp31_[6] = (guchar) 0x00;
	_tmp31_[7] = (guchar) NET_GSM_OPERATOR_INFO;
	_tmp31_[8] = (guchar) 0x08;
	_tmp31_[9] = (guchar) _tmp28_;
	_tmp31_[10] = (guchar) _tmp29_;
	_tmp31_[11] = (guchar) _tmp30_;
	_tmp31_[12] = (guchar) NET_GSM_BAND_INFO_NOT_AVAIL;
	_tmp31_[13] = (guchar) 0x00;
	_tmp31_[14] = (guchar) 0x00;
	req = _tmp31_;
	req_length1 = 15;
	_req_size_ = req_length1;
	_tmp32_ = self->priv->ll;
	g_isi_client_send_with_timeout (_tmp32_, req, req_length1, NETWORK_SET_TIMEOUT, ___lambda29__gisi_notify_func, block23_data_ref (_data23_), block23_data_unref);
	req = (g_free (req), NULL);
	block23_data_unref (_data23_);
	_data23_ = NULL;
}


static Block24Data* block24_data_ref (Block24Data* _data24_) {
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}


static void block24_data_unref (Block24Data* _data24_) {
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data24_->self);
		(_data24_->cb_target_destroy_notify == NULL) ? NULL : (_data24_->cb_target_destroy_notify (_data24_->cb_target), NULL);
		_data24_->cb = NULL;
		_data24_->cb_target = NULL;
		_data24_->cb_target_destroy_notify = NULL;
		g_slice_free (Block24Data, _data24_);
	}
}


static void __lambda22_ (Block24Data* _data24_, GIsiMessage* msg) {
	GIsiCommNetwork * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiCommIntResultFunc _tmp30_;
	void* _tmp30__target;
	self = _data24_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommIntResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data24_->cb;
		_tmp2__target = _data24_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, -1, _tmp2__target);
		return;
	}
	{
		GIsiMessage* _tmp3_;
		GIsiSubBlockIter _tmp4_ = {0};
		GIsiSubBlockIter sbi;
		_tmp3_ = msg;
		g_isi_msg_subblock_iter_create (_tmp3_, (gsize) 2, &_tmp4_);
		sbi = _tmp4_;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gboolean _tmp7_ = FALSE;
				GIsiSubBlockIter _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				GIsiSubBlockIter _tmp13_;
				gsize _tmp14_;
				gsize _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				GIsiSubBlockIter _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					g_isi_sb_iter_next (&sbi);
				}
				_tmp5_ = FALSE;
				_tmp7_ = g_isi_sb_iter_is_valid (&sbi);
				if (!_tmp7_) {
					break;
				}
				_tmp8_ = sbi;
				_tmp9_ = g_isi_sb_iter_get_id (&_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strdup_printf ("%i", _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = sbi;
				_tmp14_ = g_isi_sb_iter_get_len (&_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strdup_printf ("%" G_GSIZE_FORMAT, _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat ("Have subblock with ID ", _tmp12_, ", length ", _tmp17_, NULL);
				_tmp19_ = _tmp18_;
				g_message ("gisicomm.vala:1261: %s", _tmp19_);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp17_);
				_g_free0 (_tmp12_);
				_tmp20_ = sbi;
				_tmp21_ = g_isi_sb_iter_get_id (&_tmp20_);
				_tmp22_ = _tmp21_;
				switch (_tmp22_) {
					default:
					{
						GIsiSubBlockIter _tmp23_;
						gint _tmp24_;
						gint _tmp25_;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_;
						_tmp23_ = sbi;
						_tmp24_ = g_isi_sb_iter_get_id (&_tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = g_strdup_printf ("%i", _tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = g_strconcat ("FIXME: handle unknown subblock with ID ", _tmp27_, NULL);
						_tmp29_ = _tmp28_;
						g_message ("gisicomm.vala:1266: %s", _tmp29_);
						_g_free0 (_tmp29_);
						_g_free0 (_tmp27_);
						break;
					}
				}
			}
		}
	}
	_tmp30_ = _data24_->cb;
	_tmp30__target = _data24_->cb_target;
	_tmp30_ (GISI_COMM_ERROR_CODE_OK, 0, _tmp30__target);
}


static void ___lambda22__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda22_ (self, msg);
}


void gisi_comm_network_queryRat (GIsiCommNetwork* self, GIsiCommIntResultFunc cb, void* cb_target, GDestroyNotify cb_target_destroy_notify) {
	Block24Data* _data24_;
	GIsiCommIntResultFunc _tmp0_;
	void* _tmp0__target;
	guchar* _tmp1_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp2_;
	g_return_if_fail (self != NULL);
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	(_data24_->cb_target_destroy_notify == NULL) ? NULL : (_data24_->cb_target_destroy_notify (_data24_->cb_target), NULL);
	_data24_->cb = NULL;
	_data24_->cb_target = NULL;
	_data24_->cb_target_destroy_notify = NULL;
	_data24_->cb = _tmp0_;
	_data24_->cb_target = _tmp0__target;
	_data24_->cb_target_destroy_notify = cb_target_destroy_notify;
	_tmp1_ = g_new0 (guchar, 2);
	_tmp1_[0] = (guchar) NET_RAT_REQ;
	_tmp1_[1] = (guchar) NET_CURRENT_RAT;
	req = _tmp1_;
	req_length1 = 2;
	_req_size_ = req_length1;
	_tmp2_ = self->priv->ll;
	g_isi_client_send (_tmp2_, req, req_length1, ___lambda22__gisi_notify_func, block24_data_ref (_data24_), block24_data_unref);
	req = (g_free (req), NULL);
	block24_data_unref (_data24_);
	_data24_ = NULL;
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


void gisi_comm_network_isi_provider_copy (const GIsiCommNetworkISI_Provider* self, GIsiCommNetworkISI_Provider* dest) {
	guint8 _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gint _tmp7_;
	_tmp0_ = (*self).status;
	(*dest).status = _tmp0_;
	_tmp1_ = (*self).name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp2_;
	_tmp3_ = (*self).mcc;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).mcc);
	(*dest).mcc = _tmp4_;
	_tmp5_ = (*self).mnc;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 ((*dest).mnc);
	(*dest).mnc = _tmp6_;
	_tmp7_ = (*self).technology;
	(*dest).technology = _tmp7_;
}


void gisi_comm_network_isi_provider_destroy (GIsiCommNetworkISI_Provider* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).mcc);
	_g_free0 ((*self).mnc);
}


GIsiCommNetworkISI_Provider* gisi_comm_network_isi_provider_dup (const GIsiCommNetworkISI_Provider* self) {
	GIsiCommNetworkISI_Provider* dup;
	dup = g_new0 (GIsiCommNetworkISI_Provider, 1);
	gisi_comm_network_isi_provider_copy (self, dup);
	return dup;
}


void gisi_comm_network_isi_provider_free (GIsiCommNetworkISI_Provider* self) {
	gisi_comm_network_isi_provider_destroy (self);
	g_free (self);
}


GType gisi_comm_network_isi_provider_get_type (void) {
	static volatile gsize gisi_comm_network_isi_provider_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_network_isi_provider_type_id__volatile)) {
		GType gisi_comm_network_isi_provider_type_id;
		gisi_comm_network_isi_provider_type_id = g_boxed_type_register_static ("GIsiCommNetworkISI_Provider", (GBoxedCopyFunc) gisi_comm_network_isi_provider_dup, (GBoxedFreeFunc) gisi_comm_network_isi_provider_free);
		g_once_init_leave (&gisi_comm_network_isi_provider_type_id__volatile, gisi_comm_network_isi_provider_type_id);
	}
	return gisi_comm_network_isi_provider_type_id__volatile;
}


void gisi_comm_network_isi_regstatus_copy (const GIsiCommNetworkISI_RegStatus* self, GIsiCommNetworkISI_RegStatus* dest) {
	guint8 _tmp0_;
	guint8 _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	guint _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	_tmp0_ = (*self).status;
	(*dest).status = _tmp0_;
	_tmp1_ = (*self).mode;
	(*dest).mode = _tmp1_;
	_tmp2_ = (*self).network;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).network);
	(*dest).network = _tmp3_;
	_tmp4_ = (*self).name;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp5_;
	_tmp6_ = (*self).lac;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).lac);
	(*dest).lac = _tmp7_;
	_tmp8_ = (*self).cid;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 ((*dest).cid);
	(*dest).cid = _tmp9_;
	_tmp10_ = (*self).mcc;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 ((*dest).mcc);
	(*dest).mcc = _tmp11_;
	_tmp12_ = (*self).mnc;
	_tmp13_ = g_strdup (_tmp12_);
	_g_free0 ((*dest).mnc);
	(*dest).mnc = _tmp13_;
	_tmp14_ = (*self).band;
	(*dest).band = _tmp14_;
	_tmp15_ = (*self).egprs;
	(*dest).egprs = _tmp15_;
	_tmp16_ = (*self).hsdpa;
	(*dest).hsdpa = _tmp16_;
	_tmp17_ = (*self).hsupa;
	(*dest).hsupa = _tmp17_;
}


void gisi_comm_network_isi_regstatus_destroy (GIsiCommNetworkISI_RegStatus* self) {
	_g_free0 ((*self).network);
	_g_free0 ((*self).name);
	_g_free0 ((*self).lac);
	_g_free0 ((*self).cid);
	_g_free0 ((*self).mcc);
	_g_free0 ((*self).mnc);
}


GIsiCommNetworkISI_RegStatus* gisi_comm_network_isi_regstatus_dup (const GIsiCommNetworkISI_RegStatus* self) {
	GIsiCommNetworkISI_RegStatus* dup;
	dup = g_new0 (GIsiCommNetworkISI_RegStatus, 1);
	gisi_comm_network_isi_regstatus_copy (self, dup);
	return dup;
}


void gisi_comm_network_isi_regstatus_free (GIsiCommNetworkISI_RegStatus* self) {
	gisi_comm_network_isi_regstatus_destroy (self);
	g_free (self);
}


GType gisi_comm_network_isi_regstatus_get_type (void) {
	static volatile gsize gisi_comm_network_isi_regstatus_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_network_isi_regstatus_type_id__volatile)) {
		GType gisi_comm_network_isi_regstatus_type_id;
		gisi_comm_network_isi_regstatus_type_id = g_boxed_type_register_static ("GIsiCommNetworkISI_RegStatus", (GBoxedCopyFunc) gisi_comm_network_isi_regstatus_dup, (GBoxedFreeFunc) gisi_comm_network_isi_regstatus_free);
		g_once_init_leave (&gisi_comm_network_isi_regstatus_type_id__volatile, gisi_comm_network_isi_regstatus_type_id);
	}
	return gisi_comm_network_isi_regstatus_type_id__volatile;
}


GIsiCommNetworkISI_Time* gisi_comm_network_isi_time_dup (const GIsiCommNetworkISI_Time* self) {
	GIsiCommNetworkISI_Time* dup;
	dup = g_new0 (GIsiCommNetworkISI_Time, 1);
	memcpy (dup, self, sizeof (GIsiCommNetworkISI_Time));
	return dup;
}


void gisi_comm_network_isi_time_free (GIsiCommNetworkISI_Time* self) {
	g_free (self);
}


GType gisi_comm_network_isi_time_get_type (void) {
	static volatile gsize gisi_comm_network_isi_time_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_network_isi_time_type_id__volatile)) {
		GType gisi_comm_network_isi_time_type_id;
		gisi_comm_network_isi_time_type_id = g_boxed_type_register_static ("GIsiCommNetworkISI_Time", (GBoxedCopyFunc) gisi_comm_network_isi_time_dup, (GBoxedFreeFunc) gisi_comm_network_isi_time_free);
		g_once_init_leave (&gisi_comm_network_isi_time_type_id__volatile, gisi_comm_network_isi_time_type_id);
	}
	return gisi_comm_network_isi_time_type_id__volatile;
}


static void gisi_comm_network_class_init (GIsiCommNetworkClass * klass) {
	gisi_comm_network_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->finalize = gisi_comm_network_finalize;
	g_type_class_add_private (klass, sizeof (GIsiCommNetworkPrivate));
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->onSubsystemIsReachable = gisi_comm_network_real_onSubsystemIsReachable;
	g_signal_new ("signal_strength", GISI_COMM_TYPE_NETWORK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UCHAR, G_TYPE_NONE, 1, G_TYPE_UCHAR);
	g_signal_new ("registration_status", GISI_COMM_TYPE_NETWORK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, GISI_COMM_NETWORK_TYPE_ISI_REGSTATUS);
	g_signal_new ("time_info", GISI_COMM_TYPE_NETWORK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
}


static void gisi_comm_network_instance_init (GIsiCommNetwork * self) {
	self->priv = GISI_COMM_NETWORK_GET_PRIVATE (self);
}


static void gisi_comm_network_finalize (GIsiCommAbstractBaseClient* obj) {
	GIsiCommNetwork * self;
	self = GISI_COMM_NETWORK (obj);
	_g_isi_client_destroy0 (self->priv->ll);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (gisi_comm_network_parent_class)->finalize (obj);
}


/**
     * @class Network
     *
     * Network Registration and Status Interface
     **/
GType gisi_comm_network_get_type (void) {
	static volatile gsize gisi_comm_network_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_network_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommNetworkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_network_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommNetwork), 0, (GInstanceInitFunc) gisi_comm_network_instance_init, NULL };
		GType gisi_comm_network_type_id;
		gisi_comm_network_type_id = g_type_register_static (GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT, "GIsiCommNetwork", &g_define_type_info, 0);
		g_once_init_leave (&gisi_comm_network_type_id__volatile, gisi_comm_network_type_id);
	}
	return gisi_comm_network_type_id__volatile;
}


static GIsiClient* g_isi_modem_call_client_create (GIsiModem* self) {
	GIsiClient* result = NULL;
	GIsiClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_isi_client_create (self, PN_CALL);
	result = (GIsiClient*) _tmp0_;
	return result;
}


GIsiCommCall* gisi_comm_call_construct (GType object_type, GIsiModem* modem) {
	GIsiCommCall* self = NULL;
	GIsiModem* _tmp0_;
	GIsiClient* _tmp1_ = NULL;
	GIsiClient* _tmp2_;
	g_return_val_if_fail (modem != NULL, NULL);
	self = (GIsiCommCall*) gisi_comm_abstract_base_client_construct (object_type);
	_tmp0_ = modem;
	_tmp1_ = g_isi_modem_call_client_create (_tmp0_);
	_g_isi_client_destroy0 (self->priv->ll);
	self->priv->ll = _tmp1_;
	_tmp2_ = self->priv->ll;
	((GIsiCommAbstractBaseClient*) self)->client = _tmp2_;
	return self;
}


GIsiCommCall* gisi_comm_call_new (GIsiModem* modem) {
	return gisi_comm_call_construct (GISI_COMM_TYPE_CALL, modem);
}


static void _gisi_comm_call_onStatusIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_call_onStatusIndicationReceived (self, msg);
}


static void gisi_comm_call_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base) {
	GIsiCommCall * self;
	GIsiClient* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean ok;
	gboolean _tmp2_;
	self = (GIsiCommCall*) base;
	_tmp0_ = self->priv->ll;
	_tmp1_ = g_isi_client_ind_subscribe (_tmp0_, (guchar) CALL_STATUS_IND, _gisi_comm_call_onStatusIndicationReceived_gisi_notify_func, self);
	ok = _tmp1_;
	_tmp2_ = ok;
	if (!_tmp2_) {
		g_warning ("gisicomm.vala:1339: Could not subscribe to CALL_STATUS_IND");
	}
}


static const char* _CALL_mode_to_string (guint8 value) {
	switch (value) {
		case CALL_MODE_EMERGENCY:
		return "CALL_MODE_EMERGENCY";
		case CALL_MODE_SPEECH:
		return "CALL_MODE_SPEECH";
		case CALL_GSM_MODE_ALS_LINE_1:
		return "CALL_GSM_MODE_ALS_LINE_1";
		case CALL_GSM_MODE_ALS_LINE_2:
		return "CALL_GSM_MODE_ALS_LINE_2";
	}
	return NULL;
}


static const char* _CALL_mode_info_to_string (guint8 value) {
	switch (value) {
		case CALL_MODE_INFO_NONE:
		return "CALL_MODE_INFO_NONE";
		case CALL_MODE_ORIGINATOR:
		return "CALL_MODE_ORIGINATOR";
	}
	return NULL;
}


static const char* _CALL_status_to_string (guint8 value) {
	switch (value) {
		case CALL_STATUS_IDLE:
		return "CALL_STATUS_IDLE";
		case CALL_STATUS_CREATE:
		return "CALL_STATUS_CREATE";
		case CALL_STATUS_COMING:
		return "CALL_STATUS_COMING";
		case CALL_STATUS_PROCEEDING:
		return "CALL_STATUS_PROCEEDING";
		case CALL_STATUS_MO_ALERTING:
		return "CALL_STATUS_MO_ALERTING";
		case CALL_STATUS_MT_ALERTING:
		return "CALL_STATUS_MT_ALERTING";
		case CALL_STATUS_WAITING:
		return "CALL_STATUS_WAITING";
		case CALL_STATUS_ANSWERED:
		return "CALL_STATUS_ANSWERED";
		case CALL_STATUS_ACTIVE:
		return "CALL_STATUS_ACTIVE";
		case CALL_STATUS_MO_RELEASE:
		return "CALL_STATUS_MO_RELEASE";
		case CALL_STATUS_MT_RELEASE:
		return "CALL_STATUS_MT_RELEASE";
		case CALL_STATUS_HOLD_INITIATED:
		return "CALL_STATUS_HOLD_INITIATED";
		case CALL_STATUS_HOLD:
		return "CALL_STATUS_HOLD";
		case CALL_STATUS_RETRIEVE_INITIATED:
		return "CALL_STATUS_RETRIEVE_INITIATED";
		case CALL_STATUS_RECONNECT_PENDING:
		return "CALL_STATUS_RECONNECT_PENDING";
		case CALL_STATUS_TERMINATED:
		return "CALL_STATUS_TERMINATED";
		case CALL_STATUS_SWAP_INITIATED:
		return "CALL_STATUS_SWAP_INITIATED";
	}
	return NULL;
}


static void gisi_comm_call_parseCallStatus (GIsiCommCall* self, GIsiMessage* msg, GIsiCommCallISI_CallStatus* result) {
	GIsiCommCallISI_CallStatus status = {0};
	GIsiMessage* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8 _tmp3_;
	GIsiMessage* _tmp4_;
	guchar _tmp5_;
	guchar _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	GIsiCommCallISI_CallStatus _tmp9_;
	guint8 _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	memset (&status, 0, sizeof (GIsiCommCallISI_CallStatus));
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_get_data (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp3_ = _tmp2_[0];
	status.id = _tmp3_ & 0x07;
	_tmp4_ = msg;
	_tmp5_ = g_isi_msg_id (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%hhu", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = status;
	_tmp10_ = _tmp9_.id;
	_tmp11_ = g_strdup_printf ("%hhu", _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp8_, " for call with id ", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	g_debug ("gisicomm.vala:1366: %s", _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp8_);
	{
		GIsiMessage* _tmp15_;
		GIsiSubBlockIter _tmp16_ = {0};
		GIsiSubBlockIter sbi;
		_tmp15_ = msg;
		g_isi_msg_subblock_iter_create (_tmp15_, (gsize) 2, &_tmp16_);
		sbi = _tmp16_;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gboolean _tmp19_ = FALSE;
				GIsiSubBlockIter _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				GIsiSubBlockIter _tmp25_;
				gsize _tmp26_;
				gsize _tmp27_;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_;
				gchar* _tmp30_ = NULL;
				gchar* _tmp31_;
				GIsiSubBlockIter _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					g_isi_sb_iter_next (&sbi);
				}
				_tmp17_ = FALSE;
				_tmp19_ = g_isi_sb_iter_is_valid (&sbi);
				if (!_tmp19_) {
					break;
				}
				_tmp20_ = sbi;
				_tmp21_ = g_isi_sb_iter_get_id (&_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strdup_printf ("%i", _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = sbi;
				_tmp26_ = g_isi_sb_iter_get_len (&_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strdup_printf ("%" G_GSIZE_FORMAT, _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strconcat ("Have subblock with ID ", _tmp24_, ", length ", _tmp29_, NULL);
				_tmp31_ = _tmp30_;
				g_message ("gisicomm.vala:1370: %s", _tmp31_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp24_);
				_tmp32_ = sbi;
				_tmp33_ = g_isi_sb_iter_get_id (&_tmp32_);
				_tmp34_ = _tmp33_;
				switch (_tmp34_) {
					case CALL_MODE:
					{
						guchar _tmp35_ = '\0';
						guchar _tmp36_;
						guint8 m;
						guchar _tmp37_ = '\0';
						guchar _tmp38_;
						guint8 mi;
						guint8 _tmp39_;
						const gchar* _tmp40_ = NULL;
						gchar* _tmp41_ = NULL;
						gchar* _tmp42_;
						guint8 _tmp43_;
						guint8 _tmp44_;
						const gchar* _tmp45_ = NULL;
						gchar* _tmp46_ = NULL;
						gchar* _tmp47_;
						guint8 _tmp48_;
						_tmp35_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 2, &_inner_error_);
						_tmp36_ = _tmp35_;
						if (_inner_error_ != NULL) {
							gisi_comm_call_isi_callstatus_destroy (&status);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						m = (guint8) _tmp36_;
						_tmp37_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 3, &_inner_error_);
						_tmp38_ = _tmp37_;
						if (_inner_error_ != NULL) {
							gisi_comm_call_isi_callstatus_destroy (&status);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						mi = (guint8) _tmp38_;
						_tmp39_ = m;
						_tmp40_ = _CALL_mode_to_string (_tmp39_);
						_tmp41_ = g_strconcat ("call mode is ", _tmp40_, " (0x%0X)", NULL);
						_tmp42_ = _tmp41_;
						_tmp43_ = m;
						g_debug (_tmp42_, _tmp43_);
						_g_free0 (_tmp42_);
						_tmp44_ = mi;
						_tmp45_ = _CALL_mode_info_to_string (_tmp44_);
						_tmp46_ = g_strconcat ("call mode_info is ", _tmp45_, " (0x%0X)", NULL);
						_tmp47_ = _tmp46_;
						_tmp48_ = mi;
						g_debug (_tmp47_, _tmp48_);
						_g_free0 (_tmp47_);
						break;
					}
					case CALL_STATUS:
					{
						guchar _tmp49_ = '\0';
						guchar _tmp50_;
						guchar _tmp51_ = '\0';
						guchar _tmp52_;
						GIsiCommCallISI_CallStatus _tmp53_;
						guint8 _tmp54_;
						const gchar* _tmp55_ = NULL;
						gchar* _tmp56_ = NULL;
						gchar* _tmp57_;
						_tmp49_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 2, &_inner_error_);
						_tmp50_ = _tmp49_;
						if (_inner_error_ != NULL) {
							gisi_comm_call_isi_callstatus_destroy (&status);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						status.status = (guint8) _tmp50_;
						_tmp51_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 2, &_inner_error_);
						_tmp52_ = _tmp51_;
						if (_inner_error_ != NULL) {
							gisi_comm_call_isi_callstatus_destroy (&status);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp53_ = status;
						_tmp54_ = _tmp53_.status;
						_tmp55_ = _CALL_status_to_string (_tmp54_);
						_tmp56_ = g_strconcat ("call status is ", _tmp55_, " (0x%0X)", NULL);
						_tmp57_ = _tmp56_;
						g_debug (_tmp57_, _tmp52_);
						_g_free0 (_tmp57_);
						break;
					}
					case CALL_ORIGIN_ADDRESS:
					case CALL_DESTINATION_ADDRESS:
					{
						guchar _tmp58_ = '\0';
						guchar _tmp59_;
						guchar _tmp60_ = '\0';
						guchar _tmp61_;
						gchar* _tmp62_ = NULL;
						gchar* _tmp63_;
						GIsiCommCallISI_CallStatus _tmp64_;
						guint8 _tmp65_;
						GIsiCommCallISI_CallStatus _tmp66_;
						const gchar* _tmp67_;
						_tmp58_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 2, &_inner_error_);
						_tmp59_ = _tmp58_;
						if (_inner_error_ != NULL) {
							gisi_comm_call_isi_callstatus_destroy (&status);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						status.ntype = (guint8) (_tmp59_ | 0x80);
						_tmp60_ = g_isi_sub_block_iter_byte_at_position (&sbi, (guint) 5, &_inner_error_);
						_tmp61_ = _tmp60_;
						if (_inner_error_ != NULL) {
							gisi_comm_call_isi_callstatus_destroy (&status);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp62_ = g_isi_sub_block_iter_alpha_tag_at_position (&sbi, (gsize) (_tmp61_ * 2), (guint) 6, &_inner_error_);
						_tmp63_ = _tmp62_;
						if (_inner_error_ != NULL) {
							gisi_comm_call_isi_callstatus_destroy (&status);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_g_free0 (status.number);
						status.number = _tmp63_;
						_tmp64_ = status;
						_tmp65_ = _tmp64_.ntype;
						_tmp66_ = status;
						_tmp67_ = _tmp66_.number;
						g_debug ("gisicomm.vala:1390: call peer is type 0x%0X, number %s", (guint) _tmp65_, _tmp67_);
						break;
					}
					default:
					{
						GIsiSubBlockIter _tmp68_;
						gint _tmp69_;
						gint _tmp70_;
						gchar* _tmp71_ = NULL;
						gchar* _tmp72_;
						gchar* _tmp73_ = NULL;
						gchar* _tmp74_;
						_tmp68_ = sbi;
						_tmp69_ = g_isi_sb_iter_get_id (&_tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = g_strdup_printf ("%i", _tmp70_);
						_tmp72_ = _tmp71_;
						_tmp73_ = g_strconcat ("FIXME: handle unhandled subblock with id ", _tmp72_, NULL);
						_tmp74_ = _tmp73_;
						g_debug ("gisicomm.vala:1394: %s", _tmp74_);
						_g_free0 (_tmp74_);
						_g_free0 (_tmp72_);
						break;
					}
				}
			}
		}
	}
	*result = status;
	return;
}


static void gisi_comm_call_onStatusIndicationReceived (GIsiCommCall* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GIsiMessage* _tmp5_;
	GIsiCommCallISI_CallStatus _tmp6_ = {0};
	GIsiCommCallISI_CallStatus _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:1404: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = msg;
	gisi_comm_call_parseCallStatus (self, _tmp5_, &_tmp6_);
	_tmp7_ = _tmp6_;
	g_signal_emit_by_name (self, "status-changed", &_tmp7_);
	gisi_comm_call_isi_callstatus_destroy (&_tmp7_);
}


static Block25Data* block25_data_ref (Block25Data* _data25_) {
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}


static void block25_data_unref (Block25Data* _data25_) {
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data25_->self);
		g_slice_free (Block25Data, _data25_);
	}
}


static void __lambda13_ (Block25Data* _data25_, GIsiMessage* msg) {
	GIsiCommCall * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiCommIntResultFunc _tmp3_;
	void* _tmp3__target;
	GIsiMessage* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8 _tmp7_;
	self = _data25_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommIntResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data25_->cb;
		_tmp2__target = _data25_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, 0, _tmp2__target);
		return;
	}
	_tmp3_ = _data25_->cb;
	_tmp3__target = _data25_->cb_target;
	_tmp4_ = msg;
	_tmp5_ = g_isi_msg_get_data (_tmp4_, &_tmp5__length1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_[0];
	_tmp3_ (GISI_COMM_ERROR_CODE_OK, (gint) _tmp7_, _tmp3__target);
}


static void ___lambda13__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda13_ (self, msg);
}


void gisi_comm_call_initiateVoiceCall (GIsiCommCall* self, const gchar* number, guint8 ntype, guint8 presentation, GIsiCommIntResultFunc cb, void* cb_target) {
	Block25Data* _data25_;
	GIsiCommIntResultFunc _tmp0_;
	void* _tmp0__target;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gsize addr_len;
	gsize _tmp4_;
	gsize sub_len;
	gsize offset;
	guint8 _tmp5_;
	gsize _tmp6_;
	guint8 _tmp7_;
	gsize _tmp8_;
	guchar* _tmp9_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	gsize _tmp10_;
	gsize rlen;
	GIsiClient* _tmp23_;
	guchar* _tmp24_;
	gint _tmp24__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (number != NULL);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_data25_->cb = _tmp0_;
	_data25_->cb_target = _tmp0__target;
	_tmp1_ = number;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	addr_len = (gsize) _tmp3_;
	_tmp4_ = addr_len;
	sub_len = ((6 + (2 * _tmp4_)) + 3) & (~3);
	offset = (gsize) (((3 + 4) + 8) + 6);
	_tmp5_ = presentation;
	_tmp6_ = sub_len;
	_tmp7_ = ntype;
	_tmp8_ = addr_len;
	_tmp9_ = g_new0 (guchar, 61);
	_tmp9_[0] = (guchar) CALL_CREATE_REQ;
	_tmp9_[1] = (guchar) 0;
	_tmp9_[2] = (guchar) 3;
	_tmp9_[3] = (guchar) CALL_MODE;
	_tmp9_[4] = (guchar) 4;
	_tmp9_[5] = (guchar) CALL_MODE_SPEECH;
	_tmp9_[6] = (guchar) CALL_MODE_INFO_NONE;
	_tmp9_[7] = (guchar) CALL_ORIGIN_INFO;
	_tmp9_[8] = (guchar) 8;
	_tmp9_[9] = (guchar) _tmp5_;
	_tmp9_[10] = (guchar) 0;
	_tmp9_[11] = (guchar) 0;
	_tmp9_[12] = (guchar) 0;
	_tmp9_[13] = (guchar) 0;
	_tmp9_[14] = (guchar) 0;
	_tmp9_[15] = (guchar) CALL_DESTINATION_ADDRESS;
	_tmp9_[16] = (guchar) _tmp6_;
	_tmp9_[17] = ((guchar) _tmp7_) & 0x7F;
	_tmp9_[18] = (guchar) 0;
	_tmp9_[19] = (guchar) 0;
	_tmp9_[20] = (guchar) _tmp8_;
	_tmp9_[21] = (guchar) 0x0;
	_tmp9_[22] = (guchar) 0x0;
	_tmp9_[23] = (guchar) 0x0;
	_tmp9_[24] = (guchar) 0x0;
	_tmp9_[25] = (guchar) 0x0;
	_tmp9_[26] = (guchar) 0x0;
	_tmp9_[27] = (guchar) 0x0;
	_tmp9_[28] = (guchar) 0x0;
	_tmp9_[29] = (guchar) 0x0;
	_tmp9_[30] = (guchar) 0x0;
	_tmp9_[31] = (guchar) 0x0;
	_tmp9_[32] = (guchar) 0x0;
	_tmp9_[33] = (guchar) 0x0;
	_tmp9_[34] = (guchar) 0x0;
	_tmp9_[35] = (guchar) 0x0;
	_tmp9_[36] = (guchar) 0x0;
	_tmp9_[37] = (guchar) 0x0;
	_tmp9_[38] = (guchar) 0x0;
	_tmp9_[39] = (guchar) 0x0;
	_tmp9_[40] = (guchar) 0x0;
	_tmp9_[41] = (guchar) 0x0;
	_tmp9_[42] = (guchar) 0x0;
	_tmp9_[43] = (guchar) 0x0;
	_tmp9_[44] = (guchar) 0x0;
	_tmp9_[45] = (guchar) 0x0;
	_tmp9_[46] = (guchar) 0x0;
	_tmp9_[47] = (guchar) 0x0;
	_tmp9_[48] = (guchar) 0x0;
	_tmp9_[49] = (guchar) 0x0;
	_tmp9_[50] = (guchar) 0x0;
	_tmp9_[51] = (guchar) 0x0;
	_tmp9_[52] = (guchar) 0x0;
	_tmp9_[53] = (guchar) 0x0;
	_tmp9_[54] = (guchar) 0x0;
	_tmp9_[55] = (guchar) 0x0;
	_tmp9_[56] = (guchar) 0x0;
	_tmp9_[57] = (guchar) 0x0;
	_tmp9_[58] = (guchar) 0x0;
	_tmp9_[59] = (guchar) 0x0;
	_tmp9_[60] = (guchar) 0x0;
	req = _tmp9_;
	req_length1 = 61;
	_req_size_ = req_length1;
	_tmp10_ = sub_len;
	rlen = ((3 + 4) + 8) + _tmp10_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp11_;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_;
				gint _tmp14_;
				gsize _tmp15_;
				guchar* _tmp16_;
				gint _tmp16__length1;
				gsize _tmp17_;
				gint _tmp18_;
				const gchar* _tmp19_;
				gint _tmp20_;
				gchar _tmp21_ = '\0';
				guchar _tmp22_;
				_tmp12_ = _tmp11_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = addr_len;
				if (!(((gsize) _tmp14_) < _tmp15_)) {
					break;
				}
				_tmp16_ = req;
				_tmp16__length1 = req_length1;
				_tmp17_ = offset;
				_tmp18_ = i;
				_tmp19_ = number;
				_tmp20_ = i;
				_tmp21_ = string_get (_tmp19_, (glong) _tmp20_);
				_tmp16_[(_tmp17_ + (2 * _tmp18_)) + 1] = (guchar) _tmp21_;
				_tmp22_ = _tmp16_[(_tmp17_ + (2 * _tmp18_)) + 1];
			}
		}
	}
	_tmp23_ = self->priv->ll;
	_tmp24_ = req;
	_tmp24__length1 = req_length1;
	g_isi_client_send (_tmp23_, _tmp24_, _tmp24__length1, ___lambda13__gisi_notify_func, block25_data_ref (_data25_), block25_data_unref);
	req = (g_free (req), NULL);
	block25_data_unref (_data25_);
	_data25_ = NULL;
}


static Block26Data* block26_data_ref (Block26Data* _data26_) {
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}


static void block26_data_unref (Block26Data* _data26_) {
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data26_->self);
		g_slice_free (Block26Data, _data26_);
	}
}


static void __lambda14_ (Block26Data* _data26_, GIsiMessage* msg) {
	GIsiCommCall * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiCommVoidResultFunc _tmp3_;
	void* _tmp3__target;
	self = _data26_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommVoidResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data26_->cb;
		_tmp2__target = _data26_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _tmp2__target);
		return;
	}
	_tmp3_ = _data26_->cb;
	_tmp3__target = _data26_->cb_target;
	_tmp3_ (GISI_COMM_ERROR_CODE_OK, _tmp3__target);
}


static void ___lambda14__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda14_ (self, msg);
}


void gisi_comm_call_releaseVoiceCall (GIsiCommCall* self, guint8 callid, guint8 causeType, guint8 causeValue, GIsiCommVoidResultFunc cb, void* cb_target) {
	Block26Data* _data26_;
	GIsiCommVoidResultFunc _tmp0_;
	void* _tmp0__target;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 _tmp3_;
	guchar* _tmp4_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp5_;
	g_return_if_fail (self != NULL);
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_data26_->cb = _tmp0_;
	_data26_->cb_target = _tmp0__target;
	_tmp1_ = callid;
	_tmp2_ = causeType;
	_tmp3_ = causeValue;
	_tmp4_ = g_new0 (guchar, 7);
	_tmp4_[0] = (guchar) CALL_RELEASE_REQ;
	_tmp4_[1] = (guchar) _tmp1_;
	_tmp4_[2] = (guchar) 1;
	_tmp4_[3] = (guchar) CALL_CAUSE;
	_tmp4_[4] = (guchar) 4;
	_tmp4_[5] = (guchar) _tmp2_;
	_tmp4_[6] = (guchar) _tmp3_;
	req = _tmp4_;
	req_length1 = 7;
	_req_size_ = req_length1;
	_tmp5_ = self->priv->ll;
	g_isi_client_send (_tmp5_, req, req_length1, ___lambda14__gisi_notify_func, block26_data_ref (_data26_), block26_data_unref);
	req = (g_free (req), NULL);
	block26_data_unref (_data26_);
	_data26_ = NULL;
}


static Block27Data* block27_data_ref (Block27Data* _data27_) {
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}


static void block27_data_unref (Block27Data* _data27_) {
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data27_->self);
		g_slice_free (Block27Data, _data27_);
	}
}


static void __lambda15_ (Block27Data* _data27_, GIsiMessage* msg) {
	GIsiCommCall * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiMessage* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8 _tmp6_;
	GIsiCommVoidResultFunc _tmp7_;
	void* _tmp7__target;
	self = _data27_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommVoidResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data27_->cb;
		_tmp2__target = _data27_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _tmp2__target);
		return;
	}
	_tmp3_ = msg;
	_tmp4_ = g_isi_msg_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = _tmp5_[0];
	g_debug ("gisicomm.vala:1488: answer msg return code 0x%0X", (guint) _tmp6_);
	_tmp7_ = _data27_->cb;
	_tmp7__target = _data27_->cb_target;
	_tmp7_ (GISI_COMM_ERROR_CODE_OK, _tmp7__target);
}


static void ___lambda15__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda15_ (self, msg);
}


void gisi_comm_call_answerVoiceCall (GIsiCommCall* self, guint8 callid, GIsiCommVoidResultFunc cb, void* cb_target) {
	Block27Data* _data27_;
	GIsiCommVoidResultFunc _tmp0_;
	void* _tmp0__target;
	guint8 _tmp1_;
	guchar* _tmp2_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	guint8 _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GIsiClient* _tmp8_;
	g_return_if_fail (self != NULL);
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_data27_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_data27_->cb = _tmp0_;
	_data27_->cb_target = _tmp0__target;
	_tmp1_ = callid;
	_tmp2_ = g_new0 (guchar, 3);
	_tmp2_[0] = (guchar) CALL_ANSWER_REQ;
	_tmp2_[1] = (guchar) _tmp1_;
	_tmp2_[2] = (guchar) 0x0;
	req = _tmp2_;
	req_length1 = 3;
	_req_size_ = req_length1;
	_tmp3_ = callid;
	_tmp4_ = g_strdup_printf ("%hhu", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("sending ANSWER_REQ for call with id ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	g_debug ("gisicomm.vala:1479: %s", _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = self->priv->ll;
	g_isi_client_send (_tmp8_, req, req_length1, ___lambda15__gisi_notify_func, block27_data_ref (_data27_), block27_data_unref);
	req = (g_free (req), NULL);
	block27_data_unref (_data27_);
	_data27_ = NULL;
}


static Block28Data* block28_data_ref (Block28Data* _data28_) {
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}


static void block28_data_unref (Block28Data* _data28_) {
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data28_->self);
		g_slice_free (Block28Data, _data28_);
	}
}


static void __lambda16_ (Block28Data* _data28_, GIsiMessage* msg) {
	GIsiCommCall * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiMessage* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8 _tmp6_;
	GIsiCommVoidResultFunc _tmp7_;
	void* _tmp7__target;
	self = _data28_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommVoidResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data28_->cb;
		_tmp2__target = _data28_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _tmp2__target);
		return;
	}
	_tmp3_ = msg;
	_tmp4_ = g_isi_msg_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = _tmp5_[0];
	g_debug ("gisicomm.vala:1510: control voice call msg return code 0x%0X", (guint) _tmp6_);
	_tmp7_ = _data28_->cb;
	_tmp7__target = _data28_->cb_target;
	_tmp7_ (GISI_COMM_ERROR_CODE_OK, _tmp7__target);
}


static void ___lambda16__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda16_ (self, msg);
}


void gisi_comm_call_controlVoiceCall (GIsiCommCall* self, guint8 callid, guint8 operation, guint8 param, GIsiCommVoidResultFunc cb, void* cb_target) {
	Block28Data* _data28_;
	GIsiCommVoidResultFunc _tmp0_;
	void* _tmp0__target;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 _tmp3_;
	guchar* _tmp4_ = NULL;
	guchar* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp5_;
	g_return_if_fail (self != NULL);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_data28_->cb = _tmp0_;
	_data28_->cb_target = _tmp0__target;
	_tmp1_ = callid;
	_tmp2_ = operation;
	_tmp3_ = param;
	_tmp4_ = g_new0 (guchar, 7);
	_tmp4_[0] = (guchar) CALL_CONTROL_REQ;
	_tmp4_[1] = (guchar) _tmp1_;
	_tmp4_[2] = (guchar) 1;
	_tmp4_[3] = (guchar) CALL_OPERATION;
	_tmp4_[4] = (guchar) 4;
	_tmp4_[5] = (guchar) _tmp2_;
	_tmp4_[6] = (guchar) _tmp3_;
	req = _tmp4_;
	req_length1 = 7;
	_req_size_ = req_length1;
	_tmp5_ = self->priv->ll;
	g_isi_client_send (_tmp5_, req, req_length1, ___lambda16__gisi_notify_func, block28_data_ref (_data28_), block28_data_unref);
	req = (g_free (req), NULL);
	block28_data_unref (_data28_);
	_data28_ = NULL;
}


static Block29Data* block29_data_ref (Block29Data* _data29_) {
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}


static void block29_data_unref (Block29Data* _data29_) {
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data29_->self);
		g_slice_free (Block29Data, _data29_);
	}
}


static void __lambda17_ (Block29Data* _data29_, GIsiMessage* msg) {
	GIsiCommCall * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiMessage* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8 _tmp6_;
	GIsiCommVoidResultFunc _tmp7_;
	void* _tmp7__target;
	self = _data29_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommVoidResultFunc _tmp2_;
		void* _tmp2__target;
		_tmp2_ = _data29_->cb;
		_tmp2__target = _data29_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _tmp2__target);
		return;
	}
	_tmp3_ = msg;
	_tmp4_ = g_isi_msg_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = _tmp5_[0];
	g_debug ("gisicomm.vala:1563: send tones msg return code 0x%0X", (guint) _tmp6_);
	_tmp7_ = _data29_->cb;
	_tmp7__target = _data29_->cb_target;
	_tmp7_ (GISI_COMM_ERROR_CODE_OK, _tmp7__target);
}


static void ___lambda17__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda17_ (self, msg);
}


void gisi_comm_call_sendTonesOnVoiceCall (GIsiCommCall* self, guint8 callid, const gchar* tones, GIsiCommVoidResultFunc cb, void* cb_target) {
	Block29Data* _data29_;
	GIsiCommVoidResultFunc _tmp0_;
	void* _tmp0__target;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gsize str_len;
	gsize _tmp4_;
	gsize sub_len;
	gsize offset;
	gsize _tmp5_;
	gsize rlen;
	guint8 _tmp6_;
	gsize _tmp7_;
	gsize _tmp8_;
	guint8* _tmp9_ = NULL;
	guint8* req;
	gint req_length1;
	gint _req_size_;
	GIsiClient* _tmp22_;
	guint8* _tmp23_;
	gint _tmp23__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tones != NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = gisi_comm_abstract_base_client_ref (self);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_data29_->cb = _tmp0_;
	_data29_->cb_target = _tmp0__target;
	_tmp1_ = tones;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	str_len = (gsize) ((guint8) _tmp3_);
	_tmp4_ = str_len;
	sub_len = 4 + (((2 * _tmp4_) + 3) & (~3));
	offset = (gsize) (((3 + 4) + 8) + 4);
	_tmp5_ = sub_len;
	rlen = ((3 + 4) + 8) + _tmp5_;
	_tmp6_ = callid;
	_tmp7_ = sub_len;
	_tmp8_ = str_len;
	_tmp9_ = g_new0 (guint8, 271);
	_tmp9_[0] = CALL_DTMF_SEND_REQ;
	_tmp9_[1] = _tmp6_;
	_tmp9_[2] = (guint8) 3;
	_tmp9_[3] = CALL_DTMF_INFO;
	_tmp9_[4] = (guint8) 4;
	_tmp9_[5] = CALL_DTMF_ENABLE_TONE_IND_SEND;
	_tmp9_[6] = (guint8) 0;
	_tmp9_[7] = CALL_DTMF_TIMERS;
	_tmp9_[8] = (guint8) 8;
	_tmp9_[9] = (guint8) 0;
	_tmp9_[10] = (guint8) 200;
	_tmp9_[11] = (guint8) 0;
	_tmp9_[12] = (guint8) 100;
	_tmp9_[13] = (guint8) 0;
	_tmp9_[14] = (guint8) 0;
	_tmp9_[15] = CALL_DTMF_STRING;
	_tmp9_[16] = (guint8) _tmp7_;
	_tmp9_[17] = (guint8) 100;
	_tmp9_[18] = (guint8) _tmp8_;
	_tmp9_[19] = (guint8) 0x0;
	_tmp9_[20] = (guint8) 0x0;
	_tmp9_[21] = (guint8) 0x0;
	_tmp9_[22] = (guint8) 0x0;
	_tmp9_[23] = (guint8) 0x0;
	_tmp9_[24] = (guint8) 0x0;
	_tmp9_[25] = (guint8) 0x0;
	_tmp9_[26] = (guint8) 0x0;
	_tmp9_[27] = (guint8) 0x0;
	_tmp9_[28] = (guint8) 0x0;
	_tmp9_[29] = (guint8) 0x0;
	_tmp9_[30] = (guint8) 0x0;
	_tmp9_[31] = (guint8) 0x0;
	_tmp9_[32] = (guint8) 0x0;
	_tmp9_[33] = (guint8) 0x0;
	_tmp9_[34] = (guint8) 0x0;
	_tmp9_[35] = (guint8) 0x0;
	_tmp9_[36] = (guint8) 0x0;
	_tmp9_[37] = (guint8) 0x0;
	_tmp9_[38] = (guint8) 0x0;
	_tmp9_[39] = (guint8) 0x0;
	_tmp9_[40] = (guint8) 0x0;
	_tmp9_[41] = (guint8) 0x0;
	_tmp9_[42] = (guint8) 0x0;
	_tmp9_[43] = (guint8) 0x0;
	_tmp9_[44] = (guint8) 0x0;
	_tmp9_[45] = (guint8) 0x0;
	_tmp9_[46] = (guint8) 0x0;
	_tmp9_[47] = (guint8) 0x0;
	_tmp9_[48] = (guint8) 0x0;
	_tmp9_[49] = (guint8) 0x0;
	_tmp9_[50] = (guint8) 0x0;
	_tmp9_[51] = (guint8) 0x0;
	_tmp9_[52] = (guint8) 0x0;
	_tmp9_[53] = (guint8) 0x0;
	_tmp9_[54] = (guint8) 0x0;
	_tmp9_[55] = (guint8) 0x0;
	_tmp9_[56] = (guint8) 0x0;
	_tmp9_[57] = (guint8) 0x0;
	_tmp9_[58] = (guint8) 0x0;
	_tmp9_[59] = (guint8) 0x0;
	_tmp9_[60] = (guint8) 0x0;
	_tmp9_[61] = (guint8) 0x0;
	_tmp9_[62] = (guint8) 0x0;
	_tmp9_[63] = (guint8) 0x0;
	_tmp9_[64] = (guint8) 0x0;
	_tmp9_[65] = (guint8) 0x0;
	_tmp9_[66] = (guint8) 0x0;
	_tmp9_[67] = (guint8) 0x0;
	_tmp9_[68] = (guint8) 0x0;
	_tmp9_[69] = (guint8) 0x0;
	_tmp9_[70] = (guint8) 0x0;
	_tmp9_[71] = (guint8) 0x0;
	_tmp9_[72] = (guint8) 0x0;
	_tmp9_[73] = (guint8) 0x0;
	_tmp9_[74] = (guint8) 0x0;
	_tmp9_[75] = (guint8) 0x0;
	_tmp9_[76] = (guint8) 0x0;
	_tmp9_[77] = (guint8) 0x0;
	_tmp9_[78] = (guint8) 0x0;
	_tmp9_[79] = (guint8) 0x0;
	_tmp9_[80] = (guint8) 0x0;
	_tmp9_[81] = (guint8) 0x0;
	_tmp9_[82] = (guint8) 0x0;
	_tmp9_[83] = (guint8) 0x0;
	_tmp9_[84] = (guint8) 0x0;
	_tmp9_[85] = (guint8) 0x0;
	_tmp9_[86] = (guint8) 0x0;
	_tmp9_[87] = (guint8) 0x0;
	_tmp9_[88] = (guint8) 0x0;
	_tmp9_[89] = (guint8) 0x0;
	_tmp9_[90] = (guint8) 0x0;
	_tmp9_[91] = (guint8) 0x0;
	_tmp9_[92] = (guint8) 0x0;
	_tmp9_[93] = (guint8) 0x0;
	_tmp9_[94] = (guint8) 0x0;
	_tmp9_[95] = (guint8) 0x0;
	_tmp9_[96] = (guint8) 0x0;
	_tmp9_[97] = (guint8) 0x0;
	_tmp9_[98] = (guint8) 0x0;
	_tmp9_[99] = (guint8) 0x0;
	_tmp9_[100] = (guint8) 0x0;
	_tmp9_[101] = (guint8) 0x0;
	_tmp9_[102] = (guint8) 0x0;
	_tmp9_[103] = (guint8) 0x0;
	_tmp9_[104] = (guint8) 0x0;
	_tmp9_[105] = (guint8) 0x0;
	_tmp9_[106] = (guint8) 0x0;
	_tmp9_[107] = (guint8) 0x0;
	_tmp9_[108] = (guint8) 0x0;
	_tmp9_[109] = (guint8) 0x0;
	_tmp9_[110] = (guint8) 0x0;
	_tmp9_[111] = (guint8) 0x0;
	_tmp9_[112] = (guint8) 0x0;
	_tmp9_[113] = (guint8) 0x0;
	_tmp9_[114] = (guint8) 0x0;
	_tmp9_[115] = (guint8) 0x0;
	_tmp9_[116] = (guint8) 0x0;
	_tmp9_[117] = (guint8) 0x0;
	_tmp9_[118] = (guint8) 0x0;
	_tmp9_[119] = (guint8) 0x0;
	_tmp9_[120] = (guint8) 0x0;
	_tmp9_[121] = (guint8) 0x0;
	_tmp9_[122] = (guint8) 0x0;
	_tmp9_[123] = (guint8) 0x0;
	_tmp9_[124] = (guint8) 0x0;
	_tmp9_[125] = (guint8) 0x0;
	_tmp9_[126] = (guint8) 0x0;
	_tmp9_[127] = (guint8) 0x0;
	_tmp9_[128] = (guint8) 0x0;
	_tmp9_[129] = (guint8) 0x0;
	_tmp9_[130] = (guint8) 0x0;
	_tmp9_[131] = (guint8) 0x0;
	_tmp9_[132] = (guint8) 0x0;
	_tmp9_[133] = (guint8) 0x0;
	_tmp9_[134] = (guint8) 0x0;
	_tmp9_[135] = (guint8) 0x0;
	_tmp9_[136] = (guint8) 0x0;
	_tmp9_[137] = (guint8) 0x0;
	_tmp9_[138] = (guint8) 0x0;
	_tmp9_[139] = (guint8) 0x0;
	_tmp9_[140] = (guint8) 0x0;
	_tmp9_[141] = (guint8) 0x0;
	_tmp9_[142] = (guint8) 0x0;
	_tmp9_[143] = (guint8) 0x0;
	_tmp9_[144] = (guint8) 0x0;
	_tmp9_[145] = (guint8) 0x0;
	_tmp9_[146] = (guint8) 0x0;
	_tmp9_[147] = (guint8) 0x0;
	_tmp9_[148] = (guint8) 0x0;
	_tmp9_[149] = (guint8) 0x0;
	_tmp9_[150] = (guint8) 0x0;
	_tmp9_[151] = (guint8) 0x0;
	_tmp9_[152] = (guint8) 0x0;
	_tmp9_[153] = (guint8) 0x0;
	_tmp9_[154] = (guint8) 0x0;
	_tmp9_[155] = (guint8) 0x0;
	_tmp9_[156] = (guint8) 0x0;
	_tmp9_[157] = (guint8) 0x0;
	_tmp9_[158] = (guint8) 0x0;
	_tmp9_[159] = (guint8) 0x0;
	_tmp9_[160] = (guint8) 0x0;
	_tmp9_[161] = (guint8) 0x0;
	_tmp9_[162] = (guint8) 0x0;
	_tmp9_[163] = (guint8) 0x0;
	_tmp9_[164] = (guint8) 0x0;
	_tmp9_[165] = (guint8) 0x0;
	_tmp9_[166] = (guint8) 0x0;
	_tmp9_[167] = (guint8) 0x0;
	_tmp9_[168] = (guint8) 0x0;
	_tmp9_[169] = (guint8) 0x0;
	_tmp9_[170] = (guint8) 0x0;
	_tmp9_[171] = (guint8) 0x0;
	_tmp9_[172] = (guint8) 0x0;
	_tmp9_[173] = (guint8) 0x0;
	_tmp9_[174] = (guint8) 0x0;
	_tmp9_[175] = (guint8) 0x0;
	_tmp9_[176] = (guint8) 0x0;
	_tmp9_[177] = (guint8) 0x0;
	_tmp9_[178] = (guint8) 0x0;
	_tmp9_[179] = (guint8) 0x0;
	_tmp9_[180] = (guint8) 0x0;
	_tmp9_[181] = (guint8) 0x0;
	_tmp9_[182] = (guint8) 0x0;
	_tmp9_[183] = (guint8) 0x0;
	_tmp9_[184] = (guint8) 0x0;
	_tmp9_[185] = (guint8) 0x0;
	_tmp9_[186] = (guint8) 0x0;
	_tmp9_[187] = (guint8) 0x0;
	_tmp9_[188] = (guint8) 0x0;
	_tmp9_[189] = (guint8) 0x0;
	_tmp9_[190] = (guint8) 0x0;
	_tmp9_[191] = (guint8) 0x0;
	_tmp9_[192] = (guint8) 0x0;
	_tmp9_[193] = (guint8) 0x0;
	_tmp9_[194] = (guint8) 0x0;
	_tmp9_[195] = (guint8) 0x0;
	_tmp9_[196] = (guint8) 0x0;
	_tmp9_[197] = (guint8) 0x0;
	_tmp9_[198] = (guint8) 0x0;
	_tmp9_[199] = (guint8) 0x0;
	_tmp9_[200] = (guint8) 0x0;
	_tmp9_[201] = (guint8) 0x0;
	_tmp9_[202] = (guint8) 0x0;
	_tmp9_[203] = (guint8) 0x0;
	_tmp9_[204] = (guint8) 0x0;
	_tmp9_[205] = (guint8) 0x0;
	_tmp9_[206] = (guint8) 0x0;
	_tmp9_[207] = (guint8) 0x0;
	_tmp9_[208] = (guint8) 0x0;
	_tmp9_[209] = (guint8) 0x0;
	_tmp9_[210] = (guint8) 0x0;
	_tmp9_[211] = (guint8) 0x0;
	_tmp9_[212] = (guint8) 0x0;
	_tmp9_[213] = (guint8) 0x0;
	_tmp9_[214] = (guint8) 0x0;
	_tmp9_[215] = (guint8) 0x0;
	_tmp9_[216] = (guint8) 0x0;
	_tmp9_[217] = (guint8) 0x0;
	_tmp9_[218] = (guint8) 0x0;
	_tmp9_[219] = (guint8) 0x0;
	_tmp9_[220] = (guint8) 0x0;
	_tmp9_[221] = (guint8) 0x0;
	_tmp9_[222] = (guint8) 0x0;
	_tmp9_[223] = (guint8) 0x0;
	_tmp9_[224] = (guint8) 0x0;
	_tmp9_[225] = (guint8) 0x0;
	_tmp9_[226] = (guint8) 0x0;
	_tmp9_[227] = (guint8) 0x0;
	_tmp9_[228] = (guint8) 0x0;
	_tmp9_[229] = (guint8) 0x0;
	_tmp9_[230] = (guint8) 0x0;
	_tmp9_[231] = (guint8) 0x0;
	_tmp9_[232] = (guint8) 0x0;
	_tmp9_[233] = (guint8) 0x0;
	_tmp9_[234] = (guint8) 0x0;
	_tmp9_[235] = (guint8) 0x0;
	_tmp9_[236] = (guint8) 0x0;
	_tmp9_[237] = (guint8) 0x0;
	_tmp9_[238] = (guint8) 0x0;
	_tmp9_[239] = (guint8) 0x0;
	_tmp9_[240] = (guint8) 0x0;
	_tmp9_[241] = (guint8) 0x0;
	_tmp9_[242] = (guint8) 0x0;
	_tmp9_[243] = (guint8) 0x0;
	_tmp9_[244] = (guint8) 0x0;
	_tmp9_[245] = (guint8) 0x0;
	_tmp9_[246] = (guint8) 0x0;
	_tmp9_[247] = (guint8) 0x0;
	_tmp9_[248] = (guint8) 0x0;
	_tmp9_[249] = (guint8) 0x0;
	_tmp9_[250] = (guint8) 0x0;
	_tmp9_[251] = (guint8) 0x0;
	_tmp9_[252] = (guint8) 0x0;
	_tmp9_[253] = (guint8) 0x0;
	_tmp9_[254] = (guint8) 0x0;
	_tmp9_[255] = (guint8) 0x0;
	_tmp9_[256] = (guint8) 0x0;
	_tmp9_[257] = (guint8) 0x0;
	_tmp9_[258] = (guint8) 0x0;
	_tmp9_[259] = (guint8) 0x0;
	_tmp9_[260] = (guint8) 0x0;
	_tmp9_[261] = (guint8) 0x0;
	_tmp9_[262] = (guint8) 0x0;
	_tmp9_[263] = (guint8) 0x0;
	_tmp9_[264] = (guint8) 0x0;
	_tmp9_[265] = (guint8) 0x0;
	_tmp9_[266] = (guint8) 0x0;
	_tmp9_[267] = (guint8) 0x0;
	_tmp9_[268] = (guint8) 0x0;
	_tmp9_[269] = (guint8) 0x0;
	_tmp9_[270] = (guint8) 0x0;
	req = _tmp9_;
	req_length1 = 271;
	_req_size_ = req_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_;
				gint _tmp13_;
				gsize _tmp14_;
				guint8* _tmp15_;
				gint _tmp15__length1;
				gsize _tmp16_;
				gint _tmp17_;
				const gchar* _tmp18_;
				gint _tmp19_;
				gchar _tmp20_ = '\0';
				guint8 _tmp21_;
				_tmp11_ = _tmp10_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = str_len;
				if (!(((gsize) _tmp13_) < _tmp14_)) {
					break;
				}
				_tmp15_ = req;
				_tmp15__length1 = req_length1;
				_tmp16_ = offset;
				_tmp17_ = i;
				_tmp18_ = tones;
				_tmp19_ = i;
				_tmp20_ = string_get (_tmp18_, (glong) _tmp19_);
				_tmp15_[(_tmp16_ + (2 * _tmp17_)) + 1] = (guint8) _tmp20_;
				_tmp21_ = _tmp15_[(_tmp16_ + (2 * _tmp17_)) + 1];
			}
		}
	}
	_tmp22_ = self->priv->ll;
	_tmp23_ = req;
	_tmp23__length1 = req_length1;
	g_isi_client_send (_tmp22_, _tmp23_, _tmp23__length1, ___lambda17__gisi_notify_func, block29_data_ref (_data29_), block29_data_unref);
	req = (g_free (req), NULL);
	block29_data_unref (_data29_);
	_data29_ = NULL;
}


void gisi_comm_call_isi_callstatus_copy (const GIsiCommCallISI_CallStatus* self, GIsiCommCallISI_CallStatus* dest) {
	guint8 _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = (*self).id;
	(*dest).id = _tmp0_;
	_tmp1_ = (*self).status;
	(*dest).status = _tmp1_;
	_tmp2_ = (*self).ntype;
	(*dest).ntype = _tmp2_;
	_tmp3_ = (*self).number;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).number);
	(*dest).number = _tmp4_;
}


void gisi_comm_call_isi_callstatus_destroy (GIsiCommCallISI_CallStatus* self) {
	_g_free0 ((*self).number);
}


GIsiCommCallISI_CallStatus* gisi_comm_call_isi_callstatus_dup (const GIsiCommCallISI_CallStatus* self) {
	GIsiCommCallISI_CallStatus* dup;
	dup = g_new0 (GIsiCommCallISI_CallStatus, 1);
	gisi_comm_call_isi_callstatus_copy (self, dup);
	return dup;
}


void gisi_comm_call_isi_callstatus_free (GIsiCommCallISI_CallStatus* self) {
	gisi_comm_call_isi_callstatus_destroy (self);
	g_free (self);
}


GType gisi_comm_call_isi_callstatus_get_type (void) {
	static volatile gsize gisi_comm_call_isi_callstatus_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_call_isi_callstatus_type_id__volatile)) {
		GType gisi_comm_call_isi_callstatus_type_id;
		gisi_comm_call_isi_callstatus_type_id = g_boxed_type_register_static ("GIsiCommCallISI_CallStatus", (GBoxedCopyFunc) gisi_comm_call_isi_callstatus_dup, (GBoxedFreeFunc) gisi_comm_call_isi_callstatus_free);
		g_once_init_leave (&gisi_comm_call_isi_callstatus_type_id__volatile, gisi_comm_call_isi_callstatus_type_id);
	}
	return gisi_comm_call_isi_callstatus_type_id__volatile;
}


static void gisi_comm_call_class_init (GIsiCommCallClass * klass) {
	gisi_comm_call_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->finalize = gisi_comm_call_finalize;
	g_type_class_add_private (klass, sizeof (GIsiCommCallPrivate));
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->onSubsystemIsReachable = gisi_comm_call_real_onSubsystemIsReachable;
	g_signal_new ("status_changed", GISI_COMM_TYPE_CALL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, GISI_COMM_CALL_TYPE_ISI_CALLSTATUS);
}


static void gisi_comm_call_instance_init (GIsiCommCall * self) {
	self->priv = GISI_COMM_CALL_GET_PRIVATE (self);
}


static void gisi_comm_call_finalize (GIsiCommAbstractBaseClient* obj) {
	GIsiCommCall * self;
	self = GISI_COMM_CALL (obj);
	_g_isi_client_destroy0 (self->priv->ll);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (gisi_comm_call_parent_class)->finalize (obj);
}


/**
     * @class Call
     *
     * Call Handling
     **/
GType gisi_comm_call_get_type (void) {
	static volatile gsize gisi_comm_call_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_call_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommCall), 0, (GInstanceInitFunc) gisi_comm_call_instance_init, NULL };
		GType gisi_comm_call_type_id;
		gisi_comm_call_type_id = g_type_register_static (GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT, "GIsiCommCall", &g_define_type_info, 0);
		g_once_init_leave (&gisi_comm_call_type_id__volatile, gisi_comm_call_type_id);
	}
	return gisi_comm_call_type_id__volatile;
}


static GIsiClient* g_isi_modem_sms_client_create (GIsiModem* self) {
	GIsiClient* result = NULL;
	GIsiClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_isi_client_create (self, PN_SMS);
	result = (GIsiClient*) _tmp0_;
	return result;
}


GIsiCommSMS* gisi_comm_sms_construct (GType object_type, GIsiModem* modem) {
	GIsiCommSMS* self = NULL;
	GIsiModem* _tmp0_;
	GIsiClient* _tmp1_ = NULL;
	GIsiClient* _tmp2_;
	g_return_val_if_fail (modem != NULL, NULL);
	self = (GIsiCommSMS*) gisi_comm_abstract_base_client_construct (object_type);
	_tmp0_ = modem;
	_tmp1_ = g_isi_modem_sms_client_create (_tmp0_);
	_g_isi_client_destroy0 (self->priv->ll);
	self->priv->ll = _tmp1_;
	_tmp2_ = self->priv->ll;
	((GIsiCommAbstractBaseClient*) self)->client = _tmp2_;
	return self;
}


GIsiCommSMS* gisi_comm_sms_new (GIsiModem* modem) {
	return gisi_comm_sms_construct (GISI_COMM_TYPE_SMS, modem);
}


static void _gisi_comm_sms_onSendStatusIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_sms_onSendStatusIndicationReceived (self, msg);
}


static void gisi_comm_sms_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base) {
	GIsiCommSMS * self;
	GIsiClient* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean ok;
	gboolean _tmp2_;
	self = (GIsiCommSMS*) base;
	_tmp0_ = self->priv->ll;
	_tmp1_ = g_isi_client_ind_subscribe (_tmp0_, (guchar) SMS_MESSAGE_SEND_STATUS_IND, _gisi_comm_sms_onSendStatusIndicationReceived_gisi_notify_func, self);
	ok = _tmp1_;
	_tmp2_ = ok;
	if (!_tmp2_) {
		g_warning ("gisicomm.vala:1590: Could not subscribe to MESSAGE_SEND_STATUS_IND");
	}
}


static void gisi_comm_sms_onSendStatusIndicationReceived (GIsiCommSMS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:1626: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_sms_class_init (GIsiCommSMSClass * klass) {
	gisi_comm_sms_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->finalize = gisi_comm_sms_finalize;
	g_type_class_add_private (klass, sizeof (GIsiCommSMSPrivate));
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->onSubsystemIsReachable = gisi_comm_sms_real_onSubsystemIsReachable;
}


static void gisi_comm_sms_instance_init (GIsiCommSMS * self) {
	self->priv = GISI_COMM_SMS_GET_PRIVATE (self);
}


static void gisi_comm_sms_finalize (GIsiCommAbstractBaseClient* obj) {
	GIsiCommSMS * self;
	self = GISI_COMM_SMS (obj);
	_g_isi_client_destroy0 (self->priv->ll);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (gisi_comm_sms_parent_class)->finalize (obj);
}


/**
     * @class SMS
     *
     * Short Messages Server
     **/
GType gisi_comm_sms_get_type (void) {
	static volatile gsize gisi_comm_sms_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_sms_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommSMSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_sms_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommSMS), 0, (GInstanceInitFunc) gisi_comm_sms_instance_init, NULL };
		GType gisi_comm_sms_type_id;
		gisi_comm_sms_type_id = g_type_register_static (GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT, "GIsiCommSMS", &g_define_type_info, 0);
		g_once_init_leave (&gisi_comm_sms_type_id__volatile, gisi_comm_sms_type_id);
	}
	return gisi_comm_sms_type_id__volatile;
}


static GIsiClient* g_isi_modem_gss_client_create (GIsiModem* self) {
	GIsiClient* result = NULL;
	GIsiClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_isi_client_create (self, PN_GSS);
	result = (GIsiClient*) _tmp0_;
	return result;
}


GIsiCommGSS* gisi_comm_gss_construct (GType object_type, GIsiModem* modem) {
	GIsiCommGSS* self = NULL;
	GIsiModem* _tmp0_;
	GIsiClient* _tmp1_ = NULL;
	GIsiClient* _tmp2_;
	g_return_val_if_fail (modem != NULL, NULL);
	self = (GIsiCommGSS*) gisi_comm_abstract_base_client_construct (object_type);
	_tmp0_ = modem;
	_tmp1_ = g_isi_modem_gss_client_create (_tmp0_);
	_g_isi_client_destroy0 (self->priv->ll);
	self->priv->ll = _tmp1_;
	_tmp2_ = self->priv->ll;
	((GIsiCommAbstractBaseClient*) self)->client = _tmp2_;
	return self;
}


GIsiCommGSS* gisi_comm_gss_new (GIsiModem* modem) {
	return gisi_comm_gss_construct (GISI_COMM_TYPE_GSS, modem);
}


static void gisi_comm_gss_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base) {
	GIsiCommGSS * self;
	self = (GIsiCommGSS*) base;
}


static void gisi_comm_gss_class_init (GIsiCommGSSClass * klass) {
	gisi_comm_gss_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->finalize = gisi_comm_gss_finalize;
	g_type_class_add_private (klass, sizeof (GIsiCommGSSPrivate));
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->onSubsystemIsReachable = gisi_comm_gss_real_onSubsystemIsReachable;
}


static void gisi_comm_gss_instance_init (GIsiCommGSS * self) {
	self->priv = GISI_COMM_GSS_GET_PRIVATE (self);
}


static void gisi_comm_gss_finalize (GIsiCommAbstractBaseClient* obj) {
	GIsiCommGSS * self;
	self = GISI_COMM_GSS (obj);
	_g_isi_client_destroy0 (self->priv->ll);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (gisi_comm_gss_parent_class)->finalize (obj);
}


/**
     * @class GSS
     *
     * General Stack Server
     **/
GType gisi_comm_gss_get_type (void) {
	static volatile gsize gisi_comm_gss_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_gss_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommGSSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_gss_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommGSS), 0, (GInstanceInitFunc) gisi_comm_gss_instance_init, NULL };
		GType gisi_comm_gss_type_id;
		gisi_comm_gss_type_id = g_type_register_static (GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT, "GIsiCommGSS", &g_define_type_info, 0);
		g_once_init_leave (&gisi_comm_gss_type_id__volatile, gisi_comm_gss_type_id);
	}
	return gisi_comm_gss_type_id__volatile;
}


static GIsiClient* g_isi_modem_ss_client_create (GIsiModem* self) {
	GIsiClient* result = NULL;
	GIsiClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_isi_client_create (self, PN_SS);
	result = (GIsiClient*) _tmp0_;
	return result;
}


GIsiCommSS* gisi_comm_ss_construct (GType object_type, GIsiModem* modem) {
	GIsiCommSS* self = NULL;
	GIsiModem* _tmp0_;
	GIsiClient* _tmp1_ = NULL;
	GIsiClient* _tmp2_;
	g_return_val_if_fail (modem != NULL, NULL);
	self = (GIsiCommSS*) gisi_comm_abstract_base_client_construct (object_type);
	_tmp0_ = modem;
	_tmp1_ = g_isi_modem_ss_client_create (_tmp0_);
	_g_isi_client_destroy0 (self->priv->ll);
	self->priv->ll = _tmp1_;
	_tmp2_ = self->priv->ll;
	((GIsiCommAbstractBaseClient*) self)->client = _tmp2_;
	return self;
}


GIsiCommSS* gisi_comm_ss_new (GIsiModem* modem) {
	return gisi_comm_ss_construct (GISI_COMM_TYPE_SS, modem);
}


static void _gisi_comm_ss_onStatusIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_ss_onStatusIndicationReceived (self, msg);
}


static void _gisi_comm_ss_onUssdReceiveIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_ss_onUssdReceiveIndicationReceived (self, msg);
}


static void gisi_comm_ss_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base) {
	GIsiCommSS * self;
	GIsiClient* _tmp0_;
	GIsiClient* _tmp1_;
	self = (GIsiCommSS*) base;
	_tmp0_ = self->priv->ll;
	g_isi_client_ind_subscribe (_tmp0_, (guchar) SS_STATUS_IND, _gisi_comm_ss_onStatusIndicationReceived_gisi_notify_func, self);
	_tmp1_ = self->priv->ll;
	g_isi_client_ind_subscribe (_tmp1_, (guchar) SS_GSM_USSD_RECEIVE_IND, _gisi_comm_ss_onUssdReceiveIndicationReceived_gisi_notify_func, self);
}


static void gisi_comm_ss_onStatusIndicationReceived (GIsiCommSS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:1673: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_ss_onUssdReceiveIndicationReceived (GIsiCommSS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:1678: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_ss_class_init (GIsiCommSSClass * klass) {
	gisi_comm_ss_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->finalize = gisi_comm_ss_finalize;
	g_type_class_add_private (klass, sizeof (GIsiCommSSPrivate));
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->onSubsystemIsReachable = gisi_comm_ss_real_onSubsystemIsReachable;
}


static void gisi_comm_ss_instance_init (GIsiCommSS * self) {
	self->priv = GISI_COMM_SS_GET_PRIVATE (self);
}


static void gisi_comm_ss_finalize (GIsiCommAbstractBaseClient* obj) {
	GIsiCommSS * self;
	self = GISI_COMM_SS (obj);
	_g_isi_client_destroy0 (self->priv->ll);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (gisi_comm_ss_parent_class)->finalize (obj);
}


/**
     * @class SS
     *
     * Stack Server
     **/
GType gisi_comm_ss_get_type (void) {
	static volatile gsize gisi_comm_ss_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_ss_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommSSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_ss_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommSS), 0, (GInstanceInitFunc) gisi_comm_ss_instance_init, NULL };
		GType gisi_comm_ss_type_id;
		gisi_comm_ss_type_id = g_type_register_static (GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT, "GIsiCommSS", &g_define_type_info, 0);
		g_once_init_leave (&gisi_comm_ss_type_id__volatile, gisi_comm_ss_type_id);
	}
	return gisi_comm_ss_type_id__volatile;
}


GIsiCommGPDSHelper* gisi_comm_gpds_helper_construct (GType object_type, GIsiCommGPDS* instance, GSourceFunc cb, void* cb_target) {
	GIsiCommGPDSHelper* self = NULL;
	GIsiCommGPDS* _tmp0_;
	GIsiCommGPDS* _tmp1_;
	GSourceFunc _tmp2_;
	void* _tmp2__target;
	g_return_val_if_fail (instance != NULL, NULL);
	self = (GIsiCommGPDSHelper*) g_type_create_instance (object_type);
	_tmp0_ = instance;
	_tmp1_ = _gisi_comm_abstract_base_client_ref0 (_tmp0_);
	_gisi_comm_abstract_base_client_unref0 (self->instance);
	self->instance = _tmp1_;
	_tmp2_ = cb;
	_tmp2__target = cb_target;
	(self->cb_target_destroy_notify == NULL) ? NULL : (self->cb_target_destroy_notify (self->cb_target), NULL);
	self->cb = NULL;
	self->cb_target = NULL;
	self->cb_target_destroy_notify = NULL;
	self->cb = _tmp2_;
	self->cb_target = _tmp2__target;
	self->cb_target_destroy_notify = NULL;
	return self;
}


GIsiCommGPDSHelper* gisi_comm_gpds_helper_new (GIsiCommGPDS* instance, GSourceFunc cb, void* cb_target) {
	return gisi_comm_gpds_helper_construct (GISI_COMM_TYPE_GPDS_HELPER, instance, cb, cb_target);
}


static void gisi_comm_value_gpds_helper_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gisi_comm_value_gpds_helper_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gisi_comm_gpds_helper_unref (value->data[0].v_pointer);
	}
}


static void gisi_comm_value_gpds_helper_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gisi_comm_gpds_helper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gisi_comm_value_gpds_helper_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gisi_comm_value_gpds_helper_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GIsiCommGPDSHelper* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gisi_comm_gpds_helper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gisi_comm_value_gpds_helper_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GIsiCommGPDSHelper** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gisi_comm_gpds_helper_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gisi_comm_param_spec_gpds_helper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GIsiCommParamSpecGPDSHelper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GISI_COMM_TYPE_GPDS_HELPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gisi_comm_value_get_gpds_helper (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GISI_COMM_TYPE_GPDS_HELPER), NULL);
	return value->data[0].v_pointer;
}


void gisi_comm_value_set_gpds_helper (GValue* value, gpointer v_object) {
	GIsiCommGPDSHelper* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GISI_COMM_TYPE_GPDS_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GISI_COMM_TYPE_GPDS_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gisi_comm_gpds_helper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gisi_comm_gpds_helper_unref (old);
	}
}


void gisi_comm_value_take_gpds_helper (GValue* value, gpointer v_object) {
	GIsiCommGPDSHelper* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GISI_COMM_TYPE_GPDS_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GISI_COMM_TYPE_GPDS_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gisi_comm_gpds_helper_unref (old);
	}
}


static void gisi_comm_gpds_helper_class_init (GIsiCommGPDSHelperClass * klass) {
	gisi_comm_gpds_helper_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_GPDS_HELPER_CLASS (klass)->finalize = gisi_comm_gpds_helper_finalize;
}


static void gisi_comm_gpds_helper_instance_init (GIsiCommGPDSHelper * self) {
	self->ref_count = 1;
}


static void gisi_comm_gpds_helper_finalize (GIsiCommGPDSHelper* obj) {
	GIsiCommGPDSHelper * self;
	self = GISI_COMM_GPDS_HELPER (obj);
	_gisi_comm_abstract_base_client_unref0 (self->instance);
	(self->cb_target_destroy_notify == NULL) ? NULL : (self->cb_target_destroy_notify (self->cb_target), NULL);
	self->cb = NULL;
	self->cb_target = NULL;
	self->cb_target_destroy_notify = NULL;
}


GType gisi_comm_gpds_helper_get_type (void) {
	static volatile gsize gisi_comm_gpds_helper_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_gpds_helper_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gisi_comm_value_gpds_helper_init, gisi_comm_value_gpds_helper_free_value, gisi_comm_value_gpds_helper_copy_value, gisi_comm_value_gpds_helper_peek_pointer, "p", gisi_comm_value_gpds_helper_collect_value, "p", gisi_comm_value_gpds_helper_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommGPDSHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_gpds_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommGPDSHelper), 0, (GInstanceInitFunc) gisi_comm_gpds_helper_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gisi_comm_gpds_helper_type_id;
		gisi_comm_gpds_helper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GIsiCommGPDSHelper", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gisi_comm_gpds_helper_type_id__volatile, gisi_comm_gpds_helper_type_id);
	}
	return gisi_comm_gpds_helper_type_id__volatile;
}


gpointer gisi_comm_gpds_helper_ref (gpointer instance) {
	GIsiCommGPDSHelper* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gisi_comm_gpds_helper_unref (gpointer instance) {
	GIsiCommGPDSHelper* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GISI_COMM_GPDS_HELPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _gisi_comm_gpds_helper_ref0 (gpointer self) {
	return self ? gisi_comm_gpds_helper_ref (self) : NULL;
}


static void gisi_comm_gpds_onPipeCreated (GIsiPipe* p) {
	GIsiPipe* _tmp0_;
	void* _tmp1_ = NULL;
	GIsiCommGPDSHelper* _tmp2_;
	GIsiCommGPDSHelper* helper;
	GSourceFunc _tmp3_;
	void* _tmp3__target;
	g_return_if_fail (p != NULL);
	g_debug ("gisicomm.vala:1712: on pipe created");
	_tmp0_ = p;
	_tmp1_ = g_isi_pipe_get_userdata (_tmp0_);
	_tmp2_ = _gisi_comm_gpds_helper_ref0 (GISI_COMM_GPDS_HELPER (_tmp1_));
	helper = _tmp2_;
	_tmp3_ = helper->cb;
	_tmp3__target = helper->cb_target;
	_tmp3_ (_tmp3__target);
	_gisi_comm_gpds_helper_unref0 (helper);
}


static GIsiClient* g_isi_modem_gpds_client_create (GIsiModem* self) {
	GIsiClient* result = NULL;
	GIsiClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_isi_client_create (self, PN_GPDS);
	result = (GIsiClient*) _tmp0_;
	return result;
}


GIsiCommGPDS* gisi_comm_gpds_construct (GType object_type, GIsiModem* modem) {
	GIsiCommGPDS* self = NULL;
	GIsiModem* _tmp0_;
	GIsiClient* _tmp1_ = NULL;
	GIsiClient* _tmp2_;
	g_return_val_if_fail (modem != NULL, NULL);
	self = (GIsiCommGPDS*) gisi_comm_abstract_base_client_construct (object_type);
	_tmp0_ = modem;
	_tmp1_ = g_isi_modem_gpds_client_create (_tmp0_);
	_g_isi_client_destroy0 (self->priv->ll);
	self->priv->ll = _tmp1_;
	_tmp2_ = self->priv->ll;
	((GIsiCommAbstractBaseClient*) self)->client = _tmp2_;
	return self;
}


GIsiCommGPDS* gisi_comm_gpds_new (GIsiModem* modem) {
	return gisi_comm_gpds_construct (GISI_COMM_TYPE_GPDS, modem);
}


static void _gisi_comm_gpds_onDetachIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_gpds_onDetachIndicationReceived (self, msg);
}


static void _gisi_comm_gpds_onTransferStatusIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_gpds_onTransferStatusIndicationReceived (self, msg);
}


static void _gisi_comm_gpds_onContextActivateIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_gpds_onContextActivateIndicationReceived (self, msg);
}


static void _gisi_comm_gpds_onContextDeactivateIndicationReceived_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_gpds_onContextDeactivateIndicationReceived (self, msg);
}


static void gisi_comm_gpds_real_onSubsystemIsReachable (GIsiCommAbstractBaseClient* base) {
	GIsiCommGPDS * self;
	GIsiClient* _tmp0_;
	GIsiClient* _tmp1_;
	GIsiClient* _tmp2_;
	GIsiClient* _tmp3_;
	self = (GIsiCommGPDS*) base;
	_tmp0_ = self->priv->ll;
	g_isi_client_ind_subscribe (_tmp0_, (guchar) GPDS_DETACH_IND, _gisi_comm_gpds_onDetachIndicationReceived_gisi_notify_func, self);
	_tmp1_ = self->priv->ll;
	g_isi_client_ind_subscribe (_tmp1_, (guchar) GPDS_TRANSFER_STATUS_IND, _gisi_comm_gpds_onTransferStatusIndicationReceived_gisi_notify_func, self);
	_tmp2_ = self->priv->ll;
	g_isi_client_ind_subscribe (_tmp2_, (guchar) GPDS_CONTEXT_ACTIVATE_IND, _gisi_comm_gpds_onContextActivateIndicationReceived_gisi_notify_func, self);
	_tmp3_ = self->priv->ll;
	g_isi_client_ind_subscribe (_tmp3_, (guchar) GPDS_CONTEXT_DEACTIVATE_IND, _gisi_comm_gpds_onContextDeactivateIndicationReceived_gisi_notify_func, self);
}


static void gisi_comm_gpds_activate_data_free (gpointer _data) {
	GisiCommGpdsActivateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->apn);
	_g_free0 (_data_->user);
	_g_free0 (_data_->pw);
	_gisi_comm_abstract_base_client_unref0 (_data_->self);
	g_slice_free (GisiCommGpdsActivateData, _data_);
}


void gisi_comm_gpds_activate (GIsiCommGPDS* self, const gchar* apn, const gchar* user, const gchar* pw, GIsiCommVoidResultFunc cb, void* cb_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GisiCommGpdsActivateData* _data_;
	GIsiCommGPDS* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GIsiCommVoidResultFunc _tmp7_;
	void* _tmp7__target;
	_data_ = g_slice_new0 (GisiCommGpdsActivateData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, gisi_comm_gpds_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gisi_comm_gpds_activate_data_free);
	_tmp0_ = _gisi_comm_abstract_base_client_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = apn;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->apn = _tmp2_;
	_tmp3_ = user;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->user = _tmp4_;
	_tmp5_ = pw;
	_tmp6_ = g_strdup (_tmp5_);
	_data_->pw = _tmp6_;
	_tmp7_ = cb;
	_tmp7__target = cb_target;
	_data_->cb = _tmp7_;
	_data_->cb_target = _tmp7__target;
	gisi_comm_gpds_activate_co (_data_);
}


void gisi_comm_gpds_activate_finish (GIsiCommGPDS* self, GAsyncResult* _res_) {
	GisiCommGpdsActivateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block30Data* block30_data_ref (Block30Data* _data30_) {
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}


static void block30_data_unref (Block30Data* _data30_) {
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data30_->self);
		g_slice_free (Block30Data, _data30_);
	}
}


static void __lambda30_ (GIsiCommGPDS* self, GIsiPEP* p) {
	g_return_if_fail (p != NULL);
}


static void ___lambda30__gisi_pep_callback (GIsiPEP* pep, gpointer self) {
	__lambda30_ (self, pep);
}


static void _gisi_comm_gpds_onPipeCreated_gisi_pipe_handler (GIsiPipe* pipe) {
	gisi_comm_gpds_onPipeCreated (pipe);
}


static gboolean _gisi_comm_gpds_activate_co_gsource_func (gpointer self) {
	gboolean result;
	result = gisi_comm_gpds_activate_co (self);
	return result;
}


static void __lambda31_ (Block30Data* _data30_, GIsiMessage* msg) {
	GIsiCommGPDS * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GIsiMessage* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8 _tmp6_;
	self = _data30_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommVoidResultFunc _tmp2_;
		void* _tmp2__target;
		g_warning ("gisicomm.vala:1776: could not create GPRS context ID");
		_tmp2_ = _data30_->cb;
		_tmp2__target = _data30_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _tmp2__target);
		_data30_->ok = FALSE;
	}
	_tmp3_ = msg;
	_tmp4_ = g_isi_msg_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = _tmp5_[0];
	self->priv->ctxid = _tmp6_;
	gisi_comm_gpds_activate_co (_data30_->_async_data_);
}


static void ___lambda31__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda31_ (self, msg);
}


static void __lambda32_ (Block30Data* _data30_, GIsiMessage* msg) {
	GIsiCommGPDS * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = _data30_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommVoidResultFunc _tmp2_;
		void* _tmp2__target;
		g_warning ("gisicomm.vala:1797: could not configure GPRS PPP mode");
		_data30_->ok = FALSE;
		_tmp2_ = _data30_->cb;
		_tmp2__target = _data30_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _tmp2__target);
	}
	gisi_comm_gpds_activate_co (_data30_->_async_data_);
}


static void ___lambda32__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda32_ (self, msg);
}


static void __lambda33_ (Block30Data* _data30_, GIsiMessage* msg) {
	GIsiCommGPDS * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = _data30_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommVoidResultFunc _tmp2_;
		void* _tmp2__target;
		g_warning ("gisicomm.vala:1836: could not configure GPRS context");
		_tmp2_ = _data30_->cb;
		_tmp2__target = _data30_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _tmp2__target);
		_data30_->ok = FALSE;
	}
	gisi_comm_gpds_activate_co (_data30_->_async_data_);
}


static void ___lambda33__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda33_ (self, msg);
}


static void ___lambda34_ (Block30Data* _data30_, GIsiMessage* msg) {
	GIsiCommGPDS * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = _data30_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommVoidResultFunc _tmp2_;
		void* _tmp2__target;
		g_warning ("gisicomm.vala:1889: could not configure GPRS user and password");
		_tmp2_ = _data30_->cb;
		_tmp2__target = _data30_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _tmp2__target);
		_data30_->ok = FALSE;
	}
	gisi_comm_gpds_activate_co (_data30_->_async_data_);
}


static void ____lambda34__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	___lambda34_ (self, msg);
}


static void __lambda35_ (Block30Data* _data30_, GIsiMessage* msg) {
	GIsiCommGPDS * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = _data30_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		GIsiCommVoidResultFunc _tmp2_;
		void* _tmp2__target;
		g_warning ("gisicomm.vala:1911: could not activate context");
		_tmp2_ = _data30_->cb;
		_tmp2__target = _data30_->cb_target;
		_tmp2_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _tmp2__target);
		_data30_->ok = FALSE;
	}
	gisi_comm_gpds_activate_co (_data30_->_async_data_);
}


static void ___lambda35__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda35_ (self, msg);
}


static gboolean gisi_comm_gpds_activate_co (GisiCommGpdsActivateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data30_ = g_slice_new0 (Block30Data);
	_data_->_data30_->_ref_count_ = 1;
	_data_->_data30_->self = gisi_comm_abstract_base_client_ref (_data_->self);
	_data_->_tmp0_ = _data_->cb;
	_data_->_tmp0__target = _data_->cb_target;
	_data_->_data30_->cb = _data_->_tmp0_;
	_data_->_data30_->cb_target = _data_->_tmp0__target;
	_data_->_data30_->_async_data_ = _data_;
	_data_->_tmp1_ = _data_->self->priv->ll;
	_data_->_tmp2_ = g_isi_client_modem (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_isi_pep_create (_data_->_tmp3_, ___lambda30__gisi_pep_callback, _data_->self);
	_g_isi_pep_destroy0 (_data_->self->priv->pep);
	_data_->self->priv->pep = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->pep;
	if (_data_->_tmp5_ == NULL) {
		g_warning ("gisicomm.vala:1754: failed to create ISI PEP");
		_data_->_tmp6_ = _data_->_data30_->cb;
		_data_->_tmp6__target = _data_->_data30_->cb_target;
		_data_->_tmp6_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _data_->_tmp6__target);
		block30_data_unref (_data_->_data30_);
		_data_->_data30_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->self->priv->ll;
	_data_->_tmp8_ = g_isi_client_modem (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->self->priv->pep;
	_data_->_tmp11_ = 0U;
	_data_->_tmp11_ = g_isi_pep_get_object (_data_->_tmp10_);
	_data_->_tmp12_ = ((GIsiCommAbstractBaseClient*) _data_->self)->isiobj;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = g_isi_pipe_create (_data_->_tmp9_, _gisi_comm_gpds_onPipeCreated_gisi_pipe_handler, _data_->_tmp11_, _data_->_tmp12_, (guchar) 0x04, (guchar) 0x04);
	_g_isi_pipe_destroy0 (_data_->self->priv->pipe);
	_data_->self->priv->pipe = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->self->priv->pipe;
	if (_data_->_tmp14_ == NULL) {
		g_warning ("gisicomm.vala:1762: failed to create ISI Pipe");
		_data_->_tmp15_ = _data_->_data30_->cb;
		_data_->_tmp15__target = _data_->_data30_->cb_target;
		_data_->_tmp15_ (GISI_COMM_ERROR_CODE_INVALID_FORMAT, _data_->_tmp15__target);
		block30_data_unref (_data_->_data30_);
		_data_->_data30_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp16_ = _data_->self->priv->pipe;
	_data_->_tmp17_ = gisi_comm_gpds_helper_new (_data_->self, _gisi_comm_gpds_activate_co_gsource_func, _data_);
	_gisi_comm_gpds_helper_unref0 (_data_->self->priv->helper);
	_data_->self->priv->helper = _data_->_tmp17_;
	_data_->_tmp18_ = _data_->self->priv->helper;
	g_isi_pipe_set_userdata (_data_->_tmp16_, _data_->_tmp18_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_gisi_comm_gpds_helper_unref0 (_data_->self->priv->helper);
	_data_->self->priv->helper = NULL;
	_data_->_data30_->ok = TRUE;
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = g_new0 (guint8, 1);
	_data_->_tmp19_[0] = GPDS_CONTEXT_ID_CREATE_REQ;
	_data_->req1 = _data_->_tmp19_;
	_data_->req1_length1 = 1;
	_data_->_req1_size_ = _data_->req1_length1;
	_data_->_tmp20_ = _data_->self->priv->ll;
	_data_->_tmp21_ = _data_->req1;
	_data_->_tmp21__length1 = _data_->req1_length1;
	g_isi_client_send (_data_->_tmp20_, _data_->_tmp21_, _data_->_tmp21__length1, ___lambda31__gisi_notify_func, block30_data_ref (_data_->_data30_), block30_data_unref);
	_data_->_state_ = 2;
	return FALSE;
	_state_2:
	;
	_data_->_tmp22_ = _data_->_data30_->ok;
	if (!_data_->_tmp22_) {
		_data_->req1 = (g_free (_data_->req1), NULL);
		block30_data_unref (_data_->_data30_);
		_data_->_data30_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp23_ = _data_->self->priv->ctxid;
	_data_->_tmp24_ = _data_->self->priv->pipe;
	_data_->_tmp25_ = '\0';
	_data_->_tmp25_ = g_isi_pipe_get_handle (_data_->_tmp24_);
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = g_new0 (guint8, 4);
	_data_->_tmp26_[0] = GPDS_LL_CONFIGURE_REQ;
	_data_->_tmp26_[1] = _data_->_tmp23_;
	_data_->_tmp26_[2] = (guint8) _data_->_tmp25_;
	_data_->_tmp26_[3] = GPDS_LL_PLAIN;
	_data_->req2 = _data_->_tmp26_;
	_data_->req2_length1 = 4;
	_data_->_req2_size_ = _data_->req2_length1;
	_data_->_tmp27_ = _data_->self->priv->ll;
	_data_->_tmp28_ = _data_->req2;
	_data_->_tmp28__length1 = _data_->req2_length1;
	g_isi_client_send (_data_->_tmp27_, _data_->_tmp28_, _data_->_tmp28__length1, ___lambda32__gisi_notify_func, block30_data_ref (_data_->_data30_), block30_data_unref);
	_data_->_state_ = 3;
	return FALSE;
	_state_3:
	;
	_data_->_tmp29_ = _data_->_data30_->ok;
	if (!_data_->_tmp29_) {
		_data_->req2 = (g_free (_data_->req2), NULL);
		_data_->req1 = (g_free (_data_->req1), NULL);
		block30_data_unref (_data_->_data30_);
		_data_->_data30_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp30_ = _data_->self->priv->ctxid;
	_data_->_tmp31_ = _data_->self->priv->ctxid;
	_data_->_tmp32_ = _data_->apn;
	_data_->_tmp33_ = strlen (_data_->_tmp32_);
	_data_->_tmp34_ = _data_->_tmp33_;
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = g_new0 (guint8, 54);
	_data_->_tmp35_[0] = GPDS_CONTEXT_CONFIGURE_REQ;
	_data_->_tmp35_[1] = _data_->_tmp30_;
	_data_->_tmp35_[2] = GPDS_PDP_TYPE_IPV4;
	_data_->_tmp35_[3] = GPDS_CONT_TYPE_NORMAL;
	_data_->_tmp35_[4] = _data_->_tmp31_;
	_data_->_tmp35_[5] = (guint8) 0x00;
	_data_->_tmp35_[6] = (guint8) 2;
	_data_->_tmp35_[7] = GPDS_DNS_ADDRESS_REQ_INFO;
	_data_->_tmp35_[8] = (guint8) 4;
	_data_->_tmp35_[9] = (guint8) 0;
	_data_->_tmp35_[10] = (guint8) 0;
	_data_->_tmp35_[11] = GPDS_APN_INFO;
	_data_->_tmp35_[12] = (guint8) 43;
	_data_->_tmp35_[13] = (guint8) _data_->_tmp34_;
	_data_->_tmp35_[14] = (guint8) 0x0;
	_data_->_tmp35_[15] = (guint8) 0x0;
	_data_->_tmp35_[16] = (guint8) 0x0;
	_data_->_tmp35_[17] = (guint8) 0x0;
	_data_->_tmp35_[18] = (guint8) 0x0;
	_data_->_tmp35_[19] = (guint8) 0x0;
	_data_->_tmp35_[20] = (guint8) 0x0;
	_data_->_tmp35_[21] = (guint8) 0x0;
	_data_->_tmp35_[22] = (guint8) 0x0;
	_data_->_tmp35_[23] = (guint8) 0x0;
	_data_->_tmp35_[24] = (guint8) 0x0;
	_data_->_tmp35_[25] = (guint8) 0x0;
	_data_->_tmp35_[26] = (guint8) 0x0;
	_data_->_tmp35_[27] = (guint8) 0x0;
	_data_->_tmp35_[28] = (guint8) 0x0;
	_data_->_tmp35_[29] = (guint8) 0x0;
	_data_->_tmp35_[30] = (guint8) 0x0;
	_data_->_tmp35_[31] = (guint8) 0x0;
	_data_->_tmp35_[32] = (guint8) 0x0;
	_data_->_tmp35_[33] = (guint8) 0x0;
	_data_->_tmp35_[34] = (guint8) 0x0;
	_data_->_tmp35_[35] = (guint8) 0x0;
	_data_->_tmp35_[36] = (guint8) 0x0;
	_data_->_tmp35_[37] = (guint8) 0x0;
	_data_->_tmp35_[38] = (guint8) 0x0;
	_data_->_tmp35_[39] = (guint8) 0x0;
	_data_->_tmp35_[40] = (guint8) 0x0;
	_data_->_tmp35_[41] = (guint8) 0x0;
	_data_->_tmp35_[42] = (guint8) 0x0;
	_data_->_tmp35_[43] = (guint8) 0x0;
	_data_->_tmp35_[44] = (guint8) 0x0;
	_data_->_tmp35_[45] = (guint8) 0x0;
	_data_->_tmp35_[46] = (guint8) 0x0;
	_data_->_tmp35_[47] = (guint8) 0x0;
	_data_->_tmp35_[48] = (guint8) 0x0;
	_data_->_tmp35_[49] = (guint8) 0x0;
	_data_->_tmp35_[50] = (guint8) 0x0;
	_data_->_tmp35_[51] = (guint8) 0x0;
	_data_->_tmp35_[52] = (guint8) 0x0;
	_data_->_tmp35_[53] = (guint8) 0x0;
	_data_->req3 = _data_->_tmp35_;
	_data_->req3_length1 = 54;
	_data_->_req3_size_ = _data_->req3_length1;
	{
		_data_->i = 0;
		{
			_data_->_tmp36_ = TRUE;
			while (TRUE) {
				_data_->_tmp37_ = _data_->_tmp36_;
				if (!_data_->_tmp37_) {
					_data_->_tmp38_ = _data_->i;
					_data_->i = _data_->_tmp38_ + 1;
				}
				_data_->_tmp36_ = FALSE;
				_data_->_tmp39_ = _data_->i;
				_data_->_tmp40_ = _data_->apn;
				_data_->_tmp41_ = strlen (_data_->_tmp40_);
				_data_->_tmp42_ = _data_->_tmp41_;
				if (!(_data_->_tmp39_ < _data_->_tmp42_)) {
					break;
				}
				_data_->_tmp43_ = _data_->req3;
				_data_->_tmp43__length1 = _data_->req3_length1;
				_data_->_tmp44_ = _data_->i;
				_data_->_tmp45_ = _data_->apn;
				_data_->_tmp46_ = _data_->i;
				_data_->_tmp47_ = '\0';
				_data_->_tmp47_ = string_get (_data_->_tmp45_, (glong) _data_->_tmp46_);
				_data_->_tmp43_[14 + _data_->_tmp44_] = (guint8) _data_->_tmp47_;
				_data_->_tmp48_ = _data_->_tmp43_[14 + _data_->_tmp44_];
			}
		}
	}
	_data_->_tmp49_ = _data_->self->priv->ll;
	_data_->_tmp50_ = _data_->req3;
	_data_->_tmp50__length1 = _data_->req3_length1;
	g_isi_client_send (_data_->_tmp49_, _data_->_tmp50_, _data_->_tmp50__length1, ___lambda33__gisi_notify_func, block30_data_ref (_data_->_data30_), block30_data_unref);
	_data_->_state_ = 4;
	return FALSE;
	_state_4:
	;
	_data_->_tmp51_ = _data_->_data30_->ok;
	if (!_data_->_tmp51_) {
		_data_->req3 = (g_free (_data_->req3), NULL);
		_data_->req2 = (g_free (_data_->req2), NULL);
		_data_->req1 = (g_free (_data_->req1), NULL);
		block30_data_unref (_data_->_data30_);
		_data_->_data30_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp53_ = _data_->user;
	if (_data_->_tmp53_ != NULL) {
		_data_->_tmp54_ = _data_->pw;
		_data_->_tmp52_ = _data_->_tmp54_ != NULL;
	} else {
		_data_->_tmp52_ = FALSE;
	}
	_data_->_tmp55_ = _data_->_tmp52_;
	if (_data_->_tmp55_) {
		_data_->_tmp56_ = _data_->user;
		_data_->_tmp57_ = strlen (_data_->_tmp56_);
		_data_->_tmp58_ = _data_->_tmp57_;
		_data_->_tmp59_ = 0U;
		_data_->_tmp59_ = gisi_comm_abstract_base_client_align4 ((GIsiCommAbstractBaseClient*) _data_->self, (guint8) (3 + _data_->_tmp58_));
		_data_->sb_userinfo_len = _data_->_tmp59_;
		_data_->_tmp60_ = _data_->sb_userinfo_len;
		_data_->_tmp61_ = _data_->user;
		_data_->_tmp62_ = strlen (_data_->_tmp61_);
		_data_->_tmp63_ = _data_->_tmp62_;
		_data_->userinfo_pad_len = (guint8) (_data_->_tmp60_ - (3 + _data_->_tmp63_));
		_data_->_tmp64_ = _data_->pw;
		_data_->_tmp65_ = strlen (_data_->_tmp64_);
		_data_->_tmp66_ = _data_->_tmp65_;
		_data_->_tmp67_ = 0U;
		_data_->_tmp67_ = gisi_comm_abstract_base_client_align4 ((GIsiCommAbstractBaseClient*) _data_->self, (guint8) (3 + _data_->_tmp66_));
		_data_->sb_password_info_len = _data_->_tmp67_;
		_data_->_tmp68_ = _data_->sb_password_info_len;
		_data_->_tmp69_ = _data_->pw;
		_data_->_tmp70_ = strlen (_data_->_tmp69_);
		_data_->_tmp71_ = _data_->_tmp70_;
		_data_->password_pad_len = (guint8) (_data_->_tmp68_ - (3 + _data_->_tmp71_));
		_data_->_tmp72_ = NULL;
		_data_->_tmp72_ = g_new0 (guint8, 4);
		_data_->_tmp72_[0] = (guint8) 0x00;
		_data_->_tmp72_[1] = (guint8) 0x00;
		_data_->_tmp72_[2] = (guint8) 0x00;
		_data_->_tmp72_[3] = (guint8) 0x00;
		_data_->pad = _data_->_tmp72_;
		_data_->pad_length1 = 4;
		_data_->_pad_size_ = _data_->pad_length1;
		_data_->_tmp73_ = _data_->self->priv->ctxid;
		_data_->_tmp74_ = _data_->sb_userinfo_len;
		_data_->_tmp75_ = _data_->user;
		_data_->_tmp76_ = strlen (_data_->_tmp75_);
		_data_->_tmp77_ = _data_->_tmp76_;
		_data_->_tmp78_ = NULL;
		_data_->_tmp78_ = g_new0 (guint8, 6);
		_data_->_tmp78_[0] = GPDS_CONTEXT_AUTH_REQ;
		_data_->_tmp78_[1] = _data_->_tmp73_;
		_data_->_tmp78_[2] = (guint8) 2;
		_data_->_tmp78_[3] = GPDS_USER_NAME_INFO;
		_data_->_tmp78_[4] = _data_->_tmp74_;
		_data_->_tmp78_[5] = (guint8) _data_->_tmp77_;
		_data_->top = _data_->_tmp78_;
		_data_->top_length1 = 6;
		_data_->_top_size_ = _data_->top_length1;
		_data_->_tmp79_ = _data_->sb_password_info_len;
		_data_->_tmp80_ = _data_->pw;
		_data_->_tmp81_ = strlen (_data_->_tmp80_);
		_data_->_tmp82_ = _data_->_tmp81_;
		_data_->_tmp83_ = NULL;
		_data_->_tmp83_ = g_new0 (guint8, 3);
		_data_->_tmp83_[0] = GPDS_PASSWORD_INFO;
		_data_->_tmp83_[1] = _data_->_tmp79_;
		_data_->_tmp83_[2] = (guint8) _data_->_tmp82_;
		_data_->bottom = _data_->_tmp83_;
		_data_->bottom_length1 = 3;
		_data_->_bottom_size_ = _data_->bottom_length1;
		_data_->_tmp84_ = NULL;
		_data_->_tmp84_ = g_new0 (struct iovec, 6);
		_data_->iov2 = _data_->_tmp84_;
		_data_->iov2_length1 = 6;
		_data_->_iov2_size_ = _data_->iov2_length1;
		_data_->_tmp85_ = _data_->iov2;
		_data_->_tmp85__length1 = _data_->iov2_length1;
		_data_->_tmp86_ = _data_->top;
		_data_->_tmp86__length1 = _data_->top_length1;
		_data_->_tmp87_ = _data_->top;
		_data_->_tmp87__length1 = _data_->top_length1;
		memset (&_data_->_tmp88_, 0, sizeof (struct iovec));
		_data_->_tmp88_.iov_base = _data_->_tmp86_;
		_data_->_tmp88_.iov_len = (gsize) _data_->_tmp87__length1;
		_data_->_tmp85_[0] = _data_->_tmp88_;
		_data_->_tmp89_ = _data_->_tmp85_[0];
		_data_->_tmp90_ = _data_->iov2;
		_data_->_tmp90__length1 = _data_->iov2_length1;
		_data_->_tmp91_ = _data_->user;
		_data_->_tmp92_ = _data_->user;
		_data_->_tmp93_ = strlen (_data_->_tmp92_);
		_data_->_tmp94_ = _data_->_tmp93_;
		memset (&_data_->_tmp95_, 0, sizeof (struct iovec));
		_data_->_tmp95_.iov_base = _data_->_tmp91_;
		_data_->_tmp95_.iov_len = (gsize) _data_->_tmp94_;
		_data_->_tmp90_[1] = _data_->_tmp95_;
		_data_->_tmp96_ = _data_->_tmp90_[1];
		_data_->_tmp97_ = _data_->iov2;
		_data_->_tmp97__length1 = _data_->iov2_length1;
		_data_->_tmp98_ = _data_->pad;
		_data_->_tmp98__length1 = _data_->pad_length1;
		_data_->_tmp99_ = _data_->userinfo_pad_len;
		memset (&_data_->_tmp100_, 0, sizeof (struct iovec));
		_data_->_tmp100_.iov_base = _data_->_tmp98_;
		_data_->_tmp100_.iov_len = (gsize) _data_->_tmp99_;
		_data_->_tmp97_[2] = _data_->_tmp100_;
		_data_->_tmp101_ = _data_->_tmp97_[2];
		_data_->_tmp102_ = _data_->iov2;
		_data_->_tmp102__length1 = _data_->iov2_length1;
		_data_->_tmp103_ = _data_->bottom;
		_data_->_tmp103__length1 = _data_->bottom_length1;
		_data_->_tmp104_ = _data_->bottom;
		_data_->_tmp104__length1 = _data_->bottom_length1;
		memset (&_data_->_tmp105_, 0, sizeof (struct iovec));
		_data_->_tmp105_.iov_base = _data_->_tmp103_;
		_data_->_tmp105_.iov_len = (gsize) _data_->_tmp104__length1;
		_data_->_tmp102_[3] = _data_->_tmp105_;
		_data_->_tmp106_ = _data_->_tmp102_[3];
		_data_->_tmp107_ = _data_->iov2;
		_data_->_tmp107__length1 = _data_->iov2_length1;
		_data_->_tmp108_ = _data_->pw;
		_data_->_tmp109_ = _data_->pw;
		_data_->_tmp110_ = strlen (_data_->_tmp109_);
		_data_->_tmp111_ = _data_->_tmp110_;
		memset (&_data_->_tmp112_, 0, sizeof (struct iovec));
		_data_->_tmp112_.iov_base = _data_->_tmp108_;
		_data_->_tmp112_.iov_len = (gsize) _data_->_tmp111_;
		_data_->_tmp107_[4] = _data_->_tmp112_;
		_data_->_tmp113_ = _data_->_tmp107_[4];
		_data_->_tmp114_ = _data_->iov2;
		_data_->_tmp114__length1 = _data_->iov2_length1;
		_data_->_tmp115_ = _data_->pad;
		_data_->_tmp115__length1 = _data_->pad_length1;
		_data_->_tmp116_ = _data_->password_pad_len;
		memset (&_data_->_tmp117_, 0, sizeof (struct iovec));
		_data_->_tmp117_.iov_base = _data_->_tmp115_;
		_data_->_tmp117_.iov_len = (gsize) _data_->_tmp116_;
		_data_->_tmp114_[5] = _data_->_tmp117_;
		_data_->_tmp118_ = _data_->_tmp114_[5];
		_data_->_tmp119_ = _data_->self->priv->ll;
		_data_->_tmp120_ = _data_->iov2;
		_data_->_tmp120__length1 = _data_->iov2_length1;
		g_isi_client_vsend (_data_->_tmp119_, _data_->_tmp120_, _data_->_tmp120__length1, ____lambda34__gisi_notify_func, block30_data_ref (_data_->_data30_), block30_data_unref);
		_data_->_state_ = 5;
		return FALSE;
		_state_5:
		;
		_data_->iov2 = (g_free (_data_->iov2), NULL);
		_data_->bottom = (g_free (_data_->bottom), NULL);
		_data_->top = (g_free (_data_->top), NULL);
		_data_->pad = (g_free (_data_->pad), NULL);
	}
	_data_->_tmp121_ = _data_->_data30_->ok;
	if (!_data_->_tmp121_) {
		_data_->req3 = (g_free (_data_->req3), NULL);
		_data_->req2 = (g_free (_data_->req2), NULL);
		_data_->req1 = (g_free (_data_->req1), NULL);
		block30_data_unref (_data_->_data30_);
		_data_->_data30_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp122_ = _data_->self->priv->ctxid;
	_data_->_tmp123_ = NULL;
	_data_->_tmp123_ = g_new0 (guint8, 3);
	_data_->_tmp123_[0] = GPDS_CONTEXT_ACTIVATE_REQ;
	_data_->_tmp123_[1] = _data_->_tmp122_;
	_data_->_tmp123_[2] = (guint8) 0;
	_data_->req4 = _data_->_tmp123_;
	_data_->req4_length1 = 3;
	_data_->_req4_size_ = _data_->req4_length1;
	_data_->_tmp124_ = _data_->self->priv->ll;
	_data_->_tmp125_ = _data_->req4;
	_data_->_tmp125__length1 = _data_->req4_length1;
	g_isi_client_send (_data_->_tmp124_, _data_->_tmp125_, _data_->_tmp125__length1, ___lambda35__gisi_notify_func, block30_data_ref (_data_->_data30_), block30_data_unref);
	_data_->_state_ = 6;
	return FALSE;
	_state_6:
	;
	_data_->_tmp126_ = _data_->_data30_->ok;
	if (_data_->_tmp126_) {
		_data_->_tmp127_ = _data_->self->priv->pipe;
		g_isi_pipe_start (_data_->_tmp127_);
		_data_->_tmp128_ = _data_->_data30_->cb;
		_data_->_tmp128__target = _data_->_data30_->cb_target;
		_data_->_tmp128_ (GISI_COMM_ERROR_CODE_OK, _data_->_tmp128__target);
	}
	_data_->req4 = (g_free (_data_->req4), NULL);
	_data_->req3 = (g_free (_data_->req3), NULL);
	_data_->req2 = (g_free (_data_->req2), NULL);
	_data_->req1 = (g_free (_data_->req1), NULL);
	block30_data_unref (_data_->_data30_);
	_data_->_data30_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void gisi_comm_gpds_deactivate_data_free (gpointer _data) {
	GisiCommGpdsDeactivateData* _data_;
	_data_ = _data;
	_gisi_comm_abstract_base_client_unref0 (_data_->self);
	g_slice_free (GisiCommGpdsDeactivateData, _data_);
}


void gisi_comm_gpds_deactivate (GIsiCommGPDS* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GisiCommGpdsDeactivateData* _data_;
	GIsiCommGPDS* _tmp0_;
	_data_ = g_slice_new0 (GisiCommGpdsDeactivateData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, gisi_comm_gpds_deactivate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gisi_comm_gpds_deactivate_data_free);
	_tmp0_ = _gisi_comm_abstract_base_client_ref0 (self);
	_data_->self = _tmp0_;
	gisi_comm_gpds_deactivate_co (_data_);
}


void gisi_comm_gpds_deactivate_finish (GIsiCommGPDS* self, GAsyncResult* _res_) {
	GisiCommGpdsDeactivateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block31Data* block31_data_ref (Block31Data* _data31_) {
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}


static void block31_data_unref (Block31Data* _data31_) {
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		_gisi_comm_abstract_base_client_unref0 (_data31_->self);
		g_slice_free (Block31Data, _data31_);
	}
}


static void __lambda36_ (Block31Data* _data31_, GIsiMessage* msg) {
	GIsiCommGPDS * self;
	GIsiMessage* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = _data31_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_ok (_tmp0_);
	if (!_tmp1_) {
		gisi_comm_gpds_deactivate_co (_data31_->_async_data_);
		return;
	}
	gisi_comm_gpds_deactivate_co (_data31_->_async_data_);
}


static void ___lambda36__gisi_notify_func (GIsiMessage* msg, gpointer self) {
	__lambda36_ (self, msg);
}


static gboolean gisi_comm_gpds_deactivate_co (GisiCommGpdsDeactivateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data31_ = g_slice_new0 (Block31Data);
	_data_->_data31_->_ref_count_ = 1;
	_data_->_data31_->self = gisi_comm_abstract_base_client_ref (_data_->self);
	_data_->_data31_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->ctxid;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_new0 (guint8, 2);
	_data_->_tmp1_[0] = GPDS_CONTEXT_DEACTIVATE_REQ;
	_data_->_tmp1_[1] = _data_->_tmp0_;
	_data_->req = _data_->_tmp1_;
	_data_->req_length1 = 2;
	_data_->_req_size_ = _data_->req_length1;
	_data_->_tmp2_ = _data_->self->priv->ll;
	g_isi_client_send (_data_->_tmp2_, _data_->req, _data_->req_length1, ___lambda36__gisi_notify_func, block31_data_ref (_data_->_data31_), block31_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_g_isi_pipe_destroy0 (_data_->self->priv->pipe);
	_data_->self->priv->pipe = NULL;
	_g_isi_pep_destroy0 (_data_->self->priv->pep);
	_data_->self->priv->pep = NULL;
	_data_->req = (g_free (_data_->req), NULL);
	block31_data_unref (_data_->_data31_);
	_data_->_data31_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void gisi_comm_gpds_onContextActivateIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* ip_addr;
	gchar** _tmp5_ = NULL;
	gchar** dns;
	gint dns_length1;
	gint _dns_size_;
	const gchar* _tmp106_ = NULL;
	gchar** _tmp107_;
	gint _tmp107__length1;
	const gchar* _tmp110_ = NULL;
	gchar** _tmp111_;
	gint _tmp111__length1;
	const gchar* _tmp114_;
	const gchar* _tmp115_;
	const gchar* _tmp116_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:1953: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	ip_addr = NULL;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	dns = _tmp5_;
	dns_length1 = 0;
	_dns_size_ = dns_length1;
	{
		GIsiMessage* _tmp6_;
		GIsiSubBlockIter _tmp7_ = {0};
		GIsiSubBlockIter sbi;
		_tmp6_ = msg;
		g_isi_msg_subblock_iter_create (_tmp6_, (gsize) 2, &_tmp7_);
		sbi = _tmp7_;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gboolean _tmp10_ = FALSE;
				GIsiSubBlockIter _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				GIsiSubBlockIter _tmp16_;
				gsize _tmp17_;
				gsize _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				guint8 addr_length;
				void* addr_value;
				GIsiSubBlockIter _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					g_isi_sb_iter_next (&sbi);
				}
				_tmp8_ = FALSE;
				_tmp10_ = g_isi_sb_iter_is_valid (&sbi);
				if (!_tmp10_) {
					break;
				}
				_tmp11_ = sbi;
				_tmp12_ = g_isi_sb_iter_get_id (&_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strdup_printf ("%i", _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = sbi;
				_tmp17_ = g_isi_sb_iter_get_len (&_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strdup_printf ("%" G_GSIZE_FORMAT, _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strconcat ("Have subblock with ID ", _tmp15_, ", length ", _tmp20_, NULL);
				_tmp22_ = _tmp21_;
				g_message ("gisicomm.vala:1960: %s", _tmp22_);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp20_);
				_g_free0 (_tmp15_);
				addr_length = (guint8) 0;
				addr_value = NULL;
				_tmp23_ = sbi;
				_tmp24_ = g_isi_sb_iter_get_id (&_tmp23_);
				_tmp25_ = _tmp24_;
				switch (_tmp25_) {
					case GPDS_PDP_ADDRESS_INFO:
					{
						guchar _tmp26_ = '\0';
						gboolean _tmp27_ = FALSE;
						guint8 _tmp35_;
						gchar* _tmp36_ = NULL;
						gchar* _tmp37_;
						gchar* _tmp38_ = NULL;
						gchar* _tmp39_;
						void* _tmp40_ = NULL;
						gboolean _tmp41_ = FALSE;
						guint8 _tmp49_;
						_tmp27_ = g_isi_sb_iter_get_byte (&sbi, &_tmp26_, (guint) 3);
						addr_length = (guint8) _tmp26_;
						if (!_tmp27_) {
							GIsiSubBlockIter _tmp28_;
							gint _tmp29_;
							gint _tmp30_;
							gchar* _tmp31_ = NULL;
							gchar* _tmp32_;
							gchar* _tmp33_ = NULL;
							gchar* _tmp34_;
							_tmp28_ = sbi;
							_tmp29_ = g_isi_sb_iter_get_id (&_tmp28_);
							_tmp30_ = _tmp29_;
							_tmp31_ = g_strdup_printf ("%i", _tmp30_);
							_tmp32_ = _tmp31_;
							_tmp33_ = g_strconcat ("Failed to get length of address from subblock with ID ", _tmp32_, NULL);
							_tmp34_ = _tmp33_;
							g_warning ("gisicomm.vala:1970: %s", _tmp34_);
							_g_free0 (_tmp34_);
							_g_free0 (_tmp32_);
							continue;
						}
						_tmp35_ = addr_length;
						_tmp36_ = g_strdup_printf ("%hhu", _tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = g_strconcat ("addr_length = ", _tmp37_, NULL);
						_tmp39_ = _tmp38_;
						g_debug ("gisicomm.vala:1973: %s", _tmp39_);
						_g_free0 (_tmp39_);
						_g_free0 (_tmp37_);
						_tmp41_ = g_isi_sb_iter_get_data (&sbi, &_tmp40_, (guint) 4);
						addr_value = _tmp40_;
						if (!_tmp41_) {
							GIsiSubBlockIter _tmp42_;
							gint _tmp43_;
							gint _tmp44_;
							gchar* _tmp45_ = NULL;
							gchar* _tmp46_;
							gchar* _tmp47_ = NULL;
							gchar* _tmp48_;
							_tmp42_ = sbi;
							_tmp43_ = g_isi_sb_iter_get_id (&_tmp42_);
							_tmp44_ = _tmp43_;
							_tmp45_ = g_strdup_printf ("%i", _tmp44_);
							_tmp46_ = _tmp45_;
							_tmp47_ = g_strconcat ("Failed to get data of address from subblock with ID ", _tmp46_, NULL);
							_tmp48_ = _tmp47_;
							g_warning ("gisicomm.vala:1977: %s", _tmp48_);
							_g_free0 (_tmp48_);
							_g_free0 (_tmp46_);
							continue;
						}
						_tmp49_ = addr_length;
						if (((gint) _tmp49_) == 4) {
							guint8* _tmp50_ = NULL;
							guint8* dst;
							gint dst_length1;
							gint _dst_size_;
							void* _tmp51_;
							guint8* _tmp52_;
							gint _tmp52__length1;
							const gchar* _tmp53_ = NULL;
							gchar* _tmp54_;
							_tmp50_ = g_new0 (guint8, INET_ADDRSTRLEN);
							dst = _tmp50_;
							dst_length1 = INET_ADDRSTRLEN;
							_dst_size_ = dst_length1;
							_tmp51_ = addr_value;
							_tmp52_ = dst;
							_tmp52__length1 = dst_length1;
							_tmp53_ = inet_ntop (AF_INET, _tmp51_, _tmp52_, _tmp52__length1);
							_tmp54_ = g_strdup (_tmp53_);
							_g_free0 (ip_addr);
							ip_addr = _tmp54_;
							dst = (g_free (dst), NULL);
						} else {
							guint8 _tmp55_;
							_tmp55_ = addr_length;
							if (((gint) _tmp55_) == 16) {
								guint8* _tmp56_ = NULL;
								guint8* dst;
								gint dst_length1;
								gint _dst_size_;
								void* _tmp57_;
								guint8* _tmp58_;
								gint _tmp58__length1;
								const gchar* _tmp59_ = NULL;
								gchar* _tmp60_;
								_tmp56_ = g_new0 (guint8, INET6_ADDRSTRLEN);
								dst = _tmp56_;
								dst_length1 = INET6_ADDRSTRLEN;
								_dst_size_ = dst_length1;
								_tmp57_ = addr_value;
								_tmp58_ = dst;
								_tmp58__length1 = dst_length1;
								_tmp59_ = inet_ntop (AF_INET6, _tmp57_, _tmp58_, _tmp58__length1);
								_tmp60_ = g_strdup (_tmp59_);
								_g_free0 (ip_addr);
								ip_addr = _tmp60_;
								dst = (g_free (dst), NULL);
							}
						}
						break;
					}
					case GPDS_PDNS_ADDRESS_INFO:
					case GPDS_SDNS_ADDRESS_INFO:
					{
						gchar** _tmp61_;
						gint _tmp61__length1;
						guchar _tmp62_ = '\0';
						gboolean _tmp63_ = FALSE;
						guint8 _tmp71_;
						gchar* _tmp72_ = NULL;
						gchar* _tmp73_;
						gchar* _tmp74_ = NULL;
						gchar* _tmp75_;
						void* _tmp76_ = NULL;
						gboolean _tmp77_ = FALSE;
						guint8 _tmp85_;
						_tmp61_ = dns;
						_tmp61__length1 = dns_length1;
						if (_tmp61__length1 == 2) {
							g_warning ("gisicomm.vala:1997: Ignoring additional dns server");
							continue;
						}
						_tmp63_ = g_isi_sb_iter_get_byte (&sbi, &_tmp62_, (guint) 3);
						addr_length = (guint8) _tmp62_;
						if (!_tmp63_) {
							GIsiSubBlockIter _tmp64_;
							gint _tmp65_;
							gint _tmp66_;
							gchar* _tmp67_ = NULL;
							gchar* _tmp68_;
							gchar* _tmp69_ = NULL;
							gchar* _tmp70_;
							_tmp64_ = sbi;
							_tmp65_ = g_isi_sb_iter_get_id (&_tmp64_);
							_tmp66_ = _tmp65_;
							_tmp67_ = g_strdup_printf ("%i", _tmp66_);
							_tmp68_ = _tmp67_;
							_tmp69_ = g_strconcat ("Failed to get length of address from subblock with ID ", _tmp68_, NULL);
							_tmp70_ = _tmp69_;
							g_warning ("gisicomm.vala:2003: %s", _tmp70_);
							_g_free0 (_tmp70_);
							_g_free0 (_tmp68_);
							continue;
						}
						_tmp71_ = addr_length;
						_tmp72_ = g_strdup_printf ("%hhu", _tmp71_);
						_tmp73_ = _tmp72_;
						_tmp74_ = g_strconcat ("addr_length = ", _tmp73_, NULL);
						_tmp75_ = _tmp74_;
						g_debug ("gisicomm.vala:2006: %s", _tmp75_);
						_g_free0 (_tmp75_);
						_g_free0 (_tmp73_);
						_tmp77_ = g_isi_sb_iter_get_data (&sbi, &_tmp76_, (guint) 4);
						addr_value = _tmp76_;
						if (!_tmp77_) {
							GIsiSubBlockIter _tmp78_;
							gint _tmp79_;
							gint _tmp80_;
							gchar* _tmp81_ = NULL;
							gchar* _tmp82_;
							gchar* _tmp83_ = NULL;
							gchar* _tmp84_;
							_tmp78_ = sbi;
							_tmp79_ = g_isi_sb_iter_get_id (&_tmp78_);
							_tmp80_ = _tmp79_;
							_tmp81_ = g_strdup_printf ("%i", _tmp80_);
							_tmp82_ = _tmp81_;
							_tmp83_ = g_strconcat ("Failed to get data of address from subblock with ID ", _tmp82_, NULL);
							_tmp84_ = _tmp83_;
							g_warning ("gisicomm.vala:2010: %s", _tmp84_);
							_g_free0 (_tmp84_);
							_g_free0 (_tmp82_);
							continue;
						}
						_tmp85_ = addr_length;
						if (((gint) _tmp85_) == 4) {
							guint8* _tmp86_ = NULL;
							guint8* dst;
							gint dst_length1;
							gint _dst_size_;
							gchar** _tmp87_;
							gint _tmp87__length1;
							void* _tmp88_;
							guint8* _tmp89_;
							gint _tmp89__length1;
							const gchar* _tmp90_ = NULL;
							gchar* _tmp91_;
							_tmp86_ = g_new0 (guint8, INET_ADDRSTRLEN);
							dst = _tmp86_;
							dst_length1 = INET_ADDRSTRLEN;
							_dst_size_ = dst_length1;
							_tmp87_ = dns;
							_tmp87__length1 = dns_length1;
							_tmp88_ = addr_value;
							_tmp89_ = dst;
							_tmp89__length1 = dst_length1;
							_tmp90_ = inet_ntop (AF_INET, _tmp88_, _tmp89_, _tmp89__length1);
							_tmp91_ = g_strdup (_tmp90_);
							_vala_array_add2 (&dns, &dns_length1, &_dns_size_, _tmp91_);
							dst = (g_free (dst), NULL);
						} else {
							guint8 _tmp92_;
							_tmp92_ = addr_length;
							if (((gint) _tmp92_) == 16) {
								guint8* _tmp93_ = NULL;
								guint8* dst;
								gint dst_length1;
								gint _dst_size_;
								gchar** _tmp94_;
								gint _tmp94__length1;
								void* _tmp95_;
								guint8* _tmp96_;
								gint _tmp96__length1;
								const gchar* _tmp97_ = NULL;
								gchar* _tmp98_;
								_tmp93_ = g_new0 (guint8, INET6_ADDRSTRLEN);
								dst = _tmp93_;
								dst_length1 = INET6_ADDRSTRLEN;
								_dst_size_ = dst_length1;
								_tmp94_ = dns;
								_tmp94__length1 = dns_length1;
								_tmp95_ = addr_value;
								_tmp96_ = dst;
								_tmp96__length1 = dst_length1;
								_tmp97_ = inet_ntop (AF_INET6, _tmp95_, _tmp96_, _tmp96__length1);
								_tmp98_ = g_strdup (_tmp97_);
								_vala_array_add3 (&dns, &dns_length1, &_dns_size_, _tmp98_);
								dst = (g_free (dst), NULL);
							}
						}
						break;
					}
					default:
					{
						GIsiSubBlockIter _tmp99_;
						gint _tmp100_;
						gint _tmp101_;
						gchar* _tmp102_ = NULL;
						gchar* _tmp103_;
						gchar* _tmp104_ = NULL;
						gchar* _tmp105_;
						_tmp99_ = sbi;
						_tmp100_ = g_isi_sb_iter_get_id (&_tmp99_);
						_tmp101_ = _tmp100_;
						_tmp102_ = g_strdup_printf ("%i", _tmp101_);
						_tmp103_ = _tmp102_;
						_tmp104_ = g_strconcat ("FIXME: handle unknown subblock with ID ", _tmp103_, NULL);
						_tmp105_ = _tmp104_;
						g_message ("gisicomm.vala:2027: %s", _tmp105_);
						_g_free0 (_tmp105_);
						_g_free0 (_tmp103_);
						break;
					}
				}
			}
		}
	}
	_tmp107_ = dns;
	_tmp107__length1 = dns_length1;
	if (_tmp107__length1 > 0) {
		gchar** _tmp108_;
		gint _tmp108__length1;
		const gchar* _tmp109_;
		_tmp108_ = dns;
		_tmp108__length1 = dns_length1;
		_tmp109_ = _tmp108_[0];
		_tmp106_ = _tmp109_;
	} else {
		_tmp106_ = "";
	}
	_tmp111_ = dns;
	_tmp111__length1 = dns_length1;
	if (_tmp111__length1 > 1) {
		gchar** _tmp112_;
		gint _tmp112__length1;
		const gchar* _tmp113_;
		_tmp112_ = dns;
		_tmp112__length1 = dns_length1;
		_tmp113_ = _tmp112_[1];
		_tmp110_ = _tmp113_;
	} else {
		_tmp110_ = "";
	}
	_tmp114_ = ip_addr;
	_tmp115_ = _tmp106_;
	_tmp116_ = _tmp110_;
	g_signal_emit_by_name (self, "context-activated", "gprs0", _tmp114_, _tmp115_, _tmp116_);
	dns = (_vala_array_free (dns, dns_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (ip_addr);
}


static void gisi_comm_gpds_onContextDeactivateIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2038: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	g_signal_emit_by_name (self, "context-deactivated");
}


static void gisi_comm_gpds_onContextIdCreateIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2044: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onContextIdDeleteIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2049: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onContextMwiActRequestIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2054: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onAttachIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2059: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onDetachIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2064: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onSmsPduReceiveIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2069: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onTransferStatusIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2074: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onContextActivateFailIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2079: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onContextStatusIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2084: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onContextActivatingIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2089: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onContextModifyIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2094: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onAttachFailIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2099: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onContextDeactivatingIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2104: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onConfigurationInfoIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2109: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onRadioActivityIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2114: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onMbmsStatusIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2119: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onMbmsContextDeleteIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2124: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onMbmsServiceSelectionIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2129: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void gisi_comm_gpds_onMbmsServiceAvailableIndicationReceived (GIsiCommGPDS* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2134: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, const char* arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), data2);
}


static void gisi_comm_gpds_class_init (GIsiCommGPDSClass * klass) {
	gisi_comm_gpds_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->finalize = gisi_comm_gpds_finalize;
	g_type_class_add_private (klass, sizeof (GIsiCommGPDSPrivate));
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (klass)->onSubsystemIsReachable = gisi_comm_gpds_real_onSubsystemIsReachable;
	g_signal_new ("context_activated", GISI_COMM_TYPE_GPDS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	g_signal_new ("context_deactivated", GISI_COMM_TYPE_GPDS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void gisi_comm_gpds_instance_init (GIsiCommGPDS * self) {
	self->priv = GISI_COMM_GPDS_GET_PRIVATE (self);
}


static void gisi_comm_gpds_finalize (GIsiCommAbstractBaseClient* obj) {
	GIsiCommGPDS * self;
	self = GISI_COMM_GPDS (obj);
	_g_isi_client_destroy0 (self->priv->ll);
	_g_isi_pep_destroy0 (self->priv->pep);
	_g_isi_pipe_destroy0 (self->priv->pipe);
	_gisi_comm_gpds_helper_unref0 (self->priv->helper);
	GISI_COMM_ABSTRACT_BASE_CLIENT_CLASS (gisi_comm_gpds_parent_class)->finalize (obj);
}


/**
     * @class GSS
     *
     * General Stack Server
     **/
GType gisi_comm_gpds_get_type (void) {
	static volatile gsize gisi_comm_gpds_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_gpds_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommGPDSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_gpds_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommGPDS), 0, (GInstanceInitFunc) gisi_comm_gpds_instance_init, NULL };
		GType gisi_comm_gpds_type_id;
		gisi_comm_gpds_type_id = g_type_register_static (GISI_COMM_TYPE_ABSTRACT_BASE_CLIENT, "GIsiCommGPDS", &g_define_type_info, 0);
		g_once_init_leave (&gisi_comm_gpds_type_id__volatile, gisi_comm_gpds_type_id);
	}
	return gisi_comm_gpds_type_id__volatile;
}


static GIsiServer* g_isi_modem_info_server_create (GIsiModem* self) {
	GIsiServer* result = NULL;
	GIsiVersion* ver = NULL;
	GIsiVersion* _tmp0_;
	GIsiServer* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ver;
	_tmp1_ = g_isi_server_create (self, PN_EPOC_INFO, _tmp0_);
	result = (GIsiServer*) _tmp1_;
	_g_isi_version_free0 (ver);
	return result;
}


static void _gisi_comm_epoc_info_onSerialNumberReadReq_gisi_notify_func (GIsiMessage* msg, gpointer self) {
	gisi_comm_epoc_info_onSerialNumberReadReq (self, msg);
}


GIsiCommEpocInfo* gisi_comm_epoc_info_construct (GType object_type, GIsiModem* modem) {
	GIsiCommEpocInfo* self = NULL;
	GIsiModem* _tmp0_;
	GIsiServer* _tmp1_ = NULL;
	GIsiServer* _tmp2_;
	GIsiPending* _tmp3_ = NULL;
	GIsiPending* _tmp4_;
	g_return_val_if_fail (modem != NULL, NULL);
	self = (GIsiCommEpocInfo*) g_type_create_instance (object_type);
	self->priv->sv = (guint) 2;
	_tmp0_ = modem;
	_tmp1_ = g_isi_modem_info_server_create (_tmp0_);
	_g_isi_server_destroy0 (self->priv->ll);
	self->priv->ll = _tmp1_;
	_tmp2_ = self->priv->ll;
	_tmp3_ = g_isi_server_handle (_tmp2_, (guchar) 0x00, _gisi_comm_epoc_info_onSerialNumberReadReq_gisi_notify_func, self);
	_tmp4_ = _tmp3_;
	_0 (_tmp4_);
	return self;
}


GIsiCommEpocInfo* gisi_comm_epoc_info_new (GIsiModem* modem) {
	return gisi_comm_epoc_info_construct (GISI_COMM_TYPE_EPOC_INFO, modem);
}


static void gisi_comm_epoc_info_onSerialNumberReadReq (GIsiCommEpocInfo* self, GIsiMessage* msg) {
	GIsiMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GIsiMessage* _tmp5_;
	guchar _tmp6_;
	guchar _tmp7_;
	GIsiMessage* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	guint8 _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	guint8* _tmp14_ = NULL;
	guint8* req;
	gint req_length1;
	gint _req_size_;
	GIsiServer* _tmp15_;
	GIsiMessage* _tmp16_;
	guint8* _tmp17_;
	gint _tmp17__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_isi_msg_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " received", NULL);
	_tmp4_ = _tmp3_;
	g_message ("gisicomm.vala:2159: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = msg;
	_tmp6_ = g_isi_msg_id (_tmp5_);
	_tmp7_ = _tmp6_;
	if (((gint) _tmp7_) != 0x00) {
		return;
	}
	_tmp8_ = msg;
	_tmp9_ = g_isi_msg_get_data (_tmp8_, &_tmp9__length1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	_tmp11_ = _tmp10_[0];
	if (_tmp11_ != INFO_SB_SN_IMEI_SV_TO_NET) {
		return;
	}
	_tmp12_ = self->priv->sv;
	_tmp13_ = self->priv->sv;
	_tmp14_ = g_new0 (guint8, 19);
	_tmp14_[0] = INFO_SERIAL_NUMBER_READ_RESP;
	_tmp14_[1] = INFO_OK;
	_tmp14_[2] = (guint8) 1;
	_tmp14_[3] = INFO_SB_SN_IMEI_SV_TO_NET;
	_tmp14_[4] = (guint8) 16;
	_tmp14_[5] = (guint8) 0;
	_tmp14_[6] = (guint8) 9;
	_tmp14_[7] = (guint8) 0xf3;
	_tmp14_[8] = (guint8) 0xff;
	_tmp14_[9] = (guint8) 0xff;
	_tmp14_[10] = (guint8) 0xff;
	_tmp14_[11] = (guint8) 0xff;
	_tmp14_[12] = (guint8) 0xff;
	_tmp14_[13] = (guint8) 0xff;
	_tmp14_[14] = (guint8) (0x0f | ((_tmp12_ / 10) << 4));
	_tmp14_[15] = (guint8) (0xf0 | ((_tmp13_ % 10) & 0x0f));
	_tmp14_[16] = (guint8) 0;
	_tmp14_[17] = (guint8) 0;
	_tmp14_[18] = (guint8) 0;
	req = _tmp14_;
	req_length1 = 19;
	_req_size_ = req_length1;
	_tmp15_ = self->priv->ll;
	_tmp16_ = msg;
	_tmp17_ = req;
	_tmp17__length1 = req_length1;
	g_isi_server_send (_tmp15_, _tmp16_, _tmp17_, _tmp17__length1);
	req = (g_free (req), NULL);
}


static void gisi_comm_value_epoc_info_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gisi_comm_value_epoc_info_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gisi_comm_epoc_info_unref (value->data[0].v_pointer);
	}
}


static void gisi_comm_value_epoc_info_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gisi_comm_epoc_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gisi_comm_value_epoc_info_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gisi_comm_value_epoc_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GIsiCommEpocInfo* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gisi_comm_epoc_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gisi_comm_value_epoc_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GIsiCommEpocInfo** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gisi_comm_epoc_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gisi_comm_param_spec_epoc_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GIsiCommParamSpecEpocInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GISI_COMM_TYPE_EPOC_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gisi_comm_value_get_epoc_info (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GISI_COMM_TYPE_EPOC_INFO), NULL);
	return value->data[0].v_pointer;
}


void gisi_comm_value_set_epoc_info (GValue* value, gpointer v_object) {
	GIsiCommEpocInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GISI_COMM_TYPE_EPOC_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GISI_COMM_TYPE_EPOC_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gisi_comm_epoc_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gisi_comm_epoc_info_unref (old);
	}
}


void gisi_comm_value_take_epoc_info (GValue* value, gpointer v_object) {
	GIsiCommEpocInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GISI_COMM_TYPE_EPOC_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GISI_COMM_TYPE_EPOC_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gisi_comm_epoc_info_unref (old);
	}
}


static void gisi_comm_epoc_info_class_init (GIsiCommEpocInfoClass * klass) {
	gisi_comm_epoc_info_parent_class = g_type_class_peek_parent (klass);
	GISI_COMM_EPOC_INFO_CLASS (klass)->finalize = gisi_comm_epoc_info_finalize;
	g_type_class_add_private (klass, sizeof (GIsiCommEpocInfoPrivate));
}


static void gisi_comm_epoc_info_instance_init (GIsiCommEpocInfo * self) {
	self->priv = GISI_COMM_EPOC_INFO_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gisi_comm_epoc_info_finalize (GIsiCommEpocInfo* obj) {
	GIsiCommEpocInfo * self;
	self = GISI_COMM_EPOC_INFO (obj);
	_g_isi_server_destroy0 (self->priv->ll);
}


/**
     * @class EpocInfo
     *
     * EPOC Info Server
     **/
GType gisi_comm_epoc_info_get_type (void) {
	static volatile gsize gisi_comm_epoc_info_type_id__volatile = 0;
	if (g_once_init_enter (&gisi_comm_epoc_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gisi_comm_value_epoc_info_init, gisi_comm_value_epoc_info_free_value, gisi_comm_value_epoc_info_copy_value, gisi_comm_value_epoc_info_peek_pointer, "p", gisi_comm_value_epoc_info_collect_value, "p", gisi_comm_value_epoc_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GIsiCommEpocInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gisi_comm_epoc_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GIsiCommEpocInfo), 0, (GInstanceInitFunc) gisi_comm_epoc_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gisi_comm_epoc_info_type_id;
		gisi_comm_epoc_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GIsiCommEpocInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gisi_comm_epoc_info_type_id__volatile, gisi_comm_epoc_info_type_id);
	}
	return gisi_comm_epoc_info_type_id__volatile;
}


gpointer gisi_comm_epoc_info_ref (gpointer instance) {
	GIsiCommEpocInfo* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gisi_comm_epoc_info_unref (gpointer instance) {
	GIsiCommEpocInfo* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GISI_COMM_EPOC_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



