/*******************************************************************************************************************************************
 cserialized.h
 Instance dump introduction notion. Every class derived from CSerialized should be able to dump or load its data in/from an xml format or
 binary chunk.
*******************************************************************************************************************************************/

#ifndef __CSERIALIZED_H__
#define __CSERIALIZED_H__

#include "cclass.h"

#include "carchive.h"
#include "cxml.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// CSerialized class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CSerialized : public CClass
{
	// instanciation section
	public :

		CSerialized			();
		virtual ~CSerialized		() =0;

	// serialize global section
	public :

		// general check, may the specified metaclass be serialized i.e. is it a dynamic one that has a pointer on the default
		// constructor of the described class ?
		static bool			IsSerializable	(const CMetaClass *inMetaClass);

	// serialize specific section, archive handling
	public :

		// class tag read in or write to the specified Archive; indirectly called from CArchive
		virtual void			Serialize	(CArchive &ioArchive);

		// accessible metaclass on the archive current offset
		static const CMetaClass *	GetMetaClass	(CArchive &inArchive);

		// CSerialized derivation instanciation from the current offset of the archive, NULL if any. This function search for 
		// the current metaclass tag, checks that it is a dynamic one, instanciates it and calls the specific Serialize function
		// to load it from the current resource
		static CSerialized *		Instanciate	(CArchive &inArchive);

	// serialize specific section, xml handling
	public :

		// class tag and class name write / read; indirectly called from CXMLDocument
		virtual void			Serialize	(CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE;

		// accessible metaclass on the current xml node or on any of its direct children
		static const CMetaClass *	GetMetaClass	(CXMLElementNode *inXMLElementNode);

		// CSerialized derivation instanciation from the specified xml node or any of its direct children, NULL if any. 
		// This function searches for the metaclass tag, checks that it is a dynamic one, instanciates it and calls the specific 
		// Serialize function to load it from the current resource
		static CSerialized *		Instanciate	(CXMLElementNode *inXMLElementNode) THROWABLE;

		// generic metaclass
		SECTION_GENERIC_METACLASS;
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// classtag and metaclass declaration
//-----------------------------------------------------------------------------------------------------------------------------------------
DECLARE_GENERIC_METACLASS ('slzd', CSerialized, CClass);

//-------------------------------------------------------------------------------------------------------------------------------------------
// class tag to string and string to class tag conversion services
//-------------------------------------------------------------------------------------------------------------------------------------------
CString ClassTagToString (const UInt32);
UInt32  StringToClassTag (const CString &);

#endif
