/*******************************************************************************************************************************************
 cfile.h
 A simple tool definition that performs veru basic tasks on the standard IO stream type FILE.
*******************************************************************************************************************************************/

#ifndef __CFILE_H__
#define __CFILE_H__

#include <ftw.h>
#include <unistd.h>

#include "cclass.h"

//--------------------------------------------------------------------------------------------------------------------------------------------
// file types
//--------------------------------------------------------------------------------------------------------------------------------------------
typedef enum
{
	FILE_ERROR=0,		// an error occured...
	
	FILE_REGULAR,		// the file is a regular one
	FILE_DIRECTORY,		// the file is a directory
	FILE_LINK		// the file is a symbolic link
} TFile;

//--------------------------------------------------------------------------------------------------------------------------------------------
// class CFile
//--------------------------------------------------------------------------------------------------------------------------------------------
class CFile : public CClass
{
	// constructor / destructor
	public :
		
		CFile				(const CString &inFileName, const CString &inMode);
		CFile				(const CFile &);
		virtual ~CFile			();
		
	// general / standard functions
	public :

		// does the specified file exist ? (returns the file type, FILE_ERROR if any) 
		static TFile			Exists		(const CString &inFileNameWithPath);

		// the file name only
		CString				GetName		() const;

		// the path only
		CString				GetPath		() const;

		// the file type
		TFile				GetType		() const;

		// the file size
		UInt32				GetSize		() const;

		// the file type access
		CString				GetMode		() const;

		// the file buffer direct access
		FILE *				GetFile		() const;

		// IO standard functions
		size_t				Write		(const void *inData, const size_t inItemSize, const size_t inNumber);
		size_t				Read		(void *outData, const size_t inItemSize, const size_t inNumber);

		// standard file seek (SEEK_SET, SEEK_CUR, SEEK_END)
		void				Seek		(const long inOffset, const int inWhence);
		long				Tell		() const;

		// data flush (in user space)
		void				Flush		();

		// file truncation
		void				Truncate	(const long inSize);
		
	// protected section
	protected :

		// file name and full path, the file buffer, the file access
		CString				m_FileName;
		CString				m_FileMode;
		FILE *				m_File;
		
		// capsule metaclass description
		SECTION_CAPSULE_METACLASS;
};

// class tag and metaclass declaration
DECLARE_CAPSULE_METACLASS ('file', CFile, CClass);

#endif
