/* testpriorityqueue.c generated by valac, the Vala compiler
 * generated from testpriorityqueue.vala, do not modify */

/* testpriorityqueue.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Authors:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_QUEUE_TESTS (queue_tests_get_type ())
#define QUEUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUEUE_TESTS, QueueTests))
#define QUEUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUEUE_TESTS, QueueTestsClass))
#define IS_QUEUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUEUE_TESTS))
#define IS_QUEUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUEUE_TESTS))
#define QUEUE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUEUE_TESTS, QueueTestsClass))

typedef struct _QueueTests QueueTests;
typedef struct _QueueTestsClass QueueTestsClass;
typedef struct _QueueTestsPrivate QueueTestsPrivate;

#define TYPE_PRIORITY_QUEUE_TESTS (priority_queue_tests_get_type ())
#define PRIORITY_QUEUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRIORITY_QUEUE_TESTS, PriorityQueueTests))
#define PRIORITY_QUEUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRIORITY_QUEUE_TESTS, PriorityQueueTestsClass))
#define IS_PRIORITY_QUEUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRIORITY_QUEUE_TESTS))
#define IS_PRIORITY_QUEUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRIORITY_QUEUE_TESTS))
#define PRIORITY_QUEUE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRIORITY_QUEUE_TESTS, PriorityQueueTestsClass))

typedef struct _PriorityQueueTests PriorityQueueTests;
typedef struct _PriorityQueueTestsClass PriorityQueueTestsClass;
typedef struct _PriorityQueueTestsPrivate PriorityQueueTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _QueueTests {
	CollectionTests parent_instance;
	QueueTestsPrivate * priv;
};

struct _QueueTestsClass {
	CollectionTestsClass parent_class;
};

struct _PriorityQueueTests {
	QueueTests parent_instance;
	PriorityQueueTestsPrivate * priv;
};

struct _PriorityQueueTestsClass {
	QueueTestsClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer priority_queue_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
GType queue_tests_get_type (void) G_GNUC_CONST;
GType priority_queue_tests_get_type (void) G_GNUC_CONST;
enum  {
	PRIORITY_QUEUE_TESTS_DUMMY_PROPERTY
};
QueueTests* queue_tests_construct (GType object_type, const char* name);
void gee_test_case_add_test (GeeTestCase* self, const char* name, GeeTestCaseTestMethod test, void* test_target);
static void priority_queue_tests_test_selected_functions (PriorityQueueTests* self);
static void _priority_queue_tests_test_selected_functions_gee_test_case_test_method (gpointer self);
void priority_queue_tests_test_gobject_properties (PriorityQueueTests* self);
static void _priority_queue_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
static void priority_queue_tests_test_poll_gives_minimum (PriorityQueueTests* self);
static void _priority_queue_tests_test_poll_gives_minimum_gee_test_case_test_method (gpointer self);
PriorityQueueTests* priority_queue_tests_new (void);
PriorityQueueTests* priority_queue_tests_construct (GType object_type);
static void priority_queue_tests_real_set_up (GeeTestCase* base);
static void priority_queue_tests_real_tear_down (GeeTestCase* base);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _priority_queue_tests_test_selected_functions_gee_test_case_test_method (gpointer self) {
	priority_queue_tests_test_selected_functions (self);
}


static void _priority_queue_tests_test_gobject_properties_gee_test_case_test_method (gpointer self) {
	priority_queue_tests_test_gobject_properties (self);
}


static void _priority_queue_tests_test_poll_gives_minimum_gee_test_case_test_method (gpointer self) {
	priority_queue_tests_test_poll_gives_minimum (self);
}


PriorityQueueTests* priority_queue_tests_construct (GType object_type) {
	PriorityQueueTests * self;
	self = (PriorityQueueTests*) queue_tests_construct (object_type, "PriorityQueue");
	gee_test_case_add_test ((GeeTestCase*) self, "[PriorityQueue] selected functions", _priority_queue_tests_test_selected_functions_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[PriorityQueue] GObject properties", _priority_queue_tests_test_gobject_properties_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[PriorityQueue] poll gives minimum", _priority_queue_tests_test_poll_gives_minimum_gee_test_case_test_method, self);
	return self;
}


PriorityQueueTests* priority_queue_tests_new (void) {
	return priority_queue_tests_construct (TYPE_PRIORITY_QUEUE_TESTS);
}


static void priority_queue_tests_real_set_up (GeeTestCase* base) {
	PriorityQueueTests * self;
	GeeCollection* _tmp0_;
	self = (PriorityQueueTests*) base;
	((CollectionTests*) self)->test_collection = (_tmp0_ = (GeeCollection*) gee_priority_queue_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (((CollectionTests*) self)->test_collection), _tmp0_);
}


static void priority_queue_tests_real_tear_down (GeeTestCase* base) {
	PriorityQueueTests * self;
	GeeCollection* _tmp0_;
	self = (PriorityQueueTests*) base;
	((CollectionTests*) self)->test_collection = (_tmp0_ = NULL, _g_object_unref0 (((CollectionTests*) self)->test_collection), _tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void priority_queue_tests_test_selected_functions (PriorityQueueTests* self) {
	GeeCollection* _tmp0_;
	GeePriorityQueue* test_queue;
	g_return_if_fail (self != NULL);
	test_queue = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_PRIORITY_QUEUE (_tmp0_) ? ((GeePriorityQueue*) _tmp0_) : NULL));
	g_assert (test_queue != NULL);
	g_assert (gee_priority_queue_get_compare_func (test_queue) == ((GCompareFunc) g_strcmp0));
	_g_object_unref0 (test_queue);
}


void priority_queue_tests_test_gobject_properties (PriorityQueueTests* self) {
	GeeCollection* _tmp0_;
	GeePriorityQueue* test_queue;
	GValue value = {0};
	GValue _tmp2_;
	GValue _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	test_queue = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_PRIORITY_QUEUE (_tmp0_) ? ((GeePriorityQueue*) _tmp0_) : NULL));
	g_assert (test_queue != NULL);
	value = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_POINTER), _tmp1_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp2_);
	g_object_get_property ((GObject*) test_queue, "compare-func", &value);
	g_assert (g_value_get_pointer (&value) == ((void*) gee_priority_queue_get_compare_func (test_queue)));
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	_g_object_unref0 (test_queue);
}


static void priority_queue_tests_test_poll_gives_minimum (PriorityQueueTests* self) {
	GeeCollection* _tmp0_;
	GeeQueue* test_queue;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	char* _tmp15_;
	char* _tmp16_;
	char* _tmp17_;
	char* _tmp18_;
	char* _tmp19_;
	char* _tmp20_;
	char* _tmp21_;
	char* _tmp22_;
	char* _tmp23_;
	char* _tmp24_;
	char* _tmp25_;
	char* _tmp26_;
	char* _tmp27_;
	g_return_if_fail (self != NULL);
	test_queue = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_QUEUE (_tmp0_) ? ((GeeQueue*) _tmp0_) : NULL));
	g_assert (test_queue != NULL);
	g_assert (gee_queue_offer (test_queue, "one"));
	g_assert (gee_queue_offer (test_queue, "two"));
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_queue_peek (test_queue), "one") == 0);
	_g_free0 (_tmp1_);
	g_assert (gee_collection_remove ((GeeCollection*) test_queue, "two"));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_queue_peek (test_queue), "one") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_queue_poll (test_queue), "one") == 0);
	_g_free0 (_tmp3_);
	g_assert (gee_queue_offer (test_queue, "one"));
	g_assert (gee_queue_offer (test_queue, "two"));
	g_assert (gee_queue_offer (test_queue, "three"));
	g_assert (gee_queue_offer (test_queue, "four"));
	g_assert (gee_queue_offer (test_queue, "five"));
	g_assert (gee_queue_offer (test_queue, "six"));
	g_assert (gee_queue_offer (test_queue, "seven"));
	g_assert (gee_queue_offer (test_queue, "eight"));
	g_assert (gee_queue_offer (test_queue, "nine"));
	g_assert (gee_queue_offer (test_queue, "ten"));
	g_assert (gee_queue_offer (test_queue, "eleven"));
	g_assert (gee_queue_offer (test_queue, "twelve"));
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_queue_peek (test_queue), "eight") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_queue_poll (test_queue), "eight") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_queue_peek (test_queue), "eleven") == 0);
	_g_free0 (_tmp6_);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_queue_poll (test_queue), "eleven") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_queue_peek (test_queue), "five") == 0);
	_g_free0 (_tmp8_);
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_queue_poll (test_queue), "five") == 0);
	_g_free0 (_tmp9_);
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_queue_peek (test_queue), "four") == 0);
	_g_free0 (_tmp10_);
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_queue_poll (test_queue), "four") == 0);
	_g_free0 (_tmp11_);
	g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_queue_peek (test_queue), "nine") == 0);
	_g_free0 (_tmp12_);
	g_assert (_vala_strcmp0 (_tmp13_ = (char*) gee_queue_poll (test_queue), "nine") == 0);
	_g_free0 (_tmp13_);
	g_assert (_vala_strcmp0 (_tmp14_ = (char*) gee_queue_peek (test_queue), "one") == 0);
	_g_free0 (_tmp14_);
	g_assert (_vala_strcmp0 (_tmp15_ = (char*) gee_queue_poll (test_queue), "one") == 0);
	_g_free0 (_tmp15_);
	g_assert (_vala_strcmp0 (_tmp16_ = (char*) gee_queue_peek (test_queue), "seven") == 0);
	_g_free0 (_tmp16_);
	g_assert (_vala_strcmp0 (_tmp17_ = (char*) gee_queue_poll (test_queue), "seven") == 0);
	_g_free0 (_tmp17_);
	g_assert (_vala_strcmp0 (_tmp18_ = (char*) gee_queue_peek (test_queue), "six") == 0);
	_g_free0 (_tmp18_);
	g_assert (_vala_strcmp0 (_tmp19_ = (char*) gee_queue_poll (test_queue), "six") == 0);
	_g_free0 (_tmp19_);
	g_assert (_vala_strcmp0 (_tmp20_ = (char*) gee_queue_peek (test_queue), "ten") == 0);
	_g_free0 (_tmp20_);
	g_assert (_vala_strcmp0 (_tmp21_ = (char*) gee_queue_poll (test_queue), "ten") == 0);
	_g_free0 (_tmp21_);
	g_assert (_vala_strcmp0 (_tmp22_ = (char*) gee_queue_peek (test_queue), "three") == 0);
	_g_free0 (_tmp22_);
	g_assert (_vala_strcmp0 (_tmp23_ = (char*) gee_queue_poll (test_queue), "three") == 0);
	_g_free0 (_tmp23_);
	g_assert (_vala_strcmp0 (_tmp24_ = (char*) gee_queue_peek (test_queue), "twelve") == 0);
	_g_free0 (_tmp24_);
	g_assert (_vala_strcmp0 (_tmp25_ = (char*) gee_queue_poll (test_queue), "twelve") == 0);
	_g_free0 (_tmp25_);
	g_assert (_vala_strcmp0 (_tmp26_ = (char*) gee_queue_peek (test_queue), "two") == 0);
	_g_free0 (_tmp26_);
	g_assert (_vala_strcmp0 (_tmp27_ = (char*) gee_queue_poll (test_queue), "two") == 0);
	_g_free0 (_tmp27_);
	_g_object_unref0 (test_queue);
}


static void priority_queue_tests_class_init (PriorityQueueTestsClass * klass) {
	priority_queue_tests_parent_class = g_type_class_peek_parent (klass);
	GEE_TEST_CASE_CLASS (klass)->set_up = priority_queue_tests_real_set_up;
	GEE_TEST_CASE_CLASS (klass)->tear_down = priority_queue_tests_real_tear_down;
}


static void priority_queue_tests_instance_init (PriorityQueueTests * self) {
}


GType priority_queue_tests_get_type (void) {
	static volatile gsize priority_queue_tests_type_id__volatile = 0;
	if (g_once_init_enter (&priority_queue_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PriorityQueueTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) priority_queue_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PriorityQueueTests), 0, (GInstanceInitFunc) priority_queue_tests_instance_init, NULL };
		GType priority_queue_tests_type_id;
		priority_queue_tests_type_id = g_type_register_static (TYPE_QUEUE_TESTS, "PriorityQueueTests", &g_define_type_info, 0);
		g_once_init_leave (&priority_queue_tests_type_id__volatile, priority_queue_tests_type_id);
	}
	return priority_queue_tests_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




