/*****************************************************************************
 * vmg.h: DVD Video Manager library.
 *****************************************************************************
 * Copyright (C) 2002 VideoLAN
 * $Id: vmg.h,v 1.6 2003/01/29 22:09:46 sam Exp $
 *
 * Authors: Stphane Borel <stef@via.ecp.fr>
 *
 * Adapted from Ogle - A video player
 * Copyright (C) 2000, 2001 Hkan Hjort
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

typedef enum {
  FP_DOMAIN   = 1,
  VTS_DOMAIN  = 2,
  VMGM_DOMAIN = 4,
  VTSM_DOMAIN = 8
} domain_t;

/**
 * State: SPRM, GPRM, Domain, pgc, pgN, cellN, ?
 */
typedef struct dvd_state_s
{
    pgc_t *         p_pgc;  // either this or *pgc is enough?

    domain_t        domain;
    int             i_vtsN; // 0 is vmgm?
    int             i_pgcN; // either this or *pgc is enough. Which to use?
    int             i_pgN;  // is this needed? can allways fid pgN from cellN?
    int             i_cellN;
    int             i_blockN;
} dvd_state_t;

typedef struct dvdplay_s
{
    /* dvdread info */
    dvd_reader_t *          p_dvdread;
    ifo_handle_t *          p_vmgi;
    ifo_handle_t *          p_vtsi;
    dvd_file_t *            p_file;
    dsi_t                   dsi;
    pci_t                   pci;

    /* video manager state */
    registers_t             registers;
    dvd_state_t             state;
    dvdbool_t               b_pgc_pre;
    dvdbool_t               b_jump;

    /* manager internal data */
    link_t                  link;
    cmd_t                   cmd;

    /* resume info */
    uint16_t                pi_rsm_regs[5]; /* system registers 4-8 */
    dvd_state_t             resume;

    /* highlight info */
    dvdbool_t               b_action_highlight;

    /* callback to notify events */
    void                  (*pf_callback)( void*, dvdplay_event_t );
    void *                  p_args;

    /* messages management */
    int                     i_verbosity;

} dvdplay_t;


// Audio stream number
#define AST_REG      registers.SPRM[1]
// Subpicture stream number
#define SPST_REG     registers.SPRM[2]
// Angle number
#define AGL_REG      registers.SPRM[3]
// Title Track Number
#define TTN_REG      registers.SPRM[4]
// VTS Title Track Number
#define VTS_TTN_REG  registers.SPRM[5]
// PGC Number for this Title Track
#define TT_PGCN_REG  registers.SPRM[6]
// Current Part of Title (PTT) number for (One_Sequential_PGC_Title)
#define PTTN_REG     registers.SPRM[7]
// Highlighted Button Number (btn nr 1 == value 1024)
#define HL_BTNN_REG  registers.SPRM[8]
// Parental Level
#define PTL_REG      registers.SPRM[13]

int      _OpenVMGI        ( dvdplay_ptr, char * );
int      _OpenVTSI        ( dvdplay_ptr, int );
int      _OpenFile        ( dvdplay_ptr );

void     _SaveRSMinfo     ( dvdplay_ptr, int, int );
int      _PlayPGC         ( dvdplay_ptr );
int      _PlayPGCpost     ( dvdplay_ptr );
int      _PlayPG          ( dvdplay_ptr );
int      _PlayCell        ( dvdplay_ptr );
int      _PlayCellPost    ( dvdplay_ptr );
//link_t   _Resume          ( dvdplay_ptr );
int      _ProcessLink     ( dvdplay_ptr );
/*
 * Can only be called when in VTS_DOMAIN
 */
int      _SetTT           ( dvdplay_ptr, int );
int      _SetPTT          ( dvdplay_ptr, int, int );
int      _SetVTS_TT       ( dvdplay_ptr, int, int );
int      _SetVTS_PTT      ( dvdplay_ptr, int, int, int );

int      _SetMenu         ( dvdplay_ptr, int ); // VTSM & VMGM
int      _SetFP_PGC       ( dvdplay_ptr ); // FP

/* Called in any domain */
int      _SetPGC          ( dvdplay_ptr, int );
int      _SetDomain       ( dvdplay_ptr, domain_t );

domain_t _MenuId2Domain   ( dvdplay_menu_t );


