#include <stdio.h>

#include <ctk/ctk.h>

GSList *radio_group = NULL;
CtkWidget *entry;

void select_call(CtkWidget* widget, gint row, gint col, gpointer data)
{
	ctk_clist_remove(CTK_CLIST(widget), row);
//	for (; row; row--)
//		ctk_noise("drip");
}

CtkSignalFunc quit_test(CtkWidget *object, CdkEvent* event, gpointer *data)
{
	gint i;
	
	ctk_entry_set_text(CTK_ENTRY(entry), "hello!");
	
	for (i = 0; i < 1000; i++ )
		printf("abcdefg");
		
	return 0;
	
	ctk_main_quit();
/*
	GSList *list;
	gint i;
		ctk_close();
	list = radio_group;
	
	ctk_widget_destroy(object);
	
	exit(0);
	
	i = 0;
	while (list) {
		i += 1;
		if (((CtkToggleButton *)list->data)->active)
		    break;
		list = list->next;
	}
	
	if (list) {
		printf("Number %d Toggled!\n",i);
	} else
	    printf("nulled\n");
	printf("Exiting...\n");
	exit(0);
*/
	return 0;
}

CtkSignalFunc
    clist_test(CtkWidget *widget, gint row, gint col, gpointer event, gpointer data)
{
	gchar *text = NULL;
	gchar *real_text = NULL;
	gchar *chng_text = NULL;

	
	ctk_clist_get_text(CTK_CLIST(widget),row,col,&text);
	real_text = g_strdup(text);
	ctk_clist_freeze(CTK_CLIST(widget));
	ctk_clist_set_text(CTK_CLIST(widget),row,col,"Cool!");

	ctk_clist_get_text(CTK_CLIST(widget),row,col,&chng_text);

	ctk_close();
	printf("R: %d\n",row);
	printf("C: %d\n",col);
	printf("Real Text: %s\n",real_text);
	printf("Chng Text: %s\n",chng_text);
	exit(0);
}

CtkSignalFunc
    get_entry(CtkWidget *entry)
{
	gchar *text=NULL;
	
	//text = ctk_editable_get_chars(CTK_EDITABLE(entry),0,-1);
	text = ctk_entry_get_text(CTK_ENTRY(entry));
	
	ctk_close();
	printf("Text: *%s*\n",text);
	if (text)
	    g_free(text);
	exit(0);
}

int
main(void)
{
	CtkWidget *window;
	CtkWidget *hbox;
	CtkWidget *vbox;
	CtkWidget *vbox_main;
	CtkWidget *clisthbox;
	CtkWidget *button;
	CtkWidget *first_button;	
	CtkWidget *label;
	CtkWidget *checkbutton;	
	CtkWidget *radiobutton1;
	CtkWidget *radiobutton2;
	CtkObject *hadjustment;
	CtkObject *vadjustment;
	CtkObject *adjustment;
	CtkWidget *scrolledwindow;
	CtkWidget *viewport;
	CtkWidget *spinbutton;
	CtkWidget *clist;
	CtkWidget *notebook;
	CtkWidget *nlabel1;
	CtkWidget *nlabel2;
	CtkWidget *nlabel3;
	CtkWidget *optionmenu;
	CtkWidget *menu;
	CtkWidget *menuitem;
	CtkWidget *separator;
	CtkWidget *progressbar;
	CtkWidget *frame;
	CtkWidget *hscale;
	CtkWidget *vscale;
	CtkWidget *combo;
	CtkWidget *table;	
	GList *combo_items = NULL;
	gchar **clist_text;
	gchar clist_str[128];
	gint i,j;

	ctk_init(CTK_USEMOUSE );
	
	/* Window */
	window = ctk_window_new(CTK_WINDOW_TOPLEVEL);
	ctk_widget_set_usize(window, 30, 10);
	ctk_widget_set_uposition(window, 3, 1);
	ctk_window_set_closable(CTK_WINDOW(window), TRUE);
	ctk_window_set_title(CTK_WINDOW(window),"ƥȣ");
	ctk_widget_show(window);

	ctk_signal_connect(CTK_OBJECT(window),"delete_event",CTK_SIGNAL_FUNC(quit_test),NULL);
	
	/* Scrolled Window */
	hadjustment = ctk_adjustment_new(0,0,0,0,5,0);
	vadjustment = ctk_adjustment_new(0,0,0,0,5,0);	
	scrolledwindow = ctk_scrolled_window_new(CTK_ADJUSTMENT(hadjustment),
						CTK_ADJUSTMENT(vadjustment));
	ctk_widget_show(scrolledwindow);
//	ctk_container_add(CTK_CONTAINER(window),scrolledwindow);	
	
	/* Viewport */
	hadjustment = ctk_adjustment_new(0,0,0,0,5,0);
	vadjustment = ctk_adjustment_new(0,0,0,0,5,0);
	viewport = ctk_viewport_new(CTK_ADJUSTMENT(hadjustment),
				    CTK_ADJUSTMENT(vadjustment));
	ctk_widget_show(viewport);
//	ctk_container_add(CTK_CONTAINER(scrolledwindow),viewport);
	
		
	/* V BOX */
	vbox_main = ctk_vbox_new(FALSE,1);
	ctk_widget_show(vbox_main);
//	ctk_container_add(CTK_CONTAINER(window),vbox_main);

	/* Note Book */
	notebook = ctk_notebook_new();
	ctk_widget_show(notebook);
	ctk_notebook_set_tab_pos(CTK_NOTEBOOK(notebook),CTK_POS_TOP);
	ctk_container_add(CTK_CONTAINER(window),notebook);
//	ctk_container_set_border_width(CTK_CONTAINER(window), 3);
//	ctk_box_pack_end(CTK_BOX(),notebook,TRUE,TRUE,0);
	
	/* H Box */
/*	hbox_main = ctk_hbox_new(FALSE,0);
	ctk_widget_show(hbox_main);
	ctk_box_pack_end(CTK_BOX(vbox_main),hbox_main,TRUE,TRUE,0);
	ctk_container_add(CTK_CONTAINER(notebook),hbox_main); */
		
	/* H Box */
	hbox = ctk_hbox_new(FALSE,0);
	ctk_widget_show(hbox);

	/* Notebook Label 1 */
	nlabel1 = ctk_label_new("٥룱");
	ctk_widget_show(nlabel1);

	ctk_notebook_append_page(CTK_NOTEBOOK(notebook),
				 hbox,
				 nlabel1);
				 
	/* Button */
	button = ctk_button_new_with_label("Button 1\ntest1\ntest 2");
	ctk_widget_show(button);
	ctk_container_set_border_width(CTK_CONTAINER(button),2);
	first_button = button;

	ctk_box_pack_end(CTK_BOX(hbox),button,FALSE,TRUE,0);

	separator = ctk_vseparator_new();
	ctk_widget_show(separator);
	ctk_box_pack_end(CTK_BOX(hbox),separator,FALSE,TRUE,1);

	vscale = ctk_vscale_new(CTK_ADJUSTMENT(ctk_adjustment_new(25,1000,100000,100,1000,0)));
	ctk_widget_show(vscale);
	ctk_box_pack_end(CTK_BOX(hbox),vscale,FALSE,TRUE,1);

	/* Button */
	button = ctk_button_new();
	ctk_widget_show(button);
	ctk_widget_set_sensitive(button,FALSE);
	ctk_widget_set_sensitive(button,TRUE);
	ctk_container_set_border_width(CTK_CONTAINER(button),5);
	ctk_box_pack_end(CTK_BOX(hbox),button,TRUE,FALSE,0);

	/* Label */
	label = ctk_label_new(" Quit ");
//	ctk_widget_set_main_color(label,"white","red");
	ctk_widget_show(label);
	ctk_signal_connect(CTK_OBJECT(button),"clicked",CTK_SIGNAL_FUNC(quit_test),NULL);
	ctk_container_add(CTK_CONTAINER(button),label);
	
	/* VBox */
	vbox = ctk_vbox_new(TRUE,1);
	ctk_widget_show(vbox);
//	ctk_container_add(CTK_CONTAINER(notebook),vbox);
//	ctk_box_pack_end(CTK_BOX(hbox_main),vbox,FALSE,TRUE,0);

	/* Table */
	table = ctk_table_new(2,3,FALSE);
	ctk_widget_show(table);
	ctk_container_add(CTK_CONTAINER(notebook),table);
	
	/* Notebook Label 2 */
	nlabel2 = ctk_label_new("Label 2");
	ctk_widget_show(nlabel2);
	ctk_notebook_set_tab_label(CTK_NOTEBOOK(notebook),
				   table,
				   nlabel2);

	/* Check Button */
	checkbutton = ctk_check_button_new();
	ctk_widget_show(checkbutton);
	ctk_table_attach(CTK_TABLE(table),checkbutton,0,1,0,1,
			 (CtkAttachOptions)(0),
			 (CtkAttachOptions)(0),
			 0,0);
//	ctk_box_pack_end(CTK_BOX(vbox),checkbutton,FALSE,TRUE,0);

	/* Check Button */
	checkbutton = ctk_check_button_new_with_label(" Check Button");
	ctk_widget_show(checkbutton);
	ctk_toggle_button_toggled(CTK_TOGGLE_BUTTON(checkbutton));
	ctk_table_attach(CTK_TABLE(table),checkbutton,1,2,0,1,
			 (CtkAttachOptions)(0),
			 (CtkAttachOptions)(0),
			 0,0);

//	ctk_box_pack_end(CTK_BOX(vbox),checkbutton,FALSE,TRUE,0);

	/* Radio Button */
	radiobutton1 = ctk_radio_button_new(radio_group);
	radio_group = ctk_radio_button_group(CTK_RADIO_BUTTON(radiobutton1));
	ctk_toggle_button_toggled(CTK_TOGGLE_BUTTON(radiobutton1));
	ctk_widget_show(radiobutton1);
	ctk_table_attach(CTK_TABLE(table),radiobutton1,2,3,0,1,
			 (CtkAttachOptions)(0),
			 (CtkAttachOptions)(0),
			 0,0);	
//	ctk_box_pack_end(CTK_BOX(vbox),radiobutton1,FALSE,TRUE,0);
	
	/* Radio Button */
	radiobutton2 = ctk_radio_button_new_with_label(radio_group,"Radio 2\nis very\nvery\ntall\nto force\nmy table");
	ctk_widget_show(radiobutton2);
	ctk_table_attach(CTK_TABLE(table),radiobutton2,0,1,1,2,
			 (CtkAttachOptions)(0),
			 (CtkAttachOptions)(0),
			 0,0);	
//	ctk_box_pack_end(CTK_BOX(vbox),radiobutton2,FALSE,TRUE,0);

	/* Text Entry */
	entry = ctk_entry_new();
	ctk_entry_set_max_length(CTK_ENTRY(entry),8);
	ctk_widget_show(entry);
	ctk_signal_connect_object(CTK_OBJECT(first_button),"clicked",CTK_SIGNAL_FUNC(get_entry),CTK_OBJECT(entry));
//	ctk_editable_set_editable(CTK_EDITABLE(entry),TRUE);
//	ctk_entry_set_visibility(CTK_ENTRY(entry),TRUE);
/*	ctk_entry_set_text(CTK_ENTRY(entry),
			   "This is a to see the scrolling entry box!"); */
	ctk_table_attach(CTK_TABLE(table),entry,1,2,1,2,
			 (CtkAttachOptions)(0),
			 (CtkAttachOptions)(0),
			 0,0);
//	ctk_box_pack_end(CTK_BOX(vbox),entry,FALSE,TRUE,0);

	adjustment = ctk_adjustment_new(3,1,13,2,5,0);
	spinbutton = ctk_spin_button_new(CTK_ADJUSTMENT(adjustment),.5,3);
	ctk_widget_show(spinbutton);
	ctk_table_attach(CTK_TABLE(table),spinbutton,2,3,1,2,
			 (CtkAttachOptions)(0),
			 (CtkAttachOptions)(0),
			 0,0);	
//	ctk_box_pack_end(CTK_BOX(vbox),spinbutton,FALSE,TRUE,0);
	
	/* CList H Box */
	clisthbox = ctk_hbox_new(FALSE,1);
	ctk_widget_show(clisthbox);
	ctk_container_add(CTK_CONTAINER(notebook),clisthbox);
//	ctk_box_pack_end(CTK_BOX(hbox_main),clisthbox,TRUE,TRUE,1);
	
	/* Notebook Label 3 */
	nlabel3 = ctk_label_new("Label 3");
	ctk_widget_show(nlabel3);
	ctk_notebook_set_tab_label(CTK_NOTEBOOK(notebook),
				  clisthbox,
				  nlabel3);

	/* Scrolled Window */
	hadjustment = ctk_adjustment_new(0,0,0,0,5,0);
	vadjustment = ctk_adjustment_new(0,0,0,0,5,0);	
	scrolledwindow = ctk_scrolled_window_new(CTK_ADJUSTMENT(hadjustment),
						 CTK_ADJUSTMENT(vadjustment));
	ctk_widget_show(scrolledwindow);
//	ctk_box_pack_end(CTK_BOX(vbox),scrolledwindow,TRUE,TRUE,0);
	ctk_box_pack_end(CTK_BOX(clisthbox),scrolledwindow,TRUE,TRUE,0);

	/* CList */

	clist = ctk_clist_new(3);
	ctk_container_add(CTK_CONTAINER(scrolledwindow),clist);
	ctk_clist_set_column_width(CTK_CLIST(clist),0,10);
	ctk_clist_set_column_width(CTK_CLIST(clist),1,10);
	ctk_clist_set_column_width(CTK_CLIST(clist),2,10);
	ctk_clist_set_column_title(CTK_CLIST(clist),0,"Title 1");
	ctk_clist_set_column_title(CTK_CLIST(clist),1,"Title 2");
	ctk_clist_set_column_title(CTK_CLIST(clist),2,"Title 3");
	ctk_clist_column_titles_show(CTK_CLIST(clist));
	ctk_signal_connect(CTK_OBJECT(clist), "select_row",
		CTK_SIGNAL_FUNC(&select_call), NULL);

	j = 0;
	
	for (i = 0; i < 30; i += 1) {
		clist_text = g_malloc(sizeof(gchar *)*4);
		j += 1; sprintf(clist_str,"Text %d",j);
		*clist_text = g_strdup(clist_str);
		j += 1; sprintf(clist_str,"Text %d",j);
		*(clist_text+1) = g_strdup(clist_str);
		j += 1; sprintf(clist_str,"Text %d",j);
		*(clist_text+2) = g_strdup(clist_str);
		*(clist_text+3) = NULL;
		
		ctk_clist_append(CTK_CLIST(clist),clist_text);
	}
	
	ctk_clist_remove(CTK_CLIST(clist),1);
	
	clist_text = g_malloc(sizeof(gchar *)*4);
	*clist_text = g_strdup("Insert 1");
	*(clist_text+1) = g_strdup("Insert 2");
	*(clist_text+2) = g_strdup("Insert 3");
	*(clist_text+3) = NULL;
	
	ctk_clist_insert(CTK_CLIST(clist),1,clist_text);	
	ctk_clist_select_row(CTK_CLIST(clist),1,0);

	ctk_widget_show(clist);
//	ctk_signal_connect(CTK_OBJECT(clist),"select_row",CTK_SIGNAL_FUNC(clist_test),NULL);	

	/* V Box */
	vbox = ctk_vbox_new(FALSE,0);
	ctk_widget_show(vbox);
	ctk_container_add(CTK_CONTAINER(notebook),vbox);

	/* Notebook Label 3 */
	nlabel3 = ctk_label_new("Label 4");
	ctk_widget_show(nlabel3);
	ctk_notebook_set_tab_label(CTK_NOTEBOOK(notebook),
				  vbox,
				  nlabel3);

	optionmenu = ctk_option_menu_new();
	ctk_widget_show(optionmenu);
	ctk_box_pack_end(CTK_BOX(vbox),optionmenu,FALSE,FALSE,0);
	
	menu = ctk_menu_new();
	ctk_widget_show(menu);
	
	menuitem = ctk_menu_item_new_with_label("Item 1 Testing");
	ctk_widget_show(menuitem);
	ctk_menu_append(CTK_MENU(menu),menuitem);
	
	menuitem = ctk_menu_item_new_with_label("Item 2 here\nNewline Goes Here");
	ctk_widget_show(menuitem);
	ctk_menu_append(CTK_MENU(menu),menuitem);

	menuitem = ctk_menu_item_new_with_label("Item 3");
	ctk_widget_show(menuitem);
	ctk_menu_append(CTK_MENU(menu),menuitem);

	ctk_option_menu_set_menu(CTK_OPTION_MENU(optionmenu),menu);

	separator = ctk_hseparator_new();
	ctk_widget_show(separator);
	ctk_box_pack_end(CTK_BOX(vbox),separator,FALSE,FALSE,0);

	label = ctk_label_new("\n"); //My Test Label "
//			      "My Test Label "
//			      "My Test Label "
//			      "My Test Label "
//			      "My Test Label "
//			      "My Test Label "
//			      "My Test Label "
//			      "My Test Label ");
	ctk_label_set_line_wrap(CTK_LABEL(label),TRUE);
	ctk_widget_show(label);
	ctk_misc_set_alignment(CTK_MISC(label),0,0);
	ctk_misc_set_padding(CTK_MISC(label),10,1);
	ctk_box_pack_end(CTK_BOX(vbox),label,FALSE,FALSE,0);
	
	frame = ctk_frame_new("My Frame");
	ctk_widget_show(frame);
	ctk_box_pack_end(CTK_BOX(vbox),frame,FALSE,FALSE,0);
	
	hbox = ctk_vbox_new(FALSE,0);
	ctk_widget_show(hbox);
	ctk_container_add(CTK_CONTAINER(frame),hbox);
	
	progressbar = ctk_progress_bar_new ();
	ctk_progress_configure (CTK_PROGRESS (progressbar), 50, 0, 100);
	ctk_progress_set_show_text (CTK_PROGRESS (progressbar), TRUE);
	ctk_widget_show (progressbar);
	ctk_box_pack_end(CTK_BOX(hbox),progressbar,FALSE,FALSE,0);

	button = ctk_toggle_button_new_with_label("Toggle Button");
	ctk_widget_show(button);
	ctk_container_set_border_width(CTK_CONTAINER(button),1);
	ctk_box_pack_end(CTK_BOX(hbox),button,FALSE,FALSE,0);

	hscale = ctk_hscale_new(CTK_ADJUSTMENT(ctk_adjustment_new(25,10000,100000,100,1000,0)));
	ctk_widget_show(hscale);
	ctk_scale_set_digits(CTK_SCALE(hscale),2);
//	ctk_scale_set_draw_value(CTK_SCALE(hscale),FALSE);
	ctk_box_pack_end(CTK_BOX(vbox),hscale,FALSE,FALSE,0);
	
	combo = ctk_combo_new();
	ctk_widget_show(combo);
	ctk_box_pack_end(CTK_BOX(vbox),combo,FALSE,FALSE,0);
	
	combo_items = g_list_append(combo_items,"Item 1");
	combo_items = g_list_append(combo_items,"Item 2");
	combo_items = g_list_append(combo_items,"Item 3");
	combo_items = g_list_append(combo_items,"Item 4");
	combo_items = g_list_append(combo_items,"Item 5");
	combo_items = g_list_append(combo_items,"Item 6");
	combo_items = g_list_append(combo_items,"Item 7");
	combo_items = g_list_append(combo_items,"Item 8");
	combo_items = g_list_append(combo_items,"Item 9");
	combo_items = g_list_append(combo_items,"Item 10");
	combo_items = g_list_append(combo_items,"Item 11");
	combo_items = g_list_append(combo_items,"Item 12");
	ctk_combo_set_popdown_strings(CTK_COMBO(combo),combo_items);
	ctk_combo_set_popdown_strings(CTK_COMBO(combo),combo_items);
	g_list_free(combo_items);

	

	/* Window */
/*	window = ctk_window_new(CTK_WINDOW_TOPLEVEL);
	ctk_widget_set_size(window,10,10,20,20);
   	ctk_window_set_title(window,"Test Window 2");
	ctk_window_set_modal(window,TRUE);
	ctk_widget_show(window); */

	ctk_assert(ctk_notebook_get_nth_page(CTK_NOTEBOOK(notebook),
		1) == table, "Bad notebook behaviour");
	ctk_assert(ctk_notebook_get_nth_page(CTK_NOTEBOOK(notebook),
		2) == clisthbox, "Bad notebook behaviour");
	ctk_assert(ctk_notebook_get_nth_page(CTK_NOTEBOOK(notebook),
		3) == vbox, "Bad notebook behaviour");
	ctk_assert(ctk_notebook_get_nth_page(CTK_NOTEBOOK(notebook),
		4) == NULL, "Bad notebook behaviour");
	ctk_assert(ctk_notebook_get_nth_page(CTK_NOTEBOOK(notebook),
		-1) == NULL, "Bad notebook behaviour");
	
//	ctk_widget_destroy(vbox);
//	ctk_notebook_remove_page(CTK_NOTEBOOK(notebook), 3);

	ctk_window_set_focus(CTK_WINDOW(window), vscale);
	
	ctk_main();
	ctk_widget_destroy(window);

	ctk_close();

	return 0;
}
