/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__MEMORYSTORAGE_HPP)
#include <MemoryStorage.hpp>
#endif

namespace corelinux
{
   // Constructor

   MemoryStorage::MemoryStorage( void )
      throw( Assertion )
      :
      TransientStorage(),
      Synchronized(),
      theIdentifier( 0 ),
      theSize( 0 ),
      theBasePointer( NULLPTR ),
      theCurrentPointer( NULLPTR )
   {
      NEVER_GET_HERE;
   }

   // Copy constructor

   MemoryStorage::MemoryStorage( MemoryStorageCref aRef )
      :
      TransientStorage( aRef ),
      Synchronized( aRef ),
      theIdentifier( aRef.theIdentifier ),
      theSize( aRef.theSize ),
      theBasePointer( aRef.theBasePointer ),
      theCurrentPointer( aRef.theCurrentPointer )
   {
      ;  // vacuous, do nothing
   }

   MemoryStorage::MemoryStorage
      ( 
         MemoryIdentifierCref anId, 
         IntCref aSize, 
         VoidPtr aBase
      )
      :
      TransientStorage( ),
      theIdentifier( anId ),
      theSize( aSize ),
      theBasePointer( aBase ),
      theCurrentPointer( aBase )
   {

   }

   // Destructor

   MemoryStorage::~MemoryStorage( void )
   {
      theIdentifier = 0 ;
      theSize = 0 ;
      theBasePointer =  NULLPTR;
      theCurrentPointer =  NULLPTR;
   }

   // Operator assignment

   MemoryStorageRef  MemoryStorage::operator=( MemoryStorageCref aRef )
   {
      return MemoryStorageRef(TransientStorage::operator=(aRef));
   }

   // Equality operator

   bool MemoryStorage::operator==( MemoryStorageCref aRef ) const
   {
      return ( theIdentifier == aRef );
   }

   // Identifier coercion

   MemoryStorage::operator MemoryIdentifierCref( void ) const
   {
      return theIdentifier;
   }

   // Index increment

   void  MemoryStorage::operator+( Int aIncrement ) throw( BoundsException )
   {
      BytePtr  aCp((BytePtr(theCurrentPointer) + aIncrement));
      Int      pos(aCp - BytePtr(theBasePointer) );

      if( pos < 0 || pos > theSize )
      {
         throw BoundsException( LOCATION );
      }
      else
      {
         theCurrentPointer = VoidPtr(aCp);
      }
   }

   // Index decrement

   void  MemoryStorage::operator-( Int aIncrement ) throw( BoundsException )
   {
      BytePtr  aCp((BytePtr(theCurrentPointer) - aIncrement));
      Int      pos(aCp - BytePtr(theBasePointer) );

      if( pos < 0 || pos > theSize )
      {
         throw BoundsException( LOCATION );
      }
      else
      {
         theCurrentPointer = VoidPtr(aCp);
      }
   }

   // Absolute offset

   MemoryStorageRef MemoryStorage::operator[]( Int offset )
      throw( BoundsException )
   {
      theCurrentPointer = theBasePointer;
      (*this) + offset;
      return (*this);
   }

   // Protected access

   VoidPtr  MemoryStorage::getBasePointer( void )
   {
      return theBasePointer;
   }
}



/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.4 $
   $Date: 2000/06/06 12:04:12 $
   $Locker:  $
*/


