/*
  CLAW - a C++ Library Absolutely Wonderful

  CLAW is a free library without any particular aim but being useful to 
  anyone.

  Copyright (C) 2005-2008 Julien Jorge

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: julien_jorge@yahoo.fr
*/
/**
 * \file string_algorithm.hpp
 * \brief Generic algorithms on strings.
 * \author Julien Jorge
 */
#ifndef __CLAW_STRING_ALGORITHM_HPP__
#define __CLAW_STRING_ALGORITHM_HPP__

namespace claw
{
  namespace text
  {
    template<typename StreamType, typename StringType>
    StreamType& getline( StreamType& is, StringType& str );

    template<class StringType>
    void trim_left( StringType& str,
                    const typename StringType::value_type* const s = " " );

    template<class StringType>
    void trim_right( StringType& str,
                     const typename StringType::value_type* const s = " " );

    template<class StringType>
    void trim( StringType& str,
               const typename StringType::value_type* const s = " " );

    template<class StringType>
    void squeeze( StringType& str,
                  const typename StringType::value_type* const s );

    template<typename T, class StringType>
    bool is_of_type( const StringType& str );

    template<class BackInsertion, class StringType>
    void split( BackInsertion& sequence, const StringType& str,
		const typename StringType::value_type sep );

  } // namespace text
} // namespace claw

#include <claw/impl/string_algorithm.tpp>

#endif // __CLAW_STRING_ALGORITHM_HPP__
