#include <buffy/System.h>
#include <wibble/exception.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>


using namespace std;
using namespace wibble;

namespace buffy
{

Directory::Directory(const std::string& name) : dir(0)
{
	if ((dir = opendir(name.c_str())) == NULL)
		throw wibble::exception::File(name, "opening directory");
}

void stat(const std::string& name, struct stat* st)
{
	if (::stat(name.c_str(), st) != 0)
			throw wibble::exception::File(name, "getting stat() informations");
}

bool statIfFound(const std::string& name, struct stat* st)
{
	if (::stat(name.c_str(), st) != 0)
		if (errno == ENOENT)
			return false;
		else
			throw wibble::exception::File(name, "getting stat() informations");
	return true;
}


}

// vim:set ts=4 sw=4:
