/*
 * dstore.c - PTX global storage for lsof
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1995 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.7 2000/06/25 17:34:16 abe Exp $";
#endif


#include "lsof.h"


/*
 * Global storage definitions
 */

int CloneMaj;				/* clone major device number */


/*
 * Drive_Nl -- table to drive the building of Nl[] via build_Nl()
 *             (See lsof.h and misc.c.)
 */

struct drive_Nl Drive_Nl[] = {
	{ "asoplg",	"asops_large"	},
	{ "asopsm",	"asops_small"	},
	{ "cvops",	"cdfs_vnodeops"	},
	{ "clmaj",	"clone_c_major"	},
	{ X_DNLCA,	"dnlc_array"	},
	{ X_DNLCM,	"dnlc_mask"	},
	{ "fvops",	"fifo_vnodeops"	},
        { X_NCACHE,	"ncache"	},
        { X_NCSIZE,	"ncsize"	},
        { "nfsvops",	"nfs_vnodeops"	},
        { "nmvops",	"nm_vnodeops"	},
        { "nofile",	"Nofile"	},
        { "proc",	"proc"		},
	{ "sckvops",	"sock_vnodeops"	},
	{ "spvops",	"spec_vnodeops"	},
	{ "uvops",	"ufs_vnodeops"	},
	{ "var",	"v"		},
	{ "vvops",	"vx_vnodeops"	},
	{ "vxdnlc",	"vx_dnlc_hash"	},
	{ "vxndnlc",	"vx_dnlc_nhash"	},
	{ "",		""		},
	{ NULL,		NULL,		}
};

int HaveCloneMaj = 0;			/* CloneMaj status */
int Kd = -1;				/* /dev/kmem file descriptor */
struct l_vfs *Lvfs = NULL;		/* local vfs structure table */
int Notkmem = 0;			/* core file is not /dev/kmem */

#if	defined(HASFSTRUCT)
/*
 * Pff_tab[] - table for printing file flags
 */

struct pff_tab Pff_tab[] = {
	{ (long)FREAD,		FF_READ		},
	{ (long)FWRITE,		FF_WRITE	},
	{ (long)FNDELAY,	FF_NDELAY	},
	{ (long)FAPPEND,	FF_APPEND	},
	{ (long)FSYNC,		FF_SYNC		},
	{ (long)FASYNC,		FF_ASYNC	},
	{ (long)FNOCTTY,	FF_NOCTTY	},
	{ (long)FRCACH,		FF_RCACH	},

# if	defined(FNONBLOCK)
	{ (long)FNONBLOCK,	FF_NBLOCK	},
# endif	/*defined(FNONBLOCK) */
	{ (long)FSQNTSHARED,	FF_SQTSH	},

# if	defined(FSQNTSVM)
	{ (long)FSQNTSVM,	FF_SQTSVM	},
# endif	/* defined(FSQNTSVM) */

# if	defined(FSQNTREPAIR)
	{ (long)FSQNTREPAIR,	FF_SQTREPAIR	},
# endif	/*defined(FSQNTREPAIR) */

# if	defined(FSQNTSH1)
	{ (long)FSQNTSH1,	FF_SQTSH1	},
# endif	/*defined(FSQNTSH1) */

# if	defined(FSQNTSH2)
	{ (long)FSQNTSH2,	FF_SQTSH2	},
# endif	/*defined(FSQNTSH2) */

# if	defined(FNOTOSTOP)
	{ (long)FNOTOSTOP,	FF_NOTOSTOP	},
# endif	/* defined(FNOTOSTOP) */

# if	defined(FVHANGUP)
	{ (long)FVHANGUP,	FF_VHANGUP	},
# endif	/* defined(FVHANGUP) */

# if	defined(FHUPED)
	{ (long)FHUPED,		FF_HUP		},
# else	/* !defined(FHUPED) */
	{ (long)0x4000,		FF_HUP		},
# endif	/* defined(FHUPED) */

# if	defined(FGENTTY)
	{ (long)FGENTTY,	FF_GENTTY	},
# endif	/* defined(FGENTTY) */

# if	defined(FKIOCTL)
	{ (long)FKIOCTL,	FF_KIOCTL	},
# endif	/* defined(FKIOCTL) */

# if	defined(FWAKEUP)
	{ (long)FWAKEUP,	FF_WAKEUP	},
# endif	/* defined(FWAKEUP) */

# if	defined(FWAKEUP)
	{ (long)FWAITING,	FF_WAITING	},
# endif	/* defined(FWAKEUP) */

# if	defined(FLARGEFILE)
	{ (long)FLARGEFILE,	FF_LARGEFILE	},
# endif	/*defined(FLARGEFILE) */

# if	defined(FTCP_IN_MDEVONLY)
	{ (long)FTCP_IN_MDEVONLY,
				FF_TCP_MDEVONLY	},
# endif	/* defined(FTCP_IN_MDEVONLY) */

	{ (long)0,		NULL		}
};


/*
 * Pof_tab[] - table for print process open file flags
 */

struct pff_tab Pof_tab[] = {

# if	defined(UF_EXCLOSE)
	{ (long)UF_EXCLOSE,	POF_CLOEXEC	},
# endif	/* defined(UF_EXCLOSE) */

# if	defined(UF_ALLOC)
	{ (long)UF_ALLOC,	POF_ALLOCATED	},
# endif	/* defined(UF_ALLOC) */

# if	defined(UF_FDLOCK)
	{ (long)UF_FDLOCK,	POF_FDLOCK	},
# endif	/* defined(UF_FDLOCK) */

# if	defined(UF_CLOSING)
	{ (long)UF_CLOSING,	POF_CLOSING	},
# endif	/* defined(UF_CLOSING) */

	{ (long)0,		NULL		}
};
#endif	/* defined(HASFSTRUCT) */

# if	PTXV<400
int Swap = -1;				/* swap device file descriptor */
# endif	/* PTXV<400 */
