/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This header file declares the functions for ansi, ascii, and csv,
 * and the various data structures, global variables, and whatnot.
 */

void lt_setup();
void lt_read_config();
void lt_set_config();
void lt_set_config_err();
void lt_run();
void lt_cleanup();

/* The various output module functions */
void lt_parse_raw();
void lt_parse_ansi(); void lt_colorset_ansi();
void lt_parse_ascii();
void lt_parse_csv(); void lt_parse_csv_header();
void lt_parse_html(); void lt_colorset_html();

/* utility functions */
void lt_sh_usage();
void lt_getopts();

/*  From the regex.c file (regular expression stuff's) */
int lt_check_exclude();
int lt_check_include();
int lt_match(const char *string, char *pattern);
int lt_setgreen();
int lt_setyellow();
int lt_setexclude();
int lt_setinclude();
void lt_loadstrings();
void lt_regex_vars_sanity();
void lt_regexinit();
int lt_fmtcheck(char *tmp);

/* from parser.c */
int lt_do_parse();
void lt_set_event_color();

/* 
 * strncasecmp seems to have a few portability issues, so we use 
 * configure to test for it, and if it's not decl'd, we do it here
 */
/* Note: Why in the HELL do I have to define this, even though configure 
 * says I've already got it?
 */
#ifndef HAVE_STRNCASECMP
int strncasecmp(const char *s1, const char *s2, size_t size); 
#endif

/*
 * This is the structure each line of syslog file get's parsed into.  
 */

typedef struct {
	short int type;      	/* At the moment we don't use this (just know one type)	*/
      	char pcolor[256];	/* event color red, yellow, green, default 		*/
	char month[4];		
	char day[3];
	char time[9];
	char source[64];
	char program[64];
	char message[256];	/* the current message in full (- timestamps) 	*/
	char lmessage[256];	/* the last message in full (- timestamps) 	*/
	char raw[1024];		/* the full event in RAW format			*/
} st_event;
st_event event;

/* Structure to hold the regcomp() paterns */
typedef struct {
	regex_t include;
	regex_t exclude;
	regex_t green;
	regex_t yellow;
} st_regcomp;
st_regcomp st_regex;

/* Structure for the include true/false stuff */
typedef struct {
	short int exclude;
	short int include;
	short int yellow;
	short int green;
} st_checks;
st_checks checks;

/* Structure for the event color variables */
typedef struct {
	char red[256];
	char green[256];
	char yellow[256];
	char white[256];
	char cyan[256];
	char brightcyan[256];
	char unknown[256];
	char end[256];
} st_color;
st_color color;

/*  Want to convert the global int's below into this struct in the near future  */
typedef struct {
	short int time;
	short int host; 
} st_fmt;
st_fmt format;

short int outfmt;
short int verbose;
short int redbeep;      /* to beep, or not to beep, that is the question..	*/
short int timefmt;	/* define what format the time output should be 	*/
short int showprog;	/* do we display the 'program' field from syslog 	*/
short int showsrc;	/* define if we want to show the src host or not	*/

extern int errno;	/* the error number thing from the errno functions	*/

/*
 * The file string variables we use when setting up to read in the strings from
 * the config files.  This should be a global struct too.
 */
char yellowfile[1024];
char greenfile[1024];
char includefile[1024];
char excludefile[1024];
char configfile[1024];

/* This is where we put those strings when we get done reading in the above */

/* 
 * Note: I need to make this dynamicly allocated, but I don't know how. :)  
 * I also need to make this a global struct rather than global variables, but 
 * I ain't got around to it yet.
 */
char greenstrings[16384];
char yellowstrings[16384];
char excludestrings[16384];
char includestrings[16384];

