/* WARNING ____ IMMATURE API ____ liable to change */

/* gnome-href.h
 * Copyright (C) 1998, James Henstridge <james@daa.com.au>
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 */

/*
 * hacked up by Evan Martin <evan@livejournal.com> for LogJam.
 */

#ifndef HALFGNOME_HREF_H
#define HALFGNOME_HREF_H

#ifdef HAVE_GNOME

#define halfgnome_href_new(a, b)      gnome_href_new(a, b)
#define halfgnome_href_set_url (a, b) gnome_href_set_url (a, b) 
#define halfgnome_href_get_url (a)    gnome_href_get_url (a)   
#define halfgnome_href_set_text(a, b) gnome_href_set_text(a, b)
#define halfgnome_href_get_text(a)    gnome_href_get_text(a)   
#else

#include <glib.h>
#include <gtk/gtkbutton.h>

#define GNOME_TYPE_HREF            (halfgnome_href_get_type ())
#define GNOME_HREF(obj)            (GTK_CHECK_CAST((obj), GNOME_TYPE_HREF, GnomeHRef))
#define GNOME_HREF_CLASS(klass)    (GTK_CHECK_CLASS_CAST((klass), GNOME_TYPE_HREF, GnomeHRefClass))
#define GNOME_IS_HREF(obj)         (GTK_CHECK_TYPE((obj), GNOME_TYPE_HREF))
#define GNOME_IS_HREF_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_HREF))

typedef struct _GnomeHRef GnomeHRef;
typedef struct _GnomeHRefClass GnomeHRefClass;


struct _GnomeHRef {
  GtkButton button;

  /*< private >*/
  gchar *url;
  GtkWidget *label;
};

struct _GnomeHRefClass {
  GtkButtonClass parent_class;
};

/*
 * GNOME href class methods
 */

guint halfgnome_href_get_type(void);
GtkWidget *halfgnome_href_new(const gchar *url, const gchar *text);

void halfgnome_href_set_url(GnomeHRef *href, const gchar *url);
gchar *halfgnome_href_get_url(GnomeHRef *href);

void halfgnome_href_set_text(GnomeHRef *href, const gchar *text);
gchar *halfgnome_href_get_text(GnomeHRef *href);

#endif /* HAVE_GNOME */
#endif /* HALFGNOME_HREF_H */

