" Fichier de syntaxe XML pour Logide, bas sur le file de Syntaxe XML
" standard de vim et les macros de Marc Simon

" <BS> = 2 espaces en arrire, <TAB> = 2 espaces en avant
set sts=2
set sw=2

"
" Macros
"

imap ,pag <page><CR><title></title><CR><CR></page><CR><ESC>3kf>a
imap ,ti <title></title><ESC>F>a
imap ,ta <table><CR>  <CR><BS></table><ESC>ka
imap ,ro <row><CR>  <CR><BS></row><ESC>ka
imap ,it <item></item><ESC>F>a
imap ,ref <ref></ref><ESC>F>a
imap ,ob <objectives><CR>  <CR><BS></objectives><ESC>ka
imap ,et <state finished="" proofread="false"/><ESC>3F"i
imap ,de <dependency></dependency><ESC>F>a
imap ,su <suggestion></suggestion><ESC>F>a
imap ,au <author></author><ESC>F>a
imap ,ve <version number=""><CR><author></author><CR><comment></comment><CR><BS></version><ESC>3kf"a
imap ,in <info><CR>  <title></title><CR><ref></ref><CR><description><CR><para></para><CR></description><CR><objectives><CR>  <item></item><CR><BS></objectives><CR><ratio value="th/pr"/><CR><duration value="" unit=""/><CR><!--<prerequisite></prerequisite><CR><dependency><CR>  <ref></ref><CR><BS></dependency><CR><suggestion><CR>  <ref></ref><CR><BS></suggestion>--><CR><version number="1.0"><CR>  <author></author><CR><comment></comment><CR><BS></version><CR><level value=""/><CR><state finished="false" proofread="false"/><CR><!--<proofreaders><CR></proofreaders>--><CR><BS></info>
imap ,se <section><CR><title></title><CR><para></para><CR></section><ESC>2kF>a
imap ,sl <slide><CR><title></title><CR></slide><CR><ESC>kkf>a
imap ,par <para></para><ESC>F>a
imap ,em <em></em><ESC>F>a
imap ,cod <code></code><ESC>F>a
imap ,no <note></note><ESC>F>a
imap ,ex <exercise></exercise><ESC>F>a
imap ,qu <question></question><ESC>F>a
imap ,an <answer></answer><ESC>F>a
imap ,li <list><CR><item></item><CR><item></item><CR></list><CR><ESC>kkkf>a
imap ,col <col></col><ESC>F>a
imap ,fi <file></file><ESC>F<i
imap ,cm <cmd></cmd><ESC>F<i
imap ,me <menu></menu><ESC>F<i
imap ,im <image src=""/><ESC>F"i
imap ,uh <url href="http://"></url><ESC>F"i
imap ,ur <url href="http://"></url><ESC>F"i
imap ,uf <url href="ftp://"></url><ESC>F"i
imap &n &nbsp;
imap  &n&n<ESC>2F;a

imap ,xm <?xml version="1.0" encoding="ISO-8859-1" standalone="no" ?><CR>
imap ,dt <!DOCTYPE module PUBLIC "-//Logidee//DTD logidee-tools V1.2//EN" "../dtd/module.dtd"><CR>
imap ,fo <formation xmlns:xi="http://www.w3.org/2001/XInclude"><CR>  ,in<CR><BS></formation><ESC>ko
imap ,th <theme xmlns:xi="http://www.w3.org/2001/XInclude"><CR>  ,in<CR><BS></theme><ESC>ko
imap ,xi <xi:include href=""/><ESC>F"i
imap ,com <!--  --><ESC>F i

vmap ,com <ESC>'<<HOME>i<!--<ESC>'><END>a--><ESC>

"
" Syntaxe
"

syn clear

" Following items are case-sensitive
" Case-insensitive rules can be specified by 'syn case ignore' later
syn case ignore

" mark illegal characters
syn match xmlError "[<>&]"


" tags
syn match   xmlSpecial  contained "\\\d\d\d\|\\."
syn region  xmlString   contained matchgroup=xmlStringQ start=+"+ skip=+\\\\\|\\"+ end=+"+ contains=xmlSpecial,xmlSpecialChar
syn region  xmlString   contained matchgroup=xmlStringQ start=+'+ skip=+\\\\\|\\'+ end=+'+ contains=xmlSpecial,xmlSpecialChar
syn region  xmlEndTag             start=+</+    end=+>+              contains=xmlTagError,xmlLogideeMTagName,xmlLogideeDTagName,xmlLogideeCTagName
syn region  xmlTag                start=+<[^/]+ end=+>+              contains=xmlString,xmlTagError,xmlLogideeMTagName,xmlLogideeArgName,xmlLogideeCTagName,xmlLogideeDTagName
syn match   xmlTagError contained "[^>]<"ms=s+1

" TAGS LOGIDEE
syn keyword xmlLogideeMTagName contained module info page slide section
syn keyword xmlLogideeMTagName contained exercise formation theme

syn keyword xmlLogideeDTagName contained file url menu note image cmd
syn keyword xmlLogideeDTagName contained item em code title legend col

syn keyword xmlLogideeCTagName contained question answer 
syn keyword xmlLogideeCTagName contained para list table row
syn keyword xmlLogideeCTagName contained prerequisite dependency suggestion
syn keyword xmlLogideeCTagName contained ref description author comment
syn keyword xmlLogideeCTagName contained email date
syn keyword xmlLogideeCTagName contained ratio duration version level state
syn keyword xmlLogideeCTagName contained objectives include proofreaders

" ARGS LOGIDEE
syn keyword xmlLogideeArgName contained value unit trainer src visible 
syn keyword xmlLogideeArgName contained finished proofread number href
syn keyword xmlLogideeArgName contained restriction icon background head
syn keyword xmlLogideeArgName contained border

" special characters
syn match   xmlSpecialChar contained "&[^;]*;"
syn match   xmlSpecialChar "&[^;]*;"

syn keyword xmlTodo         contained TODO FIXME XXX

" The real comments (this implements the comments as defined by xml,
" but not all xml pages actually conform to it. Errors are flagged.
syn region  xmlComment                start=+<!+        end=+>+ contains=xmlCommentPart,xmlString,xmlCommentError,xmlTodo
syn match   xmlCommentError contained "[^><!]"
syn region  xmlCommentPart  contained start=+--+        end=+--+

" DTD -- we use dtd.vim here
syn region  xmlDocType matchgroup=xmlDocTypeDecl start="<!DOCTYPE"he=s+2,rs=s+2 end=">" contains=xmlDocTypeKeyword,xmlInlineDTD,xmlString
syn keyword xmlDocTypeKeyword contained DOCTYPE PUBLIC SYSTEM
syn region  xmlInlineDTD contained start="\[" end="]" contains=@xmlDTD
syn include @xmlDTD /usr/share/vim/vim57/syntax/dtd.vim

" Processing instructions
" This allows "?>" inside strings -- good idea?
syn region  xmlProcessing matchgroup=xmlProcessingDelim start="<?" end="?>" contains=xmlString

" CData sections
syn region  xmlCdata matchgroup=xmlCdataDecl start="<!\[CDATA\[" keepend end="]]>"

" synchronizing (does not always work if a comment includes legal
" xml tags, but doing it right would mean to always start
" at the first line, which is too slow)
syn sync match xmlHighlight groupthere NONE "<[/a-zA-Z]"
syn sync match xmlHighlightSkip "^.*['\"].*$"
syn sync minlines=10

if !exists("did_logidee_xml_syntax_inits")
  let did_logidee_xml_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  "
  hi link xmlTodo                      Todo
  hi link xmlEndTag                    xmlTag
  hi link xmlTag                       Identifier
  hi link xmlSpecialChar               xmlSpecial
  hi link xmlSpecial                   Special
  hi link xmlStringQ                   Special
  hi link xmlString                    Normal
  hi link xmlCommentPart               xmlComment
  hi link xmlComment                   Comment
  hi link xmlCommentError              xmlError
  hi link xmlTagError                  xmlError
  hi link xmlError                     Error

  hi link xmlProcessingDelim           Comment
  hi link xmlProcessing                Type
  hi link xmlCdata                     Normal
  hi link xmlCdataDecl                 Constant
  hi link xmlDocType                   Normal
  hi link xmlDocTypeDecl               Identifier
  hi link xmlDocTypeKeyword            Statement
  hi link xmlInlineDTD                 Identifier

  hi link xmlLogideeMTagName           Constant
  hi link xmlLogideeCTagName           Special
  hi link xmlLogideeDTagName           Statement
  hi link xmlLogideeArgName            Type

endif

"let b:current_syntax = "xml"

" vim: ts=8
