/*
        linuxinfo_intel.c

        Copyright (C) 1998-2000
        All Rights Reserved.

        Alex Buell <alex.buell@tahallah.demon.co.uk>

        Advanced Buell Software Engineering Ltd
        Hampshire, GU31 5DG
        United Kingdom

        Version Author  Date            Comments
        ----------------------------------------------------------------------
        1.0.0   AIB     199803??        Initial development
	1.0.1	AIB	20000405	Updated and reworked code
	1.0.2	AIB	20000527	Addded AMD K7

        This is the Intel port of linuxinfo
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>

#include "linuxinfo.h"

#ifdef system_intel

static char *vendors[] =
{
	"GenuineIntel", "Intel",
	"AuthenticAMD", "AMD",
	"CyrixInstead", "Cyrix",
	"UMC UMC UMC ", "UMC",
	"CentaurHauls", "Centaur",
	"NexGenDriven", "NexGen",
	NULL, NULL
};

static char *models[] =
{
        "K6 (166 - 266)", "K6",
        "AMD-K6tm w/ mul", "K6 (MMX)",
        "K6-2 (PR233 - PR333)", "K6-2",
        "AMD-K6(tm) 3D", "K6-3 (3DNow)",
        "AMD-K6(tm) 3D+", "K6-3 (3DNow+)",
	"AMD-K7(tm)", "K7",
	"Athlon", "Athlon",
        "Am5x86", "5x86",
        "C6", "C6",
	"C6-2", "C6-2",
        "6x86", "6x86",
        "6x86MX", "6x86MX",
        "Pentium 75+", "Pentium",
        "Pentium 75 - 200", "Pentium",
        "Pentium MMX", "Pentium MMX",
        "Mobile Pentium MMX", "Mobile Pentium MMX",
        "Pentium Pro", "Pentium Pro",
        "Pentium II (Klamath)", "Pentium II (Klamath)",
        "Pentium II (Deschutes)", "Pentium II (Deschutes)",
        "Pentium III (Katmai)", "Pentium III (Katmai)",
	"Pentium III (Coppermine)", "Pentium III (Coppermine)",
        "Celeron (Mendocino)", "Celeron (Mendocino)",
        "Celeron (Covington)", "Celeron (Covington)",
        NULL, NULL
};

void GetHardwareInfo(int fd, struct hw_stat *hw)
{
	char chip[BUFSIZ], vendor[BUFSIZ], model[BUFSIZ], Mhz[BUFSIZ], family[BUFSIZ];
	char temp_string[BUFSIZ], temp_string2[BUFSIZ];

	struct stat st_buf;

	int processors = 0; 
	float bogomips = 0.0;
	float tempMHz = 0.0;
	LONGLONG memory = 0;
	float tempbogo;

	char *p;

	strcpy(chip, "Unknown");
	strcpy(vendor, "Unknown");
	strcpy(model, "Unknown");
	strcpy(family, "Unknown");

	while (read_line(fd, temp_string, BUFSIZ) != 0) 
	{
		if (splitstring(temp_string, temp_string2))
		{
			if (strncmp(temp_string, "processor", strlen("processor")) == 0)
				processors++;

			if (strncmp(temp_string, "vendor_id", strlen("vendor_id")) == 0)
			{
				int i = 0;

				while (vendors[i] != NULL)
				{
					if (strncmp(temp_string2, vendors[i], strlen(vendors[i])) == 0)
						strcpy(vendor, vendors[++i]);

					i += 2;
				}
			}

			if (strncmp(temp_string, "model", strlen("model")) == 0) 
			{
				int i = 0;
		
				while (models[i] != NULL)
				{
					if (strncmp(temp_string2, models[i], strlen(models[i])) == 0)
						strcpy(model, models[++i]);

					i += 2;
				}
			}

			if (strncmp(temp_string, "cpu family", strlen("cpu family")) == 0)
				strcpy(family, temp_string2);

			if (strncmp(temp_string, "cpu MHz", strlen("cpu MHz")) == 0)
				tempMHz = atol(temp_string2);

			if (strncmp(temp_string, "bogomips", strlen("bogomips")) == 0)
				bogomips = bogomips + atof(temp_string2);
		}

		
	}

	stat(MEMORY_FILE, &st_buf);
	memory = st_buf.st_size;
	memory /= 1024; memory /= 1024;
	sprintf(hw->hw_memory, "%ld", (long int)memory);

	hw->hw_processors = processors;
	sprintf(hw->hw_cpuinfo, "%s %s", vendor, model);

	if ((strcmp(vendor, "Unknown") == 0) && (strcmp(model, "Unknown") == 0))
	{
		switch (family[0])
		{
			case '4': sprintf(hw->hw_cpuinfo, "Unknown 486");
				break;
		}
	}

	sprintf(hw->hw_bogomips, "%0.2f", bogomips);

	if (tempMHz == 0.0)
		sprintf(hw->hw_megahertz, "?");
	else
		sprintf(hw->hw_megahertz, "%d", (int)tempMHz);
}

#endif /* system_intel */
