/*
	linuxinfo_alpha.c

        Copyright (C) 1998-2000
        All Rights Reserved.

        Alex Buell <alex.buell@tahallah.demon.co.uk>

        Advanced Buell Software Engineering Ltd
        Hampshire, GU31 5DG
        United Kingdom

        Version Author  Date            Comments
        ----------------------------------------------------------------------
        1.0.0   AIB     199803??        Initial development
	1.0.1	AIB	20000405	Now detects MHz, code rewritten

        This is the Alpha port of linuxinfo

*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>

#include "linuxinfo.h"

#ifdef system_alpha

void GetHardwareInfo(int fd, struct hw_stat *hw)
{
	int processors = 0; 
	float bogomips = 0.0;
	float megahertz = 0.0;
	float tempbogo;
	LONGLONG memory = 0;

	char temp_string[BUFSIZ], temp_string2[BUFSIZ];
	char chip[BUFSIZ], vendor[BUFSIZ], model[BUFSIZ] = "Unknown";

	struct stat st_buf;

	while (read_line(fd, temp_string, BUFSIZ) != 0)
	{
		splitstring(temp_string, temp_string2);

		if (!(strncmp(temp_string, "cpu model", strlen("cpu model"))))
			strcpy(model, temp_string2);

		if (!(strncmp(temp_string, "BogoMIPS", strlen("BogoMIPS"))))
		{
			processors++;
			sscanf(temp_string2, "%f", &tempbogo);
			bogomips += tempbogo;	
		}

		if (!(strncmp(temp_string, "cycle frequency [Hz]", strlen("cycle frequency [Hz]"))))
		{
			sscanf(temp_string2, "%f", &megahertz);
			if (megahertz > 0)
				megahertz /= 1000000;

			if (megahertz != 0)
				sprintf(hw->hw_megahertz, "%.2f", megahertz);
			else
				strcpy(hw->hw_megahertz, "?");
		}
	}

	stat(MEMORY_FILE, &st_buf);
	memory = st_buf.st_size;
	memory /= 1024; memory /= 1024;
	sprintf(hw->hw_memory, "%ld", (long int)memory);

	hw->hw_processors = processors;
	
	sprintf(hw->hw_cpuinfo, "Alpha %s", model);
	sprintf(hw->hw_bogomips, "%0.2f", bogomips);
}

#endif /* system_alpha */
