#pragma interface
#ifndef USERCOMNG_H
#define USERCOMNG_H

#ifndef MISC_H
	#include <misc.h>
#endif

class DIALOG;
class M_DIALOG;
class USER;
class USERS;
class GROUPS;

#ifndef DICTIONARY_H
	#include <dictionary.h>
#endif

// User account co managers

class USERACCT_COMNG: public ARRAY_OBJ{
protected:
	DICTIONARY &dict;
	/*~PROTOBEG~ USERACCT_COMNG */
public:
	USERACCT_COMNG (DICTIONARY&_dict);
	virtual int deluser (PRIVILEGE *);
	virtual int save (PRIVILEGE *);
	virtual void setupdia (DIALOG&dia);
	virtual void setupdia (M_DIALOG&);
	virtual int validate (DIALOG&dia, int &nof);
	virtual int validate (M_DIALOG&, int &);
	/*~PROTOEND~ USERACCT_COMNG */
};

class USERACCT_COMNGS: public ARRAY {
	DICTIONARY dict;
	/*~PROTOBEG~ USERACCT_COMNGS */
public:
	void deluser (PRIVILEGE *priv);
	bool get_bool (const char *var)const;
	int get_int (const char *var)const;
	void *get_obj (const char *var)const;
	const char *get_str (const char *var)const;
	void getall (const char *key);
	USERACCT_COMNG *getitem (int no)const;
	void save (PRIVILEGE *priv);
	void set_bool (const char *var, bool val);
	void set_int (const char *var, int val);
	void set_obj (const char *var, void *obj);
	void set_str (const char *var,
		 const char *val);
	void setupdia (DIALOG&dia);
	void setupdia (M_DIALOG&dia);
	int validate (DIALOG&dia, int &nof);
	int validate (M_DIALOG&dia, int &nof);
	/*~PROTOEND~ USERACCT_COMNGS */
};

class REGISTER_USERACCT_COMNG{
public:
	USERACCT_COMNG *(*fct)(const char *, DICTIONARY &);
	REGISTER_USERACCT_COMNG *next;
	/*~PROTOBEG~ REGISTER_USERACCT_COMNG */
public:
	REGISTER_USERACCT_COMNG (USERACCT_COMNG * (fct
		)(const char *key, DICTIONARY&));
	/*~PROTOEND~ REGISTER_USERACCT_COMNG */
};

#endif

