#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "usersbygroup.h"
#include "usersbygroup.m"

MODULE_DEFINE_VERSION(usersbygroup);

PUBLIC MODULE_usersbygroup::MODULE_usersbygroup()
	: LINUXCONF_MODULE("usersbygroup")
{
	linuxconf_loadmsg ("usersbygroup",PACKAGE_REV);
}


static const char *keymenu=NULL;
static const char *keyspecial=NULL;

PUBLIC void MODULE_usersbygroup::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_USER_POLICIES){
		keymenu = MSG_U(M_usersbygroup,"Configure special groups");
		dia.new_menuitem ("usersbygroup","",keymenu);
	}else if (context == MENU_USER_SPC){
		keyspecial = MSG_U(M_specialgroup,"special groups");
		dia.new_menuitem ("usersbygroup","",keyspecial);
	}
}

PUBLIC int MODULE_usersbygroup::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_USER_POLICIES){
		if (key == keymenu){
			usersbg_config();
		}
	}else if (context == MENU_USER_SPC){
		if (key == keyspecial){
			usersbg_edit();
		}
	}
	return 0;
}

static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain usersbygroup usage\n"
		 "\n"
		 "    Without argument, enter special groups administration\n")
		);
}

PUBLIC void MODULE_usersbygroup::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_usersbygroup::execmain (int argc , char *argv[], bool )
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"usersbygroup")==0){
		ret = -1;
		if (argc == 1){
			usersbg_edit();
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_usersbygroup usersbygroup;

