#!/bin/bash
# This script will reset the KDE settings of some users.
# This is mainly useful when the user have broken his setup to no end
# (we are talking about children in schools)
if [ $# -lt 2 ] ; then
	echo reset-kde.sh -- user1 user2 ...
	exit 1
else
	if [ "$1" != "--" ] ; then
		echo install-bookmark.sh ref-user -- user1 user2 ...
		exit 1
	else
		for user in $*
		do
			# Playing games with bash so that is maps ~$refuser to the home
			# directory of $refuser
			echo Resetting KDE settings for user $user
			HOMEUSER=`eval echo ~$user`
			mv $HOMEUSER/.kderc $HOMEUSER/.kderc.old
			rm -fr $HOMEUSER/.kde.old
			mv $HOMEUSER/.kde $HOMEUSER/.kde.old
		done
	fi
fi

