#include <string.h>
#include <unistd.h>
#include <misc.h>
#include "shellmod.h"
#include "shellmod.m"
#include "protocol.h"

static int shellprg_runmain (
	const char *cmd,
	char *argv[],
	int start,
	int end)
{
	int ret = -1;
	SHELL_INSTANCE inst (cmd);
	if (inst.isalive()){
		SSTRING buf ("main ");
		for (int i=start; i<end; i++){
			buf.append ("\"");
			buf.append (argv[i]);
			buf.append ("\" ");
		}
		char cdcmd[PATH_MAX],cwd[PATH_MAX];
		snprintf (cdcmd,PATH_MAX-1,"cd %s",getcwd(cwd,sizeof(cwd)-1));
		inst.runfunc (cdcmd);
		ret = inst.runfunc (buf.get());
	}
	return ret;
}

static int shellprg_setabs (const char *relpath, char abspath[PATH_MAX])
{
	int ret = 0;
	if (relpath[0] != '/'){
		char cwdpath[PATH_MAX];
		const char *cwd = getcwd(cwdpath,sizeof(cwdpath));
		if (cwd == NULL){
			fprintf (stderr,MSG_U(E_CWD,"Can't find current working directory, odd!\n"));
			ret = -1;
		}else{
			snprintf (abspath,PATH_MAX-1,"%s/%s",cwdpath,relpath);
		}
	}else{
		strcpy (abspath,relpath);
	}
	return ret;
}

/*
	Execute the main program of a shellmod script
*/
int shellprg_exec (
	int argc,
	char *argv[])
{
	int ret = -1;
	const char *cmd = "/bin/sh";
	int start = 1;
	while (argv[start] != NULL){
		if (strcmp(argv[start],"--debug")==0){
			protocol_setdebug (true);
			start++;
		}else if (strcmp(argv[start],"--perl")==0){
			cmd = "/usr/bin/perl";
			start++;
		}else{
			break;
		}
	}

	char abspath[PATH_MAX];
	if (shellprg_setabs (argv[0],abspath)!=-1){
		char command[PATH_MAX];
		snprintf (command,sizeof(command)-1,"%s  %s",cmd,abspath);
		ret = shellprg_runmain (command,argv,start,argc);
	}
	return ret;
}

