#!/bin/sh
# This module lets one maintain mailing lists from the user account dialog
# by providing a co-manager.

# Where are the mailing list files
# Assume all file have extension .lst
# Assume a file /etc/lists/list.info. It contain a small description
# Assume that the files contain one user account per line. Note
#     that the files may contain fully qualified email address as well
#     and they will be preserved
LISTDIR=/etc/lists
LISTEXT=lst
. /usr/lib/linuxconf/lib/shellmod-lib.sh

register(){
	echo comanager ufct user
}

ufct_setupdia(){
	echo newf_title \"Mailing lists\" 1 - \"Mailing lists\"
	for file in $LISTDIR/*.$LISTEXT
	do
		member=0
		env >/tmp/list.log
		if [ "$name" != "" ] ; then
			email=$name
			if [ "$domain" != "/" ] ; then
				email=$name@$domain
			fi
			member=`grep ^$email$ $file | wc -l`
			member=`expr $member`
		fi
		base=`basename $file .$LISTEXT`
		echo newf_chk $base $file $member \"`cat $LISTDIR/$base.info`\"
	done
}

ufct_save(){
	email=$name
	if [ "$domain" != "/" ] ; then
		email=$name@$domain
	fi
	for file in $LISTDIR/*.$LISTEXT
	do
		base=`basename $file .$LISTEXT`
		# Blindly remove the user and then add it if needed
		grep -v ^$email$ $file >$file.new
		mv $file.new $file
		eval member=$`echo $base`
		if [ "$member" = "1" ] ; then
			echo $email >>$file
		fi
	done
}
ufct_validate(){
	echo retcode 0
}
ufct_deluser(){
	# Remove the user from all file
	email=$name
	if [ "$domain" != "/" ] ; then
		email=$name@$domain
	fi
	for file in $LISTDIR/*.$LISTEXT
	do
		grep -v ^$email$ $file >$file.new
		mv $file.new $file
	done
}
dispatch
