#include <Python.h>
#include <dialog.h>
#include "../pythonmod.h"

static PyObject *ErrorObject;

static PyObject *
LCDialogMenu_edit(LCDialogMenuObject *self, PyObject *args)
{
	char *title,*intro;
	int but=MENUBUT_ACCEPT|MENUBUT_CANCEL;
	int ret;
	LCHelpFileObject *helpfile = NULL;
	HELP_FILE *help_file;
	if (!PyArg_ParseTuple(args,"ss|iO",&title,&intro,&but,&helpfile))
		return NULL;
	if (helpfile == NULL)
		help_file = &help_nil;
	else
		help_file = helpfile->helpfile;
	ret = self->dia->editmenu(title,intro,*help_file,self->nof,but);
	signal(SIGCHLD, SIG_DFL);
	return PyInt_FromLong(ret);
}

static PyObject *
LCDialogMenu_show(LCDialogMenuObject *self, PyObject *args)
{
	char *title,*intro;
	int but=0;
	LCHelpFileObject *helpfile = NULL;
	HELP_FILE *help_file;
	if (!PyArg_ParseTuple(args,"ss|iO",&title,&intro,&but,&helpfile))
		return NULL;
	if (helpfile == NULL)
		help_file = &help_nil;
	else
		help_file = helpfile->helpfile;
	self->dia->show(title,intro,*help_file,self->nof,but);
	diagui_flush();
	signal(SIGCHLD, SIG_DFL);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
LCDialogMenu_reload(LCDialogMenuObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,""))
		return NULL;
	self->dia->reload();
	diagui_flush();
	signal(SIGCHLD, SIG_DFL);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
LCDialogMenu_save(LCDialogMenuObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,""))
		return NULL;
	self->dia->save();
	diagui_flush();
	signal(SIGCHLD, SIG_DFL);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
LCDialogMenu_remove_all(LCDialogObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,""))
		return NULL;
	self->dia->remove_all();
	diagui_flush();
	signal(SIGCHLD, SIG_DFL);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
LCDialogMenu_new_menuitem(LCDialogMenuObject *self, PyObject *args)
{
	char *prompt1,*prompt2,*icon="";
	if (!PyArg_ParseTuple(args,"ss|s",&prompt1,&prompt2,&icon))
		return NULL;
	self->dia->new_menuitem(icon,prompt1,prompt2);
	return PyInt_FromLong((long)prompt2);
}

static PyObject *
LCDialogMenu_new_menuitems(LCDialogMenuObject *self, PyObject *args)
{
	PyObject *l,*ret;
	if (!PyArg_ParseTuple(args,"O",&l))
		return NULL;
	int size = PyList_Size(l);
	ret = PyList_New(size);
	for (int i = 0; i != size; i++) {
		char *prompt1, *prompt2, *icon="";
		PyObject *o = PyList_GetItem(l,i);
		if(!PyArg_ParseTuple(o,"ss|s",&prompt1,&prompt2,&icon))
			return NULL;
		self->dia->new_menuitem(icon,prompt1,prompt2);
		PyList_SetItem(ret,i,PyInt_FromLong((long)prompt2));
	}
	return ret;
}

static PyObject *
LCDialogMenu_new_button(LCDialogObject *self, PyObject *args)
{
	char *str,*help;
	PRIVATE_MESSAGE *msg;
	if (!PyArg_ParseTuple(args,"ss",&str,&help))
		return NULL;
	msg = new PRIVATE_MESSAGE();
	self->dia->new_button(str, help, *msg);
	PyObject *obj = LCFieldButton_New(msg);
	PyList_Append(self->reflist,obj);
	return obj;
}

static PyObject *
LCDialogMenu_newf_str(LCDialogMenuObject *self, PyObject *args)
{
	char *prompt;
	char *str = "";
	if (!PyArg_ParseTuple(args,"s|s",&prompt,&str))
		return NULL;
	SSTRING *sstr = new SSTRING(str);
	self->dia->newf_str(prompt,*sstr);
	PyObject *obj = LCFieldString_New(prompt, sstr);
	PyList_Append(self->reflist,obj);
	return obj;
}

static PyObject *
LCDialogMenu_newf_pass(LCDialogMenuObject *self, PyObject *args)
{
	char *prompt;
	char *str = "";
	if (!PyArg_ParseTuple(args,"s|s",&prompt,&str))
		return NULL;
	SSTRING *sstr = new SSTRING(str);
	self->dia->newf_pass(prompt,*sstr);
	PyObject *obj = LCFieldString_New(prompt, sstr);
	PyList_Append(self->reflist,obj);
	return obj;
}

PyObject *
LCDialogMenu_newf_num(LCDialogMenuObject *self, PyObject *args)
{
	char *prompt;
	int *value = new int(0);
	if (!PyArg_ParseTuple(args,"s|i",&prompt,value))
		return NULL;
	self->dia->newf_num(prompt, *value);
	PyObject *obj = LCFieldNumber_New(prompt, value);
	PyList_Append(self->reflist,obj);
	return obj;
}

static PyObject *
LCDialogMenu_newf_textarea(LCDialogMenuObject *self, PyObject *args)
{
	char *prompt;
	char *text;
	int width = 0;
	int height = 0;
	if (!PyArg_ParseTuple(args,"ssii",&prompt,&text,&width,&height))
		return NULL;
	SSTRING *sstr = new SSTRING(text);
	self->dia->newf_textarea(prompt, *sstr, width, height);
	PyObject *obj = LCFieldString_New(prompt, sstr);
	PyList_Append(self->reflist,obj);
	return obj;
}

static PyObject *
LCDialogMenu_newf_title(LCDialogMenuObject *self, PyObject *args)
{
	char *prompt, *msg, *pad = "";
	int level = 0;
	if (!PyArg_ParseTuple(args,"ss|is",&prompt,&msg,&level,&pad))
		return NULL;
	self->dia->newf_title(pad,level,prompt,msg);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
LCDialogMenu_newf_combo(LCDialogMenuObject *self, PyObject *args)
{
	char *prompt, *str;
	PyObject *l = NULL;
	if (!PyArg_ParseTuple(args,"ss|O",&prompt,&str,&l))
		return NULL;
	SSTRING *sstr = new SSTRING(str);
	FIELD_COMBO *combo = self->dia->newf_combo(prompt,*sstr);
	if (l) {
		if (!PyList_Check(l))
			return NULL;
		int size = PyList_Size(l);
		for (int i = 0; i != size; i++) {
			char *value, *verbose="";
			PyObject *o = PyList_GetItem(l,i);
			if(!PyArg_ParseTuple(o,"s|s",&value,&verbose))
				return NULL;
			combo->addopt(value,verbose);
		}
	}
	PyObject *obj = LCFieldCombo_New(combo, prompt, sstr);
	PyList_Append(self->reflist,obj);
	return obj;
}

static PyObject *
LCDialogMenu_newf_chk(LCDialogMenuObject *self, PyObject *args)
{
	char *prompt;
	char *value = new char();
	char *title;
	if (!PyArg_ParseTuple(args,"sis",&prompt,value,&title)) {
		delete value;
		return NULL;
	}
	self->dia->newf_chk(prompt, *value, title);
	PyObject *obj = LCFieldCheck_New(prompt, value);
	PyList_Append(self->reflist,obj);
	return obj;
}

static PyObject *
LCDialogMenu_newf_chkm(LCDialogMenuObject *self, PyObject *args)
{
	static const char **titles = NULL;
	char *prompt;
	char *value = new char();
	PyObject *l;
	if (!PyArg_ParseTuple(args,"siO",&prompt,value,&l)) {
		delete value;
		return NULL;
	}
	int size = PyList_Size(l);
	titles = (const char **) realloc(titles, sizeof(char **)*(size+1));
	int i = 0;
	for (; i != size; i++) {
		PyObject *o = PyList_GetItem(l,i);
		titles[i] = PyString_AsString(o);
	}
	titles[i] = 0;
	self->dia->newf_chkm(prompt,*value,titles);
	PyObject *obj = LCFieldCheck_New(prompt, value);
	PyList_Append(self->reflist,obj);
	return obj;
}

static PyObject *
LCDialogMenu_newf_chkm_num(LCDialogMenuObject *self, PyObject *args)
{
	static const char **options = NULL;
	static int *vals = NULL;
	char *prompt;
	int *value = new int();
	PyObject *l;
	if (!PyArg_ParseTuple(args,"siO",&prompt,value,&l)) {
		delete value;
		return NULL;
	}
	int size = PyList_Size(l);
	options = (const char **) realloc(options, sizeof(char **)*(size+1));
	vals = (int *) realloc(vals, sizeof(int *)*(size));
	int n = 0;
	for (; n != size; n++) {
		PyObject *o = PyList_GetItem(l,n);
		if (!PyArg_ParseTuple(o,"is",&vals[n],&options[n])) {
			delete value;
			free(options);
			free(vals);
			options = NULL;
			vals = NULL;
			return NULL;
		}
	}
	options[n] = 0;
	self->dia->newf_chkm_num(prompt,*value,vals,options);
	PyObject *obj = LCFieldNumber_New(prompt, value);
	PyList_Append(self->reflist,obj);
	return obj;
}

static PyObject *
LCDialogMenu_newf_chkm_str(LCDialogMenuObject *self, PyObject *args)
{
	static const char **options = NULL;
	static int *vals = NULL;
	char *prompt;
	int *value = new int();
	PyObject *l;
	if (!PyArg_ParseTuple(args,"siO",&prompt,value,&l)) {
		delete value;
		return NULL;
	}
	int size = PyList_Size(l);
	options = (const char **) realloc(options, sizeof(char **)*(size));
	vals = (int *) realloc(vals, sizeof(int *)*(size));
	int n = 0;
	for (; n != size; n++) {
		PyObject *o = PyList_GetItem(l,n);
		if (!PyArg_ParseTuple(o,"is",&vals[n],&options[n])) {
			delete value;
			free(options);
			free(vals);
			options = NULL;
			vals = NULL;
			return NULL;
		}
	}
	n--;
	SSTRING *sstr = new SSTRING(options[n]);
	options[n] = 0;
	self->dia->newf_chkm_str(prompt,*value,*sstr,vals,options);
	PyObject *obj = LCFieldCheckStr_New(prompt, value, sstr);
	PyList_Append(self->reflist, obj);
	return obj;
}

static PyObject *
LCDialogMenu_newf_radio(LCDialogMenuObject *self, PyObject *args)
{
	int ivalue;
	char *value;
	char *fieldprompt = NULL;
	PyObject *l = NULL;
	if (!PyArg_ParseTuple(args,"i|O",&ivalue, &l))
		return NULL;
	value = new char(ivalue);
	if (l) {
		if (!PyList_Check(l)) {
			delete value;
			return NULL;
		}
		int size = PyList_Size(l);
		for (int i = 0; i != size; i++) {
			char *prompt, *title;
			int instance;
			PyObject *o = PyList_GetItem(l,i);
			if(!PyArg_ParseTuple(o,"sis",&prompt, &instance, &title)) {
				delete value;
				return NULL;
			}
			if (i == 0) fieldprompt = prompt;
			self->dia->newf_radio(prompt, *value, instance, title);
		}
	}
	PyObject *obj = LCFieldRadio_New(fieldprompt, value, self->dia);
	PyList_Append(self->reflist,obj);
	return obj;
}

static PyObject *
LCDialogMenu_newf_gauge(LCDialogMenuObject *self, PyObject *args)
{
	char *prompt;
	int *value = new int();
	int range;
	if (!PyArg_ParseTuple(args,"sii",&prompt,value,&range)) {
		delete value;
		return NULL;
	}
	self->dia->newf_gauge(prompt,*value,range);
	PyObject *obj = LCFieldNumber_New(prompt, value);
	PyList_Append(self->reflist, obj);
	return obj;
}

static PyObject *
LCDialogMenu_setbutinfo(LCDialogMenuObject *self, PyObject *args)
{
	int id;
	char *title;
	char *icon = "";
	if (!PyArg_ParseTuple(args,"is|s",&id,&title,&icon)) {
		return NULL;
	}
	self->dia->setbutinfo(id, title, icon);;
	Py_INCREF(Py_None);
	return Py_None;
}

static struct PyMethodDef LCDialogMenu_methods[] = {
	{"edit", (binaryfunc) LCDialogMenu_edit, 1},
	{"show", (binaryfunc) LCDialogMenu_show, 1},
	{"reload", (binaryfunc) LCDialogMenu_reload, 1},
	{"save", (binaryfunc) LCDialogMenu_save, 1},
	{"remove_all", (binaryfunc) LCDialogMenu_remove_all, 1},
	{"new_menuitem", (binaryfunc) LCDialogMenu_new_menuitem, 1},
	{"new_menuitems", (binaryfunc) LCDialogMenu_new_menuitems, 1},
	{"new_button", (binaryfunc) LCDialogMenu_new_button, 1},
	{"newf_str", (binaryfunc) LCDialogMenu_newf_str, 1},
	{"newf_pass", (binaryfunc) LCDialogMenu_newf_pass, 1},
	{"newf_num", (binaryfunc) LCDialogMenu_newf_num, 1},
	{"newf_textarea", (binaryfunc) LCDialogMenu_newf_textarea, 1},
	{"newf_title", (binaryfunc) LCDialogMenu_newf_title, 1},
	{"newf_combo", (binaryfunc) LCDialogMenu_newf_combo, 1},
	{"newf_chk", (binaryfunc) LCDialogMenu_newf_chk, 1},
	{"newf_chkm", (binaryfunc) LCDialogMenu_newf_chkm, 1},
	{"newf_chkm_num", (binaryfunc) LCDialogMenu_newf_chkm_num, 1},
	{"newf_chkm_str", (binaryfunc) LCDialogMenu_newf_chkm_str, 1},
	{"newf_radio", (binaryfunc) LCDialogMenu_newf_radio, 1},
	{"newf_gauge", (binaryfunc) LCDialogMenu_newf_gauge, 1},
	{"setbutinfo", (binaryfunc) LCDialogMenu_setbutinfo, 1},
	{NULL, NULL}
};

static void
LCDialogMenu_dealloc(LCDialogMenuObject *self)
{
	if (self->owner)
		delete self->dia;
	Py_DECREF(self->reflist);
	PyMem_DEL(self);
}

static PyObject *
LCDialogMenu_getattr(LCDialogMenuObject *self, char *name)
{
	if (strcmp(name,"nof") == 0)
		return PyInt_FromLong(self->nof);
	return Py_FindMethod(LCDialogMenu_methods, (PyObject*) self, name);
}

static int
LCDialogMenu_setattr(LCDialogMenuObject *self, char *name, PyObject *obj)
{
	if (obj != NULL && strcmp(name,"nof") == 0)
		self->nof = PyInt_AsLong(obj);
		return 0;
	return -1;
}

PyTypeObject LCDialogMenu_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCDialogMenu",
	sizeof(LCDialogMenuObject),
	0,
	(destructor) LCDialogMenu_dealloc,
	(printfunc) 0,
	(getattrfunc) LCDialogMenu_getattr,
	(setattrfunc) LCDialogMenu_setattr,
	(cmpfunc) 0,
	(reprfunc) 0,
	0,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCDialogMenu_New()
{
	LCDialogMenuObject *self;
	self = PyObject_NEW(LCDialogMenuObject, &LCDialogMenu_Type);
	if (self == NULL)
		return NULL;
	self->dia = new DIALOG_MENU();
	self->owner = 1;
	self->nof = 0;
	self->reflist = PyList_New(0);
	return (PyObject*) self;
}

PyObject *
LCDialogMenu_FromDialogMenu(DIALOG_MENU *dia)
{
	LCDialogMenuObject *self;
	self = PyObject_NEW(LCDialogMenuObject, &LCDialogMenu_Type);
	if (self == NULL)
		return NULL;
	self->dia = dia;
	self->owner = 0;
	self->nof = 0;
	self->reflist = PyList_New(0);
	return (PyObject*) self;
}

PyObject *
LCDialogMenu_FromDialogMenuDealloc(DIALOG_MENU *dia)
{
	LCDialogMenuObject *self;
	self = PyObject_NEW(LCDialogMenuObject, &LCDialogMenu_Type);
	if (self == NULL)
		return NULL;
	self->dia = dia;
	self->owner = 0;
	self->nof = 0;
	self->reflist = PyList_New(0);
	return (PyObject*) self;
}

static PyObject *
lcdialogmenu_LCDialogMenu(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	return LCDialogMenu_New();
}

static struct PyMethodDef lcdialogmenu_methods[] = {
	{"LCDialogMenu", lcdialogmenu_LCDialogMenu, 1},
	{NULL,NULL}
};

extern "C" void
initlcdialogmenu()
{
	PyObject *m, *d;
	m = Py_InitModule("lcdialogmenu", lcdialogmenu_methods);
	d = PyModule_GetDict(m);
	ErrorObject = Py_BuildValue("s", "lcdialogmenu.error");
	PyDict_SetItemString(d, "error", ErrorObject);
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module lcdialogmenu");
}
