from lcconst import *
from lcutil import *
from lcdialog import *
from lchelpfile import *
from lcchar import *
from lcconfigfile import *
from lcprivilege import *
import lcregistry
import sys

helpfile = LCHelpFile('subdir','filename')
configfile = LCConfigFile('/etc/blah',help_nil,CONFIGF_MANAGED)
privilege = LCPrivilege('pythonmod_id','Python privilege','9-Miscellaneous')

def edit_function():
	dia = LCDialog()
	dia.newf_title('NoField1','Title1')
	field1 = dia.newf_str('Field1','Value1')
	field2 = dia.newf_str('Field2','Value2')
	field3 = dia.newf_num('Field3', 10)
	field4 = dia.newf_combo('Field4','Value3',[('Item1',),('Item2','Verbose2'),('Item3','Verbose3')])
	field4.addopts([('Item4',),('Item5','Verbose5')])
	field4.addopt('Item6')
	field4.addopt('Item7', 'Verbose7')
	field5 = dia.newf_chk('Field5',0,'Item1')
	field6 = dia.newf_chkm('Field6',1,['Item1','Item2'])
	field7 = dia.newf_chkm_num('Field7',2,[(2,'Item1'),(4,'Item2'),(6,'Item3')])
	field8 = dia.newf_chkm_str('Field8',2,[(2,'Item1'),(4,'Item2'),(6,'Item3')])
	field9 = dia.newf_radio(2, [('Field9a',1,'Item1'), ('Field9b',2,'Item2')])
	field9.addopt('Field9c',3,'Item3')
	field9.addopts([('Field9d',4,'Item4'), ('Field9e',5,'Item5')])
	dia.nof = 2
	while 1:
			ret = dia.edit('Title','This is an intro text',MENUBUT_ACCEPT|MENUBUT_CANCEL,helpfile)
			if ret == MENU_CANCEL or ret == MENU_ESCAPE or ret == MENU_QUIT:
					break
			elif ret == MENU_ACCEPT:
				str = \
				      "`field1` = "+`field1`+"\n" \
				      "`field2` = "+`field2`+"\n" \
				      "`field3` = "+`field3`+"\n" \
				      "`field4` = "+`field4`+"\n" \
				      "`field5` = "+`field5`+"\n" \
				      "`field6` = "+`field6`+"\n" \
				      "`field7` = "+`field7`+"\n" \
				      "`field8` = "+`field8`+"\n" \
				      "field8.get_str() = "+field8.get_str()+"\n" \
				      "`field9` = "+`field9`+"\n"
				xconf_notice(str)
				break

def show_function():
	dia = LCDialog()
	var1 = dia.newf_gauge('Prompt1',0,10)
	import time
	for i in range(11):
		var1.set(i)
		dia.reload()
		dia.show('Title','This is an intro text ('+`i`+')')
		time.sleep(1)
		

def check_mode():
	if perm_access(privilege, 'access this'):
		if dialog_mode() == DIALOG_CURSES:
			mode = "curses"
		elif dialog_mode() == DIALOG_HTML:
			mode = "html"
		elif dialog_mode() == DIALOG_GUI:
			mode = "graphic"
		xconf_notice('Currently running in '+mode+' mode')

def registry():
	lcregistry.start_session()
	xconf_notice("Your hostname is "+lcregistry.get("netbase.hostname"))
	lcregistry.end_session()

class LinuxconfModule:
	def __init__(self):
		self._menuitem = []

	def setmenu(self, dia, context):
		menus = [('','First python menu'),('','Second python menu','icon')]
		if context == MENU_MAIN_CONFIG:
			self._menuitem = dia.new_menuitems(menus)
		if context == MENU_MAIN_CONTROL:
			self._menuitem.append(dia.new_menuitem('','Third python menu',''))
		if context == MENU_MAIN_CONTROL:
			self._menuitem.append(dia.new_menuitem('','Fourth python menu',''))
	
	def domenu(self, context, selected):
		if context == MENU_MAIN_CONFIG and selected == self._menuitem[0]:
			xconf_notice('First menu selected!')
			edit_function()
		elif context == MENU_MAIN_CONFIG and selected == self._menuitem[1]:
			xconf_notice('Second menu selected!')
			show_function()
		elif context == MENU_MAIN_CONTROL and selected == self._menuitem[2]:
			xconf_notice('Third menu selected!')
			check_mode()
		elif context == MENU_MAIN_CONTROL and selected == self._menuitem[3]:
			xconf_notice('Fourth menu selected!')
			registry()
	
	def execmain(self, argv, standalone):
		if argv[0] == 'module':
			xconf_notice('Execmain from python module\n\n(argv='+`argv`+' and standalone='+`standalone`+')')
			return 0
		# This is optional
		#return None
	
	def probe(self, state, target, simul):
		net_prtlog(NETLOG_TITLE,'Title from python module (state='+`state`+', target='+`target`+', and simul='+`simul`+')')
		net_prtlog(NETLOG_WHY,'Why from python module (state='+`state`+', target='+`target`+', and simul='+`simul`+')')
		net_prtlog(NETLOG_CMD,'Command from python module (state='+`state`+', target='+`target`+', and simul='+`simul`+')')
		net_prtlog(NETLOG_ERR,'Error from python module (state='+`state`+', target='+`target`+', and simul='+`simul`+')')
		net_prtlog(NETLOG_OUT,'Output from python module (state='+`state`+', target='+`target`+', and simul='+`simul`+')')
		net_prtlog(NETLOG_VERB,'Verbose from python module (state='+`state`+', target='+`target`+', and simul='+`simul`+')')
		# Only if an error occurred
		#return -1
	
	def message(self, msg, argv):
		if msg == 'about':
			# argv is an array of LCMetaData objects. You can
			# extract anything from it, but you must know what
			# you're doing
			s = argv[0].lcstrings()
			s.append("Test python module was written by Gustavo Niemeyer (niemeyer@conectiva.com)")

# vim:ts=4
