/* auxiliary routines */

#include <dirent.h>
#include "fviews.h"
#include <string.h>
#include <stdlib.h>
//#include "pamconf.h"
//#include "pamconf.m"

#define PAM_ENTRIES_DIR "/etc/pam.d"
#define SECLIBS_DIR "/lib/security"
#define spbool(a,b,c) a=return_value_from_element(mod_parameters.get(), b);\
            my_dialog.newf_chk(c, a, "")
#define spboolS(a,b) if(a){\
    given_line->appendf(" %s", b);\
    }
#define spstring(a,b,c) return_value_from_element(mod_parameters.get(), b, &a);\
    my_dialog.newf_str(c, a)
#define spstringS(a,b) if(*(pass_thru_if_valid(a.get())))\
    given_line->appendf(" %s%s", b, pass_thru_if_valid(a.get()))
#define SPA(a) spaces_present|=has_spaces(a)

/* here are the known config files (not included the /etc/pam.d/nonono) */
CONFIG_FILE cf_securetty("/etc/securetty", help_nil, CONFIGF_MANAGED);
CONFIG_FILE cf_access("/etc/security/access.conf", help_nil, CONFIGF_MANAGED);
CONFIG_FILE cf_limits("/etc/security/limits.conf", help_nil, CONFIGF_MANAGED);
CONFIG_FILE cf_time("/etc/security/time.conf", help_nil, CONFIGF_MANAGED);
CONFIG_FILE cf_consperms("/etc/security/console.perms", help_nil, CONFIGF_MANAGED);

/* and here the help files */
HELP_FILE hf_entry_prop("pamconf", "entry_prop");
HELP_FILE hf_list_edit("pamconf", "list_edit");
HELP_FILE hf_pam_access("pamconf", "pam_access");
HELP_FILE hf_pam_limits("pamconf", "pam_limits");
HELP_FILE hf_pam_time("pamconf", "pam_time");
HELP_FILE hf_pam_console("pamconf", "pam_console");

/* protos */
int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number);
int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number, int to_eol);
int return_value_from_element(const char *given_line, const char *given_varname, SSTRING *write_here);
char return_value_from_element(const char *given_line, const char *given_varname);
void dump_viewitems_to_list(DIALOG_RECORDS &my_dialog, VIEWITEMS &given_sstrings, int total_columns, const char given_separator);
void dump_viewitems_to_list(DIALOG_RECORDS &my_dialog, VIEWITEMS &given_sstrings, int total_columns);
void dump_viewitems_to_list(DIALOG_RECORDS &my_dialog, VIEWITEMS &given_sstrings, int total_columns, const char given_separator, const char forbid_this);
void dump_viewitems_to_list(DIALOG_RECORDS &my_dialog, VIEWITEMS &given_sstrings, int total_columns, const char given_separator, const char forbid_this, const char must_have);
int gimme_word_from_string_bchar(const char *given_string, SSTRING &write_here, int word_number, const char given_separator);
void replace_chars(SSTRING &given_string, const char old_char, const char new_char);
void informational_window(const char *my_title, const char *my_text);
int ask_a_name(const char *given_title, const char *given_desc, const char *given_fieldname, SSTRING &write_here, int space_intolerator);

/* case insensitive strstr() */
/* UNFINISHED */
/* UNFINISHED */
/* UNFINISHED */
char *ci_strstr(const char *str1, const char *str2)
{
    /* since this funtion is currently used only
     by pam_access, and the searched strings are likely
     to be always in uppercase (probably to not mix with hostnames/etc)
     i'll leave it case sensitive instead.. */

    return(strstr(str1, str2));
}

/* pops a window telling the user he/she/it entered space characters
 in fields which don't like that */
void spaces_not_allowed(void)
{
    informational_window(MSG_U(T_INVALIDCHARSPRES, "Invalid characters present"), MSG_U(I_INVALIDCHARSPRES, "One or more fields has space characters on it,\nwhich are not permitted.\nChange the incorrect entries in order to be accepted."));
}

/* returns !=0 if given string has space characters,
   0 if it doesn't */
int has_spaces(SSTRING &given_string)
{
    if(strchr(given_string.get(), ' '))
        return(1);
    return(0);
}

/* convert a multi-line text to one line with spaces between each line (LFs are removed) */
void convert_from_textarea(SSTRING &given_string)
{
    SSTRING my_backup, my_word;
    int word_count=0;

    replace_chars(given_string, '\n', ' ');

    while(gimme_word_from_string(given_string.get(), my_word, word_count++)){
        my_backup.append(my_word.get());
        my_backup.append(" ");
    }
    given_string.setfrom(my_backup.get());

    /* cuts trailing space character */
    if(given_string.getlen())
        given_string.truncate(given_string.getlen()-1);
}

/* convert a line with words with spaces between them to several lines (LFs are added) */
void convert_to_textarea(SSTRING &given_string)
{
    SSTRING my_backup, my_word;
    int word_count=0;

    while(gimme_word_from_string(given_string.get(), my_word, word_count++)){
        my_backup.append(my_word.get());
        my_backup.append("\n");
    }
    given_string.setfrom(my_backup.get());
}

/* adds space characters to string up to final_size */
void adjust_spaces_to(SSTRING &given_string, int final_size)
{
    if(given_string.getlen()<final_size){
        int needed_spaces;

        needed_spaces=final_size-given_string.getlen();
        while(needed_spaces--)
            given_string.append(" ");
    }
}

void adjust_var(SSTRINGS &given_sstrings)
{
    if(given_sstrings.lookup("quesoviejo")!=-1)
        informational_window("PAMconf credits", "This module was created by\nDaniel Mealha Cabrita (dancab@conectiva.com)\n");
}

/* returns !=0 has more than spaces (or nothing at all) */
/* (yes.. another cpu-wasting routine) */
int text_not_empty(SSTRING &given_string)
{
    SSTRING trashcan;

    return(gimme_word_from_string(given_string.get(), trashcan, 0));
}

/* returns !=0 if string found (case insensitive)
   replaces found string with spaces */
int detect_and_erase(SSTRING &given_string, const char *seek_for)
{
    char *my_buff, *my_position;
    int return_this=0;

    if((my_buff=(char *)malloc(given_string.getlen()+1))){
        strcpy(my_buff, given_string.get());
        if((my_position=ci_strstr(my_buff, seek_for))){
            int my_loop;

            my_loop=strlen(seek_for);
            while(my_loop--){
                *my_position=' ';
                my_position++;
            }
            given_string.setfrom(my_buff);
            return_this=1;
        }else{
            return_this=0;
        }
        free(my_buff);
    }

    return(return_this);
}

/* replace specified char by different one in given_string */
void replace_chars(SSTRING &given_string, const char old_char, const char new_char)
{
    char *my_pointer, *my_step;

    if((my_pointer=(char *)malloc(strlen(given_string.get())+1))){
        strcpy(my_pointer, given_string.get());
        my_step=my_pointer;
        while(*my_step){
            if(*my_step==old_char)
                *my_step=new_char;
            my_step++;
        }
        given_string.setfrom(my_pointer);
        free(my_pointer);
    }
}

void informational_window(const char *my_title, const char *my_text)
{
    int nothing=0;
    DIALOG uhoh_dialog;

    uhoh_dialog.edit(my_title, my_text, help_nil, nothing, MENUBUT_OK);
}

/* ask a new name for a entry, returns true is confirmed */
int ask_a_name(const char *given_title, const char *given_desc, const char *given_fieldname, SSTRING &write_here)
{
    return(ask_a_name(given_title, given_desc, given_fieldname, write_here, 0));
}

/* ask a new name for a entry, returns true is confirmed */
/* is space_intolerator !=0 does not acces space characters in provided name */
int ask_a_name(const char *given_title, const char *given_desc, const char *given_fieldname, SSTRING &write_here, int space_intolerator)
{
    DIALOG my_dialog;
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;

    my_dialog.newf_str(given_fieldname, write_here);

    while(1){
        /* opens dialog.. */
        my_selection=0;
        my_button=my_dialog.edit(given_title, given_desc, help_nil);

        if(my_button==MENU_ACCEPT){
            if((!has_spaces(write_here))&&space_intolerator){
                return(1);
            }else{
                if(space_intolerator){
                    informational_window(MSG_U(T_NOSPACESHERE, "Invalid characters present"), MSG_U(I_NOSPACESHERE, "The provided name has space characters,\nwhich are not accepted for this entry.\nChange the name in order to be accepted."));
                }else{
                    return(1);
                }
            }
        }else{
            return(0);
        }
    }
    return(0); /* who loves compiler warnings.. */
}

/* returns given pointer if given string has no space characters,
   returns pointer to empty string if given string has spaces */
const char *pass_thru_if_valid(const char *given_string)
{
    if(strchr(given_string, ' '))
        return(given_string+strlen(given_string));
    return(given_string);
}

char return_value_from_element(const char *given_line, const char *given_varname)
{
    if(return_value_from_element(given_line, given_varname, NULL))
        return(1);
    return(0);
}

/* return !=0 if var exists in string provided,
   will return following string (varname=nonono) if write_here is defined */
int return_value_from_element(const char *given_line, const char *given_varname, SSTRING *write_here)
{
    int my_loop=0;
    SSTRING the_element;

    if(write_here)
        write_here->setfrom("");

    while(gimme_word_from_string(given_line, the_element, my_loop++)){
        if(!write_here){
            if(!strcmp(the_element.get(), given_varname))
                return(1);
        }else{
            if(!strncmp(the_element.get(), given_varname, strlen(given_varname))){
                write_here->setfrom((the_element.get()+strlen(given_varname)));
                return(1);
            }
        }
    }

    return(0);
}

/* 'cuts off' the path, returns filename */
const char *pick_filename_from_fullpath(const char *given_string)
{
    const char *my_cont, *copy_from_here;

    my_cont=given_string;
    copy_from_here=NULL;
    while(*my_cont){
        if(*my_cont=='/')
            copy_from_here=my_cont;
        my_cont++;
    }
    if(!copy_from_here){
        copy_from_here=given_string;
    }else{
        copy_from_here++;
    }

    return(copy_from_here);
}

int fill_sstrings_with_filenames(const char *given_dirname, SSTRINGS &given_sstrings)
{
    DIR *my_dir;
    struct dirent *ent;
    int my_counter=0;

    if((my_dir=opendir(given_dirname))){
        while((ent=readdir(my_dir))){
            if(strcmp(ent->d_name, ".")&&strcmp(ent->d_name, "..")){
                given_sstrings.add(new SSTRING(ent->d_name));
                my_counter++;
            }
        }
        closedir(my_dir);
    }
    return(my_counter);
}

void dump_sstrings_to_list(DIALOG_RECORDS &my_dialog, SSTRINGS &given_sstrings)
{
    int total_groups;
    int my_counter=0;

    total_groups=given_sstrings.getnb();
    while(total_groups--)
        my_dialog.new_menuitem(given_sstrings.getitem(my_counter++)->get(), "");
}

void dump_viewitems_to_list(DIALOG_RECORDS &my_dialog, VIEWITEMS &given_sstrings, int total_columns)
{
    dump_viewitems_to_list(my_dialog, given_sstrings, total_columns, ' ');
}

void dump_viewitems_to_list(DIALOG_RECORDS &my_dialog, VIEWITEMS &given_sstrings, int total_columns, const char given_separator)
{
    dump_viewitems_to_list(my_dialog, given_sstrings, total_columns, given_separator, 0);
}

/* if forbid_this!=0 and the line has this character,
 the line is not added to the list */
void dump_viewitems_to_list(DIALOG_RECORDS &my_dialog, VIEWITEMS &given_sstrings, int total_columns, const char given_separator, const char forbid_this)
{
    dump_viewitems_to_list(my_dialog, given_sstrings, total_columns, given_separator, forbid_this, 0);
}

/* if forbid_this!=0 and the line has this character,
 the line is not added to the list
   if must_have!=0 the line must have that character, otherwise it
   won't be added */
void dump_viewitems_to_list(DIALOG_RECORDS &my_dialog, VIEWITEMS &given_sstrings, int total_columns, const char given_separator, const char forbid_this, const char must_have)
{
    int total_groups;
    int my_counter=0;
    SSTRING dump_hier;
    int column_counter;
    SSTRING whole_line;
    SSTRING *current_line;

    total_groups=given_sstrings.getnb();
    while(total_groups--){
        whole_line.setfrom("");
        column_counter=1;
        current_line=&(given_sstrings.getitem(my_counter++)->line);

        while(column_counter<total_columns){
            if(given_separator==' '){
                gimme_word_from_string((*current_line).get(), dump_hier, column_counter++);
            }else{
                gimme_word_from_string_bchar((*current_line).get(), dump_hier, column_counter++, given_separator);
            }
            whole_line.append(dump_hier.get());
            whole_line.append("\t");
        }
        if(given_separator==' '){
            gimme_word_from_string((*current_line).get(), dump_hier, 0);
        }else{
            gimme_word_from_string_bchar((*current_line).get(), dump_hier, 0, given_separator);
        }

        /* patch for a very specific case (in pc_access.cc) */
        if(!strcmp(dump_hier.get(), "-"))
            dump_hier.setfrom(MSG_U(X_DISALLOW, "Disallow"));
        if(!strcmp(dump_hier.get(), "+"))
            dump_hier.setfrom(MSG_U(X_ALLOW, "Allow"));

        /* feature for a specific case (in pc_console_perms.cc) */
        {
            int may_insert=1;

            if(forbid_this){
                if(strchr(current_line->get(), forbid_this))
                    may_insert=0;
            }
            if(must_have){
                if(!strchr(current_line->get(), must_have))
                    may_insert=0;
            }

            if(may_insert)
                my_dialog.new_menuitem(dump_hier.get(), whole_line.get());
        }
    }
}

/* return true if yes, false if no */
int confirm_yesno_window(const char *my_title, const char *my_text)
{
    if(dialog_yesno(my_title, my_text, help_nil)==MENU_YES){
        return(1);
    } else {
        return(0);
    }
}

int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number)
{
    return(gimme_word_from_string(given_string, write_here, word_number, 0));
}

/* picks a 'word' (string-particle between spaces) from a string */
/* if to_eol!=0 copy from word beginning to end of line (not only the word itself */
/* returns !=0 if non-empty string returned */
int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number, int to_eol)
{
    const char *read_from,
               *copy_from;
    int  my_counter;

    read_from=given_string;

    /* ignores heading spaces */
    while((*read_from)&&(*read_from<=' '))
        read_from++;

    /* finds the beginning of word */
    my_counter=word_number;
    while(my_counter--){
        while((*read_from)&&(*read_from>' '))
            read_from++;
        while((*read_from)&&(*read_from<=' '))
            read_from++;
    }

    /* finds the length of the word and copies string */
    if((copy_from=read_from)){
        my_counter=0;
        if(!to_eol){
            while((*read_from)&&(*read_from>' ')){
                read_from++;
                my_counter++;
            }
        }else{
            while(*read_from++)
                my_counter++;
        }

        write_here.setfrom(copy_from);
        write_here.truncate(my_counter);
    }else{
        write_here.setfrom("");
    }

    if(!*write_here.get()) /* if empty string returned.. */
        return(0);
    return(1);
}

/* picks a 'word between given_chars' from a string */
/* if to_eol!=0 copy from word beginning to end of line (not only the word itself */
/* returns !=0 is non-empty string returned */
int gimme_word_from_string_bchar(const char *given_string, SSTRING &write_here, int word_number, const char given_separator)
{
    const char *read_from,
               *copy_from;
    int  my_counter;

    read_from=given_string;

    /* finds the beginning of word */
    my_counter=word_number;
    while(my_counter--){
        if(read_from){
            if((read_from=strchr(read_from, given_separator)))
                read_from++;
        }
    }

    /* finds the length of the word and copies string */
    if((copy_from=read_from)){
        my_counter=0;
        while((*read_from)&&(*read_from!=given_separator)){
            read_from++;
            my_counter++;
        }

        write_here.setfrom(copy_from);
        write_here.truncate(my_counter);
    }else{
        write_here.setfrom("");
    }

    if(!*write_here.get()) /* if empty string returned.. */
        return(0);
    return(1);
}

