/* PAMconf 1.0
 by Daniel Mealha Cabrita (dancab@conectiva.com)
 out 19th, 2000 */

#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "pamconf.h"
#include "pamconf.m"
#include "pamconf_main.cc"

MODULE_DEFINE_VERSION(pamconf);

PUBLIC MODULE_pamconf::MODULE_pamconf()
	: LINUXCONF_MODULE("pamconf")
{
	linuxconf_loadmsg ("pamconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_pamconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_USER_POLICIES){
		keymenu = MSG_U(M_pamconf,"PAM configurator");
		dia.new_menuitem ("pamconf","",keymenu);
	}
}

PUBLIC int MODULE_pamconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_USER_POLICIES){
		if (key == keymenu){
                    heres_mainwindow();
                    // ### Place the call to the edit function here
		}
	}
	return 0;
}


PUBLIC int MODULE_pamconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"pamconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain pamconf usage\n"
		 "\n"
		 "    pamconf --option ...\n")
		);
}

PUBLIC void MODULE_pamconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_pamconf::execmain (int argc , char *argv[], bool standalone)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"pamconf")==0){
		ret = -1;
		if (argc == 1){
                    heres_mainwindow();
                    // ### Place call to main menu of the module
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_pamconf pamconf;

