
#include "opensshd.h"
#include "opensshd.m"

static HELP_FILE help_opensshd("opensshd","opensshd");

static CONFIG_FILE sshd_config(
		"/etc/ssh/sshd_config",
		help_nil,
		CONFIGF_MANAGED,
		"root","root",0600);

#define ADD_STR(x,s) do { dia.newf_str (s,opt.x); } while (0)
#define ADD_CHK(x,s) \
	char sel##x; \
	do { \
		if (opt.x.cmp("yes")==0){ \
			sel##x = 0; \
		}else if (opt.x.cmp("no")==0){ \
			sel##x = 1; \
		}else{ \
			sel##x = 2; \
		} \
		dia.newf_chkm(s,sel##x,yes_no_add); \
	} while (0)
#define GET_CHK(x) do { opt.x = yes_no_get[sel##x]; } while (0)
		
void opensshd_edit()
{
	OPENSSHD_OPTIONS opt;
	VIEWITEMS_PARSER vip;
	VIEWITEMS vi (vip);
	vip.sepchar = ' ';
	vip.quotchar = 0;
	vi.read (sshd_config);
	read_opensshd_options (opt,vi);
	DIALOG dia;
	const char *yes_no_add[] = {"yes","no","default",NULL};
	const char *yes_no_get[] = {"yes","no",NULL};
	
	ADD_STR(Port,MSG_U(F_Port,"Port"));
	ADD_STR(ListenAddress,MSG_U(F_ListenAddress,"Listen Address"));
	ADD_STR(Protocol,MSG_U(F_Protocol,"Protocol (2)"));
	
	dia.newf_title (MSG_U(T_KEY,"Host Key Options"),1,"",MSG_R(T_KEY));
	ADD_STR(HostKey,MSG_U(F_HostKey,"Host RSA Key"));
	ADD_STR(HostDsaKey,MSG_U(F_HostDsaKey,"Host DSA Key (2)"));
	ADD_STR(ServerKeyBits,MSG_U(F_ServerKeyBits,"Server Key Bits"));
	ADD_STR(KeyRegenerationInterval,MSG_U(F_KeyRegenerationInterval,"Key Regeneration Interval"));
	
	dia.newf_title (MSG_U(T_ACCESS,"Access Control"),1,"",MSG_R(T_ACCESS));
	ADD_STR(AllowGroups,MSG_U(F_AllowGroups,"Allow Groups"));
	ADD_STR(AllowUsers,MSG_U(F_AllowUsers,"Allow Users"));
	ADD_STR(DenyGroups,MSG_U(F_DenyGroups,"Deny Groups"));
	ADD_STR(DenyUsers,MSG_U(F_DenyUsers,"Deny Users"));
	if (opt.PermitRootLogin.cmp("")==0){
		opt.PermitRootLogin = "default";
	}
	FIELD_COMBO *permitrootlogin = dia.newf_combo(MSG_U(F_PermitRootLogin,"Permit Root Login"),opt.PermitRootLogin);
	permitrootlogin->addopt("yes","");
	permitrootlogin->addopt("no","");
	permitrootlogin->addopt("without-password","");
	permitrootlogin->addopt("default","");
	
	dia.newf_title (MSG_U(T_SECOPT,"Security Options"),1,"",MSG_R(T_SECOPT));
	ADD_CHK(PasswordAuthentication,MSG_U(F_PasswordAuthentication,"Password Authentication"));
	ADD_CHK(PermitEmptyPasswords,MSG_U(F_PermitEmptyPasswords,"Permit Empty Passwords"));
	ADD_CHK(RSAAuthentication,MSG_U(F_RSAAuthentication,"RSA Authentication"));
	ADD_CHK(DSAAuthentication,MSG_U(F_DSAAuthentication,"DSA Authentication (2)"));
	ADD_CHK(RhostsRSAAuthentication,MSG_U(F_RhostsRSAAuthentication,"Rhosts RSA Authentication"));
	ADD_CHK(RhostsAuthentication,MSG_U(F_RhostsAuthentication,"Rhosts Authentication"));
	ADD_CHK(IgnoreRhosts,MSG_U(F_IgnoreRhosts,"Ignore Rhosts"));
	ADD_CHK(IgnoreUserKnownHosts,MSG_U(F_IgnoreUserKnownHosts,"Ignore User Known Hosts"));
	ADD_CHK(StrictModes,MSG_U(F_StrictModes,"Strict Modes"));
	ADD_STR(LoginGraceTime,MSG_U(F_LoginGraceTime,"Login Grace Time"));
	ADD_STR(Ciphers,MSG_U(F_Ciphers,"Ciphers (2)"));

	dia.newf_title (MSG_U(T_GENOPT,"General Options"),1,"",MSG_R(T_GENOPT));
	ADD_CHK(CheckMail,MSG_U(F_CheckMail,"Check Mail"));
	ADD_CHK(KeepAlive,MSG_U(F_KeepAlive,"Keep Alive"));
	ADD_CHK(PrintMotd,MSG_U(F_PrintMotd,"Print Motd"));
	ADD_CHK(UseLogin,MSG_U(F_UseLogin,"Use Login"));
	ADD_CHK(GatewayPorts,MSG_U(F_GatewayPorts,"Gateway Ports (2)"));
	ADD_STR(PidFile,MSG_U(F_PidFile,"Pid File (2)"));
	FIELD_COMBO *loglevel = dia.newf_combo(MSG_U(F_LogLevel,"Log Level"),opt.LogLevel);
	loglevel->addopt("QUIET","");
	loglevel->addopt("FATAL","");
	loglevel->addopt("ERROR","");
	loglevel->addopt("INFO","");
	loglevel->addopt("VERBOSE","");
	loglevel->addopt("DEBUG","");
	FIELD_COMBO *syslog = dia.newf_combo(MSG_U(F_SyslogFacility,"Syslog Facility"),opt.SyslogFacility);
	syslog->addopt("DAEMON","");
	syslog->addopt("USER","");
	syslog->addopt("AUTH","");
	syslog->addopt("LOCAL0","");
	syslog->addopt("LOCAL1","");
	syslog->addopt("LOCAL2","");
	syslog->addopt("LOCAL3","");
	syslog->addopt("LOCAL4","");
	syslog->addopt("LOCAL5","");
	syslog->addopt("LOCAL6","");
	syslog->addopt("LOCAL7","");
	
	dia.newf_title (MSG_U(T_X11OPT,"X11 Options"),1,"",MSG_R(T_X11OPT));
	ADD_CHK(X11Forwarding,MSG_U(F_X11Forwarding,"X11 Forwarding"));
	ADD_STR(X11DisplayOffset,MSG_U(F_X11DisplayOffset,"X11 Display Offset"));
	
	dia.newf_title (MSG_U(T_SKEYSUP,"Skey Support"),1,"",MSG_R(T_SKEYSUP));
	ADD_CHK(SkeyAuthentication,MSG_U(F_SkeyAuthentication,"Skey Authentication"));

	dia.newf_title (MSG_U(T_KERBSUP,"Kerberos Support"),1,"",MSG_R(T_KERBSUP));
	ADD_CHK(KerberosAuthentication,MSG_U(F_KerberosAuthentication,"Kerberos Authentication"));
	ADD_CHK(KerberosOrLocalPasswd,MSG_U(F_KerberosOrLocalPasswd,"Kerberos Or Local Passwd"));
	ADD_CHK(KerberosTgtPassing,MSG_U(F_KerberosTgtPassing,"Kerberos Tgt Passing"));
	ADD_CHK(KerberosTicketCleanup,MSG_U(F_KerberosTicketCleanup,"Kerberos Ticket Cleanup"));
	ADD_CHK(AFSTokenPassing,MSG_U(F_AFSTokenPassing,"AFS Token Passing"));
	
	int nof = 0;
	while(1){
		MENU_STATUS code = dia.edit(
			MSG_U(T_CONFIG_SSHD,"Secure Shell Daemon (openssh)"),
			MSG_U(I_CONFIG_SSHD,
				"This menu allows you to configure the secure shell daemon\n"
				"(sshd). It provides encrypted communications between two\n"
				"untrusted hosts.\n"
				"\n"
				"Options marked with (2) are specific to version 2."),
			help_opensshd,
			nof,
			MENUBUT_ACCEPT|MENUBUT_CANCEL);
		if (code == MENU_ESCAPE || code == MENU_QUIT || code == MENU_CANCEL){
			break;
		}else if (code == MENU_ACCEPT){
			if (opt.PermitRootLogin.cmp("default")==0){
				opt.PermitRootLogin = "";
			}
			GET_CHK(PasswordAuthentication);
			GET_CHK(PermitEmptyPasswords);
			GET_CHK(RSAAuthentication);
			GET_CHK(DSAAuthentication);
			GET_CHK(RhostsRSAAuthentication);
			GET_CHK(RhostsAuthentication);
			GET_CHK(IgnoreRhosts);
			GET_CHK(IgnoreUserKnownHosts);
			GET_CHK(StrictModes);
			GET_CHK(CheckMail);
			GET_CHK(KeepAlive);
			GET_CHK(PrintMotd);
			GET_CHK(UseLogin);
			GET_CHK(GatewayPorts);
			GET_CHK(X11Forwarding);
			GET_CHK(SkeyAuthentication);
			GET_CHK(KerberosAuthentication);
			GET_CHK(KerberosOrLocalPasswd);
			GET_CHK(KerberosTgtPassing);
			GET_CHK(KerberosTicketCleanup);
			GET_CHK(AFSTokenPassing);
			save_opensshd_options (opt,vi);
			vi.write (sshd_config, (PRIVILEGE*)NULL);
			break;
		}
	}
}

#define OPT_GET(x) do { opt.x.setfrom (vi.locateval (#x,tmp)); } while (0)

void read_opensshd_options(OPENSSHD_OPTIONS &opt, VIEWITEMS &vi)
{
	char tmp[1000];
	OPT_GET(AFSTokenPassing);
	OPT_GET(AllowGroups);
	OPT_GET(AllowUsers);
	OPT_GET(CheckMail);
	OPT_GET(Ciphers);
	OPT_GET(DenyGroups);
	OPT_GET(DenyUsers);
	OPT_GET(DSAAuthentication);
	OPT_GET(GatewayPorts);
	OPT_GET(HostDsaKey);
	OPT_GET(HostKey);
	OPT_GET(IgnoreRhosts);
	OPT_GET(IgnoreUserKnownHosts);
	OPT_GET(KeepAlive);
	OPT_GET(KerberosAuthentication);
	OPT_GET(KerberosOrLocalPasswd);
	OPT_GET(KerberosTgtPassing);
	OPT_GET(KerberosTicketCleanup);
	OPT_GET(KeyRegenerationInterval);
	OPT_GET(ListenAddress);
	OPT_GET(LoginGraceTime);
	OPT_GET(LogLevel);
	OPT_GET(PasswordAuthentication);
	OPT_GET(PermitEmptyPasswords);
	OPT_GET(PermitRootLogin);
	OPT_GET(PidFile);
	OPT_GET(Port);
	OPT_GET(PrintMotd);
	OPT_GET(Protocol);
	OPT_GET(RhostsAuthentication);
	OPT_GET(RhostsRSAAuthentication);
	OPT_GET(RSAAuthentication);
	OPT_GET(ServerKeyBits);
	OPT_GET(SkeyAuthentication);
	OPT_GET(StrictModes);
	OPT_GET(SyslogFacility);
	OPT_GET(UseLogin);
	OPT_GET(X11DisplayOffset);
	OPT_GET(X11Forwarding);
}

#define OPT_UPDATE(x) \
	do { \
		if (!opt.x.is_empty()){ \
			if (vi.locateassign(#x) == NULL){ \
				vi.uncomment (#x); \
			} \
			vi.update (#x, opt.x.get()); \
		}else{ \
			VIEWITEM *it = vi.locateassign (#x); \
			if (it != NULL) vi.comment(it); \
		} \
	} while (0)

void save_opensshd_options(OPENSSHD_OPTIONS &opt, VIEWITEMS &vi)
{
	OPT_UPDATE(AFSTokenPassing);
	OPT_UPDATE(AllowGroups);
	OPT_UPDATE(AllowUsers);
	OPT_UPDATE(CheckMail);
	OPT_UPDATE(Ciphers);
	OPT_UPDATE(DenyGroups);
	OPT_UPDATE(DenyUsers);
	OPT_UPDATE(DSAAuthentication);
	OPT_UPDATE(GatewayPorts);
	OPT_UPDATE(HostDsaKey);
	OPT_UPDATE(HostKey);
	OPT_UPDATE(IgnoreRhosts);
	OPT_UPDATE(IgnoreUserKnownHosts);
	OPT_UPDATE(KeepAlive);
	OPT_UPDATE(KerberosAuthentication);
	OPT_UPDATE(KerberosOrLocalPasswd);
	OPT_UPDATE(KerberosTgtPassing);
	OPT_UPDATE(KerberosTicketCleanup);
	OPT_UPDATE(KeyRegenerationInterval);
	OPT_UPDATE(ListenAddress);
	OPT_UPDATE(LoginGraceTime);
	OPT_UPDATE(LogLevel);
	OPT_UPDATE(PasswordAuthentication);
	OPT_UPDATE(PermitEmptyPasswords);
	OPT_UPDATE(PermitRootLogin);
	OPT_UPDATE(PidFile);
	OPT_UPDATE(Port);
	OPT_UPDATE(PrintMotd);
	OPT_UPDATE(Protocol);
	OPT_UPDATE(RhostsAuthentication);
	OPT_UPDATE(RhostsRSAAuthentication);
	OPT_UPDATE(RSAAuthentication);
	OPT_UPDATE(ServerKeyBits);
	OPT_UPDATE(SkeyAuthentication);
	OPT_UPDATE(StrictModes);
	OPT_UPDATE(SyslogFacility);
	OPT_UPDATE(UseLogin);
	OPT_UPDATE(X11DisplayOffset);
	OPT_UPDATE(X11Forwarding);
}

// vim: nowrap
