#include <limits.h>
#include <popen.h>
#include "netadm.h"
#include "netadm.m"
#include "internal.h"

static NETADM_HELP_FILE help_remadmin ("remadmin");

/*
	Establish a remote administration session with another linuxconf
	host
*/
int remadm_call(const char *host)
{
	int ret = -1;
	char arg[2*PATH_MAX];
	sprintf (arg,"--exec ssh -l remadmin %s",host);
	POPEN pop ("remadmin",arg,popen_getloginuid());
	if (pop.isok()){
		pop.forget();
		ret = 0;
	}
	xconf_notice(MSG_U(N_CONNECTING,"Connecting to %s"),host);
	return ret;
}

void remadm_ctl()
{
	DIALOG dia;
	SSTRING rem;
	dia.newf_str (MSG_U(F_REMHOST,"Host to administer"),rem);
	dia.last_noempty();
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (
			MSG_U(T_REMADMIN,"Remote administration")
			,""
			,help_remadmin,nof);
		if (code == MENU_ESCAPE || code == MENU_CANCEL){
			break;
		}else{
			remadm_call (rem.get());
		}
	}
}

