
#include "mouseconf.h"
#include "mouseconf.m"

typedef struct t_mouse_prefs{
    SSTRING mousetype;
    SSTRING xmousetype;
    SSTRING description;
    SSTRING xemu3;
    char    emulate3but;

    SSTRING mousedevice; /* link /dev/mouse points to.. */

    /* X-specific options */
    SSTRING samplerate;
    SSTRING resolution;
    SSTRING emulate3timeout;
};

t_mouse_prefs mouse_prefs;          // the ones being edited
t_mouse_prefs original_mouse_prefs; // the ones currently saved to file

struct{
    void *Lib_XF;    // pointer for XF86 library
    int  XF_exists;  // !=0 if XF86 is installed
    int  GPM_exists; // !=0 if GPM is installed
} mouse_system;

CONFIG_FILE cf_scmouse("/etc/sysconfig/mouse", help_nil, CONFIGF_MANAGED);
CONFIG_FILE cf_xf86("/etc/X11/XF86Config", help_nil, CONFIGF_MANAGED|CONFIGF_OPTIONAL);
CONFIG_FILE cf_gpmpid("/var/run/gpm.pid", help_nil, CONFIGF_OPTIONAL|CONFIGF_NOARCH);

/* defined when most on-the-fly mouse settings for X doesn't work.
 hopefully this will be left undefined in the future, as this
 X bug is solved. */
#define COMPILE_FOR_BUGGY_XF86_OTF_SETTINGS


