#pragma interface
#include <fviews.h>

class XINETDEFAULTS {
private:
public:
	SSTRING disabled;	// List of disabled services
};

class INETDCONFLIST;
class INETDCONF: public ARRAY_OBJ {
private:
	void init (void);
	void inetd_modify_service( VIEWITEM *item );
	int write_inetd( int button );
	int write_xinetd( int button );
	int write_xinetd_service(FILE *);
	void put_string(FILE *, const char *attribute, const char *value);
	void put_integer(FILE *, const char *attribute, int value);
	int input_error( void );
	void add_xinetd_extensions( DIALOG *dia );
	const char *get_server_path( void );
	void set_attribute_log_type( );
	void set_attribute_log_on_success( );
	void set_attribute_log_on_failure( );
	void set_attribute_flags( );
	void set_attribute_type( );
	int set_enabled_disabled( );

private:
	/* Fields used during edit only */
	char type_rpc;
	char type_internal;
	char type_unlisted;
	char flags_reuse;
	char flags_intercept;
	char flags_noretry;
	char flags_idonly;
	char log_on_success_pid;
	char log_on_success_host;
	char log_on_success_userid;
	char log_on_success_exit;
	char log_on_success_duration;
	char log_on_failure_host;
	char log_on_failure_userid;
	char log_on_failure_attempt;
	char log_on_failure_record;
	/* END fields used during edit only */
public:
	SSTRING service_name;	// 
	SSTRING socket_type;	// 
	SSTRING protocol;	//
	char multi;		// wait=1, no wait=0
	int max;		// Max starts per minute (instances)
	SSTRING user;		//
	SSTRING group;		//
	SSTRING server_path;	// "internal"|path
	SSTRING server_args;	// Server arguments
	char enabled;		// Service enabled = 1
	char previous_enabled;		// Service enabled = 1
	int new_inetdconf;	// Old=0, new=1
	int inetdconf_line;	// Line number in file /etc/inetd.conf
	int port;		// Port from /etc/services
	/*
	 * The following are used for xinetd only
	 */
	SSTRING type;		// RPC|INTERNAL|UNLISTED
	SSTRING flags;		// REUSE&INTERCEPT&NORETRY&IDONLY
	SSTRING interface;	// Numeric ip-address or 0 (any)
	int nice;		// priority value
	SSTRING only_from;	// List of numeric ip-address or 0 (no access)
	SSTRING no_access;	// List of numeric ip-address or 0
	SSTRING access_times;	// hh:mm-hh:mm
	char log_type_flag;	// 0=NO_LOG, 1=SYSLOG, 2=FILE
	SSTRING log_type;	// SYSLOG|FILE
	SSTRING log_facility;	// daemon|auth|user|local0-7
	SSTRING log_level;	// emerg|alert|crit|err|warning|notice|info|debug
	SSTRING log_file;	// Log file name path
	int log_softlimit;	//
	int log_hardlimit;	//
	SSTRING log_on_success;	// 
	SSTRING log_on_failure;	// 
	SSTRING rpc_version;	// version|version-version
	SSTRING rpc_number;	// Number for an UNLISTED RPC service
	SSTRING env;		// List of name=value
	SSTRING passenv;	// List of env vars from xinetd

	SSTRING my_config_file;	// Pathname where entry was found
	/*
	 * END of used for xinetd only
	 */

	/*~PROTOBEG~ INETDCONF */
public:
	INETDCONF ( INETDCONFLIST * );
	int edit (void);
	int edit ( INETDCONFLIST *inetdconflist);
	int write ( int button );
	int server_path_error( char *text, int size );
public:
	/*~PROTOEND~ INETDCONF */
	void present( char *buf1, int size1, char *buf2, int size2);
	INETDCONFLIST *my_inetdconflist;
};

class INETDCONFLIST: public ARRAY {
private:
	void scan_directory( char *directory, const char *file );
	void scan_file( const char *file );
	void add_service_inetd( int line, VIEWITEM *item );
	void add_attribute(SSTRING *string, char *op, char *val);
	void cat_attribute(SSTRING *string, char *val);
	int valid_etcservice( char *word, INETDCONF *inetdconf );
	int valid_socket_type( char *word, INETDCONF *inetdconf );
	int valid_protocol( char *word, INETDCONF *inetdconf );
	int valid_multi_max( char *word, INETDCONF *inetdconf );
	int valid_user_group( char *word, INETDCONF *inetdconf );
	int valid_path( char *word, INETDCONF *inetdconf );
	void read_inetd(void);
	void read_xinetd(void);
	void set_enabled(INETDCONF *inetdconf);
	/*~PROTOBEG~ INETDCONFLIST */
public:
	INETDCONFLIST( );
	int edit (void);
	INETDCONF *getitem (const char *id) const;
	INETDCONF *getitem (int negative) const;
	void read (void);
	void sort ( void );
	XINETDEFAULTS *my_xinetdefaults;
	/*~PROTOEND~ INETDCONFLIST */
};

