
/* interfaces types */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "amandaconf.h"
#include "amandaconf.m"

#include "am_tools.h"
#include "lame_parser.h"

void edit_specified_interface(t_parser_control *parser_control, const char *interface_name)
{
    struct {
        SSTRING comment;
        complexint use;
    } my_intvars;

    const char *groupname;
    SSTRING sgroupname;
    SSTRING dialog_title;
    DIALOG my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    sgroupname.setfromf("define interface %s {", interface_name);
    groupname=sgroupname.get();

    /* loads vars.. */
    bload_str(comment,"comment");
    bload_cintq(use,"use");

    /* builds gui.. */
    bgui_str(comment,MSG_R(F_COMMENT));
    bgui_cint(use,MSG_U(F_USE,"Speed:"));

    /* opens dialog.. */
    dialog_title.setfromf(MSG_U(T_INTERFACESETTINGS,"Settings for interface %s"), interface_name);
    my_selection=0;
    my_button=my_dialog.editmenu(dialog_title.get(), "", interfaces_prop_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL);

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    case MENU_ACCEPT:
        /* save vars if requested so.. */
        bsave_str(comment,"comment");
        bsave_cintq(use,"use");

        update_file(parser_control);
        break;
    case MENU_DEL:
        remove_group(parser_control, groupname);
        update_file(parser_control);
        break;
    default:
        break;
    }
}

void select_interfaces_window(const char *given_groupname, CONFIG_FILE &cf_amandaconf, t_parser_control *parser_control)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    my_dialog.newf_head("", MSG_U(T_INTERFACESLISTHEAD,"interfaces"));

    while(1){
        SSTRINGS list_of_groups;
//        MENU_STATUS my_button=(MENU_STATUS)0;
//        int         my_selection=0;
        int linecounter=0;

//        my_dialog.remove_all(); // cleans window
//        my_dialog.newf_head("", MSG_U(T_INTERFACESLISTHEAD,"interfaces"));

        fills_sstrings_with_selected_groups(parser_control, list_of_groups, "define interface ");
        dump_sstrings_to_list(my_dialog, list_of_groups, linecounter);

        // remove entries below (they're the previous ones and useless now)
        my_dialog.remove_last(linecounter+1);

        my_button=my_dialog.editmenu(MSG_U(T_INTERFACESLIST,"Interfaces"), "", interfaces_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            ask_name_add_group_entry(parser_control, list_of_groups,
                                     "define interface %s {",
                                     MSG_U(T_ADDINGNEWINTERFACE,"Adding a new interface..."),
                                     "", MSG_U(F_NAMEFORNEWINTERFACE,"Name for the new interface:"));
            break;
        default:
            {
                SSTRING whole_groupname;

                whole_groupname.setfromf("define interface %s {", list_of_groups.getitem(my_selection)->get());

                if(!group_heritages_are_a_problem(parser_control, "define interface ", whole_groupname.get()))
                    edit_specified_interface(parser_control, list_of_groups.getitem(my_selection)->get());
                break;
            }
        }
    }
}


