#pragma interface
#ifndef SSTRING_H
#define SSTRING_H


// Simple string class
class SSTRING: public ARRAY_OBJ {
	char *str;
	int maxsiz;		// 0 if not specified
	/*~PROTOBEG~ SSTRING */
public:
	SSTRING (const SSTRING&_str);
	SSTRING (const char *_str);
	SSTRING (const char *_str, int _maxsiz);
	SSTRING (void);
	void append (const SSTRING *s);
	void append (const SSTRING&s);
	void append (const char *app);
	void append (const char *app, int len2);
	void append (const char car);
	int appendf (const char *ctl, ...);
	int cmp (const SSTRING&other)const;
	int cmp (const char *other)const;
	void copy (SSTRING&dst)const;
	void copy (char *dst)const;
	char *copyword (const char *line);
	const char *get (void)const;
	int getlen (void)const;
	int getmaxsiz (void)const;
	int getval (void)const;
	double getvalf (void)const;
	int icmp (const SSTRING&other)const;
	int icmp (const char *other)const;
	bool is_empty (void)const;
	bool is_filled (void)const;
	int ncmp (const SSTRING&other, int len)const;
	int ncmp (const char *other, int len)const;
	SSTRING&operator = (const SSTRING&_str);
	void setempty (void);
	void setfrom (const SSTRING&src);
	virtual void setfrom (const char *src);
	void setfrom (const char *src, int len);
	void setfrom (int val);
	int setfromf (const char *ctl, ...);
	void setmaxsiz (int size);
	const char *strchr (char carac)const;
	void strip_end (void);
	const char *strrchr (char carac)const;
	const char *strstr (const char *sub)const;
	SSTRING substr (int start)const;
	SSTRING substr (int start, int end)const;
	void to_lower (void);
	void to_upper (void);
	bool truncate (int newlen);
	~SSTRING (void);
	/*~PROTOEND~ SSTRING */
};

// table of SSTRING
class SSTRINGS: public ARRAY {
	/*~PROTOBEG~ SSTRINGS */
public:
	void append (const SSTRINGS&tb);
	SSTRING *getitem (int no)const;
	int ilookup (const SSTRING *str)const;
	int ilookup (const char *str)const;
	int lookup (const SSTRING *str)const;
	int lookup (const char *str)const;
	SSTRINGS&operator = (const SSTRINGS&_strs);
	void remove_dups (void);
	void remove_empty (void);
	void sort (void);
	/*~PROTOEND~ SSTRINGS */
};

/*
	A string with a comment
*/
class CSSTRING: public SSTRING{
public:
	SSTRING comment;
	/*~PROTOBEG~ CSSTRING */
public:
	void setcomment (const SSTRING&com);
	void setfrom_c (const SSTRING&val,
		 const SSTRING&com);
	/*~PROTOEND~ CSSTRING */
};

class TIMESTR: public SSTRING{
public:
	long seconds;		// Store a duration in seconds
				// while the SSTRING store it
				// in hh:mm:ss format
	/*~PROTOBEG~ TIMESTR */
public:
	TIMESTR (const char *_str);
	TIMESTR (long _seconds);
	TIMESTR (void);
private:
	void formatstr (void);
public:
	void setfrom (const TIMESTR&s);
	void setfrom (const char *_str);
	void setfrom (long _seconds);
	/*~PROTOEND~ TIMESTR */
};


#endif
