#include <assert.h>
#include "diawxxt.h"
//#include <DEV_windowdc.h>

wxPen *pen_white;
wxPen *pen_black;
wxPen *pen_light;
wxPen *pen_dark;
wxPen *pen_back;
wxBrush *brush_lightgray;
wxBrush *brush_white;
wxBrush *brush_black;
wxBrush *brush_back;
wxFont *font_normal;
wxFont *font_prop;
wxCursor *cursor_normal;
wxCursor *cursor_wait;
wxCursor *cursor_locked;

void defs_init()
{
	pen_white = new wxPen ("white",1,wxSOLID);
	pen_black = new wxPen ("black",1,wxSOLID);
	pen_dark  = new wxPen ("dark grey",1,wxSOLID);
	pen_light = new wxPen ("white",1,wxSOLID);
	pen_back  = new wxPen ("light grey",1,wxSOLID);

	brush_lightgray = new wxBrush ("grey",wxSOLID);
	brush_white = new wxBrush ("white",wxSOLID);
	brush_black = new wxBrush ("black",wxSOLID);
	brush_back  = new wxBrush ("light grey",wxSOLID);

	font_normal = new wxFont (10,wxDEFAULT,wxNORMAL,wxNORMAL,FALSE);
	font_prop   = new wxFont (10,wxSWISS,wxNORMAL,wxNORMAL,FALSE);
	cursor_normal = new wxCursor (wxFIRST_X11_CURSOR);
	cursor_wait = new wxCursor (wxCURSOR_WAIT);
	cursor_locked = new wxCursor (wxCURSOR_NO_ENTRY);
}

struct DCNAME{
	char *name;
	// Feature of the drawing context
	wxFont *font;
	wxPen *pen;
	wxBrush *brush;
};

static DCNAME *tbdc=NULL;
static int nbdc=0;
static int maxdc = 0;

/*
	Return an already defined DC, from its name
*/
static DCNAME *defs_getdc (const char *name)
{
	DCNAME *ret = NULL;
	DCNAME *ptdc = tbdc;
	for (int i=0; i<nbdc; i++,ptdc++){
		if (strcmp(ptdc->name,name)==0){
			ret = ptdc;
			break;
		}
	}
	return ret;
}


/*
	Define (and create as needed) a drawing context

	If the DC already exist, the new values override the old. Unspecified
	values are not affected (The DC is not reset)
*/
void defs_setdc (const char *name)
{
	DCNAME *dc = defs_getdc(name);
	if (dc == NULL){
		if (nbdc == maxdc){
			maxdc += 100;
			tbdc = (DCNAME*)realloc(tbdc,maxdc*sizeof(DCNAME));
			assert (tbdc!=NULL);
		}
		dc = tbdc + nbdc;
		dc->name = strdup(name);
		dc->font = font_normal;
		dc->pen = pen_black;
		dc->brush = brush_lightgray;
		nbdc++;
	}
	dc->font = defs_getvarfont ();
	dc->pen = defs_getvarpen ();
	dc->brush = defs_getvarbrush ();
}

wxFont *defs_getvarfont ()
{
	wxFont *ret = font_normal;
	const char *name = rem_getvar ("font");
	if (name != NULL){
		ret = defs_getfont (name);
		if (ret == NULL){
			fprintf (stderr,"Font %s is not already defined, ignored\n"
				,name);
		}
		if (ret == NULL) ret = font_normal;
	}
	return ret;
}
wxPen *defs_getvarpen ()
{
	wxPen *ret = pen_black;
	const char *name = rem_getvar ("pen");
	if (name != NULL){
		ret = defs_getpen (name);
		if (ret == NULL){
			fprintf (stderr,"Pen %s is not already defined, ignored\n"
				,name);
		}
		if (ret == NULL) ret = pen_black;
	}
	return ret;
}
wxBrush *defs_getvarbrush ()
{
	wxBrush *ret = brush_lightgray;
	const char *name = rem_getvar ("brush");
	if (name != NULL){
		ret = defs_getbrush (name);
		if (ret == NULL){
			fprintf (stderr,"Brush %s is not already defined, ignored\n"
				,name);
		}
		if (ret == NULL) ret = brush_lightgray;
	}
	return ret;
}
/*
	Program a drawing context using the information supplied
	as arguments
*/
void defs_setdc (DCNAME *dcn, wxDC *dc)
{
	if (dcn != NULL){
		dc->SetFont (dcn->font);
		dc->SetPen (dcn->pen);
		dc->SetBrush (dcn->brush);
		wxColour col = dcn->pen->GetColour();
		dc->SetTextForeground(&col);
	}else{
		defs_resetdc (dc);
	}
}

/*
	Reset the drawing context to suitable defaults
*/
void defs_resetdc (wxDC *dc)
{
	dc->SetFont (font_normal);
	dc->SetPen (pen_black);
	dc->SetBrush (brush_lightgray);
	wxColour col = pen_black->GetColour();
	dc->SetTextForeground(&col);
}

/*
	Return the argument of the $dc parameter passed in the protocol.
	The pointers points to a previously define DCNAME object or NULL.
*/
DCNAME *defs_getvardc ()
{
	DCNAME *dcn = NULL;
	const char *name = rem_getvar ("dc");
	if (name != NULL){
		dcn = defs_getdc_check (name);
	}
	return dcn;
}

/*
	Return a DCNAME from a name.
	Return NULL if the DC name does not exist.
	Signal an error if this is the case.
*/
DCNAME *defs_getdc_check (const char *name)
{
	DCNAME *dcn = NULL;
	if (name != NULL){
		dcn = defs_getdc (name);
		if (dcn == NULL){
			fprintf (stderr,"Drawing context %s is not already defined, ignored\n"
				,name);
		}
	}
	return dcn;
}

struct FONTNAME{
	char *name;
	wxFont *font;
};

static FONTNAME *tbfont=NULL;
static int nbfont=0;
static int maxfont = 0;


/*
	Define (and create as needed) a drawing context

	If the DC already exist, the new values override the old. Unspecified
	values are not affected (The DC is not reset)
*/
void defs_setfont (
	const char *name,
	int pointsize,
	int fontid,
	int style,
	int weight,
	bool underlined)
	
{
	wxFont *font = defs_getfont(name);
	if (font != NULL){
		fprintf (stderr,"Font %s already defined\n",name);
	}else{
		if (nbfont == maxfont){
			maxfont += 100;
			tbfont = (FONTNAME*)realloc(tbfont,maxfont*sizeof(FONTNAME));
			assert (tbfont!=NULL);
		}
		FONTNAME *ptfont = tbfont + nbfont;
		ptfont->name = strdup(name);
		static char tbfamilies[]={
			wxDEFAULT,
			wxDECORATIVE,
			wxMODERN,
			wxROMAN,
			wxSCRIPT,
			wxSWISS,
			wxTELETYPE
		};
		static char tbstyles[]={
			wxNORMAL,
			wxSLANT,
			wxITALIC
		};
		static char tbweights[]={
			wxNORMAL,
			wxBOLD,
			wxLIGHT,
		};
		if (fontid < 0 || fontid > 6){
			fprintf (stderr,"defs_deffont: fontid out of range %d\n",fontid);
			fontid = 0;
		}
		if (style < 1 || style > 3){
			fprintf (stderr,"defs_deffont: style out of range %d\n",style);
			style = 1;
		}
		if (weight < 0 || weight > 2){
			fprintf (stderr,"defs_deffont: weight out of range %d\n",weight);
			weight = 0;
		}

		font = new wxFont (pointsize,tbfamilies[fontid],tbstyles[style-1]
			,tbweights[weight],underlined);
		ptfont->font = font;
		nbfont++;
	}
}

/*
	Return an already defined DC, from its name
*/
wxFont *defs_getfont (const char *name)
{
	wxFont *font = NULL;
	FONTNAME *ptfont = tbfont;
	for (int i=0; i<nbfont; i++,ptfont++){
		if (strcmp(ptfont->name,name)==0){
			font = ptfont->font;
			break;
		}
	}
	return font;
}

struct PENNAME{
	char *name;
	wxPen *pen;
};

static PENNAME *tbpen=NULL;
static int nbpen=0;
static int maxpen = 0;


/*
	Define (and create as needed) a drawing context

	If the DC already exist, the new values override the old. Unspecified
	values are not affected (The DC is not reset)
*/
void defs_setpen (
	const char *name,
	const char *color,
	int thick,
	int style)
	
{
	wxPen *pen = defs_getpen(name);
	if (pen != NULL){
		fprintf (stderr,"Pen %s already defined\n",name);
	}else{
		if (nbpen == maxpen){
			maxpen += 100;
			tbpen = (PENNAME*)realloc(tbpen,maxpen*sizeof(PENNAME));
			assert (tbpen!=NULL);
		}
		PENNAME *ptpen = tbpen + nbpen;
		ptpen->name = strdup(name);
		static char tbstyles[]={
			wxSOLID,
			wxTRANSPARENT,
			wxDOT,
			wxLONG_DASH,
			wxSHORT_DASH,
			wxDOT_DASH
		};
		if (style < 0 || style > 6){
			fprintf (stderr,"defs_defpen: style out of range %d\n",style);
			style = 0;
		}
		ptpen->pen = new wxPen (color,thick,tbstyles[style]);
		nbpen++;
	}
}

/*
	Return an already defined PEN, from its name
*/
wxPen *defs_getpen (const char *name)
{
	wxPen *pen = NULL;
	PENNAME *ptpen = tbpen;
	for (int i=0; i<nbpen; i++,ptpen++){
		if (strcmp(ptpen->name,name)==0){
			pen = ptpen->pen;
			break;
		}
	}
	return pen;
}

struct BRUSHNAME{
	char *name;
	wxBrush *brush;
};

static BRUSHNAME *tbbrush=NULL;
static int nbbrush=0;
static int maxbrush = 0;


/*
	Define (and create as needed) a drawing context

	If the DC already exist, the new values override the old. Unspecified
	values are not affected (The DC is not reset)
*/
void defs_setbrush (
	const char *name,
	const char *color,
	int style)
	
{
	wxBrush *brush = defs_getbrush(name);
	if (brush != NULL){
		fprintf (stderr,"Brush %s already defined\n",name);
	}else{
		if (nbbrush == maxbrush){
			maxbrush += 100;
			tbbrush = (BRUSHNAME*)realloc(tbbrush,maxbrush*sizeof(BRUSHNAME));
			assert (tbbrush!=NULL);
		}
		BRUSHNAME *ptbrush = tbbrush + nbbrush;
		ptbrush->name = strdup(name);
		static char tbstyles[]={
			wxSOLID,
			wxTRANSPARENT,
			wxDOT,
			wxLONG_DASH,
			wxSHORT_DASH,
			wxDOT_DASH
		};
		if (style < 0 || style > 6){
			fprintf (stderr,"defs_defbrush: style out of range %d\n",style);
			style = 0;
		}
		ptbrush->brush = new wxBrush (color,tbstyles[style]);
		nbbrush++;
	}
}

/*
	Return an already defined BRUSH, from its name
*/
wxBrush *defs_getbrush (const char *name)
{
	wxBrush *brush = NULL;
	BRUSHNAME *ptbrush = tbbrush;
	for (int i=0; i<nbbrush; i++,ptbrush++){
		if (strcmp(ptbrush->name,name)==0){
			brush = ptbrush->brush;
			break;
		}
	}
	return brush;
}





