#pragma interface
#ifndef MODREGISTER_H
#define MODREGISTER_H
#ifndef MISC_H
	#include <misc.h>
#endif

#ifndef DIALOG_H
	#include "dialog.h"
#endif

typedef void (*FUNC_RECORD)(const char *, bool);

// #Specbeg: publishing variable / REGISTER_VARIABLE_LOOKUP
// This is used with strings
struct REGISTER_VARIABLE_LOOKUP{
	const char *varname;
	const char *dialog_id;
	const char *prompt;
	// Functions to trigger to execution of the dialog, so variables
	// can be moved (get or set)
	void (*exec_dialog)();
	void (*exec_dialog_record)(const char * record, bool setting);
};
// #Specend:

#ifndef TRANSLATE_H
	#include <translat.h>
#endif

// #Specbeg: publishing variable / REGISTER_VARIABLE_LOOKUP_MSG
// This is used with P_MSG_R() macros. 
// Note, this has been deprecated. Use PUBLISH_VARIABLES_MSG
struct REGISTER_VARIABLE_LOOKUP_MSG{
	const char *varname;
	const char *dialog_id;
	TRANS_NOTLOAD *notloaded;
	// Functions to trigger to execution of the dialog, so variables
	// can be moved (get or set)
	void (*exec_dialog)();
	void (*exec_dialog_record)(const char * record, bool setting);
};
// #Specend:

// #Specbeg: publishing variable / PUBLISH_VARIABLES_MSG
// This is used with P_MSG_R() macros
struct PUBLISH_VARIABLES_MSG{
	const char *varname;
	TRANS_NOTLOAD *notloaded;
};
// #Specend:

// #Specbeg: publishing variable / PUBLISH_VARIABLES_STR
struct PUBLISH_VARIABLES_STR{
	const char *varname;
	const char *prompt;
};
// #Specend:

class MASTER_REGISTRY;
class REGISTER_VARIABLES_OBJ;
class REGISTER_VARIABLES;
class REGISTER_VARIABLE;
class FIELD;

extern MASTER_REGISTRY master_registry;

class MASTER_REGISTRY : public ARRAY{
private:
	int current_module;
public:
	int session_id;
	FUNC_RECORD lastfunc;	// See MASTER_REGISTRY::set()
	char *lastrecord;
	/*~PROTOBEG~ MASTER_REGISTRY */
public:
	MASTER_REGISTRY (void);
	int add (REGISTER_VARIABLES_OBJ *obj);
	int end_session (void);
private:
	void flushrecord (void);
public:
	const char *get (const char *_key);
	const char *get (const char *_module,
		 const char *_key);
	REGISTER_VARIABLES_OBJ *getitem (int no)const;
	int getlist (const char *_key, SSTRINGS&tb);
	int getlist (const char *_module,
		 const char *_key,
		 SSTRINGS&tb);
	bool in_session (void);
private:
	const char *lookup_from_prompt (const char *_prompt,
		 const char *_dialog_id);
	int lookup_index (const char *_module,
		 const char *_key);
	int lookup_index (const char *_varname);
public:
	int lookup_module (const char *_id);
private:
	int lookup_module_from_prompt (const char *_prompt);
public:
	int register_field (FIELD *field,
		 const char *dialog_id);
private:
	int reregister_field (FIELD *field);
public:
	int retrieve (FIELD *field,
		 const char *dialog_id);
private:
	const char *retrieve_first (void);
	const char *retrieve_next (void);
	const char *retrieve_value (void);
public:
	int set (const char *_key,
		 const SSTRING&_value);
	int set (const char *_key, const char *_value);
	int set (const char *_key, int val);
	int start_session (void);
	~MASTER_REGISTRY (void);
	/*~PROTOEND~ MASTER_REGISTRY */
};


class REGISTER_VARIABLES_OBJ : public ARRAY{
	friend class MASTER_REGISTRY;
protected:
	char *module_id;
protected:
	int next;
	/*~PROTOBEG~ REGISTER_VARIABLES_OBJ */
public:
	REGISTER_VARIABLES_OBJ (const char *_module_id);
protected:
	virtual REGISTER_VARIABLE *create_registry (
		const char *_varname,
		 const char *_dialog_id,
		 const char *_prompt,
		 void (*_exec_dialog)(),
		 void (*_exec_dialog_record)(const char *record, bool setting));
public:
	virtual int delete_varname (char *varname);
	virtual int end_session (void);
	virtual const char *get (const char *_key);
	const char *get_module_id (void);
	REGISTER_VARIABLE *getitem (int no)const;
private:
	virtual void loadmsg (void);
public:
	virtual const char *lookup_from_prompt (const
		 char *,
		 const char *);
	virtual int lookup_index (const char *_prompt);
	virtual int lookup_var_index (const char *_key);
	virtual int register_field (FIELD *,
		 const char *);
	virtual int reregister_field (FIELD *);
	virtual int retrieve (FIELD *field);
	virtual const char *retrieve_first (void);
	virtual const char *retrieve_next (void);
	virtual const char *retrieve_value (void);
	virtual FUNC_RECORD set (const char *_key,
		 const char *_record,
		 const char *_value);
	virtual int set (const char *_key,
		 const char *_value);
	virtual int start_session (void);
	~REGISTER_VARIABLES_OBJ (void);
	/*~PROTOEND~ REGISTER_VARIABLES_OBJ */
};

class REGISTER_VARIABLES : public REGISTER_VARIABLES_OBJ{
	friend class MASTER_REGISTRY;
	class REGISTER_VARIABLES_PRIVATE *priv;
	/*~PROTOBEG~ REGISTER_VARIABLES */
public:
	REGISTER_VARIABLES (const char *_module_id,
		 PUBLISH_VARIABLES_MSG _tb[],
		 const char *_dialog_id,
		 void (*exec_dialog)());
	REGISTER_VARIABLES (const char *_module_id,
		 PUBLISH_VARIABLES_STR _tb[],
		 const char *_dialog_id,
		 void (*exec_dialog)());
	REGISTER_VARIABLES (const char *_module_id,
		 REGISTER_VARIABLE_LOOKUP _tb[]);
	REGISTER_VARIABLES (const char *_module_id,
		 REGISTER_VARIABLE_LOOKUP_MSG _tb[]);
	REGISTER_VARIABLES (const char *_module_id,
		 const char *_listname,
		 PUBLISH_VARIABLES_MSG _tb[],
		 const char *_dialog_id,
		 void (*exec_dialog_record)(const char *, bool),
		 void (*exec_list)(SSTRINGS&));
	REGISTER_VARIABLES (const char *_module_id,
		 const char *_listname,
		 PUBLISH_VARIABLES_STR _tb[],
		 const char *_dialog_id,
		 void (*exec_dialog_record)(const char *, bool),
		 void (*exec_list)(SSTRINGS&));
private:
	int delete_varname (const char *varname);
public:
	int end_session (void);
private:
	const char *get (const char *_varname);
public:
	REGISTER_VARIABLE *getitem (int no)const;
private:
	void loadmsg (void);
	const char *lookup_from_prompt (const char *_prompt,
		 const char *_dialog_id);
	int lookup_index (const char *_prompt);
	int lookup_var_index (const char *_varname);
	int register_field (FIELD *field,
		 const char *dialog_id);
	int reregister_field (FIELD *field);
	int retrieve (FIELD *field);
	const char *retrieve_first (void);
	const char *retrieve_next (void);
	const char *retrieve_value (void);
	FUNC_RECORD set (const char *_key,
		 const char *record,
		 const char *_value);
	int set (const char *_key, const char *_value);
public:
	int start_session (void);
	~REGISTER_VARIABLES (void);
	/*~PROTOEND~ REGISTER_VARIABLES */
};

class REGISTER_VARIABLE : public ARRAY_OBJ{
protected:
	const char *dialog_id;
	const char *prompt;
	const char *varname;
	void (*exec_dialog)();
	void (*exec_dialog_record)(const char *record, bool setting);
	char *value;
	bool value_has_been_set;
	bool dirty;
	bool system_registry; // is variable dialog defined or module defined?
	friend class REGISTER_VARIABLES;
	class REGISTRY_LIST *listvar;
	/*~PROTOBEG~ REGISTER_VARIABLE */
public:
	REGISTER_VARIABLE (const char *_varname,
		 const char *_dialog_id,
		 const char *_prompt,
		 void (*_exec_dialog)(),
		 void (*_exec_dialog_record)(const char *record, bool setting));
private:
	int flush (void);
	const char *get (const char *record);
	const char *get (void);
public:
	const char *get_prompt (void)const;
	const char *get_varname (void)const;
	int getlistvar (SSTRING&var);
	const char *getvalue (void);
private:
	bool has_been_set (void);
	bool is_dirty (void);
public:
	bool is_record (void)const;
private:
	bool is_system (void);
	void mark_unset (void);
	void mark_written (void);
	int set (const char *_value);
	FUNC_RECORD set (const char *record,
		 const char *_value);
	void set_not_system (void);
	void setvalue (const char *_value);
public:
	~REGISTER_VARIABLE (void);
	/*~PROTOEND~ REGISTER_VARIABLE */
};

#endif

