#include <string.h>
#include "dialog.h"
#include "fcombo.h"

PUBLIC ELM_STR_V::ELM_STR_V(const char *_str, char &_selected)
	: ELM_STR(" "," ",_str),selected(_selected)
{
}

/*
	Setup a combo box where the user is allowed to pick several option
	at once from the pick list (unlike FIELD_COMBO)
*/
PUBLIC FIELD_COMBO_MANY::FIELD_COMBO_MANY(
	const char *_prompt,
	SSTRING &_str)
	: FIELD_COMBO(_prompt,_str,30)
{
}

/*
	Add one string option to the combo box pick list.
	This time there is two string. The strings will be show in
	the pick list like this

	value verbose
*/
PUBLIC void FIELD_COMBO_MANY::addopt(
	const char *str,
	char &selected)
{
	opts->add (new ELM_STR_V(str,selected));
}

PROTECTED void FIELD_COMBO_MANY::assist(WINDOW *dialog)
{
	int nbopt = opts->getnb();
	DIALOG dia;
	for (int i=0; i<nbopt; i++){
		ELM_STR_V *elm = (ELM_STR_V*)opts->getitem(i);
		dia.newf_chk ("",elm->selected,elm->verbose);
	}
	dia.edit ("Option list"
		,"Select active option"
		,help_nil);
	touchwin(stdscr);
	touchwin(dialog);
}

/*
	Add a combo field to the dialog.
	The object will be destroyed by the dialog itself.
	The object is returned so the caller may add options in the
	pick list.
*/
PUBLIC FIELD_COMBO_MANY *DIALOG::newf_combo_many(
	const char *prompt,
	SSTRING &str)
{
	FIELD_COMBO_MANY *s = new FIELD_COMBO_MANY(prompt,str);
	if (s != NULL) add (s);
	return s;
}


