#! /bin/bash
# Copyright (c) 1996 S.u.S.E. GmbH Fuerth, Germany.  All rights reserved.
#
# Author: Florian La Roche <florian@suse.de>, 1996
#	  Werner Fink <werner@suse.de>, 1996
#
# /sbin/init.d/rc
#
# This file is responsible for starting/stopping services
# when the runlevel changes. If the action for a particular
# feature in the new run-level is the same as the action in
# the previous run-level, this script will neither start nor
# stop that feature.
#

# avoid being interrupted by child or keyboard
trap "echo" SIGINT

. /etc/rc.config

# on runlevel 0 (halt) and 6 (reboot) switch to first vc
# for vebose messages.
# on previous runlevel identical with current runlevel
# do not re-examine current runlevel.
if test "$RUNLEVEL" = "0" -o "$RUNLEVEL" = "6" ;  then
    exec 0<> /dev/tty1 1>&0 2>&0
    test -x /usr/bin/chvt && /usr/bin/chvt 1
else
    test "$PREVLEVEL" = "$RUNLEVEL" && exit 0
fi

# set onlcr to avoid staircase effect
stty onlcr 0>&1

echo "$0: Previous runlevel: $PREVLEVEL, current runlevel: $RUNLEVEL."

curdir=/sbin/init.d/rc$RUNLEVEL.d
prevdir=/sbin/init.d/rc$PREVLEVEL.d
rex="[0-9][0-9]"

if [ "$RUNLEVEL" != 0 -a "$RUNLEVEL" != 1 -a "$RUNLEVEL" != 6 -a -x /bin/netconf ] ; then
	/bin/netconf --bootrc $curdir $prevdir
	exit
fi

if test "$PREVLEVEL" != N; then
	#
	# run the KILL scripts of the previous runlevel
	#
	for i in $prevdir/K*; do
	   test -x "$i" || continue

	   # don't run the kill script, if the new runlevel has a start script
	   start=${i##*/K$rex}
	   set -- $curdir/S$rex$start
	   test -n "$2" && echo -e "$0: more than one start link\n -- $@"
	   test -f $1 && continue

	   $i stop
	done
fi
#
# run the START scripts of the current (new) runlevel
#
for i in $curdir/S*; do
    test -x "$i" || continue

    # don't run start script, if previous runlevel had a kill script
    if test "$PREVLEVEL" != N; then
	start=${i##*/S$rex}
	set -- $prevdir/K$rex$start
	test -n "$2" && echo -e "$0: more than one kill link\n -- $@"
	test -f $1 && continue
    fi

    $i start
done

exit 0
